/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.flowfram;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFramSty;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameData;
import java.io.IOException;

public class NumColumnInArea
extends ControlSequence {
    FlowFramSty sty;
    int numColumns;
    boolean hasAreaArgs;

    public NumColumnInArea(String string, int n, boolean bl, FlowFramSty flowFramSty) {
        super(string);
        this.sty = flowFramSty;
        this.numColumns = n;
        this.hasAreaArgs = bl;
    }

    @Override
    public Object clone() {
        return new NumColumnInArea(this.getName(), this.numColumns, this.hasAreaArgs, this.sty);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popOptLabelString(teXParser, teXObjectList);
        int n = this.numColumns;
        if (this.numColumns == 0) {
            n = TeXParserUtils.popInt(teXParser, teXObjectList, true);
        }
        FlowFrameData[] flowFrameDataArray = new FlowFrameData[n];
        TeXDimension teXDimension = null;
        TeXDimension teXDimension2 = null;
        TeXDimension teXDimension3 = null;
        TeXDimension teXDimension4 = null;
        if (this.hasAreaArgs) {
            teXDimension = this.popDimensionArg(teXParser, teXObjectList, true);
            teXDimension2 = this.popDimensionArg(teXParser, teXObjectList, true);
            teXDimension3 = this.popDimensionArg(teXParser, teXObjectList, true);
            teXDimension4 = this.popDimensionArg(teXParser, teXObjectList, true);
        } else {
            teXDimension = teXParser.getDimenRegister("typeblockwidth");
            teXDimension2 = teXParser.getDimenRegister("typeblockheight");
            teXDimension3 = new UserDimension();
            teXDimension4 = new UserDimension();
        }
        for (int i = 0; i < n; ++i) {
            flowFrameDataArray[i] = this.sty.newFlowFrame(null, false, teXDimension, teXDimension2, teXDimension3, teXDimension4);
            if (string == null) continue;
            flowFrameDataArray[i].setPageList(string);
        }
        String string2 = this.popOptLabelString(teXParser, teXObjectList);
        String[] stringArray = string2.trim().split(" *, *");
        int n2 = n - 1;
        for (int i = stringArray.length - 1; n2 >= 0 && i >= 0; --n2, --i) {
            if (stringArray[i].isEmpty()) continue;
            flowFrameDataArray[n2].setLabel(stringArray[i]);
        }
    }
}

