/*
  Copyright (C) 1989      Fung F. Lee

  zw2hz: a straightforward conversion from a zW file into a HZ file
         with absolutely no optimization on output file sizes.
         If a smaller output file size is desired, decode the HZ file
         and encode the decoded output again.

  This program is free for general distribution.  

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>

#define true 1
#define false 0
#define notAscii(c)	((c)&0x80)
#define isGB(c)		((c)>=0x21 && (c)<=0x7E)
#define DB(hi,lo)	(((hi)&0xFF) << 8 | (lo)&0xFF)

int mapASCII=false;	/* translate '#A' to 'A', '#B' to 'B', etc. */
int showComment=false;  /* also output lines not beginning with 'zW' */
char *progname;

main(argc, argv)
     int argc;
     char *argv[];
{
  int i;

  progname = argv[0];
  for (i=1; i<argc; i++)
    {
      if (argv[i][0]!='-') warning();
      switch (argv[i][1])
	{
	case 'c': showComment = true; break;
	case 'a': mapASCII = true; break;
	default:  warning(); break;
	}
    }
  filter(stdin, stdout);
}

warning()
{
  fprintf(stderr, "usage: %s [-c] [-a] < foo.zw > foo.hz\n", progname);
  exit(1);
}

filter(fin, fout)
     FILE *fin, *fout;
{
  int c1, c2, code;
  int GBmode = false;
  int lineStart = true;
  
  while ((c1=fgetc(fin)) != EOF)
    {
      if (GBmode)
	{
	  lineStart = false;
	  c2 = fgetc(fin);
	  if (c1=='\n') ungetc(c2, fin);
	  switch (c1)
	    {
	    case '\n':
	      fprintf(fout, "~}~\n"); /* soft CR */
	      GBmode = false; lineStart = true;
	      break;
	    case '#':
	      if (c2=='\n')
		{
		  fprintf(fout, "~}\n"); /* hard CR */
		  GBmode = false; lineStart = true;
		}
	      else if (isGB(c2))
		{
		  if (mapASCII)
		    fprintf(fout, "~}%c~{", c2);
		  else
		    {
		      fputc(c1, fout); fputc(c2, fout);
		    }
		}
	      else /* assert(0<=c2<=0x20 || c2==0x7F) */
		fprintf(fout, "~}%c~{", c2); break;
	      break;
	    default:
	      GBrange(c1, c2);
	      fputc(c1, fout); fputc(c2, fout);
	      break;
	    }
	}
      /* not GBmode */
      else if (c1=='\n')
	{
	  lineStart = true;
	  if (showComment) fputc(c1, fout);
	}
      else if (lineStart && c1=='z')
	{
	  lineStart = false;
	  c2 = fgetc(fin);
	  if (c2=='W')
	    {
	      GBmode = true;
	      fprintf(fout, "~{");
	    }
	  else
	    {
	      ungetc(c2, fin);
	      if (showComment) fputc(c1, fout);
	    }
	}
      else
	{
	  lineStart = false;
	  if (showComment) fputc(c1, fout);
	}
    }
}


GBrange(hi, lo)
int hi, lo;
{
  if (!isGB(hi) || !isGB(lo))
    {
      fprintf(stderr, "GB code out of range: %c%c (hex: %2x%2x)\n",
	      hi, lo, hi, lo);
      exit(1);
    }
}
