%{

/*************************************************************************
* This is the grammar file for the P2V pre-processor, modified to        *
* accept C++ input and to generate C++ code.  This may not work with C   *
* input in Volcano.                                                      *
*************************************************************************/

#include <stdio.h>
#include <math.h>
#include "gram.h"

#define print_descriptor_defs(_fp) { \
    int _i_ ; \
    for (_i_ = 0; _i_ <= drule_index; _i_++) \
        if (strcmp (drule[_i_].desc, drule[_i_].volcano_desc) != 0) \
            fprintf (_fp, "#define\t%s\t%s\n", drule[_i_].desc, \
                     drule[_i_].volcano_desc) ; }

#define print_descriptor_undefs(_fp) { \
    int _i_ ; \
    for (_i_ = 0; _i_ <= drule_index; _i_++) \
        if (strcmp (drule[_i_].desc, drule[_i_].volcano_desc) != 0) \
            fprintf (_fp, "#undef\t%s\n", drule[_i_].desc) ; }

#define print_file_defs(_fp) { \
    int _i_ ; \
    for (_i_ = 0; _i_ <= fref_index; _i_++) \
        if (strcmp (fref[_i_].fname, fref[_i_].ref) != 0) \
            fprintf (_fp, "#define\t%s\t%s\n", fref[_i_].fname, \
                     fref[_i_].ref) ; }

#define print_file_undefs(_fp) { \
    int _i_ ; \
    for (_i_ = 0; _i_ <= fref_index; _i_++) \
        if (strcmp (fref[_i_].fname, fref[_i_].ref) != 0) \
            fprintf (_fp, "#undef\t%s\n", fref[_i_].fname) ; }

#define print_op_type(x) { \
    switch (x) { \
    case (OPR) : \
        printf ("     OPR") ; \
        break ; \
    case (ALG) : \
        printf ("     ALG") ; \
        break ; \
    case (ENF_OPR) : \
        printf (" ENF_OPR") ; \
        break ; \
    case (ENF) : \
        printf ("     ENF") ; \
        break ; \
    }}
    
#define perror(x) { \
    fprintf (stderr, "Error: %s, line %d: %s\n", PRAIRIE_INPUT, lineno, x) ; \
    exit(-1) ; }

#define stream(x) \
    ((x) != NULL && (x)->node_type == STR_NODE && (x)->child[0] == NULL)

/* Does a descriptor belong to an algorithm? */
#define alg_desc(x) (strcmp (al_desc, x) == 0)

/* Check if an operator is an enforcer-operator, i.e., whether it
   has NULL_ALG as one of its implementations. */
#define is_enf_opr(x)  (op_table [find((x)->name)].op_type == ENF_OPR)

/* Check if an algorithm is an enforcer in the Volcano sense. */
#define is_enf(x)      (op_table [find((x)->name)].op_type == ENF)

/* Check if operator or algorithm has one input. */
#define is_opr_with_one_input(x) \
    ((x)->node_type == OPR_NODE && stream((x)->child[0]) \
     && (x)->child[1] == NULL)
#define is_alg_with_one_input(x) \
    ((x)->node_type == ALG_NODE && stream((x)->child[0]) \
     && (x)->child[1] == NULL)

/* Is an algorithm the no-op algorithm? */
#define is_null_alg(x) \
    (strcmp((x)->name, NULL_ALG) == 0 && is_alg_with_one_input(x))

/* Check if an operator is a concrete operator. */
#define is_concrete_operator(x) (strstr (x, CONC_SUFFIX))

/* Check if a layer is the topmost one. */
#define is_top_layer(x) (layer [find_layer (x)].layer_num == 1)

/* Check if a layer is the bottommost one. */
#define is_bottom_layer(x) (layer [find_layer (x)].next_layer == 0)

/* Check if a layer is in the middle (neither topmost nor bottommost). */
#define is_middle_layer(x) (!is_top_layer(x) && !is_bottom_layer(x))

/* "z" is the name of a concrete operator (with CONC_SUFFIX).  "x"
   should be assigned the correponding abstract operator and "y" should
   be assigned the actual name of the concrete operator in the layer
   below the current_layer.  E.g., if z == JOIN_CONC, then
   x = JOIN, y = JOIN_Merge_join (if Merge_join is the next layer). */
#define abst_conc_operator(x, y, z) { \
    int _i ; \
    int _next_layer ; \
    _next_layer = layer[find_layer (current_layer)].next_layer ; \
    if (_next_layer == 0) \
        perror ("Lowest layer cannot refer to concrete operators") \
    strncpy (x, z, strlen(z) - strlen (CONC_SUFFIX)) ; \
    x [strlen (z) - strlen (CONC_SUFFIX)] = '\0' ; \
    for (_i = 0; _i <= layer_index; _i++) \
         if (layer[_i].layer_num == _next_layer) \
         { \
             sprintf (y, "%s_%s", x, layer[_i].name) ; \
             break ; \
         }}

/* "y" is an operator name, perhaps with a layer name attached to it.
   Set "x" to "y" with the layer name removed.  E.g., if "y" is
   JOIN_Merge_join, set "x" to JOIN. */
#define strip_layer_name(x, y) { \
    int _i ; \
    char *_p ; \
    strcpy (x, y) ; \
    for (_i = 0; _i <= layer_index; _i++) \
        if ((_p = strstr (y, layer[_i].name))) \
        { \
            x [_p - y - 1] = '\0' ; \
            break ; \
        } }

#define copy_expr_list(x, y) { \
    int i ; \
    for (i = 0; i < MAX_CHILDREN; i++) \
        x[i] = y[i] ; }

#define init_pointers(x) { \
    int i ; \
    for (i = 0; i < MAX_CHILDREN; i++) \
        x[i] = NULL ; }

#define print_derive_sys_prop(x) { \
    fprintf (dbic, "/*************") ; \
    fprintf (dbic, " Begin function \"derive_%s_sys_prop\" ", x) ; \
    fprintf (dbic, "*************/") ; \
    fprintf (dbic, "\n\n") ; \
    fprintf (dbic, "STATUS derive_%s_sys_prop (", x) ; \
    fprintf (dbic, "OPERATOR_ARGUMENT *oa,\n") ; \
    fprintf (dbic, "SYSTEM_PROPERTY *input_sys_prop[],\n") ; \
    fprintf (dbic, "LOGICAL_PROPERTY *input_log_prop[],\n") ; \
    fprintf (dbic, "SYSTEM_PROPERTY *derived_sys_prop)\n") ; \
    fprintf (dbic, "{ return (OKAY) ;\n}\n\n") ; \
    fprintf (dbic, "/**************") ; \
    fprintf (dbic, " End function \"derive_%s_sys_prop\" ", x) ; \
    fprintf (dbic, "**************/") ; \
    fprintf (dbic, "\n\n") ; }

#define print_derive_log_prop(x) { \
    int __i, __j ; \
    char __str [MAX_STR_LEN] ; \
    fprintf (dbic, "/*************") ; \
    fprintf (dbic, " Begin function \"derive_%s_log_prop\" ", x) ; \
    fprintf (dbic, "*************/") ; \
    fprintf (dbic, "\n\n") ; \
    fprintf (dbic, "STATUS derive_%s_log_prop (", x) ; \
    fprintf (dbic, "OPERATOR_ARGUMENT *oa,\n") ; \
    fprintf (dbic, "LOGICAL_PROPERTY *input_log_prop[],\n") ; \
    fprintf (dbic, "LOGICAL_PROPERTY *derived_log_prop)\n") ; \
    fprintf (dbic, "{\n") ; \
    strip_layer_name (__str, x) ; \
    for (__i = 0; __i <= op_table_index; __i++) \
        if (strcmp (op_table[__i].name, __str) == 0) \
        { \
            fprintf (dbic, "void init_descriptor_%s (DESCRIPTOR *", __str) ; \
            for (__j = 0; __j < op_table[__i].arity.streams; __j++) \
                fprintf (dbic, ",\nDESCRIPTOR *") ; \
            for (__j = 0; __j < op_table[__i].arity.files; __j++) \
                fprintf (dbic, ",\nRELATION *") ; \
            fprintf (dbic, ") ;\n") ; \
            break ; \
        } \
    fprintf (dbic, "allocate (oa->log_prop, LOG_PROP) ;\n") ; \
    fprintf (dbic, "init_descriptor_%s (oa", __str) ; \
    for (__j = 0; __j < op_table[__i].arity.streams; __j++) \
        fprintf (dbic, ",\ninput_log_prop[%d]->ptr_to_descriptor", __j) ; \
    for (__j = 0; __j < op_table[__i].arity.files; __j++) \
        fprintf (dbic, ",\n&(oa->__prel.__prelation[%d])", __j) ; \
    fprintf (dbic, ") ;\n") ; \
    fprintf (dbic, "derived_log_prop->ptr_to_descriptor = oa ;\n") ; \
    fprintf (dbic, "return (OKAY) ;\n}\n\n") ; \
    fprintf (dbic, "/**************") ; \
    fprintf (dbic, " End function \"derive_%s_log_prop\" ", x) ; \
    fprintf (dbic, "**************/") ; \
    fprintf (dbic, "\n\n") ; }

#define print_cost(x) { \
    int _i ; \
    fprintf (dbic, "/********************") ; \
    fprintf (dbic, " Begin function \"cost_%s\" ", x) ; \
    fprintf (dbic, "********************/") ; \
    fprintf (dbic, "\n\n") ; \
    fprintf (dbic, "STATUS cost_%s (", x) ; \
    fprintf (dbic, "ALGORITHM_ARGUMENT *aa,\n") ; \
    fprintf (dbic, "SYSTEM_PROPERTY *sys_prop,\n") ; \
    fprintf (dbic, "LOGICAL_PROPERTY *log_prop,\n") ; \
    fprintf (dbic, "SYSTEM_PROPERTY *input_sys_prop[],\n") ; \
    fprintf (dbic, "LOGICAL_PROPERTY *input_log_prop[],\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *needed_pv,\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *derived_pv,\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *input_pv[],\n") ; \
    fprintf (dbic, "COST *cost)\n") ; \
    fprintf (dbic, "{\n") ; \
    for (_i = 0; _i <= prop_index; _i++) \
        if (prop[_i].type == COST) \
        { \
            fprintf (dbic, \
                     "copy_cost (cost, &(aa->al_arg->%s)) ;\n", \
                     prop[_i].name) ; \
            break ; \
        } \
    fprintf (dbic, "return (OKAY) ;\n}\n\n") ; \
    fprintf (dbic, "/********************") ; \
    fprintf (dbic, " End function \"cost_%s\" ", x) ; \
    fprintf (dbic, "********************/") ; \
    fprintf (dbic, "\n\n") ; }

#define print_derive_phy_prop_head(_fp) { \
    fprintf (_fp, "/*************") ; \
    fprintf (_fp, " Begin function \"derive_%s_phy_prop\" ", current_alg) ; \
    fprintf (_fp, "*************/") ; \
    fprintf (_fp, "\n\n") ; \
    fprintf (_fp, "STATUS derive_%s_phy_prop (", current_alg) ; \
    fprintf (_fp, "ALGORITHM_ARGUMENT *aa,\n") ; \
    fprintf (_fp, "PROPERTY_VECTOR *input_pv[],\n") ; \
    fprintf (_fp, "SYSTEM_PROPERTY *sys_prop,\n") ; \
    fprintf (_fp, "LOGICAL_PROPERTY *log_prop,\n") ; \
    fprintf (_fp, "SYSTEM_PROPERTY *input_sys_prop[],\n") ; \
    fprintf (_fp, "LOGICAL_PROPERTY *input_log_prop[],\n") ; \
    fprintf (_fp, "PROPERTY_VECTOR *needed_pv,\n") ; \
    fprintf (_fp, "PROPERTY_VECTOR *derived_pv)\n") ; \
    fprintf (_fp, "{\n") ; \
    if (op_table [find(current_alg)].op_type != ENF) \
    { \
        fprintf (_fp, "switch (aa->al_arg->impl_rule_num)") ;\
        fprintf (_fp, "\n{\n") ; \
    }}

#define print_derive_phy_prop_body_head(_fp, impl_rule) { \
    if (enf_rule == 0) \
        fprintf (_fp, "case (%d) :\n{\n\n", impl_rule) ; \
    print_descriptor_defs (_fp) \
    print_file_defs (_fp) \
    fprintf (_fp, "\n") ; }

#define print_derive_phy_prop_body_tail(_fp, impl_rule) { \
    int _j ; \
    fprintf (_fp, "\n") ; \
    print_descriptor_undefs (_fp) \
    print_file_undefs (_fp) \
    if (op_table [find(current_alg)].op_type != ENF) \
        fprintf (_fp, "\n}\nreturn (OKAY) ;\n") ; }

#define print_derive_phy_prop_tail(_fp) { \
    if (op_table [find(current_alg)].op_type != ENF) \
    { \
        fprintf (_fp, "}\n") ; \
        fprintf (_fp, "\treturn (ERR_OPTIMIZER_INTERNAL_ERROR) ;\n}\n\n") ; \
    } \
    else fprintf (_fp, "return (OKAY) ;\n}\n\n") ; \
    fprintf (_fp, "/*************") ; \
    fprintf (_fp, " End function \"derive_%s_phy_prop\" ", current_alg) ; \
    fprintf (_fp, "*************/") ; \
    fprintf (_fp, "\n\n") ; }

#define print_do_any_good_head(_fp) { \
    int _i ; \
    fprintf (_fp, "/*************") ; \
    fprintf (_fp, " Begin function \"do_any_good_%s\" ", current_alg) ; \
    fprintf (_fp, "*************/") ; \
    fprintf (_fp, "\n\n") ; \
    fprintf (_fp, "STATUS do_any_good_%s (", current_alg) ; \
    fprintf (_fp, "OPERATOR *current_operator,\n") ; \
    fprintf (_fp, "OPERATOR_ARGUMENT *oa,\n") ; \
    fprintf (_fp, "PROPERTY_VECTOR *needed_pv,\n") ; \
    fprintf (_fp, "SYSTEM_PROPERTY *sys_prop,\n") ; \
    fprintf (_fp, "LOGICAL_PROPERTY *log_prop,\n") ; \
    fprintf (_fp, "PROPERTY_VECTOR *excl_pv,\n") ; \
    fprintf (_fp, "OPERATOR input_operator[],\n") ; \
    fprintf (_fp, "ALGO_APPL_RETURN *ret_value)\n") ; \
    fprintf (_fp, "{\n") ; \
    if (op_table [find(current_alg)].op_type != ENF) \
    { \
        fprintf (_fp, "switch (ret_value->algorithm_argument.al_arg->impl_rule_num)") ;\
        fprintf (_fp, "\n{\n") ; \
    }}

#define print_do_any_good_body_head(_fp, impl_rule) { \
    if (enf_rule == 0) \
        fprintf (_fp, "case (%d) :\n", impl_rule) ; \
    print_descriptor_defs (_fp) \
    print_file_defs (_fp) \
    fprintf (_fp, "\n") ; }

#define print_do_any_good_body_tail(_fp, impl_rule) { \
    int _j ; \
    fprintf (_fp, "\n") ; \
    print_descriptor_undefs (_fp) \
    print_file_undefs (_fp) \
    fprintf (_fp, "}}\n") ; \
    if (op_table [find(current_alg)].op_type != ENF) \
        fprintf (_fp, "return (OKAY) ;\n") ; }

#define print_do_any_good_tail(_fp) { \
    if (op_table [find(current_alg)].op_type != ENF) \
    { \
        fprintf (_fp, "}\n") ; \
        fprintf (_fp, "\treturn (ERR_OPTIMIZER_INTERNAL_ERROR) ;\n}\n\n") ; \
    } \
    else fprintf (_fp, "return (OKAY) ;\n}\n\n") ; \
    fprintf (_fp, "/*************") ; \
    fprintf (_fp, " End function \"do_any_good_%s\" ", current_alg) ; \
    fprintf (_fp, "*************/") ; \
    fprintf (_fp, "\n\n") ; }

#define print_get_input_pv(x) { \
    int _k ; \
    fprintf (dbic, "/****************") ; \
    fprintf (dbic, " Begin function \"get_input_pv_%s\" ", x) ; \
    fprintf (dbic, "****************/") ; \
    fprintf (dbic, "\n\n") ; \
    fprintf (dbic, "STATUS get_input_pv_%s(", x) ; \
    fprintf (dbic, "ALGORITHM_ARGUMENT *aa,\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *needed_pv,\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *excl_pv,\n") ; \
    fprintf (dbic, "int input_id,\n") ; \
    fprintf (dbic, "int iteration,\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *input_pv[],\n") ; \
    fprintf (dbic, "PROPERTY_VECTOR *input_excl_pv[],\n") ; \
    fprintf (dbic, "SYSTEM_PROPERTY *input_sys_prop[],\n") ; \
    fprintf (dbic, "LOGICAL_PROPERTY *input_log_prop[],\n") ; \
    fprintf (dbic, "PHY_EXPR_LIST_ELEM *input_ret_pele[],\n") ; \
    fprintf (dbic, "COST *input_ret_cost[],\n") ; \
    fprintf (dbic, "BOOLEAN *fail)\n") ; \
    fprintf (dbic, "{\n") ; \
    fprintf (dbic, "*input_pv[input_id] = ") ; \
    fprintf (dbic, "*(aa->al_arg->required[input_id]) ;\n") ; \
    fprintf (dbic, "return (OKAY) ;\n}\n\n") ; \
    fprintf (dbic, "/****************") ; \
    fprintf (dbic, " End function \"get_input_pv_%s\" ", x) ; \
    fprintf (dbic, "****************/") ; \
    fprintf (dbic, "\n\n") ; }

/* Mapping between Prairie descriptors and Volcano operator/algorithm args. */
typedef struct {
    char    desc [MAX_STR_LEN] ;
    char    volcano_desc [200] ;
} DESC_INFO_RULES ;

/* Mapping between Prairie stored files and Volcano references to files. */
typedef struct {
    char    fname [MAX_STR_LEN] ;
    char    ref [MAX_STR_LEN] ;
} FILE_REF ;

extern    FILE       *algfile ;
extern    FILE       *dbih ;
extern    FILE       *dbic ;
extern    int        irule_cost_reestimate [] ;
extern    int        irule_cost_reestimate_index ;
extern    int        junk_trule_index ;
extern    int        junk_trule [] ;
extern    int        helper_index ;
extern    char       helper [MAX_HELPERS][MAX_STR_LEN] ;
extern    LAYERS     layer [] ;
extern    int        layer_index ;
extern    FILE       *opfile ;
extern    OPR_MAP    opr_map [] ;
extern    int        opr_map_index ;
extern    OP_TABLE   op_table [] ;
extern    int        op_table_index ;
extern    int        pass ; /* Current pass over the input file. */
extern    PROP       prop [] ;
extern    int        prop_index ;
extern    FILE       *pr_out ;
extern    FILE       *working ;
extern    FILE       *yyin ;
extern    char       *yytext ;

/* Algorithm in current I-rule. */
char current_alg [MAX_STR_LEN] ;

/* Current layer name. */
char current_layer [MAX_STR_LEN] ;

/* Prefix and postfix strings in a descriptor property name.  E.g., for
   the property, "*ch[20]", the prefix is "*", postfix is "[20]". */
char decl_prefix [100] ;
char decl_postfix [100] ;

/* File name to write derive_phy_prop function and a pointer to it. */
char derive_phy_prop_file [MAX_STR_LEN] ;
FILE *ptr_to_derive_phy_prop_file ;

/* List of descriptors which are used to recognize operator arguments. */
int desc [20] ;
int desc_index = -1 ;

/* Auxiliary descriptor definitions required in translating a T-rule. */
char desc_decls [100] ;

/* Mapping of descriptors used in collapsing T-rules. */
DESC_MAP desc_map [100] ;
int      desc_map_index = -1 ;

/* Flag to indicate whether to discard Prairie rule. */
int      discard_rule = 0 ;

/* File name used to write the "do_any_good" functions and a pointer to it. */
char do_any_good_file [MAX_STR_LEN] ;
FILE *ptr_to_do_any_good_file ;

/* Mapping of Prairie descriptors into Volcano property structures, used
   for both T-rules and I-rules. */ 
DESC_INFO_RULES drule [100] ;
int             drule_index = -1 ;

/* Index into "drule" that delineates the left side descriptors from the
   right side. */
int dleft_side_index = -1 ;

/* Flag denoting enforcer I-rules. */
int enf_rule ;

/* Mapping of Prairie stored files into Volcano operator arguments. */
FILE_REF fref [100] ;
int      fref_index = -1  ;

/* Flag to denote the first auxiliary descriptor definition in "desc_decls". */
int first ;

/* Current helper definition number. */
int helper_num ;

/* Descriptor of roots of the expressions in an I-rule. */
char irule_left_root_desc [MAX_STR_LEN] ;
char irule_right_root_desc [MAX_STR_LEN] ;

/* File where I-rule test statements go. */
FILE *irule_test_file ;

/* Files where various I-rule statements go. */
char irule_head [MAX_STR_LEN] ;
FILE *ptr_to_irule_head ;
char irule_defs [MAX_STR_LEN] ;
FILE *ptr_to_irule_defs ;
char irule_cond [MAX_STR_LEN] ;
FILE *ptr_to_irule_cond ;
char irule_divide [MAX_STR_LEN] ;
FILE *ptr_to_irule_divide ;
char irule_appl [MAX_STR_LEN] ;
FILE *ptr_to_irule_appl ;
char irule_undefs [MAX_STR_LEN] ;
FILE *ptr_to_irule_undefs ;

/* Flag denoting whether current T-rule is deleted by P2V because it is
   collapsed with other T-rules. */
int junk_this_trule ;

/* Current line number in the Prairie input source file. */
int lineno = 1 ;

/* Flag denoting the "OP => NULL_ALG" I-rule. */
int null_rule ;

/* Number of current Prairie I-rule or T-rule. */
int prairie_irule_num = -1 ;
int prairie_trule_num = -1 ;

/* File for prototype declarations of Prairie helper functions. */
FILE *prototypes ;

/* Used by function "delete_white_space" to return its value. */
char tmp_str [MAX_STR_LEN] ;

/* Files where various T-rule statements go. */
char trule_head [MAX_STR_LEN] ;
FILE *ptr_to_trule_head ;
char trule_defs [MAX_STR_LEN] ;
FILE *ptr_to_trule_defs ;
char trule_cond [MAX_STR_LEN] ;
FILE *ptr_to_trule_cond ;
char trule_divide [MAX_STR_LEN] ;
FILE *ptr_to_trule_divide ;
char trule_appl [MAX_STR_LEN] ;
FILE *ptr_to_trule_appl ;
char trule_undefs [MAX_STR_LEN] ;
FILE *ptr_to_trule_undefs ;
FILE *ptr_to_trule_stats ;

/* Descriptor of roots of the expressions in a T-rule. */
char trule_left_root_desc [MAX_STR_LEN] ;
char trule_right_root_desc [MAX_STR_LEN] ;

/* File arity (number of file inputs) of right root operator of a T-rule. */
int trule_right_root_opr_file_arity = -1 ;

/* Number of current Volcano impl_rule and trans_rule. */ 
int vol_impl_rule_num = -1 ;
int vol_trans_rule_num = -1 ;

/* Flag specifying whether two expressions "weakly" unify, i.e.,
   they don't unify in Prairie (e.g., RET(F1) => RET(F11)) but they
   do in Volcano. */
int weak_unify = -1 ;

/* String to hold the white space returned by "delete_white_space". */
char                 white [10000] ;

TREE_TYPE            *copy_expr () ;
char                 *delete_white_space () ;
void                 file_references () ;
int                  find () ;
int                  find_drule_index () ;
int                  find_layer () ;
char                 *find_opr_map () ;
int                  find_prop () ;
int                  find_prop_index () ;
int                  find_relation () ;
void                 generate_allocate_nodes () ;
void                 generate_operator_argument_tree () ;
void                 get_desc_decls () ;
void                 insert_desc () ;
void                 insert_dirule_for_derive_phy_prop () ;
void                 insert_dirule_for_do_any_good () ;
void                 insert_dirule_for_model_input () ;
void                 insert_dtrule () ;
int                  is_init_descriptor () ;
int                  is_helper () ;
int                  is_single_opr_or_alg () ;
int                  junk () ;
void                 print_prairie_tree () ;
void                 print_volcano_tree () ;
int                  reestimate_cost () ;
int                  special () ;
void                 unify_desc () ;
int                  unify_expr () ;
int                  weak_unify_expr () ;

%}

%expect 3

%union {
    TREE_TYPE        *expr ;
    LIST_TREES       expr_list ;
    ARITY            arity ;
    char             token [TOK_STR_LEN] ;
}

%token <token>       ALGORITHM
%token <token>       ASGNOP
%token <token>       BINOP
%token <token>       COLON
%token <token>       COMMA
%token <token>       DCOPY
%token <token>       DECLS
%token <token>       DESCRIPTOR
%token <token>       DESC_DECL
%token <token>       DOT
%token <token>       EXCLAIM
%token <token>       HELPER
%token <token>       IDENTIFIER
%token <token>       IRULE
%token <token>       LEFT_BRACES
%token <token>       LEFT_BRACKET
%token <token>       LEFT_PAREN
%token <token>       LAYER
%token <int>         LAYER_STACKING
%token <token>       LITERAL
%token <token>       HEADER
%token <token>       NUMBER
%token <token>       OPERATOR
%token <token>       POINTER
%token <token>       POUND_DEFINE
%token <token>       POUND_INCLUDE
%token <token>       POUND_LINE
%token <token>       POUND_UNDEF
%token <token>       POUND_IF
%token <token>       POUND_IFNDEF
%token <token>       POUND_ELIF
%token <token>       POUND_ELSE
%token <token>       POUND_ENDIF
%token <token>       RELATION
%token <token>       REWRITE
%token <token>       RIGHT_BRACES
%token <token>       RIGHT_BRACKET
%token <token>       RIGHT_PAREN
%token <token>       ROOT
%token <token>       SEMICOLON
%token <token>       STAR
%token <token>       STREAM
%token <token>       TRULE
%token <token>       UNOP

%type <expr>         abst_expr
%type <expr_list>    abst_expr_list
%type <token>        argument_list
%type <expr>         conc_expr
%type <token>        const_expr
%type <token>        c_stuff
%type <token>        c_stuff_dcopy
%type <token>        declarator
%type <token>        exclaim
%type <arity>        inputs
%type <token>        irule_pre_opt
%type <token>        irule_post_opt
%type <token>        layer_composition
%type <token>        layer_rules
%type <token>        layer_stacking
%type <token>        optional_desc
%type <arity>        single_input
%type <token>        struct_access
%type <token>        trule_post_test
%type <token>        trule_pre_test
%type <token>        trule_stats
%type <token>        trule_test
%type <token>        trule_test_stats

%start prairie

%%

prairie :
    {
        int i, j ;
        switch (pass) {
        case (0) :
            printf (">>>>>> Pass %d:  Composing layers...\n", pass) ;
            break ;
        case (1) :
            printf (">>>>>> Pass %d:  Partitioning descriptor, ", pass) ;
            printf ("identifying enforcer-operators...\n") ;
            break ;
        case (2) :
            printf (">>>>>> Pass %d:  Identifying enforcers...\n", pass) ;
            break ;
        case (3) :
            printf (">>>>>> Pass %d:  Generating files, ", pass) ;
            printf ("optimizing rules...\n") ;
            break ;
        default :
            perror ("Internal error") ;
            break ;
        }

        /* Initialize global variables accessed in different passes. */
        helper_num = -1 ;

        switch (pass) {
        case (1) :
            prototypes = fopen (PROTOTYPE_FILE, "w") ;
            fprintf (prototypes, "\n/* Helper function prototypes. */\n") ;
            break ;
        case (2) :
            fprintf (dbic, "#include \"../optgen/opt_defs.h\"\n") ;
            fprintf (dbic, "#include \"../optgen/global.h\"\n") ;
            fprintf (dbic, "#include \"dbi_gen.h\"\n") ;
            fprintf (dbic, "#include \"dbi.h\"\n") ;
            fprintf (dbic, "#include \"../optgen/opt.h\"\n\n") ;
            fprintf (dbic, "#include \"../optgen/expr_str.h\"\n\n") ;
            fprintf (dbic, "extern int indent_value ;\n\n") ;
            fprintf (dbic, "#define root(S) *current_operator\n\n") ;
            break ;
        case (3) :
            fprintf (dbic, "STATUS print_logical_prop ") ;
            fprintf (dbic, "(LOGICAL_PROPERTY *_lp)\n") ;
            fprintf (dbic, "{\nreturn (OKAY) ;\n}\n\n") ;

            fprintf (dbic, "STATUS compare_operator_args ") ;
            fprintf (dbic, "(OPERATOR_ARGUMENT *_oa1,\n") ;
            fprintf (dbic, "OPERATOR *_op1,\n") ;
            fprintf (dbic, "OPERATOR_ARGUMENT *_oa2,\n") ;
            fprintf (dbic, "OPERATOR *_op2,\n") ;
            fprintf (dbic, "COMPARE *_comp)\n") ;
            fprintf (dbic, "{\nint __pm;\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == OP_ARG)
                    fprintf (dbic,
                             "COMPARE compare_%s (%s *%s%s, %s *%s%s) ;\n",
                             prop[i].name, prop[i].declarator,
                             prop[i].prefix, prop[i].postfix,
                             prop[i].declarator, prop[i].prefix,
                             prop[i].postfix) ;
            fprintf (dbic, "if (_oa1 == NULL || _oa2 == NULL ") ;
            fprintf (dbic, "|| _op1 == NULL || _op2 == NULL)\n") ;
            fprintf (dbic, "return (ERR_NULL_POINTER) ;\n") ;
            fprintf (dbic, "if (*_op1 != *_op2)\n") ;
            fprintf (dbic, "return (ERR_SANITY_CHECK) ;\n") ;
            fprintf (dbic, "*_comp = NOT_EQUAL_TO ;\n") ;
            fprintf (dbic, "if (_oa1->__prel.__prel_arity != ") ;
            fprintf (dbic, "_oa2->__prel.__prel_arity)\n") ;
            fprintf (dbic, "return (OKAY) ;\n") ;
            fprintf (dbic, "for (__pm = 0; ") ;
            fprintf (dbic, "__pm < _oa1->__prel.__prel_arity; __pm++)\n") ;
            fprintf (dbic, "if (!equal_relation (") ;
            fprintf (dbic, "&(_oa1->__prel.__prelation[__pm]),\n");
            fprintf (dbic, "&(_oa2->__prel.__prelation[__pm])))\n") ;
            fprintf (dbic, "return (OKAY) ;\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == OP_ARG)
                {
                    fprintf (dbic, "*_comp = compare_%s ", prop[i].name) ;
                    fprintf (dbic,
                             "(&(_oa1->op_arg.%s), &(_oa2->op_arg.%s)) ;\n",
                             prop[i].name, prop[i].name) ;
                    fprintf (dbic, "if (*_comp == NOT_EQUAL_TO) ") ;
                    fprintf (dbic, "return (OKAY) ;\n") ;
                }
            fprintf (dbic, "return (OKAY) ;\n}\n\n") ;

            fprintf (dbic, "STATUS compare_property_vec ") ;
            fprintf (dbic, "(PROPERTY_VECTOR *_pv1,\n") ;
            fprintf (dbic, "PROPERTY_VECTOR *_pv2,\n") ;
            fprintf (dbic, "SYSTEM_PROPERTY *_sp,\n") ;
            fprintf (dbic, "LOGICAL_PROPERTY *_lp,\n") ;
            fprintf (dbic, "PV_COMPARE *_result)\n") ;
            fprintf (dbic, "{\n") ;
            for (i = 0, j = 0; i <= prop_index; i++)
                if (prop[i].type == PHY_PROP)
                {
                    j++ ;
                    fprintf (dbic,
                             "PV_COMPARE cover_%s (%s *%s%s, %s *%s%s) ;\n",
                             prop[i].name, prop[i].declarator,
                             prop[i].prefix, prop[i].postfix,
                             prop[i].declarator, prop[i].prefix,
                             prop[i].postfix) ;
                }
            fprintf (dbic, "int i ; \n") ;
            fprintf (dbic, "PV_COMPARE __pcomp [%d] ; \n\n", j) ;
            for (i = 0, j = 0; i <= prop_index; i++)
                if (prop[i].type == PHY_PROP)
                {
                    fprintf (dbic, "__pcomp [%d] = cover_%s ",
                             j, prop[i].name) ;
                    fprintf (dbic, "(&(_pv1->%s), &(_pv2->%s)) ;\n",
                             prop[i].name, prop[i].name) ;
                    j++ ;
                }
            fprintf (dbic, "\n") ;
            fprintf (dbic, "*_result = PV_EQUAL ;\n\n") ;
            fprintf (dbic, "for (i = 0; i <= %d; i++)\n", j - 1) ;
            fprintf (dbic, "{\n") ;
            fprintf (dbic, "if (*_result == PV_NOT_COMPARABLE)\n") ;
            fprintf (dbic, "return (OKAY) ;\n") ;
            fprintf (dbic, "if (*_result == PV_EQUAL) {\n") ;
            fprintf (dbic, "*_result = __pcomp [i] ;\n") ;
            fprintf (dbic, "continue ;\n}\n") ;
            fprintf (dbic, "if (*_result == PV1_COV_PV2) {\n") ;
            fprintf (dbic, "if (__pcomp [i] == PV2_COV_PV1)\n") ;
            fprintf (dbic, "*_result = PV_NOT_COMPARABLE ;\n") ;
            fprintf (dbic, "else if (__pcomp [i] != PV_EQUAL)\n") ;
            fprintf (dbic, "*_result = __pcomp [i] ;\n") ;
            fprintf (dbic, "continue ;\n}\n") ;
            fprintf (dbic, "if (*_result == PV2_COV_PV1) {\n") ;
            fprintf (dbic, "if (__pcomp [i] == PV1_COV_PV2)\n") ;
            fprintf (dbic, "*_result = PV_NOT_COMPARABLE ;\n") ;
            fprintf (dbic, "else if (__pcomp [i] != PV_EQUAL)\n") ;
            fprintf (dbic, "*_result = __pcomp [i] ;\n") ;
            fprintf (dbic, "continue ;\n}\n") ;
            fprintf (dbic, "}\n") ;
            fprintf (dbic, "return (OKAY) ;\n}\n\n") ;

            fprintf (dbic, "STATUS compare_excl_property_vec ") ;
            fprintf (dbic, "(PROPERTY_VECTOR *_pv1,\n") ;
            fprintf (dbic, "PROPERTY_VECTOR *_pv2,\n") ;
            fprintf (dbic, "SYSTEM_PROPERTY *_sp,\n") ;
            fprintf (dbic, "LOGICAL_PROPERTY *_lp,\n") ;
            fprintf (dbic, "PV_EXCL_COMPARE *_result)\n") ;
            fprintf (dbic, "{\n*_result = PV_EXCL_TRUE ;\n") ;
            fprintf (dbic, "return (OKAY) ;\n}\n\n") ;

            for (i = 0, first = 1; i <= op_table_index; i++)
                if (op_table[i].op_type == OPR
                    && strcmp (op_table[i].name,
                            find_opr_map (op_table[i].name)) == 0
                    && op_table[i].redundant == 0)
                {
                    if (first)
                    {
                        fprintf (opfile, "typedef enum {\n\t%s",
                                 op_table[i].name) ;
                        first = 0 ;
                    }
                    else fprintf (opfile, ",\n\t%s", op_table[i].name) ;
                    print_derive_sys_prop (op_table[i].name) ;
                    print_derive_log_prop (op_table[i].name) ;
                }
            fprintf (opfile, "\n} OPERATOR ;\n\n") ;
            for (i = 0, first = 1; i <= op_table_index; i++)
                if ((op_table[i].op_type == ALG
                     || op_table[i].op_type == ENF)
                    && op_table[i].redundant == 0)
                {
                    if (strcmp (op_table[i].name, NULL_ALG) != 0)
                    {
                        if (first)
                        {
                            first = 0 ;
                             fprintf (algfile, "typedef enum {\n\t%s",
                                      op_table[i].name) ;
                        }
                        else fprintf (algfile, ",\n\t%s", op_table[i].name) ;
                        print_cost (op_table[i].name) ;
                        /* "get_input_pv" function only exists for
                           algorithms with at least one stream input. */
                        if (op_table[i].arity.streams != 0)
                            print_get_input_pv (op_table[i].name) ;
                    }
                }
            fprintf (algfile, "\n} ALGORITHM ;\n\n") ;

            break ;
        }
    }
    header decls
    {
        if (pass == 3)
        {
            int i ;

            fprintf (dbic, "void init_operator_tree (QUERY *query)\n") ;
            fprintf (dbic, "{\nextern int opt_arity [] ;\n") ;
            fprintf (dbic, "int __pl ;\n") ;
            for (i = 0; i <= op_table_index ; i++)
                if (op_table[i].op_type == OPR
                    && strcmp (op_table[i].name,
                               find_opr_map (op_table[i].name)) == 0
                    && op_table[i].redundant == 0)
                {
                    int j ;
                    char str [MAX_STR_LEN] ;

                    strip_layer_name (str, op_table[i].name) ;
                    if (strcmp (str, op_table[i].name) == 0)
                    {
                        fprintf (dbic, "void init_descriptor_%s (DESCRIPTOR *",
                                 op_table[i].name) ;
                        for (j = 0; j < op_table[i].arity.streams; j++)
                            fprintf (dbic, ",\nDESCRIPTOR *") ;
                        for (j = 0; j < op_table[i].arity.files; j++)
                            fprintf (dbic, ",\nRELATION *") ;
                        fprintf (dbic, ") ;\n") ;
                    }
                }
            fprintf (dbic, "if (!query) return ;\n") ;
            fprintf (dbic, "/* Initalize descriptors of inputs. */\n") ;
            fprintf (dbic, "for (__pl = 0; ") ;
            fprintf (dbic, "__pl < opt_arity[(int)(query->my_operator)]; ");
            fprintf (dbic, "__pl++)\n") ;
            fprintf (dbic, "init_operator_tree (query->input[__pl]) ;\n") ;
            fprintf (dbic, "switch ((int) (query->my_operator))\n{\n") ;
            for (i = 0; i <= op_table_index; i++)
                if (op_table[i].op_type == OPR
                    && strcmp (op_table[i].name,
                               find_opr_map (op_table[i].name)) == 0
                    && op_table[i].redundant == 0)
                {
                    int j ;
                    char str [MAX_STR_LEN] ;

                    strip_layer_name (str, op_table[i].name) ;
                    fprintf (dbic, "case %s :\n", op_table[i].name) ;
                    fprintf (dbic, "init_descriptor_%s (&(query->argument)",
                             str) ;
                    for (j = 0; j < op_table[i].arity.files; j++)
                        fprintf (dbic,
                                 ",\n&(query->argument.__prel.__prelation[%d])",
                                 j) ;
                    for (j = 0; j < op_table[i].arity.streams; j++)
                        fprintf (dbic, ",\n&(query->input[%d]->argument)", j) ;
                    fprintf (dbic, ") ;\nbreak ;\n") ;
                }
            fprintf (dbic, "}\nreturn ;\n}\n\n") ;
        }
    }
    helper_defs desc_decl layer_stacking definitions
    {
        if (pass == 3)
            fclose (pr_out) ;
    }
    layer_rules
    {
        /*
           Need three passes over the input file:

           Pass 1: Insert operators into symbol table.
               Insert algorithms into symbol table.
               Recognize enforcer-operators and mark
                them as such.
               Recognize physical properties and mark
                them as such.
               Recognize COST properties and report
                error if more than one COST property.
               Write definitions of dummy functions
                in "dbi.c" file.
               Macro-define ALGORITHM_ARGUMENT and
                PROPERTY_VECTOR to OPERATOR_ARGUMENT.

           Pass 2: Recognize enforcers and mark them as such.
               Print DESCRIPTOR definition in "dbi.h" file.

           Pass 3: Print OPERATOR_ARGUMENT definition in
                "dbi.h" file.
               Generate "model.input", "dbi.h" and "dbi.c"
                files.
        */

        int i ;

        switch (pass) {
        case (1) :
            fclose (prototypes) ;
            /* Compute transitive closure of operator mappings.
	       If opr_map contains a mapping O1 --> O2, and O1 is an
	       enforcer-operator, then mark all O3 enforcer-operators
	       such that O3 --> O2. */
            for (i = 0; i <= opr_map_index; i++)
                if (op_table [find (opr_map[i].from)].op_type == ENF_OPR)
                {
                    int j ;
                    j = find (opr_map[i].to) ;
                    op_table[j].op_type = ENF_OPR ;
                    op_table[j].redundant = 1 ;
                    for (j = 0; j <= opr_map_index; j++)
                        if (strcmp (opr_map[j].to, opr_map[i].to) == 0)
                        {
                            int k ;
                            k = find (opr_map[j].from) ;
                            op_table[k].op_type = ENF_OPR;
                            op_table[k].redundant = 1 ;
                        }
                }
            break ;
        case (2) :
            for (i = 0; i <= opr_map_index; i++)
                 op_table[find (opr_map[i].from)].redundant = 1 ;
            break ;
        case (3) :
            for (i = 0; i <= op_table_index; i++)
                if ((op_table[i].op_type == ALG
                     || op_table[i].op_type == ENF)
                    && op_table[i].redundant == 0
                    && strcmp (op_table[i].name, NULL_ALG) != 0)
                {
                    strcpy (current_alg, op_table[i].name) ;
                    sprintf (do_any_good_file,
                             "_do_any_good_%s", current_alg) ;
                    ptr_to_do_any_good_file =
                        fopen (do_any_good_file, "a") ;
                    print_do_any_good_tail (ptr_to_do_any_good_file) ;
                    fclose (ptr_to_do_any_good_file) ;

                    sprintf (derive_phy_prop_file,
                             "_derive_phy_prop_%s", current_alg) ;
                    ptr_to_derive_phy_prop_file =
                        fopen (derive_phy_prop_file, "a") ;
                    print_derive_phy_prop_tail (
                        ptr_to_derive_phy_prop_file ) ;
                    fclose (ptr_to_derive_phy_prop_file) ;
                }
                fprintf (stdout, "-------------------------\n") ;
                fprintf (stdout, "Operator --> Rewritten_to\n") ;
                fprintf (stdout, "-------------------------\n") ;
                for (i = 0; i <= opr_map_index; i++)
                    printf ("%s --> %s\n", opr_map[i].from, opr_map[i].to);
                fprintf (stdout, "-------------------------\n") ;
            break ;
        }

        if (pass < NUM_PASSES)
        {
            switch (pass) {
            case (0) :
                printf ("-----------------------------------\n") ;
                printf ("      Layer  Layer_num   Next_Layer\n") ;
                printf ("-----------------------------------\n") ;
                for (i = 0; i <= layer_index; i++)
                {
                     printf ("%11s  %8d  %8d\n",
                             layer[i].name, layer[i].layer_num,
                             layer[i].next_layer) ;
                }
                printf ("-----------------------------------\n") ;
                fclose (working) ;
                printf ("-----------------------------------\n") ;
                printf ("       Op/Alg Op_type Streams Files Redundant\n") ;
                printf ("---------------------------------------------\n") ;
                for (i = 0; i <= op_table_index; i++)
                {
                    printf ("%13s", op_table[i].name) ;
                    print_op_type (op_table[i].op_type) ;
                    printf ("%6d", op_table[i].arity.streams) ;
                    printf ("%6d", op_table[i].arity.files) ;
                    printf ("%6d", op_table[i].redundant) ;
                    printf ("\n") ;
                }
                printf ("-----------------------------------\n") ;
                break ;
            case (1) :
                printf ("-----------------------------------\n") ;
                printf ("       Op/Alg Op_type Streams Files Redundant\n") ;
                printf ("---------------------------------------------\n") ;
                for (i = 0; i <= op_table_index; i++)
                {
                    printf ("%13s", op_table[i].name) ;
                    print_op_type (op_table[i].op_type) ;
                    printf ("%6d", op_table[i].arity.streams) ;
                    printf ("%6d", op_table[i].arity.files) ;
                    printf ("%6d", op_table[i].redundant) ;
                    printf ("\n") ;
                }
                printf ("-----------------------------------\n") ;
                break ;
            case (2) :
                printf ("-----------------------------------\n") ;
                printf ("       Op/Alg Op_type Streams Files Redundant\n") ;
                printf ("---------------------------------------------\n") ;
                for (i = 0; i <= op_table_index; i++)
                {
                    printf ("%13s", op_table[i].name) ;
                    print_op_type (op_table[i].op_type) ;
                    printf ("%6d", op_table[i].arity.streams) ;
                    printf ("%6d", op_table[i].arity.files) ;
                    printf ("%6d", op_table[i].redundant) ;
                    printf ("\n") ;
                }
                printf ("-----------------------------------\n") ;
                break ;
            case (3) :
                break ;
            }

            pass++ ;
            lineno = 1 ;
            prairie_irule_num = -1 ;
            prairie_trule_num = -1 ;
            drule_index = -1 ;
            vol_impl_rule_num = -1 ;
            yyin = fopen (PRAIRIE_WORKING, "r") ;
            yyrestart (yyin) ;
            yyparse () ;
        }
    }
    ;

header :
    HEADER LEFT_BRACES
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s", $1, $2) ;
            fprintf (working, "\n") ;
            fprintf (working, "#define init_layer_num(lyr) (lyr = 1)\n") ;
            fprintf (working, "#define copy_layer_num(lyr1, lyr2) ") ;
            fprintf (working, "(lyr1 = lyr2)\n") ;
            fprintf (working, "#define pprint_layer_num(lyr, m) { \\\n") ;
            fprintf (working, "    indent (m) ; \\\n") ;
            fprintf (working, "    printf (\"Layer: %%d\\n\", *(lyr)) ; }\n\n");
            break ;
        }
    }
    header_stats RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $5) ;
            break ;
        case (3) :
            fprintf (dbih, "class __PREL {\n") ;
            fprintf (dbih, "public:\n") ;
            fprintf (dbih, "\tint __prel_arity ;\n") ;
            fprintf (dbih, "\tRELATION __prelation [MAX_OPERATOR_ARITY] ;\n") ;
            fprintf (dbih, "\t__PREL () { __prel_arity = 0 ; }\n") ;
            fprintf (dbih, "} __PREL;\n\n") ;
            break ;
        }
    }
    ;

decls : /* empty */
    | DECLS LEFT_BRACES
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s", $1, $2) ;
            break ;
        }
    }
      decls_stats RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $5) ;
            break ;
        case (2) :
            fprintf (dbic, "\n") ;
            break ;
        }
    }
    ;

helper_defs : /* empty */
    {
        switch (pass) {
        case (0) :
            fprintf (working, "\n") ;
            fprintf (working, "%%helper {{\n") ;
            fprintf (working, "COMPARE compare_layer_num (int * lyr1,\n") ;
            fprintf (working, "                           int * lyr2)\n") ;
            fprintf (working, "{\n") ;
            fprintf (working, "    return (EQUAL_TO) ;\n}\n}}\n\n") ;
            break ;
        }
    }
    | helper_defs HELPER LEFT_BRACES
    {
        if (pass == 0)
        {
            fprintf (working, "%s%s", $2, $3) ;
        }
        else
        {
            helper_num++ ;

            if (pass == 3)
            {
                fprintf (dbic, "/*************************") ;
                fprintf (dbic, " Begin Helper Function %d ", helper_num) ;
                fprintf (dbic, "*************************/") ;
                fprintf (dbic, "\n\n") ;
            }

            /* If the helper is a function definition, then look for
               the opening parenthesis of the definition. */
            if (1 /* pass != 3 */)
            {
                int previous_token = -1 ;
                int current_token = -1 ;
                char previous_tok_str [MAX_STR_LEN] ;
                char current_tok_str [MAX_STR_LEN] ;
                char tok_str [MAX_STR_LEN] ;

                previous_token = yylex () ;
                strcpy (previous_tok_str, yytext) ;
                while (1)
                {
                    if (previous_token == IDENTIFIER)
                    {
                        strcpy (tok_str,
                                delete_white_space (previous_tok_str, white)) ;
                        current_token = yylex () ;
                        strcpy (current_tok_str, yytext) ;
                        if (current_token == LEFT_PAREN)
                        {
                            switch (pass) {
                            case (1) :
                                strcpy (helper[++helper_index], tok_str) ;
                                fprintf (prototypes, "%s (", previous_tok_str) ;
                                break ;
                            case (2) :
                                break ;
                            case (3) :
                                fprintf (dbic, "%s (", previous_tok_str) ;
                                break ;
                            }
                            break ;
                        }
                        else /* IDENTIFIER not followed by LEFT_PAREN. */
                        {
                            switch (pass) {
                            case (1) :
                                fprintf (prototypes, "%s", previous_tok_str) ;
                                break ;
                            case (2) :
                                break ;
                            case (3) :
                                fprintf (dbic, "%s", previous_tok_str) ;
                                break ;
                            }

                            previous_token = current_token ;
                            strcpy (previous_tok_str, current_tok_str) ;
                        }
                    }
                    else
                    {
                        switch (pass) {
                        case (1) :
                            fprintf (prototypes, "%s", previous_tok_str) ;
                            break ;
                        case (2) :
                            break ;
                        case (3) :
                            fprintf (dbic, "%s", previous_tok_str) ;
                            break ;
                        }
                        previous_token = yylex () ;
                        strcpy (previous_tok_str, yytext) ;
                    }
                }
            }

            /* Generate function prototypes from helper function decls. */
            if (pass == 1)
            {
                int token ;

                token = yylex () ;
                /* Read until the closing right parenthesis. */
                while (token != RIGHT_PAREN)
                {
                    /* The first token must be a type name.  Print it. */
                    fprintf (prototypes, "%s", yytext) ;
                    
                    /* Read until the next COMMA or RIGHT_PAREN. */
                    token = yylex () ;
                    while (token != COMMA && token != RIGHT_PAREN)
                    {
                        /* Discard all identifiers and copy the remaining. */
                        if (token != IDENTIFIER
                            && token != STREAM
                            && token != RELATION
                            && token != DESCRIPTOR)
                            fprintf (prototypes, "%s", yytext) ;

                        token = yylex () ;
                    }
                    if (token == COMMA)
                    {
                        fprintf (prototypes, "%s", yytext) ;
                        token == yylex () ;
                    }
                }
                /* Reached the closing RIGHT_PAREN of the definition. */
                fprintf (prototypes, ");\n") ;
            }
        }
    }
    helper_code RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $6) ;
            break ;
        case (3) :
            fprintf (dbic, "\n") ;
            fprintf (dbic, "/**************************") ;
            fprintf (dbic, " End Helper Function %d ", helper_num) ;
            fprintf (dbic, "**************************/") ;
            fprintf (dbic, "\n\n") ;
            break ;
        }
    }
    ;

helper_code : /* empty */
    | helper_code c_stuff
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            fprintf (dbic, "%s", $2) ;
            break ;
        }
    }
    | helper_code IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            fprintf (dbic, "%s", $2) ;
            break ;
        }
    }
    | helper_code RELATION
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            fprintf (dbic, "%s", $2) ;
            break ;
        }
    }
    | helper_code DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            {
                int i ;
                int token ;
                char reference [MAX_STR_LEN] ;

                token = yylex () ;
                if (token == DOT || token == POINTER)
                {
                    strcpy (reference, yytext) ;
                    if (yylex () == IDENTIFIER)
                    {
                        i = find_prop (delete_white_space (yytext, white)) ;
                        if (i == -1)
                            perror ("Property/Method not found")
                        switch (prop[i].type) {
                        case (METHOD) :
                            fprintf (dbic, "%s%s%s", $2, reference, yytext) ;
                            break ;
                        case (OP_ARG) :
                            fprintf (dbic,
                                     "%s%sop_arg.%s", $2, reference, yytext) ;
                            break ;
                        case (LOG_PROP) :
                            fprintf (dbic,
                                     "%s%slog_prop->%s", $2, reference, yytext) ;
                            break ;
                        case (PHY_PROP) :
                            fprintf (dbic,
                                     "%s%sprop_vec->%s", $2, reference, yytext) ;
                            break ;
                        case (COST) :
                            fprintf (dbic,
                                     "%s%sal_arg->%s", $2, reference, yytext) ;
                            break ;
                        }
                    }
                    else perror ("Property/Method expected")
                }
                else fprintf (dbic, "%s%s", $2, yytext) ;
            }
            break ;
        }
    }
    | helper_code
      DCOPY LEFT_PAREN DESCRIPTOR COMMA DESCRIPTOR RIGHT_PAREN SEMICOLON
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s%s%s%s%s%s", $2, $3, $4, $5, $6, $7, $8) ;
            break ;
        case (3) :
            fprintf (dbic, "%s%s%s%s%s%s%s", $2, $3, $4, $5, $6, $7, $8) ;
            break ;
        }
    }
    | helper_code DCOPY COLON IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s%s", $2, $3, $4) ;
            break ;
        case (3) :
            if (find_prop (delete_white_space ($4, white)) == -1)
                perror ("Property not found")

            fprintf (dbic, "%s%s%s", $2, $3, $4) ;
            break ;
        }
    }
    | helper_code DCOPY LEFT_PAREN DESCRIPTOR struct_access IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s%s%s%s", $2, $3, $4, $5, $6) ;
            break ;
        case (3) :
            {
                int i ;
                char property [MAX_STR_LEN] ;

                strcpy (property, delete_white_space ($6, white)) ;
                if ((i = find_prop (property)) == -1)
                    perror ("Property not found")

                switch (prop[i].type) {
                case (METHOD) :
                    fprintf (dbic, "%s%s%s%s%s", $2, $3, $4, $5, $6) ;
                    break ;
                case (OP_ARG) :
                    fprintf (dbic,
                             "%s%s%s%sop_arg.%s", $2, $3, $4, $5, $6) ;
                    break ;
                case (LOG_PROP) :
                    fprintf (dbic,
                             "%s%s%s%slog_prop->%s", $2, $3, $4, $5, $6) ;
                    break ;
                case (PHY_PROP) :
                    fprintf (dbic,
                             "%s%s%s%sprop_vec->%s", $2, $3, $4, $5, $6) ;
                    break ;
                case (COST) :
                    fprintf (dbic,
                             "%s%s%s%sal_arg->%s", $2, $3, $4, $5, $6) ;
                    break ;
                }
            }
            break ;
        }
    }
    ;

desc_decl : /* empty */
    | DESC_DECL LEFT_BRACES
    {
        int i ;
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s", $1, $2) ;
            fprintf (working, "int layer_num ;\n") ;
            break ;
        case (1) :
            fprintf (dbih, "#include \"dbi_error_text.h\"\n") ;
            fprintf (dbih, "#define OPERATOR_ARGUMENT DESCRIPTOR\n") ;
            fprintf (dbih, "#define ALGORITHM_ARGUMENT DESCRIPTOR\n") ;
            fprintf (dbih, "#define dcopy(x,y) ((x) = (y))\n") ;
            fprintf (dbih, "#define allocate(v, t) ") ;
            fprintf (dbih, "((v) = (t *) malloc ((unsigned) sizeof (t)))\n") ;
            fprintf (dbih, "#define NO_OP \n\n") ;
            break ;
        case (3) :
            fprintf (dbic,
                     "STATUS print_property_vec (PROPERTY_VECTOR *_pv)\n") ;
            fprintf (dbic, "{\nif (_pv == NULL) FAIL (ERR_NULL_POINTER) ;\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == PHY_PROP)
                    fprintf (dbic, "pprint_%s (&(_pv->%s), 0) ;\n",
                             prop[i].name, prop[i].name) ;
            fprintf (dbic, "return (OKAY) ;\n}\n\n") ;

            fprintf (dbic, "STATUS print_operator_arg ") ;
            fprintf (dbic, "(OPERATOR_ARGUMENT *_oa,\n") ;
            fprintf (dbic, "OPERATOR *_op)\n") ;
            fprintf (dbic, "{\nint __pn ;\n") ;
            fprintf (dbic, "if (_oa == NULL) FAIL (ERR_NULL_POINTER) ;\n") ;
            fprintf (dbic, "for (__pn = 0; ") ;
            fprintf (dbic, "__pn < _oa->__prel.__prel_arity; __pn++)\n") ;
            fprintf (dbic, "{\nprinti (\"Relation %%d: \", __pn) ;\n") ;
            fprintf (dbic,
                     "print_set (&(_oa->__prel.__prelation[__pn]), 0) ; \n") ;
            fprintf (dbic, "printf (\"\\n\") ;\n}\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == OP_ARG)
                    fprintf (dbic, "pprint_%s (&(_oa->op_arg.%s), 0) ;\n",
                             prop[i].name, prop[i].name) ;
            fprintf (dbic, "if (_oa->log_prop)\n{\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == LOG_PROP)
                    fprintf (dbic, "pprint_%s (&(_oa->log_prop->%s), 0) ;\n",
                             prop[i].name, prop[i].name) ;
            fprintf (dbic, "}\n") ;
            fprintf (dbic, "return (OKAY) ;\n}\n\n") ;

            fprintf (dbic, "STATUS print_algorithm_arg ") ;
            fprintf (dbic, "(ALGORITHM_ARGUMENT *_aa,\n") ;
            fprintf (dbic, "ALGORITHM *_al)\n") ;
            fprintf (dbic, "{\nif (_aa == NULL) FAIL (ERR_NULL_POINTER) ;\n") ;
            fprintf (dbic, "print_operator_arg (_aa, (OPERATOR *) NULL) ;\n") ;
            fprintf (dbic, "return (OKAY) ;\n}\n\n") ;

            break ;
        }
    }
    prop_decl RIGHT_BRACES
    {
        int i ;
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $5) ;
            break ;
        case (3) :
            fprintf (dbih, "class OP_ARG {\n") ;
            fprintf (dbih, "public:\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == OP_ARG)
                    fprintf (dbih, "\t%s %s%s%s ;\n",
                             prop[i].declarator, prop[i].prefix,
                             prop[i].name, prop[i].postfix) ;
            fprintf (dbih, "} ;\n\n") ;

            fprintf (dbih, "class LOG_PROP {\n") ;
            fprintf (dbih, "public:\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == LOG_PROP)
                    fprintf (dbih, "\t%s %s%s%s ;\n",
                             prop[i].declarator, prop[i].prefix,
                             prop[i].name, prop[i].postfix) ;
            fprintf (dbih, "} ;\n\n") ;

            fprintf (dbih, "class PROPERTY_VECTOR {\n") ;
            fprintf (dbih, "public:\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == PHY_PROP)
                    fprintf (dbih, "\t%s %s%s%s ;\n",
                             prop[i].declarator, prop[i].prefix,
                             prop[i].name, prop[i].postfix) ;
            fprintf (dbih, "} ;\n\n") ;

            fprintf (dbih, "class AL_ARG ;\n\n") ;

            fprintf (dbih, "class DESCRIPTOR {\n") ;
            fprintf (dbih, "public:\n") ;
            fprintf (dbih, "\t__PREL __prel ;\n") ;
            fprintf (dbih, "\tOP_ARG op_arg ;\n") ;
            fprintf (dbih, "\tLOG_PROP *log_prop ;\n") ;
            fprintf (dbih, "\tPROPERTY_VECTOR *prop_vec ;\n") ;
            fprintf (dbih, "\tAL_ARG *al_arg ;\n") ;
            fprintf (dbih, "\tDESCRIPTOR () {\n") ;
            fprintf (dbih, "\t\t/* op_arg = NULL ; */\n") ;
            fprintf (dbih, "\t\tlog_prop = NULL ;\n") ;
            fprintf (dbih, "\t\tprop_vec = NULL ;\n") ;
            fprintf (dbih, "\t\tal_arg = NULL ; }\n") ;
            fprintf (dbih, "} ;\n\n") ;

            fprintf (dbih, "class AL_ARG {\n") ;
            fprintf (dbih, "public:\n") ;
            fprintf (dbih, "\tunsigned impl_rule_num ;\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == COST)
                    fprintf (dbih, "\t%s %s%s%s ;\n",
                             prop[i].declarator, prop[i].prefix,
                             prop[i].name, prop[i].postfix) ;
            fprintf (dbih, "\tDESCRIPTOR *operator_argument ; ") ;
            fprintf (dbih, "/* Pointing to left side operator. */\n") ;
            fprintf (dbih, "\tPROPERTY_VECTOR ") ;
            fprintf (dbih, "*required[MAX_ALGORITHM_ARITY] ;\n") ;
            fprintf (dbih, "\tDESCRIPTOR ") ;
            fprintf (dbih, "*desc[MAX_OPERATOR_ARITY+MAX_ALGORITHM_ARITY] ; ") ;
            fprintf (dbih, "/* Pointing to inputs. */\n") ;
            fprintf (dbih, "} ;\n\n") ;

            fprintf (dbih, "class LOGICAL_PROPERTY {\n") ;
            fprintf (dbih, "public: \n") ;
            fprintf (dbih, "\tDESCRIPTOR *ptr_to_descriptor ;\n") ;
            fprintf (dbih, "} ;\n") ;
            fprintf (dbih, "#define init_logical_prop(_lp) ") ;
            fprintf (dbih, "((_lp)->ptr_to_descriptor = NULL)\n") ;
            fprintf (dbih, "#define copy_logical_prop(_lp1,_lp2) \\\n") ;
            fprintf (dbih, "\t((_lp1)->ptr_to_descriptor = ") ;
            fprintf (dbih, "(_lp2)->ptr_to_descriptor)\n") ;
            fprintf (dbih, "#define logical_prop_not_set(_lp) ") ;
            fprintf (dbih, "((_lp)->ptr_to_descriptor == NULL)\n\n") ;

            fprintf (dbih, "#define init_descriptor(_desc) { \\\n") ;
            fprintf (dbih, "\t(_desc)->__prel.__prel_arity = 0 ; \\\n") ;
            fprintf (dbih, "\t(_desc)->log_prop = NULL ; \\\n") ;
            fprintf (dbih, "\t(_desc)->prop_vec = NULL ; \\\n") ;
            fprintf (dbih, "\t(_desc)->al_arg = NULL ; }\n") ;
            fprintf (dbih, "#define copy_descriptor(_desc1,_desc2) { \\\n") ;
            fprintf (dbih, "\t(_desc1)->__prel = (_desc2)->__prel ; \\\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == OP_ARG)
                {
                    fprintf (dbih, "\tcopy_%s ((_desc1)->op_arg.%s, ",
                             prop[i].name, prop[i].name) ;
                    fprintf (dbih, "(_desc2)->op_arg.%s) ; \\\n",
                             prop[i].name) ;
                }
            fprintf (dbih, "\t(_desc1)->log_prop = (_desc2)->log_prop ; \\\n") ;
            fprintf (dbih, "\t(_desc1)->prop_vec = (_desc2)->prop_vec ; \\\n") ;
            fprintf (dbih, "\t(_desc1)->al_arg = (_desc2)->al_arg ; }\n\n") ;

            fprintf (dbih, "#define copy_operator_arg(_oa1,_oa2) ") ;
            fprintf (dbih, "copy_descriptor (_oa1, _oa2)\n") ;
            fprintf (dbih, "#define copy_algorithm_arg(_aa1,_aa2) ") ;
            fprintf (dbih, "copy_descriptor (_aa1, _aa2)\n") ;
            fprintf (dbih, "#define property_vec_not_set(_pv) (0)\n") ;
            fprintf (dbih, "#define init_property_vec(_pv) { \\\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == PHY_PROP)
                    fprintf (dbih, "\tinit_%s ((_pv)->%s) ; \\\n",
                             prop[i].name, prop[i].name) ;
            fprintf (dbih, "\t}\n") ;
            fprintf (dbih, "#define copy_property_vec(_pv1,_pv2) { \\\n") ;
            for (i = 0; i <= prop_index; i++)
                if (prop[i].type == PHY_PROP)
                    fprintf (dbih,
                             "\tcopy_%s ((_pv1)->%s, (_pv2)->%s) ; \\\n",
                             prop[i].name, prop[i].name, prop[i].name) ;
            fprintf (dbih, "\t}\n") ;
            fprintf (dbih, "#define init_operator_arg(_oa) ") ;
            fprintf (dbih, "init_descriptor (_oa)\n") ;
            fprintf (dbih, "#define init_algorithm_arg(_aa) ") ;
            fprintf (dbih, "init_descriptor (_aa)\n\n") ;

            break ;
        }
    }
    ;

prop_decl : /* empty */
    | prop_decl IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcpy (decl_prefix, "") ;
        strcpy (decl_postfix, "") ;
    }
    declarator SEMICOLON
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $5) ;
            break ;
        case (1) :
            strcpy (prop[prop_index].declarator, $2) ;
            strcpy (prop[prop_index].prefix, decl_prefix) ;
            strcpy (prop[prop_index].postfix, decl_postfix) ;
            break ;
        case (2) :
            if (strcmp (delete_white_space ($2, white), "COST") == 0)
                prop[find_prop ($4)].type = COST ;
            break ;
        }
    }
    ;

declarator :
    IDENTIFIER
    {
        char tok_str [MAX_STR_LEN] ;
        strcpy (tok_str, delete_white_space ($1, white)) ;

        switch (pass) {
        case (0) :
            fprintf (working, "%s", $1) ;
            break ;
        case (1) :
            /* By default, everything is a logical property. */
            if (find_prop (tok_str) != -1)
                perror ("Duplicate property in descriptor")

            strcpy (prop[++prop_index].name, tok_str) ;
            prop[prop_index].type = LOG_PROP ;
            break ;
        }
        strcpy ($$, tok_str) ;
    }
    | declarator LEFT_PAREN
    {
        int pindex ;
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            if ((pindex = find_prop ($1)) == -1)
                perror ("Internal error")

            prop[pindex].type = METHOD ;
            break ;
        }
        strcat (decl_postfix, $2) ;
    }
    argument_list RIGHT_PAREN
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $5) ;
            break ;
        }
        strcat (decl_postfix, $5) ;
        strcpy ($$, $1) ;
    }
    | STAR
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $1) ;
            break ;
        }
        strcat (decl_prefix, $1) ;
    }
    declarator
    {
        strcpy ($$, $3) ;
    }
    | declarator LEFT_BRACKET
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $2) ;
    }
    const_expr RIGHT_BRACKET
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $5) ;
            break ;
        }
        strcat (decl_postfix, $5) ;
        strcpy ($$, $1) ;
    }
    ;

argument_list : { strcpy ($$, "") ; }
    | argument_list IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list ASGNOP
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list BINOP
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list COLON
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list COMMA
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list DOT
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list EXCLAIM
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list LEFT_BRACKET
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list LITERAL
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list NUMBER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list RIGHT_BRACKET
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list STAR
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | argument_list UNOP
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    ;

const_expr : { strcpy ($$, "") ; }
    | const_expr IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr ASGNOP
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr BINOP
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr COLON
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr COMMA
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr DOT
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr EXCLAIM
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr LEFT_PAREN
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr LITERAL
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr NUMBER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr RIGHT_PAREN
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr STAR
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    | const_expr UNOP
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
        strcat (decl_postfix, $1) ;
        strcat (decl_postfix, $2) ;
    }
    ;

header_stats : /* empty */
    | header_stats IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            fprintf (dbih, "%s", $2) ;
            break ;
        }
    }
    | header_stats DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            /* Probably needs to be fixed, depending on property reference. */
            fprintf (dbih, "%s", $2) ;
            break ;
        }
    }
    | header_stats c_stuff_dcopy
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            fprintf (dbih, "%s", $2) ;
            break ;
        }
    }
    ;

decls_stats : /* empty */
    | decls_stats IDENTIFIER
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            fprintf (dbic, "%s", $2) ;
            break ;
        }
    }
    | decls_stats c_stuff_dcopy
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            fprintf (dbic, "%s", $2) ;
            break ;
        }
    }
    ;

layer_stacking : /* empty */
    { strcpy ($$, "") ; }
    | LAYER_STACKING layer_composition
    {
        strcpy ($$, "") ;
    }
    ;

layer_composition :
    IDENTIFIER
    {
        switch (pass) {
        case (0) :
            {
                int i ;
                char layer_name [MAX_STR_LEN] ;

                strcpy (layer_name, delete_white_space ($1, white)) ;

                /* Check if this layer is already present in the composition. */
                for (i = 0; i <= layer_index; i++)
                    if (strcmp (layer_name, layer[i].name) == 0)
                        perror ("Layers must be distinct in composition")

                /* Insert current layer in layer table. */
                layer_index++ ;
                strcpy (layer[layer_index].name, layer_name) ;
                layer[layer_index].layer_num = 1 ;
                layer[layer_index].next_layer = 0 ;
                layer[layer_index].defined = 0 ;
            }
            break ;
        }
    }
    | IDENTIFIER LEFT_BRACKET layer_composition RIGHT_BRACKET
    {
        switch (pass) {
        case (0) :
            {
                int i ;
                char layer_name [MAX_STR_LEN] ;

                strcpy (layer_name, delete_white_space ($1, white)) ;

                /* Increment all other layer numbers. */
                for (i = 0; i <= layer_index; i++)
                {
                    layer[i].layer_num++ ;
                    if (layer[i].next_layer != 0) layer[i].next_layer++ ;
                }

                /* Insert new layer into layer table. */
                layer_index++ ;
                strcpy (layer[layer_index].name, layer_name) ;
                layer[layer_index].layer_num = 1 ;
                layer[layer_index].next_layer = 2 ;
                layer[layer_index].defined = 0 ;
            }
            break ;
        }
    }
    ;

definitions : /* empty */
    | definitions operator_def
    | definitions algorithm_def
    ;

operator_def :
    OPERATOR IDENTIFIER LEFT_PAREN
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s%s", $1, $2, $3) ;
            break ;
        }
    }
    inputs RIGHT_PAREN
    {
        int i ;
        char tok_str [MAX_STR_LEN] ;

        strcpy (tok_str, delete_white_space ($2, white)) ;

        switch (pass) {
        case (0) :
            fprintf (working, "%s", $6) ;
            op_table_index++ ;
            strcpy(op_table[op_table_index].name, tok_str) ;
            op_table[op_table_index].arity.files = $5.files;
            op_table[op_table_index].arity.streams = $5.streams ;
            op_table[op_table_index].op_type = OPR ;
            op_table[op_table_index].redundant = 1 ;

            /* Insert a version of the operator for each layer
               except the top. */
            for (i = 0; i <= layer_index; i++)
            {
                if (i == layer_index)
                    break ;
                op_table_index++ ;
                sprintf (op_table[op_table_index].name,
                         "%s_%s", tok_str, layer[i].name) ;
                op_table[op_table_index].arity.files = $5.files;
                op_table[op_table_index].arity.streams = $5.streams ;
                op_table[op_table_index].op_type = OPR ;
                op_table[op_table_index].redundant = 1 ;
            }
            break ;
        case (1) :
            break ;
        case (3) :
            i = find (tok_str) ;
            if (op_table[i].op_type == OPR
                && strcmp (op_table[i].name, find_opr_map (op_table[i].name))
                       == 0
                && op_table[i].redundant == 0)
            {
                int j ;
                char layer_op [MAX_STR_LEN] ;
                fprintf (pr_out, "%%operator %s %d\n",
                         op_table[i].name, op_table[i].arity.streams) ;
                for (j = 0; j <= layer_index; j++)
                {
                    if (j == layer_index)
                         break ;
                    sprintf (layer_op, "%s_%s", tok_str, layer[j].name) ;
                    if (op_table [find (layer_op)].redundant == 0)
                        fprintf (pr_out, "%%operator %s %d\n",
                                 layer_op, op_table[i].arity.streams) ;
                }
            }
            break ;
        }
    }
    ;

algorithm_def :
    ALGORITHM IDENTIFIER LEFT_PAREN
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s%s%s", $1, $2, $3) ;
            break ;
        }
    }
    inputs RIGHT_PAREN
    {
        char tok_str [MAX_STR_LEN] ;

        strcpy (tok_str, delete_white_space ($2, white)) ;

        switch (pass) {
        case (0) :
            fprintf (working, "%s", $6) ;
            op_table_index++ ;
            strcpy(op_table[op_table_index].name, tok_str) ;
            op_table[op_table_index].arity.files = $5.files;
            op_table[op_table_index].arity.streams = $5.streams ;
            op_table[op_table_index].op_type = ALG ;
            op_table[op_table_index].redundant = 1 ;
            break ;
        case (1) :
            break ;
        case (3) :
            {
                int i ;
                i = find (tok_str) ;
                if (op_table[i].op_type == ALG && op_table[i].redundant == 0)
                    fprintf (pr_out, "%%algorithm %s %d\n",
                             op_table[i].name, op_table[i].arity.streams) ;
                else
                    if (strcmp (tok_str, NULL_ALG) != 0
                        && op_table[i].redundant == 0)
                        fprintf (pr_out, "%%enforcer %s %d\n",
                                 op_table[i].name, op_table[i].arity.streams) ;

                /* Print the headers of the do_any_good and the
                   derive_phy_prop functions. */
                if (strcmp (tok_str, NULL_ALG) != 0
                    && op_table[i].redundant == 0)
                {
                    strcpy (current_alg, tok_str) ;
                    sprintf (do_any_good_file,
                             "_do_any_good_%s", current_alg) ;
                    ptr_to_do_any_good_file = fopen (do_any_good_file, "w") ;
                    print_do_any_good_head (ptr_to_do_any_good_file) ;
                    fclose (ptr_to_do_any_good_file) ;

                    sprintf (derive_phy_prop_file,
                             "_derive_phy_prop_%s", current_alg) ;
                    ptr_to_derive_phy_prop_file =
                        fopen (derive_phy_prop_file, "w") ;
                    print_derive_phy_prop_head (ptr_to_derive_phy_prop_file) ;
                    fclose (ptr_to_derive_phy_prop_file) ;
                }
            }
            break ;
        }
    }
    ;

single_input : /* empty */
    {
        $$.files = 0 ;
        $$.streams = 0 ;
    }
    | RELATION
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $1) ;
            break ;
        }
        $$.files = 1 ;
        $$.streams = 0 ;
    }
    | STREAM
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $1) ;
            break ;
        }
        $$.files = 0 ;
        $$.streams = 1 ;
    }
    ;

inputs :
    single_input
    | inputs COMMA
    {
        switch (pass) {
        case (0) :
            fprintf (working, "%s", $2) ;
            break ;
        }
    }
    single_input
    {
        $$.files = $1.files + $4.files ;
        $$.streams = $1.streams + $4.streams ;
    }
    ;

layer_rules :
    rules
    {
        strcpy ($$, "") ;
    }
    | layer_rules LAYER IDENTIFIER
    {
        switch (pass) {
        case (0) :
            strcpy (current_layer, delete_white_space ($3, white)) ;
            /* If layer is not in optimizer, then discard all
               rules in this layer. */
            discard_rule = (find_layer (current_layer) == -1) ? 1 : 0 ;
            break ;
        }
    }
    rules
    {
    }
    ;

rules : /* empty */
    | rules
    {
        drule_index = -1 ;
        fref_index = -1 ;
    }
    trule
    | rules
    {
        drule_index = -1 ;
        fref_index = -1 ;
    }
    irule
    ;

irule :
    IRULE
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
    }
    abst_expr
    REWRITE
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $4) ;
            break ;
        }
    }
    conc_expr
    {
        int i, j, k ;
        int duplicate ;

        ++prairie_irule_num ;

        strcpy (irule_left_root_desc, $3->desc) ;
        strcpy (irule_right_root_desc, $6->desc) ;

        /* Verify that "conc_expr" is a single algorithm. */
        if (!is_single_opr_or_alg ($6))
            perror ("Right side must be a single algorithm")
        switch (pass) {
        case (0) :
            if (discard_rule)
            {
                fprintf (stdout, "I-rule %d: ", prairie_irule_num) ;
                fprintf (stdout, "Discarding rule in unused layer %s...\n",
                         current_layer) ;
                fprintf (stdout, "    ") ;
                print_prairie_tree (stdout, $3, "") ;
                fprintf (stdout, " %s", $4) ;
                print_prairie_tree (stdout, $6, "") ;
                fprintf (stdout, "\n") ;
            }
            break ;
        case (1) :
            /* Recognize enforcer-operators. */
            null_rule = 0 ;
            if (is_opr_with_one_input ($3) && is_null_alg ($6))
            {
                null_rule = 1 ;
                op_table [find ($3->name)].op_type = ENF_OPR ;
            }
            break ;
        case (2) :
            /* Recognize enforcers. */
            if (is_enf_opr ($3))
                if (is_alg_with_one_input ($6))
                {
                    int i ;
                    i = find ($6->name) ;
                    op_table[i].op_type = ENF ;
                    op_table[i].redundant = 0 ;
                }
                else perror ("Right side must be a single-input algorithm")
            else
            {
                op_table[find ($3->name)].redundant = 0 ;
                op_table[find ($6->name)].redundant = 0 ;
            }
            ++vol_impl_rule_num ;
            break ;
        case (3) :
            /* Check that left side is not an enforcer operator or
               right side is not an enforcer. */
printf ("Processing I-rule %d ******************\n", prairie_irule_num) ;
            null_rule = 0 ;
            enf_rule = 0 ;

            sprintf (do_any_good_file, "_do_any_good_%s", current_alg) ;
            ptr_to_do_any_good_file = fopen (do_any_good_file, "a") ;

            sprintf (derive_phy_prop_file, "_derive_phy_prop_%s", current_alg) ;
            ptr_to_derive_phy_prop_file = fopen (derive_phy_prop_file, "a") ;

            if (is_enf_opr ($3))
            {
                if (is_null_alg ($6))
                {
                    null_rule = 1 ;
                    fprintf (stdout, "I-rule %d: ", prairie_irule_num) ;
                    fprintf (stdout, "Discarding %s algorithm...\n", NULL_ALG) ;
                    fprintf (stdout, "    ") ;
                    print_prairie_tree (stdout, $3, "") ;
                    fprintf (stdout, " %s", $4) ;
                    print_prairie_tree (stdout, $6, "") ;
                    fprintf (stdout, "\n") ;
                }
                else
                {
                    TREE_TYPE *child ;
                    enf_rule = 1 ;

                    irule_test_file = ptr_to_do_any_good_file ;
                    /* Generate the descriptor mapping info table
                       drule [] for do_any_good function. */
                    fref_index = -1 ;
                    drule_index = -1 ;
                    file_references ($3) ;
                    file_references ($6) ;
                    insert_dirule_for_do_any_good ($3, "", -1) ;
                    child = $3->child[0] ;
                    sprintf (drule[++drule_index].desc, "D%s", child->name+1) ;
                    strcpy (drule[drule_index].volcano_desc, $3->desc) ;
                    sprintf (drule[++drule_index].desc,
                             "D%soa",
                             child->name+1) ;
                    sprintf (drule[drule_index].volcano_desc, "%soa", $3->desc);
                    sprintf (drule[++drule_index].desc,
                             "D%slp",
                             child->name+1) ;
                    sprintf (drule[drule_index].volcano_desc, "%slp", $3->desc);
                    insert_dirule_for_do_any_good ($6, "", -1) ;
                    /* Insert needed property vector of left hand side. */
                    sprintf (drule[++drule_index].desc, "%spv", $3->desc) ;
                    strcpy (drule[drule_index].volcano_desc,
                            "(*needed_pv)") ;

                    print_do_any_good_body_head (ptr_to_do_any_good_file,
                                                 vol_impl_rule_num) ;
                    fprintf (ptr_to_do_any_good_file,
                             "ret_value->apply_truth_value = FALSE ;\n") ;
                    fprintf (ptr_to_do_any_good_file,
                             "memset ((void *) &%soa, 0, sizeof (OP_ARG)) ;\n",
                             $6->desc) ;
                    fprintf (ptr_to_do_any_good_file,
                             "%s.prop_vec = needed_pv ;\n",
                             $3->desc) ;
                    fprintf (ptr_to_do_any_good_file,
                             "allocate (%s.al_arg, AL_ARG) ;\n",
                             $6->desc) ;
                    fprintf (ptr_to_do_any_good_file,
                             "%s.al_arg->operator_argument = oa ;\n",
                             $6->desc) ;
                    fprintf (ptr_to_do_any_good_file,
                             "allocate (%s.al_arg->desc[0], OPERATOR_ARGUMENT) ;\n",
                             $6->desc) ;
                    for (i = 0; i <= prop_index; i++)
                        if (prop[i].type == OP_ARG)
                        {
                            fprintf (ptr_to_do_any_good_file,
                                     "copy_%s (%s.al_arg->desc[0]->op_arg.%s,",
                                     prop[i].name, $6->desc, prop[i].name) ;
                            fprintf (ptr_to_do_any_good_file,
                                     "oa->op_arg.%s) ;\n",
                                     prop[i].name) ;
                        }
                    fprintf (ptr_to_do_any_good_file,
                             "%s.al_arg->desc[0]->log_prop = oa->log_prop ;\n",
                             $6->desc) ;
                }
            }
            else
            {
                ++vol_impl_rule_num ;
                sprintf (irule_head, "_irule_head_%03d", vol_impl_rule_num) ;
                ptr_to_irule_head = fopen (irule_head, "w") ;
                sprintf (irule_defs, "_irule_defs_%03d", vol_impl_rule_num) ;
                ptr_to_irule_defs = fopen (irule_defs, "w") ;
                sprintf (irule_cond, "_irule_cond_%03d", vol_impl_rule_num) ;
                ptr_to_irule_cond = fopen (irule_cond, "w") ;
                sprintf (irule_divide, "_irule_divide_%03d", vol_impl_rule_num);
                ptr_to_irule_divide = fopen (irule_divide, "w") ;
                sprintf (irule_appl, "_irule_appl_%03d", vol_impl_rule_num) ;
                ptr_to_irule_appl = fopen (irule_appl, "w") ;
                sprintf (irule_undefs, "_irule_undefs_%03d", vol_impl_rule_num);
                ptr_to_irule_undefs = fopen (irule_undefs, "w") ;

                irule_test_file = ptr_to_irule_cond ;
                fprintf (ptr_to_irule_head, "\n") ;
                fprintf (ptr_to_irule_head, "------------------------") ;
                fprintf (ptr_to_irule_head, " Begin Implementation rule %d ",
                         vol_impl_rule_num) ;
                fprintf (ptr_to_irule_head, "------------------------") ;
                fprintf (ptr_to_irule_head, "\n\n") ;
                fprintf (ptr_to_irule_head, "%%impl_rule ") ;
                print_volcano_tree (ptr_to_irule_head, $3, "") ;
                fprintf (ptr_to_irule_head, "\n        -> ") ;
                print_volcano_tree (ptr_to_irule_head, $6, "") ;
                fprintf (ptr_to_irule_head, "\n%%cond_code\n{{\n") ;

                /* Generate the descriptor mapping info table drule []
                   for model.input file. */
                drule_index = -1 ;
                insert_dirule_for_model_input ($3, "", -1) ;
                file_references ($3) ;
                file_references ($6) ;
                /* Insert the algorithm argument also. */
                strcpy (drule[++drule_index].desc, $6->desc) ;
                sprintf (drule[drule_index].volcano_desc, "(*(?al_arg%s))",
                         $6->desc+1) ;
                sprintf (drule[++drule_index].desc, "%soa", $6->desc) ;
                sprintf (drule[drule_index].volcano_desc, "(%s.op_arg)",
                         $6->desc) ;
                sprintf (drule[++drule_index].desc, "%slp", $6->desc) ;
                sprintf (drule[drule_index].volcano_desc, "(*(%s.log_prop))",
                         $6->desc) ;

                fprintf (ptr_to_irule_divide, "}}\n") ;
                fprintf (ptr_to_irule_divide, "%%appl_code\n{{\n") ;
                fprintf (ptr_to_irule_appl, "{\n") ;

                if (vol_impl_rule_num == 0)
                    fprintf (ptr_to_irule_defs, "#include \"prototypes.h\"\n") ;
                print_descriptor_defs (ptr_to_irule_defs)
                print_file_defs (ptr_to_irule_defs)
                fprintf (ptr_to_irule_defs, "\n") ;

                fprintf (ptr_to_irule_undefs, "\n") ;
                print_descriptor_undefs (ptr_to_irule_undefs)
                print_file_undefs (ptr_to_irule_undefs)
                fprintf (ptr_to_irule_undefs, "}}") ;
                fprintf (ptr_to_irule_undefs, "\n\n") ;
                fprintf (ptr_to_irule_undefs, "-------------------------") ;
                fprintf (ptr_to_irule_undefs, " End Implementation rule %d ",
                         vol_impl_rule_num) ;
                fprintf (ptr_to_irule_undefs, "-------------------------") ;
                fprintf (ptr_to_irule_undefs, "\n") ;

                fprintf (ptr_to_irule_cond, "{\n") ;
                fprintf (ptr_to_irule_cond,
                         "%s.prop_vec = %s.prop_vec ;\n",
                         $3->desc, $6->desc) ;

                /* Generate the descriptor mapping info table drule []
                   for do_any_good function. */
                fref_index = -1 ;
                file_references ($3) ;
                file_references ($6) ;
                drule_index = -1 ;
                insert_dirule_for_do_any_good ($3, "", -1) ;
                for (i = op_table[find(current_alg)].arity.streams, j = 0;
                     j < MAX_CHILDREN; j++)
                {
                    TREE_TYPE *child ;
                    child = $3->child[j] ;
                    if (child == NULL)
                        break ;
                    switch (child->node_type) {
                    case (OPR_NODE) :
                        insert_dirule_for_do_any_good (child,
                                                       irule_right_root_desc,
                                                       i) ;
                        i++ ;
                        break ;
                    case (STR_NODE) :
                        duplicate = 0 ;
                        /* Check if the stream is an input of the algorithm. */
                        for (k = 0; k < MAX_CHILDREN; k++)
                        {
                            if ($6->child[k] == NULL)
                                break ;
                            if (strcmp ($6->child[k]->name,
                                        child->name) == NULL)
                            {
                                duplicate = 1 ;
                                insert_dirule_for_do_any_good (child,
                                                          irule_right_root_desc,
                                                               k) ;
                                break ;
                            }
                        }
                        if (duplicate == 0)
                        {
                            insert_dirule_for_do_any_good (child,
                                                          irule_right_root_desc,
                                                           i) ;
                            i++ ;
                        }
                        break ;
                    case (REL_NODE) :
                        break ;
                    case (ALG_NODE) :
                        /* This will never happen. */
                        break ;
                    }
                }
                sprintf (drule[++drule_index].desc, "%spv", $3->desc) ;
                strcpy (drule[drule_index].volcano_desc, "(*needed_pv)") ;
                insert_dirule_for_do_any_good ($6, "", -1) ;

                print_do_any_good_body_head (ptr_to_do_any_good_file,
                                             vol_impl_rule_num) ;
                fprintf (ptr_to_do_any_good_file,
                         "%s.prop_vec = needed_pv ;\n",
                         $3->desc) ;
                fprintf (ptr_to_do_any_good_file,
                         "%s.al_arg->operator_argument = oa ;\n",
                         $6->desc) ;
            }
            break ;
        }
    }
    irule_test
    {
        switch (pass) {
        case (1) :
            break ;
        case (2) :
            break ;
        case (3) :
            if (!is_enf_opr ($3))
            {
                int i, j, k ;
                int duplicate ;

                fprintf (ptr_to_irule_appl,
                         "allocate (%s.al_arg, AL_ARG) ;\n",
                         $6->desc) ;
                fprintf (ptr_to_irule_appl, "%s.al_arg->impl_rule_num = %d ;\n",
                         $6->desc, vol_impl_rule_num) ;

                generate_operator_argument_tree ($6, "", -1) ;

                for (i = op_table[find(current_alg)].arity.streams, j = 0;
                     j < MAX_CHILDREN; j++)
                {
                    TREE_TYPE *child ;
                    child = $3->child[j] ;
                    if (child == NULL)
                        break ;
                    switch (child->node_type) {
                    case (OPR_NODE) :
                        fprintf (ptr_to_irule_appl,
                                 "%s.al_arg->desc[%d] = &(%s) ;\n",
                                 $6->desc, i, child->desc) ;
                        i++ ;
                        break ;
                    case (STR_NODE) :
                        duplicate = 0 ;
                        /* Check if the stream is an input of the algorithm. */
                        for (k = 0; k < MAX_CHILDREN; k++)
                        {
                            if ($6->child[k] == NULL)
                                break ;
                            if (strcmp ($6->child[k]->name,
                                        child->name) == NULL)
                            {
                                duplicate = 1 ;
                                break ;
                            }
                        }
                        if (duplicate == 0)
                        {
                            fprintf (ptr_to_irule_appl,
                                     "%s.al_arg->desc[%d] = &(D%s) ;\n",
                                     $6->desc, i, child->name+1) ;
                            i++ ;
                        }
                        break ;
                    case (REL_NODE) :
                        break ;
                    case (ALG_NODE) :
                        /* This will never happen. */
                        break ;
                    }
                }
                fprintf (ptr_to_irule_appl, "}\n") ;
            }

            break ;
        }
    }
    irule_pre_opt
    {
        switch (pass) {
        case (3) :
            if (!null_rule)
            {
                int i, j, k ;
                int duplicate ;
                TREE_TYPE *ptr ;

                print_do_any_good_body_tail (ptr_to_do_any_good_file,
                                             vol_impl_rule_num) ;
                drule_index = -1 ;
                insert_dirule_for_derive_phy_prop ($3, "", -1) ;
                for (i = op_table[find(current_alg)].arity.streams, j = 0;
                     j < MAX_CHILDREN; j++)
                {
                    TREE_TYPE *child ;
                    child = $3->child[j] ;
                    if (child == NULL)
                        break ;
                    switch (child->node_type) {
                    case (OPR_NODE) :
                        insert_dirule_for_derive_phy_prop (child,
                                                          irule_right_root_desc,
                                                           i) ;
                        i++ ;
                        break ;
                    case (STR_NODE) :
                        duplicate = 0 ;
                        /* Check if the stream is an input of the algorithm. */
                        for (k = 0; k < MAX_CHILDREN; k++)
                        {
                            if ($6->child[k] == NULL)
                                break ;
                            if (strcmp ($6->child[k]->name,
                                        child->name) == NULL)
                            {
                                duplicate = 1 ;
                                insert_dirule_for_derive_phy_prop (child,
                                                          irule_right_root_desc,
                                                               k) ;
                                break ;
                            }
                        }
                        if (duplicate == 0)
                        {
                            insert_dirule_for_derive_phy_prop (child,
                                                          irule_right_root_desc,
                                                           i) ;
                            i++ ;
                        }
                        break ;
                    case (REL_NODE) :
                        break ;
                    case (ALG_NODE) :
                        /* This will never happen. */
                        break ;
                    }
                }
                insert_dirule_for_derive_phy_prop ($6, "", -1) ;

                print_derive_phy_prop_body_head (ptr_to_derive_phy_prop_file,
                                                 vol_impl_rule_num) ;

                if (op_table [find (current_alg)].op_type == ENF)
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s.prop_vec = needed_pv ;\n",
                             $3->desc) ;

                fprintf (ptr_to_derive_phy_prop_file,
                         "%s.prop_vec = derived_pv ;\n",
                         $6->desc) ;
                for (i = 0; i < MAX_CHILDREN; i++)
                    if ((ptr = $6->child[i]) == NULL)
                        break ;
                    else if (ptr->node_type == OPR_NODE
                             || ptr->node_type == STR_NODE)
                        fprintf (ptr_to_derive_phy_prop_file,
                                 "%s.prop_vec = input_pv[%d] ;\n",
                                 ptr->desc, i) ;

                fprintf (ptr_to_derive_phy_prop_file, "\n{\n") ;
            }
        }
        break ;
    }
    irule_post_opt
    {
        switch (pass) {
        case (3) :
            if (!null_rule)
            {
                char command [MAX_STR_LEN] ;

                if (!is_enf_opr ($3))
                    fprintf (ptr_to_irule_cond, "}\n") ;
                fprintf (ptr_to_derive_phy_prop_file, "\n}\n") ;

                print_derive_phy_prop_body_tail (ptr_to_derive_phy_prop_file,
                                                 vol_impl_rule_num) ;
                fclose (ptr_to_do_any_good_file) ;
                fclose (ptr_to_derive_phy_prop_file) ;

                fclose (ptr_to_irule_head) ;
                fclose (ptr_to_irule_defs) ;
                fclose (ptr_to_irule_cond) ;
                fclose (ptr_to_irule_divide) ;
                fclose (ptr_to_irule_appl) ;
                fclose (ptr_to_irule_undefs) ;

                if (!is_enf_opr ($3))
                {
                    sprintf (command,
                             "indent -bap -bl -bli0 -cli0 -sob %s",
                             irule_cond) ;
                    system (command) ;
                    sprintf (command,
                             "indent -bap -bl -bli0 -cli0 -sob %s",
                             irule_appl) ;
                    system (command) ;
                    sprintf (command,
                             "cat %s %s %s %s %s %s >> %s",
                             irule_head, irule_defs, irule_cond,
                             irule_divide, irule_appl, irule_undefs,
                             PRAIRIE_IRULES) ;
                    system (command) ;
                }
            }
            break ;
        }
    }
    ;

trule :
    TRULE
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
    }
    abst_expr
    REWRITE exclaim
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s", $4, $5) ;
            break ;
        }
    }
    abst_expr
    {
        ++prairie_trule_num ;
        junk_this_trule = 1 ;
        desc_index = -1 ;
        fref_index = -1 ;
        drule_index = -1 ;
        file_references ($3) ;
        file_references ($7) ;
        insert_dtrule ($3) ;
        dleft_side_index = drule_index ;
        insert_dtrule ($7) ;
        strcpy (trule_left_root_desc, $3->desc) ;
        strcpy (trule_right_root_desc, $7->desc) ;
        switch (pass) {
        case (0) :
            if (discard_rule)
            {
                fprintf (stdout, "T-rule %d: ", prairie_trule_num) ;
                fprintf (stdout, "Discarding rule in unused layer %s...\n",
                         current_layer) ;
                fprintf (stdout, "    ") ;
                print_prairie_tree (stdout, $3, "") ;
                fprintf (stdout, " %s", $4) ;
                fprintf (stdout, "%s", $5) ;
                print_prairie_tree (stdout, $7, "") ;
                fprintf (stdout, "\n") ;
            }
            break ;
        case (1) :
            unify_expr ($3, $7) ;
            break ;
        case (2) :
            if (is_enf_opr ($3) || is_enf_opr ($7))
            {
                op_table[find ($3->name)].op_type = ENF_OPR ;
                op_table[find ($7->name)].op_type = ENF_OPR ;
            }
            if (unify_expr ($3, $7) != 1)
                junk_this_trule = 0 ;
            break ;
        case (3) :
printf ("Processing T-rule %d ******************\n", prairie_trule_num) ;
            if (unify_expr ($3, $7))
            {
                weak_unify = weak_unify_expr ($3, $7) ;
                trule_right_root_opr_file_arity
                    = op_table[find ($7->name)].arity.files ;
            }
            if (is_enf_opr ($3))
            {
                fprintf (stdout, "T-rule %d: ", prairie_trule_num) ;
                fprintf (stdout, "Discarding enforcer-operator rule...\n") ;
                fprintf (stdout, "    ") ;
                print_prairie_tree (stdout, $3, "") ;
                fprintf (stdout, " %s%s", $4, $5) ;
                print_prairie_tree (stdout, $7, "") ;
                fprintf (stdout, "\n") ;
            }
            else
            {
                int i ;
                /* Keep track of Volcano rule numbers. */
                if ((junk_this_trule = junk (prairie_trule_num)) == 0)
                    vol_trans_rule_num += 1 ;
                if (junk_this_trule == 0)
                {
                    sprintf (trule_head,
                             "_trule_head_%03d", vol_trans_rule_num) ;
                    ptr_to_trule_head = fopen (trule_head, "w") ;
                    sprintf (trule_defs,
                             "_trule_defs_%03d", vol_trans_rule_num) ;
                    ptr_to_trule_defs = fopen (trule_defs, "w") ;
                    sprintf (trule_cond,
                             "_trule_cond_%03d", vol_trans_rule_num) ;
                    ptr_to_trule_cond = fopen (trule_cond, "w") ;
                    sprintf (trule_divide,
                             "_trule_divide_%03d", vol_trans_rule_num);
                    ptr_to_trule_divide = fopen (trule_divide, "w") ;
                    sprintf (trule_appl,
                             "_trule_appl_%03d", vol_trans_rule_num) ;
                    ptr_to_trule_appl = fopen (trule_appl, "w") ;
                    sprintf (trule_undefs,
                             "_trule_undefs_%03d", vol_trans_rule_num);
                    ptr_to_trule_undefs = fopen (trule_undefs, "w") ;

                    file_references ($3) ;
                    fprintf (ptr_to_trule_head, "\n") ;
                    fprintf (ptr_to_trule_head,
                             "------------------------") ;
                    fprintf (ptr_to_trule_head,
                             " Begin Transformation rule %d ",
                             vol_trans_rule_num) ;
                    fprintf (ptr_to_trule_head,
                             "------------------------") ;
                    fprintf (ptr_to_trule_head, "\n\n") ;
                    fprintf (ptr_to_trule_head, "%%trans_rule ") ;
                    print_volcano_tree (ptr_to_trule_head, $3, "") ;
                    if (strcmp ($5, "") == 0)
                        fprintf (ptr_to_trule_head, "\n         -> ") ;
                    else fprintf (ptr_to_trule_head, "\n        ->%s", $5) ;
                    print_volcano_tree (ptr_to_trule_head, $7, "") ;
                    fprintf (ptr_to_trule_head, "\n") ;

                    fprintf (ptr_to_trule_divide, "}}\n") ;
                    fprintf (ptr_to_trule_divide, "%%appl_code\n") ;
                    fprintf (ptr_to_trule_divide, "{{\n") ;

                    fprintf (ptr_to_trule_head, "%%cond_code\n{{\n") ;
                    if (vol_trans_rule_num == 0)
                        fprintf (ptr_to_trule_head,
                                 "#include \"prototypes.h\"\n") ;
                    print_descriptor_defs (ptr_to_trule_defs)
                    print_file_defs (ptr_to_trule_defs)
                    fprintf (ptr_to_trule_cond, "\n") ;

                    fprintf (ptr_to_trule_appl, "%s", desc_decls) ;
                    fprintf (ptr_to_trule_appl,
                             "/* Volcano requires right side op_args ") ;
                    fprintf (ptr_to_trule_appl,
                             "to appear in appl_code. */\n") ;
                    fprintf (ptr_to_trule_appl,
                             "/* We put them in a comment, since we ") ;
                    fprintf (ptr_to_trule_appl,
                             "are using macros.        */\n") ;
                    fprintf (ptr_to_trule_appl, "/* ") ;
                    for (i = dleft_side_index + 1; i <= drule_index; i++)
                        if (strstr (drule[i].volcano_desc, "?op_arg")
                                != NULL)
                            fprintf (ptr_to_trule_appl, "%s; ",
                                     strtok (strchr (drule[i].volcano_desc,
                                             '?'),
                                     ")")) ;
                    fprintf (ptr_to_trule_appl, "*/\n") ;
                    fprintf (ptr_to_trule_appl, "{\n") ;

                    fprintf (ptr_to_trule_undefs, "\n") ;
                    print_descriptor_undefs (ptr_to_trule_undefs)
                    print_file_undefs (ptr_to_trule_undefs)
                    fprintf (ptr_to_trule_undefs, "}}\n") ;
                    fprintf (ptr_to_trule_undefs, "\n") ;
                    fprintf (ptr_to_trule_undefs,
                             "-------------------------") ;
                    fprintf (ptr_to_trule_undefs,
                             " End Transformation rule %d ",
                             vol_trans_rule_num) ;
                    fprintf (ptr_to_trule_undefs,
                             "-------------------------") ;
                    fprintf (ptr_to_trule_undefs, "\n") ;

                    first = 1 ;
                    strcpy (desc_decls, "") ;
                    get_desc_decls ($7, 1) ;
                    if (first != 1)
                        strcat (desc_decls, " ;") ;
                }
                else
                {
                    fprintf (stdout, "T-rule %d: ", prairie_trule_num) ;
                    fprintf (stdout, "Discarding idempotent rule...\n");
                    fprintf (stdout, "    ") ;
                    print_prairie_tree (stdout, $3, "") ;
                    fprintf (stdout, " %s%s", $4, $5) ;
                    print_prairie_tree (stdout, $7, "") ;
                    fprintf (stdout, "\n") ;
                }
            }
            break ;
        }
    }
    trule_pre_test trule_test trule_post_test
    {
        switch (pass) {
        case (2) :
            /* Insert prairie_trule_num into junk_trule list. */
            if (junk_this_trule == 1)
                junk_trule [++junk_trule_index] = prairie_trule_num ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                char command [MAX_STR_LEN] ;

                fprintf (ptr_to_trule_appl, "}\n") ;

                fclose (ptr_to_trule_head) ;
                fclose (ptr_to_trule_defs) ;
                fclose (ptr_to_trule_cond) ;
                fclose (ptr_to_trule_divide) ;
                fclose (ptr_to_trule_appl) ;
                fclose (ptr_to_trule_undefs) ;

                sprintf (command,
                         "indent -bap -bl -bli0 -cli0 -sob %s",
                         trule_cond) ;
                system (command) ;
                sprintf (command,
                         "indent -bap -bl -bli0 -cli0 -sob %s",
                         trule_appl) ;
                system (command) ;
                sprintf (command,
                         "cat %s %s %s %s %s %s >> %s",
                         trule_head, trule_defs, trule_cond,
                         trule_divide, trule_appl, trule_undefs,
                         PRAIRIE_TRULES) ;
                system (command) ;
            }
            break ;
        }
    }
    ;

exclaim :
    { strcpy ($$, "") ; }
    | EXCLAIM
    ;

abst_expr :
    IDENTIFIER
    {
        char tok_str [MAX_STR_LEN] ;
        strcpy (tok_str, delete_white_space ($1, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                if (is_concrete_operator (tok_str))
                {
                    /* If it is a concrete operator, correctly map
                       it to a lower layer operator and insert the
                       new operator into the operator table. */
                    int i ;
                    char abst [MAX_STR_LEN],
                         conc [MAX_STR_LEN] ;
                    abst_conc_operator (abst, conc, tok_str) ;
                    if ((i = find (abst)) == -1)
                        perror ("Abstract operator not found")
                    if (find (conc) == -1)
                    {
                        op_table_index++ ;
                        strcpy (op_table[op_table_index].name, conc) ;
                        op_table[op_table_index].arity.files
                            = op_table[i].arity.files ;
                        op_table[op_table_index].arity.streams
                            = op_table[i].arity.streams ;
                        op_table[op_table_index].op_type
                            = op_table[i].op_type ;
                        op_table[op_table_index].redundant = 0 ;
                    }
                    else op_table[find (conc)].redundant = 0 ;
                    fprintf (working, "%s", conc) ;
                }
                else
                {
                    /* Rename abstract operators according to the current
                       layer.  If current layer is the middle or bottom
                       layer, append current layer name to the abstract
                       operator, and insert the new operator into the
                       operator table. */
                    if (is_top_layer (current_layer))
                        fprintf (working, "%s", $1) ;
                    else
                    {
                        int i ;
                        char layer_abst [MAX_STR_LEN] ;
                        if ((i = find (tok_str)) == -1)
                            perror ("Operator not defined")
                        sprintf (layer_abst, "%s_%s", tok_str, current_layer) ;
                        if (find (layer_abst) == -1)
                        {
                            op_table_index++ ;
                            strcpy (op_table[op_table_index].name, layer_abst) ;
                            op_table[op_table_index].arity.files
                                = op_table[i].arity.files ;
                            op_table[op_table_index].arity.streams
                                = op_table[i].arity.streams ;
                            op_table[op_table_index].op_type
                                = op_table[i].op_type ;
                            op_table[op_table_index].redundant = 0 ;
                        }
                        else op_table[find (layer_abst)].redundant = 0 ;
                        fprintf (working, "%s", layer_abst) ;
                    }
                }
            break ;
        case (1) :
            {
                int i ;
                i = find (tok_str) ;

                /* Check if IDENTIFIER is in op_table. */
                if (i == -1)
                    perror ("Operator not defined")

                /* Check if IDENTIFIER is an operator. */
                if (op_table[i].op_type != OPR &&
                     op_table[i].op_type != ENF_OPR)
                    perror ("Operator expected")
            }
            break ;
        }
    }
    LEFT_PAREN
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $3) ;
            break ;
        }
    }
    abst_expr_list
    RIGHT_PAREN
    {
        char tok_str [MAX_STR_LEN] ;
        strcpy (tok_str, delete_white_space ($1, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $6) ;
            break ;
        case (1) :
            {
                int i ;
                i = find(tok_str) ;

                /* check to see if it has right number of inputs. */
                if ($5.num_trees !=
                    op_table [i].arity.files + op_table [i].arity.streams)
                    perror ("Incorrect number of inputs")
            }
            break ;
        }
    }
    COLON DESCRIPTOR
    {
        char node_name [MAX_STR_LEN] ;
        char descriptor [MAX_STR_LEN] ;

        strcpy (node_name, delete_white_space ($1, white)) ;
        strcpy (descriptor, delete_white_space ($9, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s", $8, $9) ;
            break ;
        case (3) :
            /* Insert descriptor info into table. */
            if (find_drule_index (descriptor) != -1)
                perror ("Duplicate descriptor")
            break ;
        }
        /* Create expr structure. */
        $$ = allocate (TREE_TYPE) ;
        $$->node_type = OPR_NODE ;
        strcpy ($$->name, node_name) ;
        strcpy ($$->desc, descriptor) ;
        copy_expr_list ($$->child, $5.trees) ;
    }
    ;

abst_expr_list :
    RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
        $$.num_trees = 1 ;
        init_pointers ($$.trees) ;
        $$.trees[0] = allocate (TREE_TYPE) ;
        $$.trees[0]->node_type = REL_NODE ;
        strcpy ($$.trees[0]->name, $1) ;
    }
    | STREAM
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
    }
    optional_desc
    {
        $$.num_trees = 1 ;
        init_pointers ($$.trees) ;
        $$.trees[0] = allocate (TREE_TYPE) ;
        $$.trees[0]->node_type = STR_NODE ;
        strcpy ($$.trees[0]->name, $1) ;
        strcpy ($$.trees[0]->desc, $3) ;
    }
    | abst_expr
    {
        $$.num_trees = 1 ;
        init_pointers ($$.trees) ;
        $$.trees[0] = $1 ;
    }
    | abst_expr_list COMMA RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s", $2, $3) ;
            break ;
        }
        copy_expr_list ($$.trees, $1.trees) ;
        $$.trees[$1.num_trees] = allocate (TREE_TYPE) ;
        $$.trees[$1.num_trees]->node_type = REL_NODE ;
        strcpy ($$.trees[$1.num_trees]->name, $3) ;
        $$.num_trees = $1.num_trees + 1 ;
        
    }
    | abst_expr_list COMMA STREAM
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s", $2, $3) ;
            break ;
        }
    }
    optional_desc
    {
        copy_expr_list ($$.trees, $1.trees) ;
        $$.trees[$1.num_trees] = allocate (TREE_TYPE) ;
        $$.trees[$1.num_trees]->node_type = STR_NODE ;
        strcpy ($$.trees[$1.num_trees]->name, $3) ;
        strcpy ($$.trees[$1.num_trees]->desc, $5) ;
        $$.num_trees = $1.num_trees + 1 ;
    }
    | abst_expr_list COMMA
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        }
    }
    abst_expr
    {
        copy_expr_list ($$.trees, $1.trees) ;
        $$.trees[$1.num_trees] = $4 ;
        $$.num_trees = $1.num_trees + 1 ;
    }
    ;

optional_desc : /* empty */
    { strcpy ($$, "") ; }
    | COLON DESCRIPTOR
    {
        char descriptor [MAX_STR_LEN] ;

        strcpy (descriptor, delete_white_space ($2, white)) ;
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s", $1, $2) ;
            break ;
        case (3) :
            /* Insert descriptor info into table. */
            if (find_drule_index (descriptor) != -1)
                perror ("Duplicate descriptor")
            break ;
        }
        strcpy ($$, descriptor) ;
    }
    ;

conc_expr :
    IDENTIFIER
    {
        char tok_str [MAX_STR_LEN] ;
        strcpy (tok_str, delete_white_space ($1, white)) ;

        strcpy (current_alg, tok_str) ;
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        case (1) :
            {
                int i ;
                i = find (tok_str) ;

                /* Check if IDENTIFIER is in op_table. */
                if (i == -1)
                    perror ("Algorithm not defined")

                /* Check if IDENTIFIER is an algorithm. */
                if (op_table[i].op_type != ALG)
                    perror ("Algorithm expected")
            }
            break ;
        }
    }
    LEFT_PAREN
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $3) ;
            break ;
        }
    }
    abst_expr_list
    RIGHT_PAREN
    {
        char tok_str [MAX_STR_LEN] ;
        strcpy (tok_str, delete_white_space ($1, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $6) ;
            break ;
        case (1) :
            {
                int i ;
                i = find (tok_str) ;

                /* check to see if it has right # of inputs. */
                if ($5.num_trees != op_table [i].arity.files
                                    + op_table [i].arity.streams)
                    perror ("Incorrect number of inputs")
            }
            break ;
        }
    }
    COLON DESCRIPTOR
    {
        char node_name [MAX_STR_LEN] ;
        char descriptor [MAX_STR_LEN] ;

        strcpy (node_name, delete_white_space ($1, white)) ;
        strcpy (descriptor, delete_white_space ($9, white)) ;
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s", $8, $9) ;
            break ;
        case (3) :
            /* Insert descriptor info into table. */
            if (find_drule_index (descriptor) != -1)
                perror ("Duplicate descriptor")
            break ;
        }
        /* Create expr structure. */
        $$ = allocate (TREE_TYPE) ;
        $$->node_type = ALG_NODE ;
        strcpy ($$->name, node_name) ;
        strcpy ($$->desc, descriptor) ;
        copy_expr_list ($$->child, $5.trees) ;
    }
    ;

trule_pre_test :
    {
        switch (pass) {
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_cond, "\n{\n") ;
            break ;
        }
        strcpy ($$, "") ;
    }
    | LEFT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "\n{\n") ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_cond, "\n{\n") ;
            break ;
        }
        ptr_to_trule_stats = ptr_to_trule_cond ;
    }
    trule_stats RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
            {
                fprintf (working, "}\n") ;
                fprintf (working, "%s", $4) ;
            }
            break ;
        }
    }
    ;

trule_post_test :
    { strcpy ($$, "") ; }
    | LEFT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
        ptr_to_trule_stats = ptr_to_trule_appl ;
    }
    trule_stats RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
            {
                fprintf (working, "dcopy (%s.layer_num, %d) ;\n",
                         trule_right_root_desc,
                         layer [find_layer (current_layer)].layer_num) ;
                fprintf (working, "%s", $4) ;
            }
            break ;
        }
    }
    ;

trule_test :
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "(") ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_cond, "if (!(") ;
            break ;
        }
    }
    trule_test_stats
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
            {
                if (strcmp ($2, "") == 0)
                    fprintf (working, "TRUE") ;
                fprintf (working, ") && ") ;
                fprintf (working, "(%soa.layer_num <= %d)\n",
                         trule_left_root_desc,
                         layer [find_layer (current_layer)].layer_num) ;
            }
            break ;
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_cond, "))\nREJECT ;\n}\n") ;
            break ;
        }
    }
    ;
trule_test_stats :
    { strcpy ($$, "") ; }
    | trule_test_stats c_stuff
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_cond, "%s", $2) ;
            break ;
        }
        strcpy ($$, "OK") ;
    }
    | trule_test_stats IDENTIFIER
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_cond, "%s", $2) ;
            break ;
        }
        strcpy ($$, "OK") ;
    }
    | trule_test_stats RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                int i ;
                if ((i = find_relation ($2)) == -1)
                    perror ("File not defined")
                fprintf (ptr_to_trule_cond, "%s%s", fref[i].ref, white) ;
            }
            break ;
        }
        strcpy ($$, "OK") ;
    }
    | trule_test_stats DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                int token ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($2, white)) ;

                if (find_drule_index (tok_str) == -1
                    && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")

                token = yylex () ;
                if (token == DOT || token == POINTER)
                {
                    char tok [MAX_STR_LEN] ;
                    strcpy (tok, yytext) ;

                    if (token == POINTER)
                        perror ("Descriptor should not be a pointer")

                    if (yylex () == IDENTIFIER)
                    {
                        int i ;
                        char property [MAX_STR_LEN] ;

                        strcpy (property, delete_white_space (yytext, white)) ;
                        i = find_prop (property) ;
                        if (i == -1)
                            perror ("Property not found")

                        switch (prop[i].type) {
                        case (METHOD) :
                            fprintf (ptr_to_trule_cond,
                                     "%s%s%s", tok_str, tok, property) ;
                            break ;
                        case (OP_ARG) :
                            fprintf (ptr_to_trule_cond, 
                                     "%soa%s%s", tok_str, tok, property) ;
                            break ;
                        case (LOG_PROP) :
                            fprintf (ptr_to_trule_cond, 
                                     "%slp%s%s", tok_str, tok, property) ;
                            break ;
                        case (PHY_PROP) :
                            perror ("Cannot reference this property in T-rule")
                            break ;
                        case (COST) :
                            perror ("Cannot reference cost property in T-rule")
                            break ;
                        }
                    }
                    else perror ("Property expected")
                }
                else
                    fprintf (ptr_to_trule_cond, "%s%s", $2, yytext) ;
            }
            break ;
        }
        strcpy ($$, "OK") ;
    }
    ;

trule_stats :
    { strcpy ($$, "") ; }
    | trule_stats c_stuff
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            junk_this_trule = 0 ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
                fprintf (ptr_to_trule_stats, "%s%s", $2, white) ;
            break ;
        }
    }
    | trule_stats IDENTIFIER
    {
        switch (pass) {
        case (0) : 
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            junk_this_trule = 0 ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                if (is_init_descriptor ($2))
                {
                    /* Replace this with a NO_OP. */
                    fprintf (ptr_to_trule_stats, "NO_OP ;\n") ;
                    /* Read till SEMICOLON is encountered. */
                    while (yylex () != SEMICOLON)
                       ;
                }
                else fprintf (ptr_to_trule_stats, "%s", $2) ;
            }
            break ;
        }
    }
    | trule_stats RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            junk_this_trule = 0 ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                if (find_relation ($2) == -1)
                    perror ("File not defined")
                fprintf (ptr_to_trule_stats, "%s", $2) ;
            }
            break ;
        }
    }
    | trule_stats DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (2) :
            junk_this_trule = 0 ;
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                int token ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($2, white)) ;

                if (find_drule_index (tok_str) == -1
                    && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")

                token = yylex () ;
                if (token == DOT || token == POINTER)
                {
                    char tok [MAX_STR_LEN] ;
                    strcpy (tok, yytext) ;

                    if (token == POINTER)
                        perror ("Descriptor cannot be a pointer")

                    if (yylex () == IDENTIFIER)
                    {
                        int i ;
                        char property [MAX_STR_LEN] ;

                        strcpy (property, delete_white_space (yytext, white)) ;
                        i = find_prop (property) ;
                        if (i == -1)
                            perror ("Property not found")

                        switch (prop[i].type) {
                        case (METHOD) :
                            fprintf (ptr_to_trule_stats,
                                     "%s%s%s", tok_str, tok, property) ;
                            break ;
                        case (OP_ARG) :
                            fprintf (ptr_to_trule_stats,
                                     "%soa%s%s", tok_str, tok, property) ;
                            break ;
                        case (LOG_PROP) :
                            fprintf (ptr_to_trule_stats,
                                     "%slp%s%s", tok_str, tok, property) ;
                            break ;
                        case (PHY_PROP) :
                            perror ("Cannot reference this property in T-rule")
                            break ;
                        case (COST) :
                            perror ("Cannot reference cost property in T-rule")
                            break ;
                        }
                    }
                    else perror ("Property expected")
                }
                else
                    fprintf (ptr_to_trule_stats, "%s%s", $2, yytext) ;
            }
            break ;
        }
    }
    | trule_stats DCOPY COLON IDENTIFIER
    {
        int i ;
        char tok [MAX_STR_LEN] ;

        strcpy (tok, delete_white_space ($4, white)) ;
        i = find_prop (tok) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s", $2, $3, $4) ;
            break ;
        case (2) :
            /* Check if next two tokens are LEFT_PAREN and DESCRIPTOR. */
            if (yylex () == LEFT_PAREN)
                if (yylex () == DESCRIPTOR)
                {
                    char tok_str [MAX_STR_LEN] ;
                    strcpy (tok_str, delete_white_space (yytext, white)) ;

                    if (strcmp (tok_str, trule_right_root_desc) == 0)
                        prop[i].type = OP_ARG ;
                }
            break ;
        case (3) :
            if (junk_this_trule == 0)
                switch (prop[i].type) {
                case (OP_ARG) :
                    fprintf (ptr_to_trule_stats, "%s%s%s", $2, $3, $4) ;
                    break ;
                case (LOG_PROP) :
                    /* Read input until or if we can find what descriptor's
                       logical property is being changed. */
                    if (yylex () != LEFT_PAREN)
                        perror ("\")\" expected")
                    if (yylex () == DESCRIPTOR)
                        /* If root of new expression being changed ... */
                        if (strcmp (yytext, trule_right_root_desc) == 0)
                        {
                            /* ... then copy the left side pointer. */
                            fprintf (ptr_to_trule_stats,
                                     "%s (%s.log_prop, %s.log_prop) ",
                                     $2, trule_right_root_desc,
                                     trule_left_root_desc) ;
                            /* Read till the closing semi-colon. */
                            while (yylex () != SEMICOLON)
                                ;
                            fprintf (ptr_to_trule_stats, "%s", yytext) ;
                        }
                        else fprintf (ptr_to_trule_stats,
                                      "%s%s%s (%s", $2, $3, $4, yytext) ;
                    else fprintf (ptr_to_trule_stats,
                                  "%s%s%s (%s", $2, $3, $4, yytext) ;
                    break ;
                case (METHOD) :
                    perror ("Cannot change method value")
                    break ;
                case (PHY_PROP) :
                    perror ("Cannot change value of this property in T-rule")
                    break ;
                case (COST) :
                    perror ("Cannot change cost property in T-rule")
                    break ;
                }
            break ;
        }
    }
    | trule_stats
    DCOPY LEFT_PAREN DESCRIPTOR COMMA DESCRIPTOR RIGHT_PAREN SEMICOLON
    {
        int i ;
        char tok_str1 [MAX_STR_LEN], tok_str2 [MAX_STR_LEN] ;
        strcpy (tok_str1, delete_white_space ($4, white)) ;
        strcpy (tok_str2, delete_white_space ($6, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s%s%s%s",
                         $2, $3, $4, $5, $6, $7, $8) ;
            break ;
        case (2) :
            {
                int i, ind1, ind2 ;
                /* Make the first descriptor special. */
                desc[++desc_index] = atoi (tok_str1+1) ;
                /* Find the two descriptors in desc_map table. */
                ind1 = -1 ;
                ind2 = -1 ;
                for (i = 0; i <= desc_map_index; i++)
                {
                    if (strcmp (desc_map [i].from, tok_str1) == 0)
                        ind1 = i ;
                    if (strcmp (desc_map [i].from, tok_str2) == 0)
                        ind2 = i ;
                }
                if (ind1 == -1 || ind2 == -1)
                    junk_this_trule = 0 ;
                else if (strcmp (desc_map [ind1].to, desc_map [ind2].to) != 0)
                    junk_this_trule = 0 ;
            }
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                if (find_drule_index (tok_str1) == -1
                    && strstr (desc_decls, tok_str1) == NULL)
                    perror ("Descriptor not defined")
                if (find_drule_index (tok_str2) == -1
                    && strstr (desc_decls, tok_str2) == NULL)
                    perror ("Descriptor not defined")
                for (i = 0; i <= prop_index; i++)
                    if (prop[i].type == OP_ARG)
                    {
                        fprintf (ptr_to_trule_stats,
                                 "\tcopy_%s (%soa.%s, %soa.%s) %s",
                                 prop[i].name, tok_str1, prop[i].name,
                                 tok_str2, prop[i].name, $8) ;
                    }
                if (strcmp (tok_str1, trule_right_root_desc) == 0)
                    fprintf (ptr_to_trule_stats,
                             "%s%s%s.log_prop%s%s.log_prop%s%s",
                             $2, $3, trule_right_root_desc, $5,
                             trule_left_root_desc, $7, $8) ;
                else
                for (i = 0; i <= prop_index; i++)
                    if (prop[i].type == LOG_PROP)
                    {
                        fprintf (ptr_to_trule_stats,
                                 "\tcopy_%s (%s.log_prop->%s, %s.log_prop->%s) %s",
                                 prop[i].name, tok_str1, prop[i].name,
                                 tok_str2, prop[i].name, $8) ;
                    }
            }
            break ;
        }
    }
    | trule_stats DCOPY LEFT_PAREN DESCRIPTOR struct_access IDENTIFIER
    {
        char property [MAX_STR_LEN] ;

        if (strcmp ($5, "->") == 0)
            perror ("Descriptor cannot be a pointer")

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s%s", $2, $3, $4, $5, $6) ;
            break ;
        case (2) :
            {
                int pindex ;
                char tok_str [MAX_STR_LEN] ;

                strcpy (property, delete_white_space ($6, white)) ;
                pindex = find_prop (property) ;

                strcpy (tok_str, delete_white_space ($4, white)) ;

                if (strcmp (tok_str, trule_right_root_desc) == 0)
                    prop[pindex].type = OP_ARG ;

                /* Check if this is a statement added by P2V in pass 0
                   of the form "dcopy (Di.layer_num, n) ;"; if so,
                   then this statement should be ignored. */
                if (strcmp (property, "layer_num") == 0)
                { 
                    /* Read next four tokens, they should be COMMA,
                       NUMBER, RIGHT_PAREN and SEMICOLON. */
                    yylex () ;
                    yylex () ;
                    yylex () ;
                    yylex () ;
                } 
            }
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                int pindex ;
                char tok_str [MAX_STR_LEN] ;

                strcpy (tok_str, delete_white_space ($4, white)) ;
                strcpy (property, delete_white_space ($6, white)) ;
                pindex = find_prop (property) ;

                if (find_drule_index (tok_str) == -1
                    && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")

                switch (prop[pindex].type) {
                case (COST) :
                    perror ("Cannot reference cost property in T-rule")
                    break ;
                case (OP_ARG) :
                    if (yylex() == COMMA)
                    {
                        /* If setting "layer_num", and the expressions
                           in the T-rule weakly unify, then set the
                           layer number to the next layer. */
                        if (weak_unify == 1)
                        {
                            if (strcmp (property, "layer_num") == 0)
                            {
                                fprintf (ptr_to_trule_stats,
                                        "dcopy (%s.__prel.__prel_arity, %d);\n",
                                         trule_right_root_desc,
                                         trule_right_root_opr_file_arity) ;
                                fprintf (ptr_to_trule_stats,
                                         "copy_%s %s%soa%s%s%s",
                                         property, $3, $4, $5, $6, yytext) ;
                            }
                            /* The next token is the layer number;
                               increment it by 1. */
                            yylex () ;
                            fprintf (ptr_to_trule_stats, "%d",
                                     atoi (yytext) + 1) ;
                        }
                        else fprintf (ptr_to_trule_stats,
                                      "copy_%s %s%soa%s%s%s",
                                      property, $3, $4, $5, $6, yytext) ;
                    }
                    else fprintf (ptr_to_trule_stats,
                                  "%s %s%soa%s%s%s",
                                  $2, $3, $4, $5, $6, yytext) ;
                    break ;
                case (LOG_PROP) :
                    if (strcmp ($4, trule_right_root_desc) == 0)
                    {
                        fprintf (ptr_to_trule_stats,
                                 "%s(%s.log_prop, %s.log_prop) ",
                                 $2, $4, trule_left_root_desc) ;
                        /* Read till the closing semi-colon. */
                        while (yylex () != SEMICOLON)
                            ;
                        fprintf (ptr_to_trule_stats, "%s", yytext) ;           
                    }
                    else fprintf (ptr_to_trule_stats,
                                  "%s%s%slp%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (PHY_PROP) :
                    perror ("Cannot change physical property in I-rule pre-opt")
                    break ;
                case (METHOD) :
                    perror ("Cannot change method in descriptor")
                    break ;
                }
            }
            break ;
        }
    }
    | trule_stats DCOPY LEFT_PAREN RELATION COMMA 
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s", $2, $3, $4, $5) ;
            break ;
        case (1) :
            break ;
        case (2) :
            break ;
        case (3) :
            if (junk_this_trule == 0)
            {
                if (find_relation ($4) == -1)
                    perror ("File not defined")

                fprintf (ptr_to_trule_stats, "%s%s%s%s", $2, $3, $4, $5) ;
            }
            break ;
        }
    }
    ;

irule_test :
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "(") ;
            break ;
        case (3) :
            if (!null_rule)
                if (op_table[find(current_alg)].op_type == ALG)
                    fprintf (irule_test_file, "\n\tif (!(") ;
                else /* enforcer. */
                    fprintf (irule_test_file, "\n\tif (") ;
            break ;
        }
    }
    irule_test_stats
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
            {
                fprintf (working, ") && ") ;
                fprintf (working, "(%soa.layer_num <= %d)\n",
                         irule_left_root_desc,
                         layer [find_layer (current_layer)].layer_num) ;
            }
            break ;
        case (3) :
            if (!null_rule)
            {
                int i, k ;
                if (op_table[find(current_alg)].op_type == ALG)
                    fprintf (irule_test_file, "))\n\t\tREJECT ;\n") ;
                else /* enforcer. */
                    fprintf (irule_test_file, ")") ;
                fprintf (ptr_to_do_any_good_file,
                         "{\nret_value->apply_truth_value = TRUE ;\n") ;
                fprintf (ptr_to_do_any_good_file,
                         "ret_value->process_input_count = 1 ;\n") ;
                if (reestimate_cost (prairie_irule_num))
                    fprintf (ptr_to_do_any_good_file,
                             "ret_value->reestimate_cost = TRUE ;\n\n") ;
                else fprintf (ptr_to_do_any_good_file,
                              "ret_value->reestimate_cost = FALSE ;\n\n") ;

                for (i = 0; i < op_table[find (current_alg)].arity.streams; i++)
                {
                    fprintf (ptr_to_do_any_good_file,
                             "allocate (%s.al_arg->required[%d], PROPERTY_VECTOR) ;\n",
                             irule_right_root_desc, i) ;
                    for (k = 0; k <= prop_index; k++)
                        if (prop[k].type == PHY_PROP)
                            fprintf (ptr_to_do_any_good_file,
                                     "init_%s (%s.al_arg->required[%d]->%s) ;\n",
                                     prop[k].name, irule_right_root_desc,
                                     i, prop[k].name) ;
                }
                fprintf (ptr_to_do_any_good_file, "\n{") ;
            }
            break ;
        }
    }
    ;

irule_test_stats : /* empty */
    | irule_test_stats c_stuff
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
                fprintf (irule_test_file, "%s", $2) ;
            break ;
        }
    }
    | irule_test_stats IDENTIFIER
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
                fprintf (irule_test_file, "%s", $2) ;
            break ;
        }
    }
    | irule_test_stats RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            /* We assume that there is only one operator 
               on the left side of an I-rule. */
            if (!null_rule)
            {
                int i ;
                if ((i = find_relation ($2)) == -1)
                    perror ("File not defined")
                fprintf (irule_test_file, "%s%s", $2, white) ;
            }
            break ;
        }
    }
    | irule_test_stats ROOT LEFT_PAREN STREAM RIGHT_PAREN
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s", $2, $3, $4, $5) ;
            break ;
        case (3) :
            /* The "root" macro is used to obtain the root operator of an
               operator tree. */
            if (!null_rule)
                fprintf (irule_test_file, "(*current_operator)") ;
            break ;
        }
    }
    | irule_test_stats DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
            {
                int token ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($2, white)) ;

                /* Check to see if we are referring to an individual member
                   of a descriptor. */
                token = yylex () ;
                if (token == DOT || token == POINTER)
                {
                    char tok [MAX_STR_LEN] ;
                    strcpy (tok, yytext) ;

                    if (yylex () == IDENTIFIER)
                    {
                        int i ;
                        int pindex ;

                        i = find_drule_index (tok_str) ;
                        pindex = find_prop (delete_white_space (yytext, white)) ;

                        if (i == -1 && strstr (desc_decls, tok_str) == NULL)
                            perror ("Descriptor not defined")
                        switch (prop[pindex].type) {
                        case (COST) :
                            perror ("Cannot reference cost property in I-rule test")
                            break ;
                        case (PHY_PROP) :
                            /* Worked for TI OODB, but not for simple example...
                            fprintf (irule_test_file,
                                     "needed_pv->%s", yytext) ;
                            */
                            fprintf (irule_test_file,
                                     "%spv%s%s", tok_str, tok, yytext) ;
                            break ;
                            break ;
                        case (OP_ARG) :
                            /* Worked for TI OODB, but not for simple example...
                            fprintf (irule_test_file,
                                     "%s%s%s", tok_str, tok, yytext) ;
                            */
                            fprintf (irule_test_file,
                                     "%soa%s%s", tok_str, tok, yytext) ;
                            break ;
                        case (LOG_PROP) :
                            fprintf (irule_test_file,
                                     "%slp%s%s", tok_str, tok, yytext) ;
                            break ;
                        case (METHOD) :
                            /* Need to do something here... */
                            break ;
                        }
                    }
                    else perror ("Property expected")
                }
                else fprintf (irule_test_file, "%s%s", $2, yytext) ;
            }
            break ;
        }
    }
    ;

irule_pre_opt_stats : /* empty */
    | irule_pre_opt_stats c_stuff
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
                fprintf (ptr_to_do_any_good_file, "%s", $2) ;
            break ;
        }
    }
    | irule_pre_opt_stats IDENTIFIER
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
                fprintf (ptr_to_do_any_good_file, "%s", $2) ;
            break ;
        }
    }
    | irule_pre_opt_stats RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            /* Assume only one relation input, needs to be fixed. */
            if (!null_rule)
            {
                int i ;
                if ((i = find_relation ($2)) == -1)
                    perror ("File not defined")
                fprintf (ptr_to_do_any_good_file, "%s%s", $2, white) ;
            }
            break ;
        }
    }
    | irule_pre_opt_stats DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
            {
                char str [MAX_STR_LEN] ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($2, white)) ;

                if (find_drule_index (tok_str) == -1
                    && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")
                if (yylex () == DOT)
                    if (yylex () == IDENTIFIER)
                    {
                        int pindex ;
                        pindex = find_prop (delete_white_space (yytext, white)) ;

                        switch (prop[pindex].type) {
                        case (COST) :
                            /* Only the cost property of the algorithm is legal. */
                            sprintf (str, "%scost", tok_str) ;
                            if (find_drule_index (str) == -1)
                                perror ("Cannot access cost of this descriptor")
                            fprintf (ptr_to_do_any_good_file,
                                     "%scost.%s", tok_str, yytext) ;
                            break ;
                        case (OP_ARG) :
                            fprintf (ptr_to_do_any_good_file,
                                     "%soa.%s", tok_str, yytext) ;
                            break ;
                        case (PHY_PROP) :
                            fprintf (ptr_to_do_any_good_file,
                                     "%spv.%s", tok_str, yytext) ;
                            break ;
                        case (LOG_PROP) :
                            fprintf (ptr_to_do_any_good_file,
                                     "%slp.%s", tok_str, yytext) ;
                            break ;
                        case (METHOD) :
                            /* Need to do something here... */
                            break ;
                        }
                    }
                    else perror ("Property expected")
                else fprintf (ptr_to_do_any_good_file, "%s%s", $2, yytext) ;
            }
            break ;
        }
    }
    | irule_pre_opt_stats DCOPY COLON IDENTIFIER
    {
        int i ;
        char property [MAX_STR_LEN] ;

        strcpy (property, delete_white_space ($4, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s", $2, $3, $4) ;
            break ;
        case (1) :
            /* Recognize physical properties. */
            if (null_rule)
                prop[find_prop (property)].type = PHY_PROP ;
            break ;
        case (3) :
            if (!null_rule)
            {
                i = find_prop (delete_white_space ($4, white)) ;
                switch (prop[i].type) {
                case (OP_ARG) :
                    fprintf (ptr_to_do_any_good_file, "%s%s%s", $2, $3, $4) ;
                    break ;
                case (LOG_PROP) :
                    fprintf (ptr_to_do_any_good_file, "%s%s%s", $2, $3, $4) ;
                    break ;
                case (METHOD) :
                    perror ("Cannot change method value")
                    break ;
                case (PHY_PROP) :
                    fprintf (ptr_to_do_any_good_file, "%s%s%s", $2, $3, $4) ;
                    break ;
                case (COST) :
                    fprintf (ptr_to_do_any_good_file, "%s%s%s", $2, $3, $4) ;
                    break ;
                }
            }
            break ;
        }
    }
    | irule_pre_opt_stats
    DCOPY LEFT_PAREN DESCRIPTOR COMMA DESCRIPTOR RIGHT_PAREN SEMICOLON
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s%s%s%s",
                         $2, $3, $4, $5, $6, $7, $8) ;
            break ;
        case (3) :
            if (!null_rule)
            {
                int i ;
                char *str ;
                char tok_str1 [MAX_STR_LEN], tok_str2 [MAX_STR_LEN] ;
                strcpy (tok_str1, delete_white_space ($4, white)) ;
                strcpy (tok_str2, delete_white_space ($6, white)) ;

                i = find_drule_index (tok_str1) ;
                if (i == -1 && strstr (desc_decls, tok_str1) == NULL)
                    perror ("Descriptor not defined")
                if (find_drule_index (tok_str2) == -1
                    && strstr (desc_decls, tok_str2) == NULL)
                    perror ("Descriptor not defined")
                str = drule[i].volcano_desc ;
                if (strstr (str, "oa") != 0 || strstr (str, "in_desc") != 0)
                    perror ("Cannot change left hand side descriptor")
                if (strcmp (str, $6) == 0)
                    /* Translate to a no-op. */
                    fprintf (ptr_to_do_any_good_file, "NO_OP%s", $8) ;
                else
                {
                    for (i = 0; i <= prop_index; i++)
                        if (prop[i].type == OP_ARG)
                            fprintf (ptr_to_do_any_good_file,
                                     "\tcopy_%s (%soa.%s, %soa.%s) %s",
                                     prop[i].name, tok_str1, prop[i].name,
                                     tok_str2, prop[i].name, $8) ;

                    fprintf (ptr_to_do_any_good_file,
                             "%s%s%s.log_prop%s%s.log_prop%s%s",
                             $2, $3, tok_str1, $5, tok_str2, $7, $8) ;
                }
            }
            break ;
        }
    }
    | irule_pre_opt_stats DCOPY LEFT_PAREN DESCRIPTOR struct_access IDENTIFIER
    {
        char property [MAX_STR_LEN] ;

        strcpy (property, delete_white_space ($6, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s%s", $2, $3, $4, $5, $6) ;
            break ;
        case (1) :
            /* Recognize physical properties. */
            if (null_rule)
                prop[find_prop (property)].type = PHY_PROP ;
            break ;
        case (3) :
            if (!null_rule)
            {
                int pindex ;
                char str [MAX_STR_LEN] ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($4, white)) ;

                pindex = find_prop (property) ;

                if (find_drule_index (tok_str) == -1
                    && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")

                switch (prop[pindex].type) {
                case (COST) :
                    sprintf (str, "%scost", tok_str) ;
                    if (find_drule_index (str) == -1)
                        perror ("Cannot change cost of this descriptor")
                    fprintf (ptr_to_do_any_good_file,
                             "%s%s%scost%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (OP_ARG) :
                    fprintf (ptr_to_do_any_good_file,
                             "%s%s%soa%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (LOG_PROP) :
                    /* Logical properties cannot be changed in an
                       I-rule, so just discard this statement.
                       In a different layer ordering, this same property
                       might be a physical property. */
                    /*
                    fprintf (ptr_to_do_any_good_file,
                             "%s%s%s.log_prop, oa->log_prop);\n",
                             $2, $3, tok_str) ;
                    */
                    /* Read until SEMICOLON is encountered. */
                    while (yylex () != SEMICOLON)
                        ;
                    /* Replace the statement with a NO_OP. */
                    fprintf (ptr_to_do_any_good_file, "NO_OP ;\n") ;
                    break ;
                case (PHY_PROP) :
                    /* Worked for TI OODB, but not in simple example...
                    perror ("Cannot change physical property in I-rule pre-opt")
                    */
                    fprintf (ptr_to_do_any_good_file,
                             "%s%s%spv%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (METHOD) :
                    /* Need to do something here... */
                    break ;
                }
            }
            break ;
        }
    }
    ;

irule_post_opt_stats : /* empty */
    | irule_post_opt_stats c_stuff
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
                fprintf (ptr_to_derive_phy_prop_file, "%s", $2) ;
            break ;
        }
    }
    | irule_post_opt_stats IDENTIFIER
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
                fprintf (ptr_to_derive_phy_prop_file, "%s", $2) ;
            break ;
        }
    }
    | irule_post_opt_stats RELATION
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            /* Assume only one relation input, needs to be fixed. */
            if (!null_rule)
            {
                int i ;
                if ((i = find_relation ($2)) == -1)
                    perror ("File not defined")
                fprintf (ptr_to_derive_phy_prop_file, "%s%s", $2, white) ;
            }
            break ;
        }
    }
    | irule_post_opt_stats DESCRIPTOR
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $2) ;
            break ;
        case (3) :
            if (!null_rule)
            {
                int i ;
                int pindex ;
                char *str ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($2, white)) ;

                i = find_drule_index (tok_str) ;
                if (i == -1 && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")
                str = drule[i].volcano_desc ;
                if (yylex () == DOT)
                    if (yylex () == IDENTIFIER)
                    {
                        pindex = find_prop (delete_white_space (yytext, white)) ;

                        switch (prop[pindex].type) {
                        case (COST) :
                            perror ("Cannot reference cost property in I-rule post-opt section")
                            break ;
                        case (OP_ARG) :
                            fprintf (ptr_to_derive_phy_prop_file,
                                     "%soa.%s", tok_str, yytext) ;
                            break ;
                        case (PHY_PROP) :
                            fprintf (ptr_to_derive_phy_prop_file,
                                     "%spv.%s", tok_str, yytext) ;
                            break ;
                        case (LOG_PROP) :
                            fprintf (ptr_to_derive_phy_prop_file,
                                     "%slp.%s", tok_str, yytext) ;
                            break ;
                        case (METHOD) :
                            /* Need to do something here... */
                            break ;
                        }
                    }
                    else perror ("Property expected")
                else
                    fprintf (ptr_to_derive_phy_prop_file, "%s%s", $2, yytext) ;
            }
            break ;
        }
    }
    | irule_post_opt_stats DCOPY COLON IDENTIFIER
    {
        int i ;
        char property [MAX_STR_LEN] ;

        strcpy (property, delete_white_space ($4, white)) ;
        i = find_prop (property) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s", $2, $3, $4) ;
            break ;
        case (2) :
            if (prop[i].type == COST)
                if (!reestimate_cost (vol_impl_rule_num))
                    irule_cost_reestimate[++irule_cost_reestimate_index]
                        = prairie_irule_num ;
            break ;
        case (3) :
            if (!null_rule)
                switch (prop[i].type) {
                case (OP_ARG) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s", $2, $3, $4) ;
                    break ;
                case (LOG_PROP) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s", $2, $3, $4) ;
                    break ;
                case (METHOD) :
                    perror ("Cannot change method value")
                    break ;
                case (PHY_PROP) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s", $2, $3, $4) ;
                    break ;
                case (COST) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s", $2, $3, $4) ;
                    break ;
                }
            break ;
        }
    }
    | irule_post_opt_stats
    DCOPY LEFT_PAREN DESCRIPTOR COMMA DESCRIPTOR RIGHT_PAREN SEMICOLON
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s%s%s%s",
                         $2, $3, $4, $5, $6, $7, $8) ;
            break ;
        case (3) :
            if (!null_rule)
            {
                int i ;
                char *str ;
                char tok_str1 [MAX_STR_LEN], tok_str2 [MAX_STR_LEN] ;
                strcpy (tok_str1, delete_white_space ($4, white)) ;
                strcpy (tok_str2, delete_white_space ($6, white)) ;

                i = find_drule_index (tok_str1) ;
                if (i == -1 && strstr (desc_decls, tok_str1) == NULL)
                    perror ("Descriptor not defined")
                if (find_drule_index (tok_str2) == -1
                    && strstr (desc_decls, tok_str2) == NULL)
                    perror ("Descriptor not defined")
                str = drule[i].volcano_desc ;
                if (strstr (str, "oa") != 0 || strstr (str, "in_desc") != 0)
                    perror ("Cannot change left hand side descriptor")
                if (strcmp (str, $6) == 0)
                    /* Translate to a no-op. */
                    fprintf (ptr_to_derive_phy_prop_file, "NO_OP%s", $8) ;
                else
                {
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s.op_arg%s%s.op_arg%s%s\n",
                             $2, $3, tok_str1, $5, tok_str2, $7, $8) ;
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s.log_prop%s%s.log_prop%s%s",
                             $2, $3, tok_str1, $5, tok_str2, $7, $8) ;
                }
            }
            break ;
        }
    }
    | irule_post_opt_stats DCOPY LEFT_PAREN DESCRIPTOR struct_access IDENTIFIER
    {
        char property [MAX_STR_LEN] ;

        strcpy (property, delete_white_space ($6, white)) ;

        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s%s%s%s%s", $2, $3, $4, $5, $6) ;
            break ;
        case (1) :
            /* Recognize physical properties. */
            if (null_rule)
                prop[find_prop (property)].type = PHY_PROP ;
            break ;
        case (3) :
            if (!null_rule)
            {
                int i ;
                int pindex ;
                char *str ;
                char tok_str [MAX_STR_LEN] ;
                strcpy (tok_str, delete_white_space ($4, white)) ;

                i = find_drule_index (tok_str) ;
                pindex = find_prop (property) ;

                if (i == -1 && strstr (desc_decls, tok_str) == NULL)
                    perror ("Descriptor not defined")
                str = drule[i].volcano_desc ;
                if (strstr (str, "oa") != 0)
                    perror ("Cannot change left side descriptor")
                switch (prop[pindex].type) {
                case (COST) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%s%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (PHY_PROP) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%spv%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (OP_ARG) :
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%soa%s%s", $2, $3, tok_str, $5, $6) ;
                    break ;
                case (LOG_PROP) :
                    /* Logical properties cannot be changed in an
                       I-rule, so just discard this statement.
                       In a different layer ordering, this same property
                       might be a physical property. */
                    /*
                    fprintf (ptr_to_derive_phy_prop_file,
                             "%s%s%slp%s%s", $2, $3, tok_str, $5, $6) ;
                    */
                    /* Read until SEMICOLON is encountered. */
                    while (yylex () != SEMICOLON)
                        ;
                    /* Replace the statement with a NO_OP. */
                    fprintf (ptr_to_derive_phy_prop_file, "NO_OP ;\n") ;
                    break ;
                case (METHOD) :
                    /* Need to do something here... */
                    break ;
                }
            }
            break ;
        }
    }
    ;

irule_pre_opt :
    LEFT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
    }
    irule_pre_opt_stats
    RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $4) ;
            break ;
        }
    }
    ;

irule_post_opt :
    LEFT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $1) ;
            break ;
        }
    }
    irule_post_opt_stats
    RIGHT_BRACES
    {
        switch (pass) {
        case (0) :
            if (!discard_rule)
                fprintf (working, "%s", $4) ;
            break ;
        }
    }
    ;

struct_access : DOT
    | POINTER
    ;

c_stuff_dcopy : c_stuff
    | DCOPY
    ;

c_stuff : ASGNOP
    | BINOP
    | COLON
    | COMMA
    | DOT
    | EXCLAIM
    | LEFT_BRACKET
    | LEFT_PAREN
    | LITERAL
    | NUMBER
    | POINTER
    | POUND_DEFINE
    | POUND_INCLUDE
    | POUND_LINE
    | POUND_UNDEF
    | POUND_IF
    | POUND_IFNDEF
    | POUND_ELIF
    | POUND_ELSE
    { strcat ($$, "\n") ; }
    | POUND_ENDIF
    { strcat ($$, "\n") ; }
    | RIGHT_BRACKET
    | RIGHT_PAREN
    | SEMICOLON
    | STAR
    | UNOP
    ;

%%

/*************************************************************************
* Return a copy of expr, with all enforcer-operators removed.            *
*************************************************************************/
TREE_TYPE *
copy_expr (expr)
TREE_TYPE *expr ;
{
    int i ;
    TREE_TYPE *copy ;

    if (expr == NULL) return ((TREE_TYPE *) NULL) ;

    if (expr->node_type == OPR_NODE)
        if (op_table [find (expr->name)].op_type == ENF_OPR)
            return (copy_expr (expr->child[0])) ;

    copy = allocate (TREE_TYPE) ;
    copy->node_type = expr->node_type ;
    strcpy (copy->name, expr->name) ;
    strcpy (copy->desc, expr->desc) ;

    if (expr->node_type == OPR_NODE)
    {
        op_table [find (expr->name)].redundant = 0 ;
        for (i = 0; i < MAX_CHILDREN; i++)
            copy->child[i] = copy_expr (expr->child[i]) ;
    }
    else
        for (i = 0; i < MAX_CHILDREN; i++)
            copy->child[i] = (TREE_TYPE *) NULL ;

    return (copy) ;
}

/*************************************************************************
* Return "str" with its trailing whitespaces deleted.  Set "white" to    *
* the trailing whitespaces.                                              *
*************************************************************************/
char *
delete_white_space (str, white)
char str [] ;
char white [] ;
{
    int  i, j ;

    i = 0 ;
    while (str[i] != '\0')
    {
        if (isspace (str[i]))
            break ;
        else tmp_str[i] = str[i] ;
        i++ ;
    }
    tmp_str[i] = '\0' ;

    j = 0 ;
    while (str[i] != '\0')
    {
        white[j] = str[i] ;
        j++ ;
        i++ ;
    }
    white[j] = '\0' ;

    return (tmp_str) ;
}

/*************************************************************************
* Obtain the file references from the expr tree.                         *
*************************************************************************/
void
file_references (expr)
TREE_TYPE *expr ;
{
    int i ;

    if (expr->node_type == REL_NODE)
        return ;
    if (expr->node_type == STR_NODE)
        return ;
    /* expr->node_type == OPR_NODE or expr->node_type == ALG_NODE. */
    for (i = 0; i < MAX_CHILDREN; i++)
        if (expr->child[i] == NULL)
            break ;
        else if (expr->child[i]->node_type == REL_NODE)
        {
            if (find_relation (expr->child[i]->name) == -1)
            {
                strcpy (fref [++fref_index].fname, expr->child[i]->name) ;
                sprintf (fref [fref_index].ref, "%s.__prel.__prelation[%d]",
                         expr->desc, i) ;
            }
        }
        else file_references (expr->child[i]) ;

    return ;
}

/*************************************************************************
* Return index of ident in op_table if present, -1 otherwise.            *
*************************************************************************/
int
find (ident)
char *ident ;
{
    int i ;

    for (i = 0; i <= op_table_index; i++)
        if (strcmp (ident, op_table [i].name) == 0)
            return (i) ;

    return (-1) ;
}

/*************************************************************************
* Find the index to the volcano descriptor string in drule table         *
* corresponding to descriptor "dstr".                                    *
*************************************************************************/
int
find_drule_index (dstr)
char *dstr ;
{
    int i ;
    for (i = 0; i <= drule_index; i++)
        if (strcmp (drule[i].desc, dstr) == 0)
            return (i) ;

    return (-1) ;
}

/*************************************************************************
* Find the index to the layer "lyr" in the layer table if present,       *
* -1 otherwise.                                                          *
*************************************************************************/
int
find_layer (lyr)
char *lyr ;
{
    int i ;
    for (i = 0; i <= layer_index; i++)
        if (strcmp (layer[i].name, lyr) == 0)
            return (i) ;

    return (-1) ;
}

/*************************************************************************
* Find index of property "pname", -1 otherwise.                          *
*************************************************************************/
int
find_prop (pname)
char *pname ;
{
    int i ;

    for (i = 0; i <= prop_index; i++)
        if (strcmp (pname, prop[i].name) == 0)
            return (i) ;

    return (-1) ;
}

/*************************************************************************
* Find index of property "pname" of type "type" if present,              *
* -1 otherwise.                                                          *
*************************************************************************/
int
find_prop_index (pname, type)
char       *pname ;
PROP_TYPE  type ;
{
    int i ;

    i = find_prop (pname) ;
    if (prop[i].type == type)
        return (i) ;
    else return (-1) ;
}

/*************************************************************************
* Return the operator that "opr" maps to in the opr_map table;           *
* if "opr" is not present in the opr_map table, then return "opr".       *
*************************************************************************/
char *
find_opr_map (opr)
char    opr [] ;
{
    int i ;

    for (i = 0; i <= opr_map_index; i++)
        if (strcmp (opr_map [i].from, opr) == 0)
            return (opr_map [i].to) ;

    return (opr) ;
}

/*************************************************************************
* Find index of file "s" in fref if present, -1 otherwise.               *
*************************************************************************/
int
find_relation (s)
char *s ;
{
    int i ;

    for (i = 0; i <= fref_index; i++)
        if (strcmp (fref[i].fname, s) == 0)
            return (i) ;

    return (-1) ;
}

/*************************************************************************
* Generate statements that allocate space for pointers that will be      *
* used to generate the operator argument tree.                           *
*************************************************************************/
void
generate_allocate_nodes (expr)
TREE_TYPE *expr ;
{
    int i ;

    if (expr == NULL)
        return ;
    switch (expr->node_type) {
    case (REL_NODE) :
        break ;
    case (STR_NODE) :
        break ;
    case (ALG_NODE) :
        break ;
    case (OPR_NODE) :
        i = find (expr->name) ;
        if (op_table[i].arity.streams > 0)
            fprintf (pr_out, "allocate (%s.al_arg, AL_ARG) ;\n", expr->desc) ;

        for (i = 0; i < MAX_CHILDREN; i++)
        {
            TREE_TYPE *ptr ;
            ptr = expr->child[i] ;
            if (ptr == NULL)
                break ;
            switch (ptr->node_type) {
            case (REL_NODE) :
                break ;
            case (ALG_NODE) :
                break ;
            case (STR_NODE) :
                break ;
            case (OPR_NODE) :
                generate_allocate_nodes (ptr) ;
                break ;
            }
        }
        break ;
    }
}

/*************************************************************************
* Generate operator argument tree corresponding to the operator tree     *
* "expr".  The operator arguments have the same parent-child             *
* relationship as the operator tree.                                     *
*************************************************************************/
void
generate_operator_argument_tree (expr, parent_desc, child_num)
TREE_TYPE *expr ;
char      parent_desc [] ;
int       child_num ;
{
    int i ;
    TREE_TYPE *ptr ;

    switch (expr->node_type) {
    case (REL_NODE) :
        break ;
    case (STR_NODE) :
        /* "parent_desc" is not an empty string. */
        if (strcmp (parent_desc, "") != 0)
            if (strcmp (expr->desc, "") == 0)
                fprintf (ptr_to_irule_appl, "%s.al_arg->desc[%d] = &(D%s) ;\n",
                         parent_desc, child_num, expr->name+1) ;
            else fprintf (ptr_to_irule_appl, "%s.al_arg->desc[%d] = &(%s) ;\n",
                          parent_desc, child_num, expr->desc) ;
        break ;
    case (OPR_NODE) :
        if (strcmp (parent_desc, "") != 0)
            if (strcmp (expr->desc, "") == 0)
                fprintf (ptr_to_irule_appl, "%s.al_arg->desc[%d] = &(D%s) ;\n",
                         parent_desc, child_num, expr->name+1) ;
            else fprintf (ptr_to_irule_appl, "%s.al_arg->desc[%d] = &(%s) ;\n",
                          parent_desc, child_num, expr->desc) ;

        for (i = 0; i < MAX_CHILDREN; i++)
            if ((ptr = expr->child[i]) != NULL)
                generate_operator_argument_tree (ptr, expr->desc, i) ;
            else break ;
        break ;
    case (ALG_NODE) :
        /* Algorithm node has stream inputs. */
        if (strcmp (parent_desc, "") != 0)
            fprintf (ptr_to_irule_appl, "%s.al_arg->desc[%d] = &(D%s) ;\n",
                     parent_desc, child_num, expr->name+1) ;

        for (i = 0; i < MAX_CHILDREN; i++)
        {
            ptr = expr->child[i] ;
            if (ptr == NULL)
                break ;
            if (ptr->node_type == REL_NODE)
                continue ;
            /* ptr->node_type == STR_NODE. */
            fprintf (ptr_to_irule_appl, "%s.al_arg->desc[%d] = &(D%s) ;\n",
                     expr->desc, i, ptr->name+1) ;
        }
        break ;
    }

    return ;
}

/*************************************************************************
* Get descriptor declarations of enforcer-operators from abst tree expr. *
*************************************************************************/
void
get_desc_decls (expr)
TREE_TYPE *expr ;
{
    int i ;

    if (expr == NULL) return ;

    if (expr->node_type == REL_NODE)
        return ;

    if (expr->node_type == STR_NODE)
        return ;

    /* expr->node_type == OPR_NODE */

    if (op_table[find (expr->name)].op_type == ENF_OPR)
    {
        char str[100] ;
        if (first)
            sprintf (str, "OPERATOR_ARGUMENT %s", expr->desc) ;
        else sprintf (str, ", %s", expr->desc) ;
        strcat (desc_decls, str) ;
        first = 0 ;
        get_desc_decls (expr->child[0]) ;
    }
    else for (i = 0; i < MAX_CHILDREN; i++)
            if (expr->child[i] == NULL)
                break ;
            else get_desc_decls (expr->child[i]) ;

    return ;
}

/*************************************************************************
* Insert descriptors of expr into the descriptor mapping table desc_map. *
* Take into account transitive mappings, i.e., if D1 maps to D2 and D2   *
* maps to D3, insert the mapping D1->D3 into desc_map.                   *
*************************************************************************/
void
insert_desc (expr)
TREE_TYPE *expr ;
{
    int i ;

    if (expr == NULL) return ;
    if (expr->node_type == STR_NODE) return ;
    if (expr->node_type == REL_NODE) return ;

    /* expr->node_type == OPR_NODE. */
    if (op_table [find (expr->name)].op_type != ENF_OPR)
        for (i = 0; i < MAX_CHILDREN; i++)
        {
            if (expr->child[i] == NULL) break ;
            insert_desc (expr->child[i]) ;
        }
    else
    {
        TREE_TYPE *ch ;

        ch = expr->child[0] ;
        if (ch->node_type == STR_NODE || ch->node_type == REL_NODE)
        {
            char temp [MAX_STR_LEN] ;

            sprintf (temp, "D%s", ch->name+1) ;
            /* Find the descriptor mapping of ch... */
            for (i = 0; i <= desc_map_index; i++)
                if (strcmp (temp, desc_map [i].from) == 0)
                    break ;
            if (i > desc_map_index)
                perror ("Internal error")
            ++desc_map_index ;
            strcpy (desc_map [desc_map_index].from, expr->desc) ;
            strcpy (desc_map [desc_map_index].to, desc_map [i].to) ;
        }
        else
        {
            insert_desc (ch) ;
            /* Find the descriptor mapping of ch... */
            for (i = 0; i <= desc_map_index; i++)
                if (strcmp (ch->desc, desc_map [i].from) == 0)
                    break ;
            if (i > desc_map_index)
                perror ("Internal error")
            ++desc_map_index ;
            strcpy (desc_map [desc_map_index].from, expr->desc) ;
            strcpy (desc_map [desc_map_index].to, desc_map [i].to) ;
        }
    }

    return ;
}

/*************************************************************************
* Collect all descriptor info from expr and insert into drule [].        *
* Pre-condition is that expr is either a single operator or algorithm.   *
*************************************************************************/
void
insert_dirule_for_do_any_good (expr, parent_desc, child_num)
TREE_TYPE *expr ;
char      parent_desc [] ;
int       child_num ;
{
    int i, d ;
    TREE_TYPE *ptr ;

    switch (expr->node_type) {
    case (OPR_NODE) :
        if (find_drule_index (expr->desc) != -1)
            return ;
        strcpy (drule[++drule_index].desc, expr->desc) ;
        if (strcmp (parent_desc, "") == 0)
            strcpy (drule[drule_index].volcano_desc, "(*oa)") ;
        else sprintf (drule[drule_index].volcano_desc,
                      "(*(%s.al_arg->desc[%d]))", parent_desc, child_num) ;
        sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc, "(%s.op_arg)", expr->desc) ;
        sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(*(%s.log_prop))",
                 expr->desc) ;
        break ;
    case (REL_NODE) :
        break ;
    case (STR_NODE) :
        /* We assume that S1:D2 must occur only on the right side of an
           I-rule and S1 (without a descriptor annotation) can occur on
           the left (and possibly right??) side of an I-rule. */
        if (find_drule_index (expr->desc) != -1)
            return ;
        if (strcmp (expr->desc, "") == 0)
        {
            sprintf (drule[++drule_index].desc, "D%s", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.al_arg->desc[%d]))",
                     parent_desc, child_num) ;
            sprintf (drule[++drule_index].desc, "D%soa", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(D%s.op_arg)", expr->name+1) ;
            sprintf (drule[++drule_index].desc, "D%slp", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(D%s.log_prop))", expr->name+1) ;
        }
        else
        {
            sprintf (drule[++drule_index].desc, "%s", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc, "D%s", expr->name+1) ;
            sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc, "D%soa", expr->name+1) ;
            sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc, "D%slp", expr->name+1) ;
            sprintf (drule[++drule_index].desc, "%spv", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.al_arg->required[%d]))", parent_desc, child_num) ;
        }
        break ;
    case (ALG_NODE) :
        if (find_drule_index (expr->desc) != -1)
            return ;
        strcpy (drule[++drule_index].desc, expr->desc) ;
        strcpy (drule[drule_index].volcano_desc,
                "(ret_value->algorithm_argument)") ;
        sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(%s.op_arg)", expr->desc) ;
        sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(*(%s.log_prop))", expr->desc) ;
        sprintf (drule[++drule_index].desc, "%scost", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(*(%s.al_arg))", expr->desc) ;
        for (i = 0; i < MAX_CHILDREN; i++)
        {
            if ((ptr = expr->child[i]) == NULL)
                return ;
            insert_dirule_for_do_any_good (ptr, expr->desc, i) ;
        }
        break ;
    }

    return ;
}

/*************************************************************************
* Collect all descriptor info from expr and insert into drule [] for     *
* the derive_phy_prop function.  Pre-condition is that expr is a single  *
* algorithm with a single (stream or file) input.                        *
*************************************************************************/
void
insert_dirule_for_derive_phy_prop (expr, parent_desc, child_num)
TREE_TYPE *expr ;
char      parent_desc [] ;
int       child_num ;
{
    int i ;
    TREE_TYPE *ptr ;

    switch (expr->node_type) {
    case (OPR_NODE) :
        /* This must be the left side of an I-rule.  Insert only the
           root operator and its inputs. */
        if (strcmp (parent_desc, "") == 0)
        {
            char child_desc [MAX_STR_LEN] ;

            strcpy (drule[++drule_index].desc, expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(aa->al_arg->operator_argument))") ;
            sprintf (drule[++drule_index].desc, "%spv", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.prop_vec))", expr->desc) ;
        }
        else
        {
            sprintf (drule[++drule_index].desc, expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.al_arg->desc[%d]))",
                     parent_desc, child_num) ;
            sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(%s.op_arg)",
                     expr->desc) ;
            sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.log_prop))",
                     expr->desc) ;
        }
        break ;
    case (REL_NODE) :
        break ;
    case (STR_NODE) :
        /* We assume that the input stream of an algorithm must be of the
           form S1:D2, i.e., all streams must have a descriptor attached. */
        if (find_drule_index (expr->desc) != -1)
            return ;
        if (strcmp (expr->desc, "") == 0)
        {
            sprintf (drule[++drule_index].desc, "D%s", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.al_arg->desc[%d]))", parent_desc, child_num) ;
            sprintf (drule[++drule_index].desc, "D%soa", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(D%s.op_arg)", expr->name+1) ;
            sprintf (drule[++drule_index].desc, "D%slp", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(D%s.log_prop))", expr->name+1) ;
            sprintf (drule[++drule_index].desc, "D%spv", expr->name+1) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(D%s.prop_vec))", expr->name+1) ;
        }
        else
        {
            strcpy (drule[++drule_index].desc, expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.al_arg->desc[%d]))", parent_desc, child_num) ;
            sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(%s.op_arg)", expr->desc) ;
            sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.log_prop))", expr->desc) ;
            sprintf (drule[++drule_index].desc, "%spv", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.prop_vec))", expr->desc) ;
        }
        break ;
    case (ALG_NODE) :
        if (find_drule_index (expr->desc) != -1)
            return ;
        strcpy (drule[++drule_index].desc, expr->desc) ;
        strcpy (drule[drule_index].volcano_desc, "(*aa)") ;
        sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(%s.op_arg)", expr->desc) ;
        sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(*(%s.log_prop))", expr->desc) ;
        sprintf (drule[++drule_index].desc, "%spv", expr->desc) ;
        sprintf (drule[drule_index].volcano_desc,
                 "(*(%s.prop_vec))",
                 expr->desc) ;
        for (i = 0; i < MAX_CHILDREN; i++)
        {
            if ((ptr = expr->child[i]) == NULL)
                return ;
            insert_dirule_for_derive_phy_prop (ptr, expr->desc, i) ;
        }
        break ;
    }

   return ;
}

/*************************************************************************
* Collect all descriptor info from expr and insert into drule [].        *
* Pre-condition is that expr is an operator.                             *
*************************************************************************/
void
insert_dirule_for_model_input (expr, parent_desc, child_num)
TREE_TYPE *expr ;
char      parent_desc [] ;
int       child_num ;
{
    int        i ;
    int        fnum = 0 ;
    TREE_TYPE  *ptr ;
    char       str [MAX_STR_LEN] ;

    if (op_table[find (expr->name)].op_type != ENF_OPR)
    {
        /* If not present in drule table, insert. */
        if (find_drule_index (expr->desc) == -1)
        {
            strcpy (drule[++drule_index].desc, expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(?op_arg%s))", expr->desc+1) ;
            sprintf (drule[++drule_index].desc, "%soa", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(%s.op_arg)", expr->desc) ;
            sprintf (drule[++drule_index].desc, "%slp", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.log_prop))", expr->desc) ;
            sprintf (drule[++drule_index].desc, "%spv", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.prop_vec))", expr->desc) ;
        }
    }
    for (i = 0; i < MAX_CHILDREN; i++)
        if ((ptr = expr->child[i]) != NULL)
        {
            if (ptr->node_type == OPR_NODE)
                insert_dirule_for_model_input (ptr, expr->desc, i) ;
            else if (strcmp (ptr->desc, "") == 0)
            {
                /* NAMED file like F1 or NAMED stream like S1. */
                /* Check if it is already in drule table. */
                sprintf (str, "D%s", ptr->name+1) ;
                if (find_drule_index (str) != -1)
                    continue ;
                if (ptr->node_type == REL_NODE)
                    continue ;
                else /* ptr->node_type == STR_NODE */
                {
                    sprintf (drule[++drule_index].desc, "%s", str) ;
                    sprintf (drule[drule_index].volcano_desc,
                             "(?%s->expr.argument)", ptr->name+1) ;
                    sprintf (drule[++drule_index].desc, "%soa", str) ;
                    sprintf (drule[drule_index].volcano_desc,
                             "(%s.op_arg)", str) ;
                    sprintf (drule[++drule_index].desc, "%slp", str) ;
                    sprintf (drule[drule_index].volcano_desc,
                             "(*(%s.log_prop))", str) ;
                }
            }
            else /* NAMED stream like S1:D4, illegal in trules. */
                perror ("Stream cannot have a new descriptor")
        }
        else break ;

    return ;
}

/*************************************************************************
* Collect all descriptor info from expr and insert into drule [].        *
* Pre-condition is that expr is an operator.                             *
*************************************************************************/
void
insert_dtrule (expr)
TREE_TYPE *expr ;
{
    int        i ;
    TREE_TYPE  *ptr ;
    char       str [MAX_STR_LEN] ;

    if (op_table[find (expr->name)].op_type != ENF_OPR)
    {
        /* If not present in drule table, insert. */
        if (find_drule_index (expr->desc) == -1)
        {
            strcpy (drule[++drule_index].desc, expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(?op_arg%s))", expr->desc+1) ;
            sprintf (drule[++drule_index].desc,
                     "%soa", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(%s.op_arg)", expr->desc) ;
            sprintf (drule[++drule_index].desc,
                     "%slp", expr->desc) ;
            sprintf (drule[drule_index].volcano_desc,
                     "(*(%s.log_prop))", expr->desc) ;
        }
    }
    for (i = 0; i < MAX_CHILDREN; i++)
        if ((ptr = expr->child[i]) != NULL)
        {
            if (ptr->node_type == OPR_NODE)
                insert_dtrule (ptr) ;
            else if (strcmp (ptr->desc, "") == 0)
            {
                /* NAMED file like F1 or NAMED stream like S1. */
                /* Check if it is already in drule table. */
                sprintf (str, "D%s", ptr->name+1) ;
                if (find_drule_index (str) != -1)
                    continue ;
                if (ptr->node_type == REL_NODE)
                    continue ;
                else /* ptr->node_type == STR_NODE */
                {
                    sprintf (drule[++drule_index].desc,
                             "D%s", ptr->name+1) ;
                    sprintf (drule[drule_index].volcano_desc,
                             "(?%s->expr.argument)", ptr->name+1) ;
                    sprintf (drule[++drule_index].desc,
                             "D%soa", ptr->name+1) ;
                    sprintf (drule[drule_index].volcano_desc,
                             "(D%s.op_arg)", ptr->name+1) ;
                    sprintf (drule[++drule_index].desc,
                             "D%slp", ptr->name+1) ;
                    sprintf (drule[drule_index].volcano_desc,
                             "(*(D%s.log_prop))", ptr->name+1) ;
                }
            }
            else /* NAMED stream like S1:D4, illegal in trules. */
                perror ("Stream cannot have a new descriptor")
        }
        else break ;

    return ;
}

/*************************************************************************
* Check if ident is of the form "init_descriptor_<OP>".                  *
*************************************************************************/
int
is_init_descriptor (ident)
char *ident ;
{
    int i ;
    for (i = 0; i <= op_table_index; i++)
    {
        char initdesc [MAX_STR_LEN] ;
        sprintf (initdesc, "init_descriptor_%s", op_table[i].name) ;
        if (strcmp (initdesc, delete_white_space (ident, white)) == 0)
            return (1) ;
    }
    return (0) ;
}

/*************************************************************************
* Check if ident is a helper function.                                   *
*************************************************************************/
int
is_helper (ident)
char *ident ;
{
    int i ;
    for (i = 0; i <= helper_index; i++)
        if (strcmp (helper[i], ident) == 0)
            return (1) ;

    return (0) ;
}

/*************************************************************************
* Verify that expr is a single operator or algorithm.                    *
*************************************************************************/
int
is_single_opr_or_alg (expr)
TREE_TYPE *expr ;
{
    int i ;
    TREE_TYPE *ptr ;

    if (expr == NULL) return (0) ;

    for (i = 0; i < MAX_CHILDREN; i++)
        if ((ptr = expr->child[i]) != NULL)
            if (ptr->node_type != STR_NODE && ptr->node_type != REL_NODE)
                return (0) ;

    return (1) ;
}

/*************************************************************************
* Check if trule is to be junked (i.e., discarded while translating)     *
* by looking in the junk_trule list.                                     *
*************************************************************************/
int
junk (trule)
int trule ;
{
    int i ;

    for (i = 0; i <= junk_trule_index; i++)
        if (junk_trule [i] == trule)
            return (1) ;

    return (0) ;
}

/*************************************************************************
* Print the expression pointed to by "expr" in Prairie format, in "fp".  *
* "str" is either "" (null string) or "," (comma).                       *
*************************************************************************/
void
print_prairie_tree (fp, expr, str)
FILE      *fp ;
TREE_TYPE *expr ;
char      *str ;
{
    int i ;

    if (expr == NULL) return ;

    switch (expr->node_type) {
    case (REL_NODE) :
        fprintf (fp, "%s%s", str, expr->name) ;
        break ;
    case (STR_NODE) :
        fprintf (fp, "%s%s", str, expr->name) ;
        if (strcmp (expr->desc, "") != 0)
            fprintf (fp, ":%s", expr->desc) ;
        break ;
    case (OPR_NODE) :
        fprintf (fp, "%s%s", str, expr->name) ;
        fprintf (fp, "(") ;
        for (i = 0; i < MAX_CHILDREN; i++)
            if (expr->child[i] == NULL)
                break ;
            else if (i == 0)
                print_prairie_tree (fp, expr->child[i], "") ;
            else print_prairie_tree (fp, expr->child[i], ",") ;
        fprintf (fp, ")") ;
        fprintf (fp, ":%s", expr->desc) ;
        break ;
    case (ALG_NODE) :
        fprintf (fp, "%s%s", str, expr->name) ;
        fprintf (fp, "(") ;
        for (i = 0; i < MAX_CHILDREN; i++)
            if (expr->child[i] == NULL)
                break ;
            else if (i == 0)
                print_prairie_tree (fp, expr->child[i], "") ;
            else print_prairie_tree (fp, expr->child[i], ",") ;
        fprintf (fp, ")") ;
        fprintf (fp, ":%s", expr->desc) ;
        break ;
    }

    return ;
}

/*************************************************************************
* Print the expression pointed to by "expr" in Volcano format, in "fp".  *
* "str" is either "" (null string) or " " (the string of one blank).     *
*************************************************************************/
void
print_volcano_tree (fp, expr, str)
FILE      *fp ;
TREE_TYPE *expr ;
char      *str ;
{
    int i ;

    if (expr == NULL) return ;

    switch (expr->node_type) {
    case (REL_NODE) :
        return ;
    case (STR_NODE) :
        fprintf (fp, "%s?%s", str, expr->name+1) ;
        return ;
    case (OPR_NODE) :
        /* If enforcer-operator, delete it from the expression. */
        if (op_table[find (expr->name)].op_type == ENF_OPR)
        {
            print_volcano_tree (fp, expr->child[0], str) ;
            return ;
        }
        else
        {
            /* Replace the current operator with its transitively-mapped
               counterpart. */
            fprintf (fp, "%s(%s ?op_arg%s (",
                     str, find_opr_map (expr->name), expr->desc+1) ;
                
        }
        break ;
    case (ALG_NODE) :
        fprintf (fp, "%s(%s ?al_arg%s (", str, expr->name, expr->desc+1) ;
        break ;
    }

    /* Recursively print children. */
    for (i = 0; i < MAX_CHILDREN; i++)
        if (expr->child[i] == NULL)
            break ;
        else if (i == 0)
            print_volcano_tree (fp, expr->child[i], "") ;
        else print_volcano_tree (fp, expr->child[i], " ") ;

    fprintf (fp, "))") ;

    return ;
}

/*************************************************************************
* Check if impl_rule needs to reestimate the cost of its algorithm.      *
*************************************************************************/
int
reestimate_cost (impl_rule)
int impl_rule ;
{
    int i ;
    for (i = 0; i <= irule_cost_reestimate_index; i++)
        if (irule_cost_reestimate[i] == impl_rule)
            return (1) ;

    return (0) ;
}

/*************************************************************************
* Check if descriptor d is "special", i.e., if it is present in desc[].  *
*************************************************************************/
int
special (d)
int d ;
{
    int i ;
    for (i = 0; i <= desc_index; i++)
        if (desc[i] == d)
            return (1) ;

    return (0) ;
}

/*************************************************************************
* Generate descriptor mapping table from expressions expr1 and expr2.    *
* expr1 and expr2 unify according to unify_expr.                         *
*************************************************************************/
void
unify_desc (expr1, expr2)
TREE_TYPE *expr1, *expr2 ;
{
    int i ;
    int op_ind ;
    TREE_TYPE *copy1, *copy2 ;

    copy1 = copy_expr (expr1) ;
    copy2 = copy_expr (expr2) ;

    desc_map_index = 0 ;
    op_ind = find (copy1->name) ;
    sprintf (desc_map [0].from, "%s", copy1->desc) ;
    sprintf (desc_map [0].to, "$%d",
            op_table [op_ind].arity.streams
            + op_table [op_ind].arity.files) ;
    /* Insert all of the children of the root of copy1. */
    for (i = 0; i < MAX_CHILDREN; i++)
    {
        TREE_TYPE *ch ;
        ch = copy1->child[i] ;
        if (ch == NULL) break ;
        ++desc_map_index ;
        sprintf (desc_map [desc_map_index].from, "D%s", ch->name+1) ; 
        sprintf (desc_map [desc_map_index].to, "$%d", i) ;
    }

    /* Insert the root descriptor of copy2. */
    ++desc_map_index ;
    sprintf (desc_map [desc_map_index].from, "%s", copy2->desc) ;
    sprintf (desc_map [desc_map_index].to, "%s", desc_map [0].to) ;

    /* Insert the remaining nodes of expr2. */
    insert_desc (expr2) ;

    return ;
}

/*************************************************************************
* Unify expressions expr1 and expr2, that may contain enforcer-operators.*
* The unification tests whether expr1 and expr2, with enforcer-operators *
* removed, represent two operators O1 and O2 with the same stream        *
* inputs (i.e., O1 (S1,...,Sn) and O2 (S1,...,Sn)).  If so, it           *
* returns 1; otherwise, it returns 0.  The unification also generates a  *
* descriptor mapping table from expr1 to expr2.                          *
*************************************************************************/
int
unify_expr (expr1, expr2)
TREE_TYPE *expr1, *expr2 ;
{
    int i ;
    int return_value ;
    char from [MAX_STR_LEN] ;
    char to [MAX_STR_LEN] ;
    TREE_TYPE *copy1, *copy2 ;
    char expr1_maps_to [MAX_STR_LEN];
    char expr2_maps_to [MAX_STR_LEN] ;

    /* Make copies of expressions, with enforcer-operators removed. */
    copy1 = copy_expr (expr1) ;
    copy2 = copy_expr (expr2) ;

    if (copy1 == NULL || copy2 == NULL) return (0) ;

    if (copy1->node_type != OPR_NODE || copy2->node_type != OPR_NODE)
        return (0) ;

    strcpy (expr1_maps_to, "") ;
    strcpy (expr2_maps_to, "") ;

    /* If O1 and O2 are already in the operator mapping table,
       then they must both map to the same operator. */
    for (i = 0; i <= opr_map_index; i++)
        if (strcmp (opr_map [i].from, copy1->name) == 0)
            strcpy (expr1_maps_to, opr_map [i].to) ;
        else if (strcmp (opr_map [i].from, copy2->name) == 0)
            strcpy (expr2_maps_to, opr_map [i].to) ;

    if (strlen (expr1_maps_to) > 0
        && strcmp (expr1_maps_to, expr2_maps_to) == 0)

    {
        unify_desc (expr1, expr2) ;
        return (1) ;
    }

    /* copy1->node_type == OPR_NODE && copy2->node_type == OPR_NODE. */
    return_value = 1 ;
    for (i = 0; i < MAX_CHILDREN; i++)
    {
        TREE_TYPE *ch1, *ch2 ;
        ch1 = copy1->child[i] ;
        ch2 = copy2->child[i] ;

        if (ch1 == NULL && ch2 != NULL) return (0) ;
        if (ch1 != NULL && ch2 == NULL) return (0) ;
        if (ch1 == NULL && ch2 == NULL) break ;

        if (ch1->node_type == OPR_NODE || ch2->node_type == OPR_NODE)
            return (0) ;
        /* Neither child is an OPR_NODE.  Check if they are REL_NODEs. */
        if (ch1->node_type == REL_NODE)
            if (ch2->node_type == REL_NODE)
            {
                /* Both nodes are REL_NODEs; they unify regardless of
                   whether they have the same inputs. */
                return_value = 1 ;
            }
            else return (0) ;
        else /* ch1 is a STR_NODE; it must be the same as ch2 to unify. */
            if (strcmp (ch1->name, ch2->name) != 0)
                return (0) ;
    }

    /* If O2 already exists in operator mapping table, and it
       doesn't translate to O1, then unification fails. */
    for (i = 0; i <= opr_map_index; i++)
        if (strcmp (opr_map [i].from, copy2->name) == 0)
            if (strcmp (opr_map [i].to, copy1->name) != 0)
                return (0) ;
            else
            {
                unify_desc (expr1, expr2) ;
                return (return_value) ;
            }

    /* expr1 and expr2 unify; generate the operator mapping info.,
       taking into account transitive mappings; i.e., if O2 maps
       to O1, and O1 maps to O3, then O2 should map to O3 in the
       operator mapping table. */
    strcpy (from, copy2->name) ;
    strcpy (to, copy1->name) ;

    for (i = 0; i <= opr_map_index; i++)
        if (strcmp (opr_map [i].from, to) == 0)
        {
            strcpy (to, opr_map [i].to) ;
            break ;
        }
    /* Also, if any operator used to map to O2, now it should map
       to whatever O2 maps to. */
    for (i = 0; i <= opr_map_index; i++)
        if (strcmp (opr_map [i].to, from) == 0)
            strcpy (opr_map [i].to, to) ;

    ++opr_map_index ;
    strcpy (opr_map [opr_map_index].from, from) ;
    strcpy (opr_map [opr_map_index].to, to) ;
    unify_desc (expr1, expr2) ;

    return (return_value) ;
}

/*************************************************************************
* Two expressions expr1 and expr2 according to unify_expr.  This         *
* function tests whether they "weakly" unify.  That is, two expressions  *
* which unify in Volcano, but not in Prairie, e.g., RET(F1) => RET(F11). *
* If so, return 1, otherwise 0.                                          *
*************************************************************************/
int
weak_unify_expr (expr1, expr2)
TREE_TYPE *expr1, *expr2 ;
{
    int i ;
    TREE_TYPE *copy1, *copy2 ;

    /* Make copies of expressions, with enforcer-operators removed. */
    copy1 = copy_expr (expr1) ;
    copy2 = copy_expr (expr2) ;

    if (copy1 == NULL || copy2 == NULL) return (0) ;

    if (copy1->node_type != OPR_NODE || copy2->node_type != OPR_NODE)
        return (0) ;

    /* copy1->node_type == OPR_NODE && copy2->node_type == OPR_NODE. */
    for (i = 0; i < MAX_CHILDREN; i++)
    {
        TREE_TYPE *ch1, *ch2 ;
        ch1 = copy1->child[i] ;
        ch2 = copy2->child[i] ;

        if (ch1 == NULL) break ;

        /* Since the two expressions unify, the children must all
           be STR_NODEs or REL_NODEs.  The two expressions weakly
           unify if at least one of the children is a REL_NODE and
           the corresponding children in the two expressions are
           different. */
        if (ch1->node_type == REL_NODE && strcmp (ch1->name, ch2->name) != 0)
            return (1) ;
    }

    return (0) ;
}
