/* -*-C-*- */
#include "texsgi.h"
#include "externs.h"
#include "proto.h"
char *getenv(char *s);

int
  readgf()
{        /* return 0 on success, EOF on failure */
  UNSIGN32        checksum;
  register struct char_entry *tcharptr;  /* temporary char_entry
					  * pointer */
  register BYTE   the_byte;
  register UNSIGN16 the_char;  /* loop index */
  
  /*
   * read a GF  file postamble, extracting  character metrics and
   * raster locations.  The character xoffp, yoffp,  wp, and hp values
   * will  not be filled in until a character raster description is
   * actually called for.
   */
  
  /******************************************************************/
  
  /* Process the post-postamble */
  
  if (fseek(fontfp, -4L, 2)) {  /* start 4 bytes from end-of-file */
    (void) warning("readgf():  fseek() failed--GF font file may be empty");
    return (EOF);
  }
  while ((the_byte = (BYTE) nosignex(fontfp, (BYTE) 1)) == GFEOF) {
    if (fseek(fontfp, -2L, 1)) {  /* backup 2 bytes to read
				   * previous one */
      (void) warning(
		     "readgf():  fseek() failed to find GF font file EOF trailer bytes");
      return (EOF);
    }
  }
  
  if (the_byte != (BYTE) GFID) {
    (void) warning("readgf():  GF font file ID byte not found");
    return (EOF);
  }
  if (fseek(fontfp, -6L, 1)) {  /* backup to read post_post */
    (void) warning(
		   "readgf():  fseek() failed to find GF font file POSTPOST byte");
    return (EOF);
  }
  if ((BYTE) nosignex(fontfp, (BYTE) 1) != (BYTE) GFPOSTPOST) {
    (void) warning("readgf():  GF font file POSTPOST byte not found");
    return (EOF);
  }
  if (fseek(fontfp, (long) nosignex(fontfp, (BYTE) 4), 0)) {  /* position to start of
							       * postamble */
    (void) warning(
		   "readgf():  fseek() failed to find postamble in GF font file");
    return (EOF);
  }
  /******************************************************************/
  
  /* Process the postamble */
  
  if ((BYTE) nosignex(fontfp, (BYTE) 1) != (BYTE) GFPOST) {
    (void) warning("readgf():  GF font file POST byte not found");
    return (EOF);
  }
  (void) nosignex(fontfp, (BYTE) 4);  /* discard special pointer
				       * p[4] */
  
  fontptr->designsize = nosignex(fontfp, (BYTE) 4);
  
  checksum = nosignex(fontfp, (BYTE) 4);
  if ((fontptr->c != 0L) && (checksum != 0L) && (fontptr->c != checksum)) {
    (void) sprintf(message,
		   "readgf():  font [%s] has checksum = 10#%010lu [16#%08lx] [8#%011lo] \
different from DVI checksum = 10#%010lu [16#%08lx] [8#%011lo].  \
TeX preloaded .fmt file is probably out-of-date with respect to new fonts.",
		   fontptr->name, fontptr->c, fontptr->c, fontptr->c,
		   checksum, checksum, checksum);
    (void) warning(message);
  }
  fontptr->hppp = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
  fontptr->vppp = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
  fontptr->min_m = (INT32) signex(fontfp, (BYTE) 4);
  fontptr->max_m = (INT32) signex(fontfp, (BYTE) 4);
  fontptr->min_n = (INT32) signex(fontfp, (BYTE) 4);
  fontptr->max_n = (INT32) signex(fontfp, (BYTE) 4);
  
  fontptr->magnification = (UNSIGN32) (0.5 + 5.0 * 72.27 *
				       (float) (fontptr->hppp) / 65536.0);  /* from GFtoPXL Section
									     * 53 */
  
  /******************************************************************/
  
  /* Process the character locators */
  
  the_byte = (BYTE) GFNOOP;
  while (the_byte == (BYTE) GFNOOP) {
    switch (the_byte = (BYTE) nosignex(fontfp, (BYTE) 1)) {
    case GFCHLOC:
    case GFCHLOC0:
      the_char = (UNSIGN16) nosignex(fontfp, (BYTE) 1);
      /* character number MOD 256 */
      if (the_char >= NPXLCHARS) {
        (void) warning(
		       "readgf():  GF font file character number is too big for me");
        return (EOF);
      }
      tcharptr = &(fontptr->ch[the_char]);
      if (the_byte == (BYTE) GFCHLOC) {  /* long form */
        tcharptr->dx = (INT32) signex(fontfp, (BYTE) 4);
        tcharptr->dy = (INT32) signex(fontfp, (BYTE) 4);
      } else {/* short form */
        tcharptr->dx = (INT32) (((UNSIGN32) nosignex(fontfp, (BYTE) 1)) <<
				16);
        tcharptr->dy = 0L;
      }
      tcharptr->tfmw = (UNSIGN32) (((float) nosignex(fontfp, (BYTE) 4) *
				    (float) fontptr->s) / (float) (1L << 20));
      tcharptr->pxlw = (UNSIGN16) PIXROUND(tcharptr->dx, 1.0 / 65536.0);
      tcharptr->fontrp = (long) signex(fontfp, (BYTE) 4);
      
      the_byte = (BYTE) GFNOOP;  /* to force loop
				  * continuation */
      break;
      
    case GFNOOP:
      break;
      
    default:  /* this causes loop exit */
      break;
    }    /* end switch */
  }      /* end while */
  
  for (the_char = FIRSTPXLCHAR; the_char <= LASTPXLCHAR; the_char++) {
    /*
     * Get remaining character metrics, and ignore error returns for now. 
     */
    tcharptr = &(fontptr->ch[the_char]);
    if (tcharptr->fontrp >= 0L)
      (void) chargf((BYTE) the_char, (void (*) ()) NULL);
  }
  
  (void) newfont();
  
  return (0);
}

int
  chargf(c, outfcn)    /* return 0 on success, and EOF on failure */
BYTE            c;  /* current character value */
void            (*outfcn) ();  /* (possibly NULL) function to output
				* current row */
{
  UNSIGN16        d;  /* step in m index */
  BOOLEAN         do_output;  /* FALSE if outfcn is NULL */
  register UNSIGN16 k;  /* loop step */
  register INT16  m, n;  /* column,row indices in image[n][m] */
  long            p;  /* pointer into font file */
  BYTE            paint_switch;  /* alternates between PBLACK and
				  * PWHITE */
  struct char_entry *tcharptr;  /* temporary char_entry pointer */
  register BYTE   the_byte;  /* current command byte */
  UNSIGN32        the_word;  /* temporary result holder */
  
  /*
   * NB: We only test for equality with PBLACK.   PWHITE is any
   * non-zero bit pattern, so we cannot test for equality with it
   */
#define PBLACK ((BYTE)0)
#define PWHITE ((BYTE)(!PBLACK))
  
  /*******************************************************************
    This function is called to process a single character description in
    the GF font file,  and to set the  character metrics hp, wp,  xoffp,
    and yoffp for it.  The character  description may start either at  a
    special (XXX) command, or at a beginning-of-character (BOC or  BOC1)
    command.   It  processes  the  character  description  up  to,   and
    including, the end-of-character (EOC) command which terminates it.
    
    The GF  raster description  is encoded  in a  complex form,  but  is
    guaranteed to step across raster rows  from left to right, and  down
    from the  top  row  to  bottom  row,  such  that  in  references  to
    image[n][m], m never decreases in a row, and n never increases in  a
    character.  This means that we  only require enough memory space  to
    hold one row, provided that outfcn(c,yoff) is called each time a row
    is   completed.    This   is   an  important   economization    for
    high-resolution output  devices --  e.g. a  10pt character  at  2400
    dots/inch would require about  8Kb for the  entire image, but  fewer
    than 25 bytes for a  single row.  A 72pt  character (such as in  the
    aminch font) would need  about 430Kb for the  image, but only  about
    200 bytes for a row.
    
    Access to bit m in the current row is controlled through the  macros
    SETBIT(m) and  TESTBIT(m) so  we  need not  be concerned  about  the
    details of bit masking.  Too bad C does not have a bit data type!
    
    The row image is recorded in such a way that bits min_m .. max_m are
    mapped onto  bits  0  ..  (max_m -  min_m)  in  img_row[],  so  that
    outfcn(c,yoff) should be relieved of any shifting operations.
    
    outfcn(c,yoff) is NEVER called if either of hp or wp is <= 0, or if
    if it is NULL.
    *******************************************************************/
  
  if ((c < FIRSTPXLCHAR) || (LASTPXLCHAR < c)) {
    (void) warning(
		   "chargf():  Character value out of range for GF font file");
    return (EOF);
  }
  tcharptr = &(fontptr->ch[c]);
  
  p = (long) tcharptr->fontrp;  /* font file raster pointer */
  if (p < 0L) {
    (void) warning(
		   "chargf():  Requested character not found in GF font file");
    return (EOF);
  }
  if (fseek(fontfp, p, 0)) {
    (void) warning(
		   "chargf():  fseek() failure for GF font file character raster");
    return (EOF);
  }
  do_output = (BOOLEAN) (outfcn != (void (*) ()) NULL);
  
  (void) skgfspec();  /* skip any GF special commands */
  
  the_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
  if ((the_byte != GFBOC) && (the_byte != GFBOC1)) {
    (void) warning(
		   "chargf():  GF font file not positioned at BOC or BOC1 command");
    return (EOF);
  }
  for (;;) {    /* loop with exit at EOC, or at BOC or BOC1
		 * if no rasters */
    switch (the_byte) {
    case GFPAINT0:
      paint_switch = (BYTE) (!paint_switch);
      break;
      
    case GFPAINT1:
      d = (UNSIGN16) nosignex(fontfp, (BYTE) 1);
      if (do_output && (paint_switch == PBLACK)) {
        for (k = 0; k < d; (++m, ++k))
          SETBIT(m);
      } else
        m += (INT16) d;
      paint_switch = (BYTE) (!paint_switch);
      break;
      
    case GFPAINT2:
      d = (UNSIGN16) nosignex(fontfp, (BYTE) 2);
      if (do_output && (paint_switch == PBLACK)) {
        for (k = 0; k < d; (++m, ++k))
          SETBIT(m);
      } else
        m += (INT16) d;
      paint_switch = (BYTE) (!paint_switch);
      break;
      
    case GFPAINT3:  /* METAFONT never needs this */
      d = (UNSIGN16) nosignex(fontfp, (BYTE) 3);  /* NOTE: truncation */
      if (do_output && (paint_switch == PBLACK)) {
        for (k = 0; k < d; (++m, ++k))
          SETBIT(m);
      } else
        m += (INT16) d;
      paint_switch = (BYTE) (!paint_switch);
      break;
      
    case GFBOC:  /* beginning-of-character -- long form */
      the_word = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
      p = (long) signex(fontfp, (BYTE) 4);
      if ((UNSIGN32) c != the_word) {
        if (p < 0L) {
          (void) warning(
			 "chargf():  Requested character not found in back chain in GF font file");
          return (EOF);
        } else
          (void) fseek(fontfp, p, 0);  /* must follow back
					* chain */
        break;
      } else {
        min_m = (INT16) signex(fontfp, (BYTE) 4);
        max_m = (INT16) signex(fontfp, (BYTE) 4);
        min_n = (INT16) signex(fontfp, (BYTE) 4);
        max_n = (INT16) signex(fontfp, (BYTE) 4);
      }
      if ((min_m < MIN_M) || (MAX_M < max_m) ||
          (min_n < MIN_N) || (MAX_N < max_n)) {
        (void) warning(
		       "chargf():  GF font file character box too large for me");
        return (EOF);
      }
      m = min_m;
      n = max_n;
      paint_switch = PWHITE;
      tcharptr->hp = (COORDINATE) (max_n - min_n + 1);
      tcharptr->wp = (COORDINATE) (max_m - min_m + 1);
      tcharptr->xoffp = -(COORDINATE) (min_m);
      tcharptr->yoffp = (COORDINATE) (min_n);
      if (!VISIBLE(tcharptr))
        return (0);  /* empty character raster --
		      * nothing to output */
      clrparr(parray, tcharptr->hp, tcharptr->wp);
      break;
      
    case GFBOC1:  /* beginning-of-character -- short form */
      if (c != (BYTE) nosignex(fontfp, (BYTE) 1)) {
        (void) warning(
		       "chargf():  Requested character not found in GF font file");
        return (EOF);
      } else {
        min_m = (INT16) nosignex(fontfp, (BYTE) 1);
        max_m = (INT16) nosignex(fontfp, (BYTE) 1);
        min_m = max_m - min_m;
        min_n = (INT16) nosignex(fontfp, (BYTE) 1);
        max_n = (INT16) nosignex(fontfp, (BYTE) 1);
        min_n = max_n - min_n;
      }
      if ((min_m < MIN_M) || (MAX_M < max_m) ||
          (min_n < MIN_N) || (MAX_N < max_n)) {
        (void) warning(
		       "chargf():  GF font file character box too large for me");
        return (EOF);
      }
      m = min_m;
      n = max_n;
      paint_switch = PWHITE;
      tcharptr->hp = (COORDINATE) (max_n - min_n + 1);
      tcharptr->wp = (COORDINATE) (max_m - min_m + 1);
      tcharptr->xoffp = -(COORDINATE) (min_m);
      tcharptr->yoffp = (COORDINATE) (min_n);
      if (!VISIBLE(tcharptr))
        return (0);  /* empty character raster --
		      * nothing to output */
      clrparr(parray, tcharptr->hp, tcharptr->wp);
      break;
      
    case GFEOC:  /* end-of-character */
      return (0);  /* exit outer loop */
      
    case GFSKIP0:
      --n;  /* advance to next row below */
      m = min_m;
      paint_switch = PWHITE;
      break;
      
    case GFSKIP1:
      d = (UNSIGN16) nosignex(fontfp, (BYTE) 1);
      n -= (INT16) d + 1;
      m = min_m;
      paint_switch = PWHITE;
      break;
      
    case GFSKIP2:
      d = (UNSIGN16) nosignex(fontfp, (BYTE) 2);
      n -= (INT16) d + 1;
      m = min_m;
      paint_switch = PWHITE;
      break;
      
    case GFSKIP3:  /* METAFONT never needs this */
      d = (UNSIGN16) nosignex(fontfp, (BYTE) 3);  /* NOTE truncation */
      n -= (INT16) d + 1;
      m = min_m;
      paint_switch = PWHITE;
      break;
      
    case GFXXX1:
    case GFXXX2:
    case GFXXX3:
    case GFXXX4:
    case GFYYY:
    case GFNOOP:
      (void) ungetc((char) the_byte, fontfp);
      (void) skgfspec();
      break;
      
    default:
      if (((BYTE) GFPAINT0 < the_byte) && (the_byte < GFPAINT1)) {
        d = (UNSIGN16) (the_byte - GFPAINT0);
        if (do_output && (paint_switch == PBLACK)) {
          for (k = 0; k < d; (++m, ++k))
            SETBIT(m);
        } else
          m += (INT16) d;
        paint_switch = (BYTE) (!paint_switch);
      } else if (((BYTE) GFNROW0 <= the_byte) && (the_byte <= GFNROWMAX)) {
        n--;  /* advance to next row below */
        paint_switch = PBLACK;
        m = min_m + (UNSIGN16) (the_byte - GFNROW0);
      } else {
        (void) sprintf(message,
		       "chargf():  Unexpected byte %d (0x%02x) in GF font file \
at position %ld",
		       the_byte, the_byte, (long) ftell(fontfp));
        (void) warning(message);
        return (EOF);
      }
      break;
    }    /* end switch */
    the_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
  }      /* end for() */
}

void
  skgfspec()
{        /* Skip GF font file specials */
  BYTE            the_byte;
  
  the_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
  while ((the_byte >= (BYTE) GFXXX1) && (the_byte != GFPOST)) {
    switch (the_byte) {
    case GFXXX1:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 1), 1);
      break;
      
    case GFXXX2:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 2), 1);
      break;
      
    case GFXXX3:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 3), 1);
      break;
      
    case GFXXX4:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 4), 1);
      break;
      
    case GFYYY:
      (void) nosignex(fontfp, (BYTE) 4);
      break;
      
    case GFNOOP:
      break;
      
    default:
      (void) sprintf(message, "skgfspec():  Bad GF font file [%s]",
		     fontptr->name);
      (void) fatal(message);
    }
    the_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
  }
  (void) ungetc((char) the_byte, fontfp);  /* put back lookahead byte */
}

