/*
 *	This file contains definition used in AST handling.
 *
 *	Types of AST's:
 */

#define AST_NULL             0
#define AST_DEVICE_WRITE_IO  1
#define AST_DEVICE_READ_IO   2
#define AST_DEVICE_INPUT     3
#define AST_JOBCTL_MESSAGE   4
#define AST_CARRIER_LOSS     5
#define AST_BROADCAST        6
#define AST_INTERRUPT        7
#define AST_CONTROL_D        8
#define AST_TIMER            9

/*
 *	The associated priorites for the AST's. These values are critical
 *	to the proper execution of the program. In particular:
 *
 *	- Timeouts must be processed after any input for which the timeout
 *	  was waiting, since the timeout was (probably) satisfied by the
 *	  input (it indicates something is going on, at least);
 *
 *	- Control-D is processed before input_io and after output_io (the
 *	  Control-D interrupt is generated from the input interrupt
 *	  processor, so must be processed before another input occurs);
 *
 *	- Presence of input is driven by output_io, so output_io must be
 *	  processed first, since it occurs first. A Control-D is generated
 *	  from output_io, so must be processed after it (but before
 *	  additional input;
 *
 *	- Job controller directives take precedence over all other things;
 *
 *	- A carrier loss is a relatively high priority thing, effectively
 *	  nullifying the efforts of all other processes;
 *
 *	- Interrupts only occur in DVIOUT, so it's value is not really
 *	  important.
 *
 *	Any questions?
 */

#define PRI_BROADCAST         1
#define PRI_TIMER             2
#define PRI_DEVICE_READ_IO    3
#define PRI_DEVICE_INPUT      3
#define PRI_CONTROL_D         5
#define PRI_DEVICE_WRITE_IO   7
#define PRI_CARRIER_LOSS      9
#define PRI_JOBCTL_MESSAGE   20
#define PRI_INTERRUPT        30
