/*
 *	Symbiont header file.
 */

#include descrip
#include "smbdef.h"

/*
 *	This is a multi-threaded symbiont, so we need to establish the
 *	maximum number of threads. This is set to four since anyone who
 *	can afford four LaserWriters can afford something better:
 */

#define MAX_THREADS  4
#define MAX_TIMER   10

/*
 *	'Thread' is the main data structure for controlling each thread.
 *	Each contains all the necessary context information.
 *
 *	In addition to information received from the Job Controller,
 *	we keep a few status variables to indicate our progress in
 *	the current task. This works by defining subtasks within the
 *	task, and recording updates for each subtask as it is completed.
 */

struct Misc_Output {
	struct Misc_Output *Link;
	struct dsc$descriptor Misc_Output_Desc;
};

struct Time { unsigned : 32; unsigned : 32; };

struct Timer_Entry {
	unsigned long Task_Type;
	struct Time Total_Time;
};

#define MAX_CONDITION_VALUES 8
struct Thread {
	struct smbmsg$r_accounting_data Accounting_Data;
	struct smbmsg$r_checkpoint_data Checkpoint_Data;
	unsigned char Characteristics[16];
	unsigned char File_Identification[28];
#define MISC_START Accounting_Data
#define MISC_END   Device_Name
	struct dsc$descriptor Device_Name;
	struct dsc$descriptor Executor_Queue;
	struct dsc$descriptor Job_Reset_Modules;
	struct dsc$descriptor Library_Specification;
#define DESC_START_THREAD Device_Name
#define DESC_END_THREAD   Account_Name
	struct dsc$descriptor Account_Name;
	struct dsc$descriptor User_Name; 
	struct dsc$descriptor File_Setup_Modules;
	struct dsc$descriptor File_Specification; 
	struct dsc$descriptor Form_Name; 
	struct dsc$descriptor Form_Setup_Modules;
	struct dsc$descriptor Job_Name; 
	struct dsc$descriptor Note;
	struct dsc$descriptor Page_Setup_Modules;
	struct dsc$descriptor Queue;
	struct dsc$descriptor Search_String;
	struct dsc$descriptor Form_Type;
/*
 *	Miscellaneous dynamic quantities generated during a task:
 */
	struct dsc$descriptor Page_Desc;
	struct dsc$descriptor Output_Page;
	struct dsc$descriptor Note_Sentence;
	struct dsc$descriptor Job_Sentence;
	struct dsc$descriptor File_Sentence;
	struct dsc$descriptor Qualifier_Sentence;
	struct dsc$descriptor Error_Name;
	struct dsc$descriptor Offending_Command;
#define DESC_START Account_Name
#define DESC_END   Misc_Output_Head
	struct Misc_Output *Misc_Output_Head;
	struct Misc_Output *Stats_Output_Head;
/*
 *	Other Job Parameters:
 */
	unsigned long Item_Flags[4];
	struct Time After_Time;
	struct Time Time_Queued;
	struct Time Time_Printed;
	unsigned long N_Condition_Values;
	unsigned long Condition_Vector[MAX_CONDITION_VALUES];
	unsigned long N_Message_Values;
	unsigned long Message_Vector[MAX_CONDITION_VALUES];
	unsigned long Maximum_Streams;
	unsigned long Print_Control;
	unsigned long Request_Control;
	unsigned long Separation_Control;
	unsigned long Device_Status;
	unsigned long Request_Response;
	unsigned long Refuse_Reason;
	unsigned long Stop_Condition;
	unsigned long Top_Margin;
	unsigned long Bottom_Margin;
	unsigned long Left_Margin;
	unsigned long Right_Margin;
	unsigned long Form_Length;
	unsigned long Form_Width;
	unsigned long Entry_Number;
	unsigned long File_Copies;
	unsigned long File_Count;
	unsigned long Alignment_Pages;
	unsigned long First_Page;
	unsigned long Last_Page;
	         long Relative_Page;
	unsigned long Job_Copies;
	unsigned long Job_Count;
	unsigned long Priority;
	unsigned long Uic;
#define LONG_START Item_Flags[0]
#define LONG_END   Stream_Number
	unsigned long Stream_Number;
	unsigned long Incarnation;
/*
 *	These next items are used in controlling subtasks:
 */
	unsigned long Current_Page;
	char *Lcb;			/* Library control block */
	char *Fcb;			/* File (or module) control block */
	char *Dcb;			/* Device control block */
	struct dsc$descriptor Input_Buffer_Desc; /* Buffer descriptor */
	char Input_Buffer[200];		/* Buffer for reads */
	unsigned long Current_Subtask;
#define TASK_V_START                 0	/* Starting up task */
#define TASK_V_ALIGNMENT             1	/* Doing alignment pages (n/a) */
#define TASK_V_FORM_SETUP            2	/* Printing form setup modules */
#define TASK_V_FLAG_PREFIX           3	/* Printing flag/burst prefix */
#define TASK_V_JOB_FLAG              4	/* Printing job flag page */
#define TASK_V_JOB_BURST             5	/* Printing job burst page */
#define TASK_V_FILE_FLAG             6	/* Printing file flag page */
#define TASK_V_FILE_BURST            7	/* Printing file burst page */
#define TASK_V_FLAG_POSTFIX          8	/* Printing flag/burst postfix */
#define TASK_V_FILE_PREFIX           9	/* Printing file prefix */
#define TASK_V_PAGE_SETUP_PREFIX    10	/* Printing page setup prefix string */
#define TASK_V_PAGE_SETUP           11	/* Printing page setup modules contents */
#define TASK_V_PAGE_SETUP_POSTFIX   12	/* Printing page setup postfix string */
#define TASK_V_FILE_SETUP           13	/* Printing file setup modules */
#define TASK_V_PRINT_FILE           14	/* Printing the file */
#define TASK_V_FILE_POSTFIX         15	/* Printing file postfix */
#define TASK_V_AFTER_PRINT          16	/* Make decisions based on job completion status */
#define TASK_V_FILE_TRAILER_PREFIX  17	/* Printing file trailer page prefix */
#define TASK_V_JOB_OUTPUT           18	/* Printing LaserWriter output */
#define TASK_V_JOB_ERRORS           19	/* Printing User Errors */
#define TASK_V_FILE_TRAILER         20	/* Printing file trailer page */
#define TASK_V_FILE_TRAILER_POSTFIX 21	/* Printing file trailer page postfix */
#define TASK_V_JOB_RESET            22	/* Printing device reset modules */
#define TASK_V_JOB_TRAILER_PREFIX   23	/* Printing job trailer page prefix */
#define TASK_V_JOB_TRAILER          24	/* Printing job trailer page */
#define TASK_V_JOB_STATS            25	/* Printing job statistics page */
#define TASK_V_JOB_TRAILER_POSTFIX  26	/* Printing job trailer page postfix */
#define TASK_V_FINISH               27	/* Finishing up task */
	unsigned long Task_Request_Status, Task_Completion_Status;
#define TASK_M_START                (1 << TASK_V_START)
#define TASK_M_ALIGNMENT            (1 << TASK_V_ALIGNMENT)
#define TASK_M_FORM_SETUP           (1 << TASK_V_FORM_SETUP)
#define TASK_M_FLAG_PREFIX          (1 << TASK_V_FLAG_PREFIX)
#define TASK_M_JOB_FLAG             (1 << TASK_V_JOB_FLAG)
#define TASK_M_JOB_BURST            (1 << TASK_V_JOB_BURST)
#define TASK_M_FILE_FLAG            (1 << TASK_V_FILE_FLAG)
#define TASK_M_FILE_BURST           (1 << TASK_V_FILE_BURST)
#define TASK_M_FLAG_POSTFIX         (1 << TASK_V_FLAG_POSTFIX)
#define TASK_M_FILE_PREFIX          (1 << TASK_V_FILE_PREFIX)
#define TASK_M_PAGE_SETUP_PREFIX    (1 << TASK_V_PAGE_SETUP_PREFIX)
#define TASK_M_PAGE_SETUP           (1 << TASK_V_PAGE_SETUP)
#define TASK_M_PAGE_SETUP_POSTFIX   (1 << TASK_V_PAGE_SETUP_POSTFIX)
#define TASK_M_FILE_SETUP           (1 << TASK_V_FILE_SETUP)
#define TASK_M_PRINT_FILE           (1 << TASK_V_PRINT_FILE)
#define TASK_M_FILE_POSTFIX         (1 << TASK_V_FILE_POSTFIX)
#define TASK_M_AFTER_PRINT          (1 << TASK_V_AFTER_PRINT)
#define TASK_M_FILE_TRAILER_PREFIX  (1 << TASK_V_FILE_TRAILER_PREFIX)
#define TASK_M_JOB_OUTPUT           (1 << TASK_V_JOB_OUTPUT)
#define TASK_M_JOB_ERRORS           (1 << TASK_V_JOB_ERRORS)
#define TASK_M_FILE_TRAILER         (1 << TASK_V_FILE_TRAILER)
#define TASK_M_FILE_TRAILER_POSTFIX (1 << TASK_V_FILE_TRAILER_POSTFIX)
#define TASK_M_JOB_RESET            (1 << TASK_V_JOB_RESET)
#define TASK_M_JOB_TRAILER_PREFIX   (1 << TASK_V_JOB_TRAILER_PREFIX)
#define TASK_M_JOB_TRAILER          (1 << TASK_V_JOB_TRAILER)
#define TASK_M_JOB_STATS            (1 << TASK_V_JOB_STATS)
#define TASK_M_JOB_TRAILER_POSTFIX  (1 << TASK_V_JOB_TRAILER_POSTFIX)
#define TASK_M_FINISH               (1 << TASK_V_FINISH)
	unsigned long Task_Status;
#define TASK_M_STOP                 0x00000001
#define TASK_M_STOPPED              0x00000002
#define TASK_M_RESET                0x00000004
#define TASK_M_PAUSED               0x00000008
#define TASK_M_USERERROR            0x00000010
#define TASK_M_DEVERROR             0x00000020
#define TASK_M_CONTROL_D            0x00000040
#define TASK_M_CONTROL_D_WAIT       0x00000080
	unsigned long Task_Options;
#define TASK_M_MANUAL_FEED          0x00000001
#define TASK_M_TEXT_FILE            0x00000002
#define TASK_M_FORM                 0x00000004
#define TASK_M_STATISTICS           0x00000008
/*
 *	These next parameters describe auxiliary information
 *	regarding the current point within a specific subtask
 *	(e.g., which setup module is being printed or which
 *	part of the flag page string remains to be printed):
 */
	struct dsc$descriptor Whole_Desc[10];	/* Whole entity */
	struct dsc$descriptor Partial_Desc;	/* Current entity */
	unsigned int Desc_Count;		/* How many strings to output */
	unsigned int Desc_Index;		/* Index of string currently being output */
	unsigned int Special_Page_Count;	/* How many special pages left */
	unsigned int Output_Page_Count;		/* How many output pages were generated */
	unsigned int Library_Module_Count;	/* How many library modules processed */
	unsigned int Timer_Count;		/* How many timer entries */
	struct Timer_Entry Timer[MAX_TIMER];	/* For statistics */
	struct Time Subtask_Time[TASK_V_FINISH+1]; /* Also for statistics */
} Device_Thread[MAX_THREADS];

/*
 *	This is the buffer size we use for the output to the
 *	LaserWriter. It must be less than the SYSGEN MAXBUF value,
 *	usually 1584.
 */

#define BUFFER_SIZE 1024

/*
 *	Here are some definitions to specify what should be included
 *	in a message to the Job Controller:
 */

#define JBC_ACNT 0x0001
#define JBC_CKPT 0x0002
#define JBC_DVST 0x0004
#define JBC_ERR  0x0008
