/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	These routines perform various manipulations on
 *	file specifications.
 */

#include descrip
#include fscndef

Add_File_Defaults (Filespec, Default_Filespec, Result_Filespec, Replace_Flag)
char *Filespec, *Default_Filespec, *Result_Filespec;
int Replace_Flag;
{
	auto   int Index;
	static char *Filespec_Descriptor[12];
	static char *Default_Descriptor[12];

	Parse_VMS_Filespec (Filespec, Filespec_Descriptor);
	Parse_VMS_Filespec (Default_Filespec, Default_Descriptor);
	for (Index = 0; Index < 12; Index += 2)
	if ((Replace_Flag != 0 && Default_Descriptor[Index] != 0) ||
			Filespec_Descriptor[Index] == 0) {
		Filespec_Descriptor[Index] = Default_Descriptor[Index];
		Filespec_Descriptor[Index+1] = Default_Descriptor[Index+1];
	}
	Generate_VMS_Filespec (Filespec_Descriptor, Result_Filespec);
}

Provide_Name_Only (Filespec, File_Name)
char *Filespec, *File_Name;
{
	static char *Filespec_Descriptor[12];

	Parse_VMS_Filespec (Filespec, Filespec_Descriptor);
	Filespec_Descriptor[0] = Filespec_Descriptor[1] = 0;
	Filespec_Descriptor[2] = Filespec_Descriptor[3] = 0;
	Filespec_Descriptor[4] = Filespec_Descriptor[5] = 0;
	Filespec_Descriptor[8] = Filespec_Descriptor[9] = 0;
	Filespec_Descriptor[10] = Filespec_Descriptor[11] = 0;
	Generate_VMS_Filespec (Filespec_Descriptor, File_Name);
}

Generate_VMS_Filespec (Component_Descriptor, Filespec)
char *Component_Descriptor[12], *Filespec;
{
	auto   char **CD_Ptr, *Out_Ptr, *In_Ptr;
	auto   int Index;

	Out_Ptr = Filespec;
	CD_Ptr = &Component_Descriptor[0];
	for (Index = 0; Index < 12; Index += 2) {
		if ((In_Ptr = *CD_Ptr) != 0)
			while (In_Ptr <= *(CD_Ptr+1))
				*Out_Ptr++ = *In_Ptr++;
		CD_Ptr += 2;
	}
	*Out_Ptr = '\0';
}

/*
 *	This pretty much standard routine parses a VMS filespec
 *	into its node, device, directory, name, extension and
 *	version fields, returning the start and end address of each.
 */

int Parse_VMS_Filespec (Filespec, Component_Descriptor)
char *Filespec;
char *Component_Descriptor[12];
{
	auto   char **CD_Ptr;
	auto   int Index;
	auto   unsigned long Sys_Status, Flags;
	static struct dsc$descriptor Input_Descriptor;
	static struct FSCNDEF Value_List[] = {
		{ 0, FSCN$_NODE, 0 },
		{ 0, FSCN$_DEVICE, 0 },
		{ 0, FSCN$_DIRECTORY, 0 },
		{ 0, FSCN$_NAME, 0 },
		{ 0, FSCN$_TYPE, 0 },
		{ 0, FSCN$_VERSION, 0 },
		{ 0, 0, 0 }
	};
	extern unsigned long Sys$Filescan();
	extern int Check_System_Status();

	Make_VMS_Descriptor (Filespec, &Input_Descriptor);
	Sys_Status = Sys$Filescan (&Input_Descriptor, &Value_List[0], &Flags);
	if (Check_System_Status (Sys_Status) != 0) {
		CD_Ptr = &Component_Descriptor[0];
		for (Index = 0; Index < 6; Index++)
		if (Value_List[Index].fscn$w_length == 0) {
			*CD_Ptr++ = 0; *CD_Ptr++ = 0;
		} else {
			*CD_Ptr++ = Value_List[Index].fscn$l_addr;
			*CD_Ptr++ = Value_List[Index].fscn$l_addr +
					Value_List[Index].fscn$w_length - 1;
		}
	}
	return (Sys_Status & 0x01);
}
