/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2lfuti.c                                                    *
 * description: Some File UTIlities added by Andreas Tille                    *
 ******************************************************************************/
#include <stdio.h>
#include "wp2latex.h"

FILE *CheckOpen(char *name, char *type)
/* Open a file and check whether successful (AT)
 * --- parameters: ---
 * char  *name        : file name
 * char  *type        : type of the file
 * --- return:     ---
 * FILE  *CheckOpen() : file pointer if successful, else NULL
 */
{
   FILE *fp;

   if ( (fp = fopen(name, type)) == NULL ) {
      fprintf(stderr, "ERROR - File %s not found\n", name);
      return NULL;
   }
   return fp;
}

int ReadAndSplitLine(FILE *fp, char *regel)
/* read text from a file until '\n', if a line is longer than LineLength
 * charcters a blank will be substituted by '\n' to split the long line
 * In the former release there was a
 *   fgets(regel, 256, strip);
 * at this place, but it leads to the fact, that words in paragraphs with
 * more than 256 charcters could be splitted over two lines.
 *
 * Now the output lines will splitted in this way, that they contain about
 * LineLength (defined in the header) characters
 * --- parameters: ---
 * FILE *fp                : file to read from
 * char *regel             : buffer for part to read
 * --- return:     ---
 * char *regel             : read part of file
 * int  ReadAndSplitLine() : number of bytes read
 */
{
   register char *s = regel-1, *h = regel;
   register int  n = 0;

   while ( (*(++s) = fgetc(fp)) != EOF ) {
      n++;
      if ( *s == '\n' ) {
         *s++ = 0;  /* increase s for correct return value */
         break;
      }
      if ( *s == ' ' ) {
         if ( n >= LineLength ) {
            *h = '\n';
            n  = 0;
         }
         h = s;
      }
   }
   if ( *s == EOF ) *s = 0;
   return s - regel;
}

/* The following two functions are substituted by a #define statement    *
 * in wp2latex.h if the EMX compiler is used. This define should         *
 * work for every machine with Intel byte order (|low byte||high byte|)  *
 * but because it was never tested here only EMX is checked.             *
 */

#ifndef __EMX__
void Rd_word(FILE *f, unsigned short *w)
/* Read a word from binary file
 * --- parameters: ---
 * FILE           *f : binary file
 * unsigned short *w : word to read
 * --- return:     ---
 * unsigned short *w : read word
 */
{
   unsigned char b;

   fread(&b, sizeof(unsigned char), 1, f);
   *w = b;
   fread(&b, sizeof(unsigned char), 1, f);
   *w += b * 256;
}

void Wr_word(FILE *f, unsigned short w)
/* Write a word to binary file
 * --- parameters: ---
 * FILE           *f : binary file
 * unsigned short w  : word to write
 */
{
  unsigned char b;

  b = w & 255;
  fwrite(&b, sizeof(unsigned char), 1, f);
  b = w / 256;
  fwrite(&b, sizeof(unsigned char), 1, f);
}
#endif
