/*
 * LaTeX to HTML translator.
 * Copyright (C) 1996 David Mosberger-Tang.
 * This file is part of the LaTeX to HTML translator package.
 *
 * The LaTeX to HTML translator is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * The LaTeX to HTML translator is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the LaTeX to HTML translator; see the file COPYING.  If
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 * Cambridge, MA 02139, USA.
 */
/*
 * String hash-tables.  The number of string/value pairs is unlimited,
 * but once entered, an entry cannot be removed.
 */
#ifndef sh_h
#define sh_h

struct sh;

extern struct sh *	sh_new (int num_buckets);
extern void		sh_enter (struct sh * sh, const char * name,
				  void * value);
extern void *		sh_lookup (struct sh * sh, const char * name);
extern void *		sh_nlookup (struct sh * sh,
				    const char * name, size_t len);

#endif /* sh_h */
