/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * This file contains the output routines.
 */

#include <stdio.h>
#include <stdlib.h>

#include "simple.h"

void
output_token(token tk)
     /* Output the token tk (if special, an error is produced). */
{
  if (tk==EOF) { /* GAME OVER */
    fflush(stdout);
    exit(EXIT_SUCCESS);
  } else if ((tk>=0)&&(tk<FIRST_SPECIAL)) putchar(tk);
  else
    fatal(0,"Non-output token found in output (number %d).",tk);
}
