/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.editor.TexProjectionAnnotation;
import net.sourceforge.texlipse.model.OutlineNode;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class TexCodeFolder {
    private TexEditor editor;
    private ProjectionAnnotationModel model;
    private ArrayList oldNodes;
    private boolean firstRun;
    private HashSet environments;
    private boolean preamble;
    private boolean part;
    private boolean chapter;
    private boolean section;
    private boolean subs;
    private boolean subsubs;
    private boolean paragraph;

    public TexCodeFolder(TexEditor editor) {
        this.editor = editor;
        this.firstRun = true;
    }

    public void update(ArrayList outline) {
        this.model = (ProjectionAnnotationModel)this.editor.getAdapter(ProjectionAnnotationModel.class);
        if (this.model != null) {
            this.addMarks(outline);
        }
    }

    private void addMarks(ArrayList outline) {
        if (this.firstRun) {
            String[] envs = TexlipsePlugin.getPreferenceArray("codeFoldingEnvs");
            this.environments = new HashSet(envs.length + 1);
            int i = 0;
            while (i < envs.length) {
                this.environments.add(envs[i]);
                ++i;
            }
            this.preamble = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingPreamble");
            this.part = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingPart");
            this.chapter = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingChapter");
            this.section = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingSection");
            this.subs = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingSubSection");
            this.subsubs = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingSubSubSection");
            this.paragraph = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFoldingParagraph");
            HashMap map = new HashMap();
            this.fillAnnotationMap(outline, map);
            this.model.modifyAnnotations(null, map, null);
            this.firstRun = false;
            this.environments = null;
        } else {
            this.oldNodes = new ArrayList();
            Iterator iter = this.model.getAnnotationIterator();
            while (iter.hasNext()) {
                this.oldNodes.add((TexProjectionAnnotation)((Object)iter.next()));
            }
            this.markTreeNodes(outline);
            TexProjectionAnnotation[] deletes = new TexProjectionAnnotation[this.oldNodes.size()];
            this.oldNodes.toArray(deletes);
            this.model.modifyAnnotations((Annotation[])deletes, null, null);
        }
    }

    private void markTreeNodes(ArrayList documentTree) {
        ListIterator iter = documentTree.listIterator();
        while (iter.hasNext()) {
            OutlineNode on = (OutlineNode)iter.next();
            this.inspectAndAddMark(on);
            if (on.getChildren() == null) continue;
            this.markTreeNodes(on.getChildren());
        }
    }

    private void inspectAndAddMark(OutlineNode node) {
        Position pos = node.getPosition();
        ListIterator iter = this.oldNodes.listIterator();
        while (iter.hasNext()) {
            TexProjectionAnnotation cAnnotation = (TexProjectionAnnotation)((Object)iter.next());
            if (!cAnnotation.likelySame(node)) continue;
            this.oldNodes.remove((Object)cAnnotation);
            return;
        }
        this.model.addAnnotation((Annotation)new TexProjectionAnnotation(node), pos);
    }

    private void fillAnnotationMap(List documentTree, Map map) {
        ListIterator iter = documentTree.listIterator();
        while (iter.hasNext()) {
            OutlineNode node = (OutlineNode)iter.next();
            Position pos = node.getPosition();
            boolean folding = false;
            switch (node.getType()) {
                case 14: {
                    folding = this.preamble;
                    break;
                }
                case 0: {
                    folding = this.part;
                    break;
                }
                case 1: {
                    folding = this.chapter;
                    break;
                }
                case 2: {
                    folding = this.section;
                    break;
                }
                case 3: {
                    folding = this.subs;
                    break;
                }
                case 4: {
                    folding = this.subsubs;
                    break;
                }
                case 5: {
                    folding = this.paragraph;
                    break;
                }
                case 13: {
                    if (!this.environments.contains(node.getName())) break;
                    folding = true;
                    break;
                }
            }
            TexProjectionAnnotation tpa = new TexProjectionAnnotation(node, folding);
            map.put(tpa, pos);
            if (node.getChildren() == null) continue;
            this.fillAnnotationMap(node.getChildren(), map);
        }
    }
}

