/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser;

import java.io.PushbackReader;
import java.util.HashSet;
import net.sourceforge.texlipse.texparser.lexer.Lexer;
import net.sourceforge.texlipse.texparser.lexer.LexerException;
import net.sourceforge.texlipse.texparser.node.EOF;
import net.sourceforge.texlipse.texparser.node.TArgument;
import net.sourceforge.texlipse.texparser.node.TBverbatim;
import net.sourceforge.texlipse.texparser.node.TCnew;
import net.sourceforge.texlipse.texparser.node.TCword;
import net.sourceforge.texlipse.texparser.node.TEverbatim;
import net.sourceforge.texlipse.texparser.node.TLBrace;
import net.sourceforge.texlipse.texparser.node.TOptargument;
import net.sourceforge.texlipse.texparser.node.TRBrace;
import net.sourceforge.texlipse.texparser.node.TRBracket;
import net.sourceforge.texlipse.texparser.node.TVtext;
import net.sourceforge.texlipse.texparser.node.TWhitespace;
import net.sourceforge.texlipse.texparser.node.Token;

public class LatexLexer
extends Lexer {
    private int count;
    private Token argStart;
    private StringBuffer text;
    private char startChar;
    private int vline;
    private int vpos;
    private HashSet<String> defCommands = new HashSet();
    private boolean commandDef = false;

    public LatexLexer(PushbackReader in) {
        super(in);
    }

    protected void filter() throws LexerException {
        if (this.state.equals(Lexer.State.COMCAPT)) {
            if (this.token instanceof TCnew) {
                this.commandDef = true;
            } else if (this.token instanceof TCword && !this.commandDef && !this.defCommands.contains(this.token.getText().substring(1))) {
                this.state = Lexer.State.NORMAL;
                return;
            }
        } else if (this.state.equals(Lexer.State.BLOCKCAPT)) {
            if (this.argStart == null) {
                this.argStart = this.token;
                this.text = new StringBuffer("");
                this.count = 1;
                this.token = null;
            } else {
                if (this.token instanceof TLBrace) {
                    ++this.count;
                } else if (this.token instanceof TRBrace) {
                    --this.count;
                } else if (this.token instanceof EOF) {
                    throw new LexerException("[" + this.argStart.getLine() + "," + (this.argStart.getPos() - 1) + "] There's a } missing: unexpected end of file");
                }
                if (this.count != 0) {
                    if (this.token instanceof TWhitespace) {
                        this.text.append(" ");
                    } else {
                        this.text.append(this.token.getText());
                    }
                    this.token = null;
                } else {
                    TArgument targ = new TArgument(this.text.toString(), this.argStart.getLine(), this.argStart.getPos());
                    this.token = targ;
                    this.state = Lexer.State.COMCAPT;
                    this.argStart = null;
                    this.commandDef = false;
                }
            }
        } else if (this.state.equals(Lexer.State.OPTCAPT)) {
            if (this.argStart == null) {
                this.argStart = this.token;
                this.text = new StringBuffer("");
                this.count = 0;
                this.token = null;
            } else {
                if (this.token instanceof TLBrace) {
                    ++this.count;
                } else if (this.token instanceof TRBrace) {
                    --this.count;
                } else if (this.token instanceof EOF) {
                    throw new LexerException("[" + this.argStart.getLine() + "," + this.argStart.getPos() + "] There's a } or a ] missing: unexpected end of file");
                }
                if (this.count != 0 || !(this.token instanceof TRBracket)) {
                    if (this.token instanceof TWhitespace) {
                        this.text.append(" ");
                    } else {
                        this.text.append(this.token.getText());
                    }
                    this.token = null;
                } else {
                    TOptargument tsl = new TOptargument(this.text.toString(), this.argStart.getLine(), this.argStart.getPos());
                    this.token = tsl;
                    this.state = Lexer.State.COMCAPT;
                    this.argStart = null;
                    this.commandDef = false;
                }
            }
        } else if (this.state.equals(Lexer.State.VERBATIM)) {
            if (this.token instanceof TBverbatim) {
                this.argStart = this.token;
                this.text = new StringBuffer(this.token.getText());
                this.vline = this.token.getLine();
                this.vpos = this.token.getPos();
            } else if (this.token instanceof TVtext || this.token instanceof TWhitespace) {
                this.text.append(this.token.getText());
                this.token = null;
            } else if (this.token instanceof EOF) {
                throw new LexerException("[" + this.vline + "," + this.vpos + "] The verbatim environment isn't closed: unexpected end of file");
            }
        } else if (this.state.equals(Lexer.State.VERB)) {
            if (this.token instanceof TVtext) {
                if (this.argStart == null) {
                    this.argStart = this.token;
                    this.startChar = this.token.getText().charAt(0);
                } else if (this.startChar == this.token.getText().charAt(0)) {
                    this.state = Lexer.State.NORMAL;
                    this.startChar = '\u0000';
                    this.argStart = null;
                }
                this.token = null;
            } else if (this.token instanceof EOF) {
                throw new LexerException("[" + this.argStart.getLine() + "," + this.argStart.getPos() + "] The verb-command isn't closed: unexpected end of file");
            }
        } else if (this.state.equals(Lexer.State.NORMAL) && this.token instanceof TEverbatim) {
            String endCommand;
            String startCommand = this.argStart.getText().substring(this.argStart.getText().indexOf("{"));
            if (!startCommand.equals(endCommand = this.token.getText().substring(this.token.getText().indexOf("{")))) {
                throw new LexerException("[" + this.vline + "," + this.vpos + "] The verbatim environment isn't closed with the correct command");
            }
            this.text.append(this.token.getText());
            this.token = new TVtext(this.text.toString(), this.vline, this.vpos);
            this.argStart = null;
        }
    }

    public void registerCommand(String command) {
        this.defCommands.add(command);
    }
}

