/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.ui;

import java.io.File;
import java.io.FileFilter;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.Kpath;
import net.sourceforge.texlipse.builder.KpsewhichRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class KpathseaProvider
implements ITreeContentProvider,
ILabelProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            Object[] objectArray = new Object[1];
            KpathseaProvider kpathseaProvider = this;
            kpathseaProvider.getClass();
            objectArray[0] = kpathseaProvider.new TopLevel((IProject)parentElement);
            return objectArray;
        }
        if (parentElement instanceof ITreeNode) {
            return ((ITreeNode)parentElement).getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ITreeNode) {
            return ((ITreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ITreeNode) {
            return ((ITreeNode)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (element instanceof ITreeNode) {
            return ((ITreeNode)element).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ITreeNode) {
            return ((ITreeNode)element).getText();
        }
        if (element instanceof File) {
            return ((File)element).getName();
        }
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private class ExtFilter
    implements FileFilter {
        protected String extension;
        protected boolean folders;

        public ExtFilter(String extension, boolean folders) {
            this.extension = extension;
            this.folders = folders;
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return this.folders;
            }
            return pathname.getName().endsWith(this.extension);
        }
    }

    private class FileType
    implements ITreeNode {
        protected String extension;
        protected TopLevel parent;
        protected Image image;

        public FileType(TopLevel parent, String extension, String imageFile) {
            this.parent = parent;
            this.extension = extension;
            this.image = TexlipsePlugin.getImage(imageFile);
        }

        public Object[] getChildren() {
            KpsewhichRunner filesearch = new KpsewhichRunner();
            try {
                Kpath[] paths = filesearch.getSearchPaths((IResource)this.parent.getProject(), this.extension);
                Object[] nodes = new KpathNode[paths.length];
                int i = 0;
                while (i < paths.length) {
                    nodes[i] = new KpathNode(this, paths[i].path, new ExtFilter(this.extension, paths[i].searchChildren));
                    ++i;
                }
                return nodes;
            }
            catch (CoreException ce) {
                TexlipsePlugin.log("Can't run Kpathsea", ce);
                return null;
            }
        }

        public boolean hasChildren() {
            return this.getChildren() != null;
        }

        public String getText() {
            return this.extension;
        }

        public Object getParent() {
            return this.parent;
        }

        public Image getImage() {
            return this.image;
        }
    }

    static interface ITreeNode {
        public Object[] getChildren();

        public boolean hasChildren();

        public String getText();

        public Object getParent();

        public Image getImage();
    }

    private class KpathNode
    extends PathNode {
        public KpathNode(ITreeNode parent, File path, FileFilter filter) {
            super(parent, path, filter);
        }

        public String getText() {
            return this.path.getPath();
        }
    }

    private class PathNode
    implements ITreeNode {
        protected ITreeNode parent;
        protected File path;
        protected FileFilter filter;

        public PathNode(ITreeNode parent, File path, FileFilter filter) {
            this.parent = parent;
            this.path = path;
            this.filter = filter;
        }

        public Object[] getChildren() {
            File[] files = this.path.listFiles(this.filter);
            Object[] nodes = new PathNode[files.length];
            int i = 0;
            while (i < files.length) {
                nodes[i] = new PathNode(this, files[i], this.filter);
                ++i;
            }
            return nodes;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getText() {
            return this.path.getName();
        }

        public boolean hasChildren() {
            return this.path.isDirectory() && this.getChildren().length > 0;
        }

        public Image getImage() {
            if (this.path.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (!this.path.exists()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }

    private class TopLevel
    implements ITreeNode {
        protected IProject parent;
        protected FileType[] children;

        public TopLevel(IProject parent) {
            this.parent = parent;
            this.children = new FileType[3];
            this.children[0] = new FileType(this, "tex", "texfile");
            this.children[1] = new FileType(this, "bib", "bibfile");
            this.children[2] = new FileType(this, "bst", "bibfile");
        }

        public Object[] getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return true;
        }

        public String getText() {
            return "Search Paths";
        }

        public Object getParent() {
            return this.parent;
        }

        public IProject getProject() {
            return this.parent;
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }
}

