## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "BibCompletions.tcl"
 #                                    created: 10/5/95 {12:55:13 am} 
 #                                last update: 27/4/98 {5:39:43 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # ###################################################################
 ##

set completions(Bib) {completion::cmd Entry completion::word}

#  Completions  #

set Bibcmds "$entryNames"

## 
 # -------------------------------------------------------------------------
 #	 
 # "Bib::Completion::Entry"	--
 #	
 #	If the current text	is '@XXX' where	'XXX' is the name of a bib-entry
 #	type, then insert the correct template for that	type.
 # -------------------------------------------------------------------------
 ##
proc Bib::Completion::Entry {{dummy ""}} {
	global rqdFld
	set lastword [completion::lastWord where]
	set where [pos::math $where - 1]
	if {[lookAt $where] != "@"} {
		return 0
	}
	if ![info exists rqdFld($lastword)] {
		return 0
	}
	bibFormatSetup
	deleteText $where [getPos]
	goto $where
	newEntry $lastword
}
