package require Cpptcl
package require Itcl 3.0

#INDEX\
proc cpp::ClassBrowser

class cpp::ClassBrowser {
    inherit cpp::WindowTree 

    constructor {args} {}
    
    method makeHierarchy {} { pure_virtual }
    method addObjectAndDescendants {obj} {pure_virtual}
    method addPair {obj parent} {}
    method niceName {obj} {}
	method setNodeType {type} {}
	public variable nodeType "cpp::TIplain"
}

body cpp::ClassBrowser::constructor {args} {
	set mb $itk_component(mbar).configure
	$mb.menu add cascade -label "Node Type" \
		-menu $mb.menu.ntmenu
	set m [menu $mb.menu.ntmenu]
	global ::cpp::options
	foreach d $options(classdisplays) {
		$m add command -label "$d" \
			-command [code $this setNodeType "cpp::TI${d}"]
	}
	#makeHierarchy
}

body cpp::ClassBrowser::setNodeType {type} {
	# should check if descended from correct thing
	set nodeType $type
	myHierarchy clear
	makeHierarchy
}

body cpp::ClassBrowser::addPair {obj parent} {
	set objname [niceName $obj]
	set item [myHierarchy theCanvas].a$objname
	if {[info commands $item] == ""} {
		set parent [niceName $parent]
		$nodeType $item $obj [myHierarchy theCanvas] -text "$obj"
		myHierarchy add $item $objname $parent	
	}
	
}

body cpp::ClassBrowser::niceName {obj} {
	regsub -all "::" [join $obj ""] "-" obj
	return $obj
}


itcl::class cpp::CpptclClassBrowser {
    inherit cpp::ClassBrowser cpp::ObjectControl
    
    constructor {args} {}
    
    method makeHierarchy {} {}
    method addObjectAndDescendants {obj} {}
}

body cpp::CpptclClassBrowser::constructor {args} {
	wm title [namespace tail $this] "Cpptcl Class Browser"
}

body cpp::CpptclClassBrowser::makeHierarchy {} {
    foreach base [cppmeta listTypes] {
	addObjectAndDescendants $base
    }
    update
    myHierarchy draw
}

body cpp::CpptclClassBrowser::addObjectAndDescendants {obj} {
    set objname [join $obj ""]
    set item [myHierarchy theCanvas].a$objname
    $nodeType $item $obj [myHierarchy theCanvas] -text "$obj"
    foreach parent [cppmeta listParents $obj] {
	if {$parent == "type-hierarchy" } { 
	    set parent "" 
	} else {
	    set parent [join $parent ""]
	}
	myHierarchy add $item $objname $parent
    }
    foreach descendant [cppmeta listTypes $obj] {
	addObjectAndDescendants $descendant
    }
}

#INDEX\
proc cpp::ItclClassBrowser

class cpp::ItclClassBrowser {
    inherit cpp::ClassBrowser 

    constructor {args} {}
    
    method makeHierarchy {} {}
    method addObjectAndDescendants {obj} {}
    method addObjectAndParents {obj} {}
}

body cpp::ItclClassBrowser::constructor {args} {
	wm title [info namespace tail $this] "Itcl Class Browser"
}

body cpp::ItclClassBrowser::makeHierarchy {} {
	foreach base [uplevel \#0 info classes *] {
		addObjectAndParents $base
	}
	update
	myHierarchy draw
}

body cpp::ItclClassBrowser::addObjectAndParents {obj} {
    if {[catch {uplevel \#0 namespace $obj \{info inherit\}} inherit] == 0} {
    	foreach parent $inherit {
    		addObjectAndParents $parent
    		addPair $obj $parent
    	}
    	if {$inherit == ""} {
    		addPair $obj ""
    	}
	}
}

body cpp::ItclClassBrowser::addObjectAndDescendants {obj} {
	return
	set objname [join $obj ""]
	set item [myHierarchy theCanvas].a$objname
	$nodeType $item $obj [myHierarchy theCanvas] -text "$obj"
	foreach parent [info listParents $obj] {
		if {$parent == "All Objects" } { 
			set parent "" 
		} else {
			set parent [niceName $parent]
		}
		myHierarchy add $item $objname $parent
	}
	foreach descendant [info descendants $obj] {
		addObjectAndDescendants $descendant
	}
}
