/* socket.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include <rsxnt.h>
#include <rsxntso.h>

int __socket (int domain, int type, int protocol)
{
    int s, fd;

    if (!_rsxnt_socket_inited)
      return _rsxnt_errno(ENETDOWN);

    s = (*wsa_socket) (domain, type, protocol);
    if (s == SOCKET_ERROR)
        return _rsxnt_socket_errno();

    fd = _rsxnt_get_new_file(_rsxnt_get_process_ptr());

    if (fd < 0) {
        (*wsa_closesocket)(s);
        return _rsxnt_errno(EMFILE);
    }
    else {
        EMXPROCESS *p = _rsxnt_get_process_ptr();

        p->file[fd].f_handle = (HANDLE) s;
        p->file[fd].f_mode = HT_SOCKET;
        p->file[fd].f_flags = 0;

        return fd;
    }
}
