/* sys/select.h (emx+gcc) */

#if !defined (_SYS_SELECT_H)
#define _SYS_SELECT_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (FD_SETSIZE)

#define	FD_SETSIZE      256

typedef struct _fd_set
{
  unsigned long fds_bits[(FD_SETSIZE+31) / 32];
} fd_set;

#define	FD_SET(n,s)    ((s)->fds_bits[(n)/32] |=  (1L << ((n) & 0x1f)))
#define	FD_CLR(n,s)    ((s)->fds_bits[(n)/32] &= ~(1L << ((n) & 0x1f)))
#define	FD_ISSET(n,s)  ((s)->fds_bits[(n)/32] &   (1L << ((n) & 0x1f)))
#define FD_ZERO(s)     (void)memset (s, 0, sizeof (*(s)))

#endif

struct timeval;

int select (int, struct _fd_set *, struct _fd_set *, struct _fd_set *,
    struct timeval *);

int _select (int, struct _fd_set *, struct _fd_set *, struct _fd_set *,
    struct timeval *);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_SYS_SELECT_H) */
