procedure DiscardOneChar(nfont, nchar : byte;
                        var FChar : CharDataType;
                        var FLig  : ptrLigRecord;
                        var FLigB : ptrLigRecord);
var ptrL : ptrLigRecord;
    ptrD : ptrDiscardChar;
    i, j : integer;
    fl : boolean;
begin

    if FChar[nchar].twork <> 2 then
    begin
       ErrorLog('*** Internal Error : Call to DISCARD CHAR with illegal TWORK attribute');
       FlagError:=true;
    end;

    if FChar[nchar].included then
    begin
       ErrorLog('*** Internal Error : Attempt to discard already included character.');
       FlagError:=true;
    end;

    if FChar[nchar].defined then
       ErrorLog('... Character '+ConvChar(nchar)+' in font D '+ConvInt(nfont)+' is deleted');

    FChar[nchar].defined:=false;
    FChar[nchar].included:=false;
    FChar[nchar].twork:=0;

    fl:=true; ptrD:=ptrDiscCharGlb;
    while ptrD <> nil do
    begin
         if (ptrD^.charnum = nchar) and (ptrD^.fontnum = nfont)
            then fl:=false;
         ptrD:=ptrD^.ptrNext;
    end; {while}

    if fl and FlagDiscInclude then
    begin
         new(ptrD);
         ptrD^.charnum:=nchar; ptrD^.fontnum:=nfont;
         ptrD^.ptrNext:=ptrDiscCharGlb;
         ptrDiscCharGlb:=ptrD;
    end;

    for i:=0 to 255 do
    with FChar[i] do
    begin
         if FlAddParm = 1 then {NextLarger}
         begin
              if NextLarger = nchar then
              begin
                 ErrorLog('...... For character '+ConvChar(NextLarger)+' in font D '+ConvInt(nfont));
                 ErrorLog('       the attribute NEXTLARGER is deleted (reference on discarded char)');
                 FlAddParm:=0;
              end;
         end;

         if FlAddParm in [2,3] then {VarChar}
         begin
              if (Top <> 0) and (Top = nchar) then
              begin
                 ErrorLog('...... For character '+ConvChar(Top)+' in font D '+ConvInt(nfont));
                 ErrorLog('       the attribute VARCHAR [TOP] is deleted (reference on discarded char)');
                 FlAddParm:=0;
              end;
              if (Mid <> 0) and (Mid = nchar) then
              begin
                 ErrorLog('...... For character '+ConvChar(Mid)+' in font D '+ConvInt(nfont));
                 ErrorLog('       the attribute VARCHAR [MID] is deleted (reference on discarded char)');
                 FlAddParm:=0;
              end;
              if (Bot <> 0) and (Bot = nchar) then
              begin
                 ErrorLog('...... For character '+ConvChar(Bot)+' in font D '+ConvInt(nfont));
                 ErrorLog('       the attribute VARCHAR [BOT] is deleted (reference on discarded char)');
                 FlAddParm:=0;
              end;
         end;

         if FlAddParm = 3 then {VarChar + REP}
         begin
              if Rep = nchar then
              begin
                 ErrorLog('...... For character '+ConvChar(Rep)+' in font D '+ConvInt(nfont));
                 ErrorLog('       the attribute VARCHAR [REP] is deleted (reference on discarded char)');
                 FlAddParm:=0;
              end;
         end;

    end; {for i}

    ptrL:=FLig;
    while ptrL <> nil do
    begin
         case ptrL^.TTLig of
         TLabel : if ptrL^.LigChar = nchar then ptrL^.marked:=LigDiscard;
         TKern : if ptrL^.KernChar = nchar then ptrL^.marked:=LigDiscard;
         TLig, TSLig, TSLigH, TLigS,
         TLigSH, TSLigS, TSLigSH,
         TSLigSHH : if (ptrL^.NextChar = nchar)
                       or (ptrL^.InsChar = nchar)
             then ptrL^.marked:=LigDiscard;
         end; {case}
         ptrL:=ptrL^.ptrNext;
    end; {while}

    ptrL:=FLigB;
    while ptrL <> nil do
    begin
         case ptrL^.TTLig of
         TLabel : if ptrL^.LigChar = nchar then ptrL^.marked:=LigDiscard;
         TKern : if ptrL^.KernChar = nchar then ptrL^.marked:=LigDiscard;
         TLig, TSLig, TSLigH, TLigS,
         TLigSH, TSLigS, TSLigSH,
         TSLigSHH : if (ptrL^.NextChar = nchar)
                       or (ptrL^.InsChar = nchar)
             then ptrL^.marked:=LigDiscard;
         end; {case}
         ptrL:=ptrL^.ptrNext;
    end; {while}

end; {DiscardOneChar}


function FixAdd1(var FPar  : FontParamRec;
                 var FChar : CharDataType;
                 var FLL   : LigRecord;
                 nfont : byte; ncharstr : string;
                 ichar : byte; flbound : boolean) : boolean;
var fl : boolean;
begin

     if (FLL.marked = LigDiscard) or (FChar[ichar].twork = 2) then
     begin
         FLL.marked:=LigDiscard;
         FixAdd1:=false;
         exit;
     end;

     fl:=false;
     if not FChar[ichar].defined then
     begin
         if (flbound)
            and (FPar.FlBoundChar)
            and (FPar.BoundChar = ichar)
         then begin
              FLL.marked:=LigUsedBound;
         end
         else begin
            ErrorLog('...... Character '+ConvChar(ichar)+' in font D '+ConvInt(nfont));
            ErrorLog('       is not defined. Corresponding KRN and LIG records are deleted.');
            FLL.marked:=LigDiscard;
         end;
     end
     else
     if (not FChar[ichar].included) and (FChar[ichar].twork <> 1) then
     begin
         if (FlagInclude = 0)
            or ((FlagInclude = 1) and (FLL.TTLig = TKern))
            or ((FlagInclude = 2)
                and (FLL.TTLig in [TLig, TSLig, TSLigH, TLigS, TLigSH,
                                   TSLigS, TSLigSH, TSLigSHH]))
         then begin
              FLL.marked:=LigDiscard;
              ErrorLog('... Character '+ConvChar(ichar)+' in font D '+ConvInt(nfont)+' referenced in LIGTABLE');
              ErrorLog('       for LABEL '+ncharstr+' is absent in map table.');
              ErrorLog('       LIGTABLE record is discarded.');
         end
         else begin
             FLL.marked:=LigUsed;
             ErrorLog('... Character '+ConvChar(ichar)+' in font D '+ConvInt(nfont)+' will be added');
             ErrorLog('       to virtual font (it is referenced in LIGTABLE specified');
             ErrorLog('       for the character '+ncharstr+')');
             FChar[ichar].twork:=1;
             fl:=true;
         end;
     end
     else FLL.marked:=LigUsed;

     FixAdd1:=fl;

end; {FixAdd1}


function FixAdd2(var FChar : CharDataType;
                 nfont, nchar, ichar : byte;
                 s, st : string) : boolean;
var fl : boolean;
begin
   fl:=false;
   if (not FChar[ichar].defined) or (FChar[ichar].twork = 2) then
   begin
       ErrorLog('...... Character '+ConvChar(nchar)+' in font D '+ConvInt(nfont));
       ErrorLog('       is referenced ['+s+st+'] on deleted/absent character '+ConvChar(ichar));
       ErrorLog('       Attribute '+s+' is deleted.');
       FChar[nchar].FlAddParm:=0;
   end
   else if (not FChar[ichar].included) and (FChar[ichar].twork <> 1) then
   begin
       if (FlagInclude = 0) or  (FlagInclude = 2) then
       begin
            ErrorLog('... Character '+ConvChar(nchar)+' in font D '+ConvInt(nfont));
            ErrorLog('       is referenced ['+s+st+'] on character '+ConvChar(ichar));
            ErrorLog('       which is absent in the map table.');
            ErrorLog('       Attribute '+s+' is deleted.');
            FChar[nchar].FlAddParm:=0;
       end
       else begin
            ErrorLog('... Character '+ConvChar(ichar)+' in font D '+ConvInt(nfont));
            ErrorLog('       will be added to virtual font (it is referenced ['+s+st+']');
            ErrorLog('       from the character '+ConvChar(nchar)+')');
            FChar[ichar].twork:=1;
            fl:=true;
       end;
   end;

   FixAdd2:=fl;

end; {FixAdd2}


function IncludeOneChar(nfont, nchar : byte;
                        var FPar  : FontParamRec;
                        var FChar : CharDataType;
                        var FLig  : ptrLigRecord;
                        var FLigB : ptrLigRecord) : boolean;

var ptrL, ptrTT : ptrLigRecord;
var i, j : integer;
    fl, fll : boolean;
begin

    if FChar[nchar].twork <> 1 then
    begin
       ErrorLog('*** Internal Error : Call to INCLUDE CHAR with illegal TWORK attribute');
       FlagError:=true;
    end;

    if not FChar[nchar].defined then
    begin
       ErrorLog('*** Character '+ConvChar(nchar)+' in font D '+ConvInt(nfont)+' is deleted');
       ErrorLog('       and cannot be included in virtual font');
       FlagError:=true;
       FChar[nchar].included:=false;
       FChar[nchar].twork:=0;
       IncludeOneChar:=false;
       exit;
    end;

    if FChar[nchar].included then
    begin
       ErrorLog('*** Internal Error : Character '+ConvChar(nchar)+' in font D '+ConvInt(nfont));
       ErrorLog('       is already included in virtual font');
       FlagError:=true;
       FChar[nchar].twork:=0;
       IncludeOneChar:=false;
       exit;
    end;

    FChar[nchar].included:=true;
    FChar[nchar].twork:=0;

    fl:=not FChar[nchar].traced; i:=255;
    FChar[nchar].traced:=false;
    if fl and (CharDataGlb^[nchar].marked = CharNotUsed) then
    begin
         i:=nchar;
    end;
    while (fl) and (i >= 0) do
    with CharDataGlb^[i] do
    begin
         if marked = CharNotUsed then
         begin
              FlPhantom:=FontsParm^[nfont].FlagNullDVI;
              marked:=CharUsed;
              DefMapfont:=true; DefMapchar:=true;
              mapchar:=nchar; mapfont:=nfont;
              fl:=false;
              ErrorLog('--- Character '+ConvChar(i)+' from virtual font');
              ErrorLog('       is mapped into character '+ConvChar(nchar)+' in font D '+ConvInt(nfont));
         end
         else i:=i-1;
    end; {while}

    if fl then
    begin
       ErrorLog('*** There are no free characters in virtual font');
       ErrorLog('       to add the character '+ConvChar(nchar)+' in font D '+ConvInt(nfont));
       FlagError:=true;
       FChar[nchar].twork:=2;
       DiscardOneChar(nfont, nchar, FChar, FLig, FLigB);
       IncludeOneChar:=false;
       exit;
    end;

    fl:=false;
    with FChar[nchar] do
    begin
         if FlAddParm = 1 then {NextLarger}
         begin
              if FixAdd2(FChar,nfont,nchar,NextLarger,'NEXTLARGER','')
                 then fl:=true;
         end;

         if FlAddParm in [2,3] then {VarChar}
         begin

              if (Top <> 0) then
              begin
                 if FixAdd2(FChar,nfont,nchar,Top,'VARCHAR','/TOP')
                    then fl:=true;
              end;

              if (Mid <> 0) then
              begin
                 if FixAdd2(FChar,nfont,nchar,Mid,'VARCHAR','/MID')
                    then fl:=true;
              end;

              if (Bot <> 0) then
              begin
                 if FixAdd2(FChar,nfont,nchar,Bot,'VARCHAR','/BOT')
                    then fl:=true;
              end;

         end; {FlAddParm = 2,3}

         if FlAddParm = 3 then {VarChar + REP}
         begin
             if FixAdd2(FChar,nfont,nchar,Rep,'VARCHAR','/REP')
                then fl:=true;
         end;

    end; {with FChar}

    {----- Update Main LIGTABLE ----}
    ptrL:=FLig;
    while ptrL <> nil do
    begin
         if (ptrL^.TTLig = TLabel) and (ptrL^.LigChar = nchar) then
         begin
              ptrTT:=ptrL; ptrTT^.marked:=LigUsed;
              while ptrTT <> nil do
              begin
                   case ptrTT^.TTLig of
                   TKern : begin
                           if ptrTT^.marked = LigNotUsed then
                           begin
                              if FixAdd1(FPar,FChar,ptrTT^,
                                         nfont,ConvChar(nchar),
                                         ptrTT^.KernChar,true)
                                 then fl:=true;
                           end; {if marked}
                           ptrTT:=ptrTT^.ptrNext;
                   end;
                   TStop : begin
                                ptrTT^.marked:=LigUsed;
                                ptrTT:=nil;
                           end;
                   TLig, TSLig, TSLigH, TLigS,
                   TLigSH, TSLigS, TSLigSH,
                   TSLigSHH : begin
                           if ptrTT^.marked = LigNotUsed then
                           begin
                              if FixAdd1(FPar,FChar,ptrTT^,
                                         nfont,ConvChar(nchar),
                                         ptrTT^.NextChar,true)
                                 then fl:=true;
                              if FixAdd1(FPar,FChar,ptrTT^,
                                         nfont,ConvChar(nchar),
                                         ptrTT^.InsChar,false)
                                 then fl:=true;
                           end; {if marked}
                           ptrTT:=ptrTT^.ptrNext;
                   end;
                   TSkip : begin
                             ptrTT^.marked:=LigUsed;
                             i:=0; j:=ptrTT^.SkipNum;
                             while (ptrTT <> nil) and (i <= j) do
                             begin
                                  if ptrTT^.TTLig in [TKern, TLig, TSLig,
                                                      TSLigH, TLigS, TLigSH,
                                                      TSLigS, TSLigSH,
                                                      TSLigSHH]
                                     then i:=i+1;
                                  ptrTT:=ptrTT^.ptrNext;
                             end;
                   end;
                   else begin {Label, Label Boundary}
                        ptrTT:=ptrTT^.ptrNext;
                   end;
                   end; {case}
              end; {while ptrTT <> nil}
         end;
         ptrL:=ptrL^.ptrNext;
    end; {while}
    {----- end Update Main LIGTABLE ----}

    {----- Update Bound LIGTABLE ----}
    ptrL:=FLigB;
    while ptrL <> nil do
    begin
         case ptrL^.TTLig of
         TKern : begin
                  if ptrTT^.marked = LigNotUsed then
                  begin
                      if ptrTT^.KernChar = nchar then ptrTT^.marked:=LigUsed;
                  end;
         end;
         TLig, TSLig, TSLigH, TLigS,
         TLigSH, TSLigS, TSLigSH,
         TSLigSHH : begin
                      if ptrTT^.marked = LigNotUsed then
                      begin
                         if ptrTT^.NextChar = nchar then
                         begin
                              ptrTT^.marked:=LigUsed;
                              if FixAdd1(FPar,FChar,ptrTT^,
                                         nfont,ConvChar(nchar),
                                         ptrTT^.InsChar,false)
                                 then fl:=true;
                         end;
                      end; {if marked}
         end;
         end; {case}
         ptrL:=ptrL^.ptrNext;
    end; {while}
    {----- end Update Bound LIGTABLE ----}

end; {IncludeOneChar}


procedure CleanFont(nfont      : integer;
                    var FParam : FontParamRec;
                    var FDim   : FontDimenRec;
                    var FChar  : CharDataType;
                    var FLig   : ptrLigRecord;
                    var FLigB  : ptrLigRecord);
procedure MarkAsUsed(ich, jch : integer;
                     flnulldvi : boolean);
var ptrD : ptrDiscardChar;
    fl   : boolean;
begin
     if FChar[ich].defined then
     begin

          fl:=true;
          {--- check chars defined as DISCARD ---}
          ptrD:=ptrDiscCharGlb;
          while fl and (ptrD <> nil) do
          begin
               if ptrD^.fontnum = nfont then
               begin
                    if ich=ptrD^.charnum then fl:=false;
               end;
               ptrD:=ptrD^.ptrNext;
          end; {while}

          if fl then with CharDataGlb^[jch] do
          if (marked = CharNotUsed) then
          begin
               FlPhantom:=flnulldvi;
               marked:=CharUsed;
               DefMapfont:=true; DefMapchar:=true;
               mapchar:=ich; mapfont:=nfont;
          end
          else begin
               ErrorLog('*** Warning : character '+ConvInt(jch)+' is occupied already.');
               ErrorLog('              Unable to (auto)map this character into character '
                          +ConvInt(ich)+' from font '+ConvInt(nfont)+'.');
          end;
     end;
end; {MarkAsUsed}


var ptrL, pLH,
    ppLig, ppLigP, ppSkip : ptrLigRecord;
    ptrLEnd, ptrLTrace : ptrLigRecord;
    ptrD : ptrDiscardChar;
    i, j : integer;
    ich  : byte;
    fl, flSkip, flSK,
    flEmpty, flSkipEmpty : boolean;

begin

     {--- delete NextLarger mark ---}
     for i:=0 to 255 do
     if FChar[i].defined then
     begin
          if FChar[i].FlAddParm <> 0 then
          begin
               FChar[i].FlAddParm:=0;
               ErrorLog('*** Warning : Attribute VARCHAR/NEXTLARGER is deleted');
               ErrorLog('              (character '+ConvChar(i)+' from font D '+ConvInt(nfont)+').');
          end;
     end;

     {--- delete chars defined as DISCARD ---}
     ptrD:=ptrDiscCharGlb;
     while ptrD <> nil do
     begin
          if ptrD^.fontnum = nfont then
          begin
             ich:=ptrD^.charnum;
             FChar[ich].twork:=2;
             DiscardOneChar(nfont, ich, FChar, FLig, FLigB);
          end;
          ptrD:=ptrD^.ptrNext;
     end; {while}

     {--- include chars which are included by default ---}
     fl:=FontsParm^[nfont].FlagNullDvi;
     case FontsParm^[nfont].MapFontMode of
     FModeNone    : ;
     FModeFull    : for i:=0 to 255 do
                        MarkAsUsed(i, i, fl);
     FMode7to8    : for i:=128 to 255 do
                        MarkAsUsed(i-128, i, fl);
     FMode8to7    : for i:=0 to 127 do
                        MarkAsUsed(i+128, i, fl);
     FModeHbit    : for i:=128 to 255 do
                        MarkAsUsed(i, i, fl);
     FModeLBit    : for i:=0 to 127 do
                        MarkAsUsed(i, i, fl);
     FModeJWNCyr  : for i:=128 to 255 do
                    begin
                         if (JWN_Code[i] <> 0)
                            then MarkAsUsed(JWN_Code[i], i, fl);
                    end;
     FModeAltGost : for i:=128 to 255 do
                    begin
                         if i in [128..175, 224..239]
                            then MarkAsUsed(i, i, fl);
                    end;
     end; {case, for j}

     for i:=0 to 255 do
     with FChar[i] do
     begin
          traced:=false; included:=false;
          if not defined then twork:=2
                         else twork:=0;
     end;

     {--- Extract Label BoundaryChar ----}
     FLigB:=nil; ptrLEnd:=nil;
     ptrLTrace:=FLig; pLH:=nil;

     while ptrLTrace <> nil do
     begin
           ptrLTrace^.marked:=LigNotUsed;

           if ptrLTrace^.TTLig = TLabelBoundary then
           begin
              ptrL:=ptrLTrace;
              while ptrL <> nil do
              begin
                  case ptrL^.TTLig of
                  TLabel, TLabelBoundary : ptrL:=ptrL^.ptrNext;
                  TStop : ptrL:=nil;
                  TSkip : begin
                             i:=0; j:=ptrL^.SkipNum;
                             while (ptrL <> nil) and (i <= j) do
                             begin
                                  if ptrL^.TTLig in [TKern, TLig, TSLig,
                                                     TSLigH, TLigS, TLigSH,
                                                     TSLigS, TSLigSH,
                                                     TSLigSHH]
                                     then i:=i+1;
                                  ptrL:=ptrL^.ptrNext;
                             end;
                   end;
                   else begin {TKern, TLig ?}
                        new(pLH); pLH^:=ptrL^;
                        pLH^.ptrNext:=nil; pLH^.marked:=LigNotUsed;
                        if ptrLEnd = nil then
                        begin
                           FLigB:=pLH; ptrLEnd:=pLH;
                        end
                        else begin
                           ptrLEnd^.ptrNext:=pLH;
                           ptrLEnd:=pLH;
                        end;
                        ptrL:=ptrL^.ptrNext;
                   end;
                   end; {case}
              end;
           end;

           pLH:=ptrLTrace;
           ptrLTrace:=ptrLTrace^.ptrNext;
     end;


     for i:=0 to 255 do
     with CharDataGlb^[i] do
     begin
          if (marked = CharUsed)
             or ((marked = CharDVI) and (DefMapfont or DefMapchar))
          then begin
               if mapfont = nfont then
               begin
                  if not FChar[mapchar].defined then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' is mapped to character '+ConvChar(mapchar));
                       ErrorLog('               in font D '+ConvInt(mapfont)+' which does not contain');
                       ErrorLog('               this character. Character '+ConvChar(i)+' is discarded.');
                       marked:=CharDiscard; FlagError:=true;
                  end
                  else begin
                       FChar[mapchar].twork:=1;
                       FChar[mapchar].traced:=true;
                  end;
               end;
          end;

          if FlTFMData then
          begin
               if sizefont = nfont then
               begin
                  if not FChar[sizechar].defined then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' uses TFM data from character '+ConvChar(sizechar));
                       ErrorLog('               in font D '+ConvInt(sizefont)+' which does not contain');
                       ErrorLog('               this character. Attribute TFMFONT/TFMCHAR is deleted.');
                       FlagError:=true;
                       DefSizefont:=false; DefSizechar:=false;
                       FlTFMData:=false;
                  end;
               end;
          end;
     end;

     if FlagInclude = 4 then {Include All}
     begin
         for i:=0 to 255 do
         begin
             if FChar[i].defined and (FChar[i].twork = 0)
                then FChar[i].twork:=1;
         end;
     end {Include All}
     else
     if FlagInclude >= 1 then {Include char from Bound Table}
     begin
          ptrL:=FLigB; fl:=false;
          while ptrL <> nil do
          begin
                case ptrL^.TTLig of
                TKern : if (FlagInclude = 3) or (FlagInclude = 2)
                then begin
                        if ptrL^.marked = LigNotUsed then
                        begin
                           if FixAdd1(FParam,FChar,ptrL^,
                                      nfont,'BOUNDARYCHAR',
                                      ptrL^.KernChar,true)
                              then fl:=true;
                        end; {if marked}
                end;
                TLig, TSLig, TSLigH, TLigS,
                TLigSH, TSLigS, TSLigSH,
                TSLigSHH : if (FlagInclude = 3) or (FlagInclude = 1)
                then begin
                           if ptrL^.marked = LigNotUsed then
                           begin
                              if FixAdd1(FParam,FChar,ptrL^,
                                         nfont,'BOUNDARYCHAR',
                                         ptrL^.NextChar,true)
                                 then fl:=true;
                              if FixAdd1(FParam,FChar,ptrL^,
                                         nfont,'BOUNDARYCHAR',
                                         ptrL^.InsChar,false)
                                 then fl:=true;
                           end; {if marked}
                end;
                end; {case}
                ptrL:=ptrL^.ptrNext;
          end; {while}
     end; {Include from Bound Table}

     fl:=true;
     while fl do
     begin
          fl:=false;
          for i:=0 to 255 do
          begin
              case FChar[i].twork of
              0 : ;
              1 : begin
                     if IncludeOneChar(nfont, i, FParam, FChar, FLig, FLigB)
                        then fl:=true;
                  end;
              2 : begin
                     DiscardOneChar(nfont, i, FChar, FLig, FLigB);
                  end;
              else FChar[i].twork:=0;
              end;
          end;
     end; {while fl}

     {--- Last Cleaning :
            delete not-necessary skip, stop, label, etc. ---}
     MarkSkipRecord(FLig);

end; {CleanFont}

