/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.Converter;
import nts.noad.Delimiter;
import nts.noad.Egg;
import nts.noad.Field;
import nts.noad.PureNoad;
import nts.noad.ScriptableNoad;
import nts.noad.StSimpleNodeEgg;
import nts.node.HBoxNode;
import nts.node.HShiftNode;
import nts.node.Node;
import nts.node.NodeList;

public class RadicalNoad
extends ScriptableNoad {
    protected final Delimiter radical;
    protected final Field nucleus;

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc()).add(this.radical);
        this.nucleus.addOn(log, cntx, '.');
    }

    protected String getDesc() {
        return "radical";
    }

    protected byte spacingType() {
        return 0;
    }

    public Egg convert(Converter conv) {
        Node node = this.nucleus.cleanBox(conv, (byte)1);
        Dimen drt = conv.getDimPar(17);
        Dimen clr = drt.plus((conv.getStyle() != 0 ? drt : conv.getDimPar(0)).absolute().over(4));
        Dimen size = node.getHeight().plus(node.getDepth()).plus(clr);
        Node rad = conv.fetchSufficientNode(this.radical, size.plus(drt));
        Dimen height = rad.getHeight();
        size = rad.getDepth().minus(size);
        if (size.moreThan(0)) {
            clr = clr.plus(size.halved());
        }
        rad = HShiftNode.shiftingUp(rad, node.getHeight().plus(clr));
        NodeList list = new NodeList(2);
        list.append(rad).append(PureNoad.makeOverBar(node, clr, height, height));
        return new StSimpleNodeEgg(HBoxNode.packedOf(list), this.spacingType());
    }

    public RadicalNoad(Delimiter radical, Field nucleus) {
        this.radical = radical;
        this.nucleus = nucleus;
    }
}

