/*
 *  TEX Device Driver  ver 2.02-
 *  copyright(c) 1988,1989 by TSG, 1990-93 by SHIMA
 *
 *  raster.c : functions for raster-buffer
 *	very slightly modified against warnings by Oh-Yeah? 25 May 1992
 *  modified to use EMS by SHIMA 13 Dec 1992
 *  added raster_buf_realloc() by Yakumo Nov. 1992
 */

#include <stdio.h>
#ifdef  UNIX
#include <memory.h>
#else
#ifdef MSVC
#include <memory.h>
#else
#include <mem.h>
#endif
#endif

#include "dd.h"
#include "buffer.h"
#include "err.h"

#ifdef	VIRTUALFONT
/* virtual.c */
void local_charinfo_flush(FONT_INFO *);
#endif

/* inter.c */
extern int id_dvi;
extern int id_page;

uint num_char;
CHAR_INFO *char_info_ptr;	/* current char_info */

static void raster_buf_flush(void)
	/*  _raster_buf ̃tbVDchar_info-list ͂D
	 */
{
	FONT_INFO *font;
	int i;

	ENTER("raster_buf_flush");

	for (font = first_font_info; font; font = font->next_font) {
		for (i = 0; i < CHAR_ROOT; i++)
			font->char_info[i] = NULL;
#ifdef	VIRTUALFONT
		if (font->font_type == VIRTUAL_FONT
#ifdef	USE_ETF
		  || (font->font_type == ETF_FONT && font->etf_type == VIRTUAL_FONT)
#endif
		) 
			local_charinfo_flush(font->ext.local_font);
#endif
	}
	raster_buf_pointer->current = raster_buf_pointer->start;
	raster_buf_pointer->flush++;
	num_char = 0;
	END();
}

void save_char_info(void)
{
	BUFFER *dst;

	dst = raster_buf_pointer->start;
	memcpy(dst, char_info_ptr, sizeof(CHAR_INFO));
	char_info_ptr = (CHAR_INFO *)dst;
	(HUGE_BUF *)raster_buf_pointer->current += sizeof(CHAR_INFO);
}

void cut_raster(uint size)
{
	size &= ~(sizeof(long)-1);
	(HUGE_BUF *)raster_buf_pointer->current -= size;
}

static void WarnFlush(void)
{
	static int id_flush;
	static int id_fdvi;

	if(id_page == (id_flush -= 0x2000))
		error(WARNING, "Raster buffer size -br: %d K in [System]"
			" (<- Setup Parameters <- Option)\n is too small.\n"
			"Not an error but it is better to increase the size!", 
			raster_buf_pointer->size/1024);
	else if(id_fdvi != id_page + raster_buf_pointer->size){
			id_fdvi  = id_page + raster_buf_pointer->size;
			id_flush = id_page + 0x2000;
	}
}

void raster_buf_alloc(PREAMBLE **preamble_ptr, long size)
	/*  allocate raster-size of the character from raster_buf.
	 *   when no buffer's left, copy preamble to the top of preamble_buf
	 *  and then flush char_info_list
	 */
{
	PREAMBLE *preamble;

/* the following for a bug in BC4.02J
#if	__TURBOC__ >= 0x452
	long	bug_in_BC402;
#endif
*/

	ENTER("raster_buf_alloc");
	
	if(size & (sizeof(long) -1))
		size = (size + sizeof(long)) & ~(sizeof(long) - 1); 
	preamble = *preamble_ptr;
	preamble->raster = raster_buf_pointer->current;
	if ((HUGE_BUF *)raster_buf_pointer->end -
		(HUGE_BUF *)raster_buf_pointer->current < size - 1) {
		WarnFlush();
		raster_buf_flush();
		save_char_info();
		*preamble_ptr = preamble = &(char_info_ptr->pre);
		if ((HUGE_BUF *)raster_buf_pointer->end -
			(HUGE_BUF *)raster_buf_pointer->current < size - 1) {
			error(NO_MEMORY, 
				"The value of -br: "
#ifdef	WIN32G
				"in [Setup Parameters...] -> [System]\n"
				"  is too small for a big font.\n"
				"It should be at least %d K", size/1024 + 2
#else
				"is too small for a big font\n"
				"It should be at least %d", size + 1024
#endif
			);
		}
	}
	preamble->raster = raster_buf_pointer->current;
	raster_buf_pointer->current += size;
	END();
}

#ifdef VFD
void raster_buf_realloc(PREAMBLE **preamble_ptr)
{
	ENTER("raster_buf_realloc");

	raster_buf_pointer->current = (*preamble_ptr)->raster;
	raster_buf_alloc(preamble_ptr,
			(long)(*preamble_ptr)->byte_width * (*preamble_ptr)->height);
	END();
}

#endif

PREAMBLE *
	alloc_preamble(void)
{
	ENTER("alloc_preamble");

resume:
	char_info_ptr = (CHAR_INFO *)raster_buf_pointer->current;
	(HUGE_BUF *)raster_buf_pointer->current += sizeof(CHAR_INFO);
	if (is_end_of(raster_buf_pointer)) {
		WarnFlush();
		raster_buf_flush();
		goto resume;
	}
	num_char++;
	RETURN(&(char_info_ptr->pre));
}

/* end of file : raster.c */
