# Makefile for W32
# make libluahbtex.lib for luahbtex.dll

SHELL = sh
MAKE=make
top_srcdir = ..
srcdir = .

#
# Release
#
OPTIMIZE=-O2

#
# Debugging
#
#OPTIMIZE=-Od -Zi

MPLIBDIR=../mplibdir

CC = cl

CFLAGS = -nologo $(OPTIMIZE) -MD -wd4819

CPPFLAGS =  $(XCPPFLAGS)

XDEFS = -D_CRT_NONSTDC_NO_DEPRECATE -D_CRT_SECURE_NO_DEPRECATE \
-DLUA_COMPAT_MODULE=1 -DLUA_COMPAT_LOADSTRING=1 \
-DLUA_BUILD_AS_DLL=1 -D_CRT_OBSOLETE_NO_DEPRECATE -D_SECURE_SCL=0 \
-DNATIVE_TEXLIVE_BUILD=1 -DHAVE_STRUCTTREEROOT_H=1 -DLuaTeX=1 \
-DLUA_COMPAT_APIINTCASTS=1 -DLUATEX_HARFBUZZ_ENABLED=1 \
-Denviron=_environ -Dmkdir=_mkdir -Dstat=_stat

#
DEFS = -DHAVE_CONFIG_H -Zm200 -DWIN32=1 -DMSVC=1 -DW32TEX=1 -DpdfTeX \
-DSYNCTEX_ENGINE_H='<synctex-luatex.h>' -DNO_KPSE_DLL=1 \
-DNO_DUMP_SHARE=1 $(XDEFS)
#

# Kpathsea needs this for compiling, programs need it for linking.
LIBTOOL = $(kpathsea_srcdir_parent)/klibtool

# You can change [X]CPPFLAGS, [X]CFLAGS, or [X]DEFS, but
# please don't change ALL_CPPFLAGS or ALL_CFLAGS.
# prog_cflags is set by subdirectories of web2c.
ALL_CPPFLAGS = -W2 $(DEFS) -I. -I.. -I$(ZLIBDIR) \
  -I../.. -I$(MPLIBDIR) -I../../kpathsea -I../synctexdir \
  -I../lualibs \
  -I../../../libs -I../../../libs/pplib/src/util \
  -I../../../libs/pplib/src \
  -I../../../libs/harfbuzz/harfbuzz-src/src \
  $(prog_cflags) $(CPPFLAGS)
ALL_CFLAGS = $(ALL_CPPFLAGS) $(CFLAGS) -c
compile = $(CC) $(ALL_CFLAGS) -Fo$@

.SUFFIXES:
.SUFFIXES: .c .obj # in case the suffix list has been cleared, e.g., by web2c
luahbbin/%.obj: %.c
	$(compile) $<

# Installation.
INSTALL = cp
INSTALL_PROGRAM = ${INSTALL}
INSTALL_SCRIPT = $(INSTALL_PROGRAM)
INSTALL_DATA = ${INSTALL}
INSTALL_LIBTOOL_LIBS = INSTALL_DATA='$(INSTALL_DATA)' $(LIBTOOL) install-lib
INSTALL_LIBTOOL_PROG = INSTALL_PROGRAM='$(INSTALL_PROGRAM)' $(LIBTOOL) install-prog

# Creating (symbolic) links.
LN = cp

# We use these for many things.
kpathsea_parent = ..
kpathsea_dir = $(kpathsea_parent)/kpathsea
kpathsea_srcdir_parent = $(top_srcdir)/..
kpathsea_srcdir = $(kpathsea_srcdir_parent)/kpathsea
kpathsea = $(kpathsea_dir)/libkpathsea.lib


LDFLAGS =  $(XLDFLAGS)

LIBS = 
LOADLIBES = $(proglib) $(kpathsea) $(LIBS) $(XLOADLIBES)

# May as well separate linking from compiling, just in case.
CCLD = $(CC)
link_command = $(CCLD) -Fe$@ $(LDFLAGS) 

kpathsea_link = $(link_command)

AR = lib
ARFLAGS = -out:
RANLIB = ranlib

kpathsea_srcdir_parent = $(srcdir)/../..
kpathsea_dir_parent = ../..
.SUFFIXES: .cc .obj
luahbbin/%.obj: %.cc
	$(CXX) $(CXXFLAGS) -c -Fo$@ -Tp$<

CXXFLAGS = -nologo -W2 $(OPTIMIZE) -MD -EHsc -wd4819 -DHAVE_CONFIG_H -DWIN32=1 \
 $(XDEFS) -DNO_KPSE_DLL=1 -I. -I.. -I$(kpathsea_dir_parent) \
 -I$(kpathsea_dir_parent)/kpathsea \
 -I$(kpathsea_srcdir_parent) \
 -I$(LIBPNGDIR) -I$(ZLIBDIR) \
 -I../../../libs -I../../../libs/pplib/src/util \
 -I../../../libs/pplib/src \
 -I../lualibs  -I../lualibs/lua53

CXX = cl

LIBPNGDIR=../../../libs/libpng
LIBPNGSRCDIR=$(srcdir)/$(LIBPNGDIR)

ZLIBDIR=../../../libs/zlib
ZLIBSRCDIR=$(srcdir)/$(ZLIBDIR)
ZLIBLIB=$(ZLIBDIR)/libz.lib

LIBXPDFDIR=../../../libs/xpdf
LIBXPDFSRCDIR=$(srcdir)/$(LIBXPDFDIR)

LIBMD5DIR=../libmd5
LIBMD5SRCDIR=$(srcdir)/$(LIBMD5DIR)

LUAINC=-I../lualibs/lua53 -I../lualibs

XCPPFLAGS=-I.. -I$(srcdir)/.. -I../.. -I$(srcdir)/../.. \
-I$(LIBPNGDIR) -I$(LIBMD5DIR) -I$(LIBMD5SRCDIR) -I$(LIBPNGSRCDIR) \
-I$(ZLIBDIR) -I$(ZLIBSRCDIR) $(LUAINC)

OBJS = \
luahbbin/dvi/dvigen.obj \
luahbbin/font/mapfile.obj \
luahbbin/font/pkin.obj \
luahbbin/font/tounicode.obj \
luahbbin/font/vfpacket.obj \
luahbbin/font/writeenc.obj \
luahbbin/font/writefont.obj \
luahbbin/font/writet1.obj \
luahbbin/font/writet3.obj \
luahbbin/font/writettf.obj \
luahbbin/font/writetype0.obj \
luahbbin/font/writetype2.obj \
luahbbin/font/writecff.obj \
luahbbin/font/tt_glyf.obj \
luahbbin/font/tt_table.obj \
luahbbin/font/sfnt.obj \
luahbbin/font/texfont.obj \
luahbbin/font/tfmofm.obj \
luahbbin/font/vfovf.obj \
luahbbin/font/luafont.obj \
luahbbin/font/dofont.obj \
luahbbin/image/pdftoepdf.obj \
luahbbin/image/writeimg.obj \
luahbbin/image/writejbig2.obj \
luahbbin/image/writejp2.obj \
luahbbin/image/writejpg.obj \
luahbbin/image/writepng.obj \
luahbbin/lang/hnjalloc.obj \
luahbbin/lang/hyphen.obj \
luahbbin/lang/texlang.obj \
luahbbin/lua/helpers.obj \
luahbbin/lua/lcallbacklib.obj \
luahbbin/lua/lpdfelib.obj \
luahbbin/lua/lpdflib.obj \
luahbbin/lua/lfontlib.obj \
luahbbin/lua/limglib.obj \
luahbbin/lua/liolibext.obj \
luahbbin/lua/llanglib.obj \
luahbbin/lua/llualib.obj \
luahbbin/lua/lkpselib.obj \
luahbbin/lua/lnodelib.obj \
luahbbin/lua/loslibext.obj \
luahbbin/lua/lpdfscannerlib.obj \
luahbbin/lua/lstrlibext.obj \
luahbbin/lua/lstatslib.obj \
luahbbin/lua/ltexiolib.obj \
luahbbin/lua/ltexlib.obj \
luahbbin/lua/lnewtokenlib.obj \
luahbbin/lua/luainit.obj \
luahbbin/lua/luanode.obj \
luahbbin/lua/luastuff.obj \
luahbbin/lua/luatex-core.obj \
luahbbin/lua/luatoken.obj \
luahbbin/lua/mplibstuff.obj \
luahbbin/lua/texluac.obj \
luahbbin/luaharfbuzz/blob.obj \
luahbbin/luaharfbuzz/buffer.obj \
luahbbin/luaharfbuzz/class_utils.obj \
luahbbin/luaharfbuzz/direction.obj \
luahbbin/luaharfbuzz/face.obj \
luahbbin/luaharfbuzz/feature.obj \
luahbbin/luaharfbuzz/font.obj \
luahbbin/luaharfbuzz/language.obj \
luahbbin/luaharfbuzz/luaharfbuzz.obj \
luahbbin/luaharfbuzz/ot.obj \
luahbbin/luaharfbuzz/script.obj \
luahbbin/luaharfbuzz/tag.obj \
luahbbin/luaharfbuzz/unicode.obj \
luahbbin/pdf/pdfaction.obj \
luahbbin/pdf/pdfannot.obj \
luahbbin/pdf/pdfcolorstack.obj \
luahbbin/pdf/pdfdest.obj \
luahbbin/pdf/pdffont.obj \
luahbbin/pdf/pdfgen.obj \
luahbbin/pdf/pdfglyph.obj \
luahbbin/pdf/pdfimage.obj \
luahbbin/pdf/pdflink.obj \
luahbbin/pdf/pdflistout.obj \
luahbbin/pdf/pdfliteral.obj \
luahbbin/pdf/pdfobj.obj \
luahbbin/pdf/pdfoutline.obj \
luahbbin/pdf/pdfpage.obj \
luahbbin/pdf/pdfpagetree.obj \
luahbbin/pdf/pdfrule.obj \
luahbbin/pdf/pdfsaverestore.obj \
luahbbin/pdf/pdfsetmatrix.obj \
luahbbin/pdf/pdfshipout.obj \
luahbbin/pdf/pdftables.obj \
luahbbin/pdf/pdfthread.obj \
luahbbin/pdf/pdfxform.obj \
luahbbin/tex/align.obj \
luahbbin/tex/arithmetic.obj \
luahbbin/tex/backend.obj \
luahbbin/tex/buildpage.obj \
luahbbin/tex/commands.obj \
luahbbin/tex/conditional.obj \
luahbbin/tex/directions.obj \
luahbbin/tex/dumpdata.obj \
luahbbin/tex/equivalents.obj \
luahbbin/tex/errors.obj \
luahbbin/tex/expand.obj \
luahbbin/tex/extensions.obj \
luahbbin/tex/filename.obj \
luahbbin/tex/inputstack.obj \
luahbbin/tex/linebreak.obj \
luahbbin/tex/mainbody.obj \
luahbbin/tex/maincontrol.obj \
luahbbin/tex/mathcodes.obj \
luahbbin/tex/memoryword.obj \
luahbbin/tex/mlist.obj \
luahbbin/tex/nesting.obj \
luahbbin/tex/packaging.obj \
luahbbin/tex/postlinebreak.obj \
luahbbin/tex/primitive.obj \
luahbbin/tex/printing.obj \
luahbbin/tex/scanning.obj \
luahbbin/tex/stringpool.obj \
luahbbin/tex/texdeffont.obj \
luahbbin/tex/texfileio.obj \
luahbbin/tex/texmath.obj \
luahbbin/tex/texnodes.obj \
luahbbin/tex/textcodes.obj \
luahbbin/tex/textoken.obj \
luahbbin/utils/avl.obj \
luahbbin/utils/avlstuff.obj \
luahbbin/utils/managed-sa.obj \
luahbbin/utils/unistring.obj \
luahbbin/utils/utils.obj \
luahbbin/synctex.obj \
../libmd5/md5.obj

all: libluahbtex.lib

libluahbtex.lib: $(OBJS)
	$(AR) $(ARFLAGS)$@  $(OBJS)

../libmd5/md5.obj: ../libmd5/md5.c
	$(CC) $(ALL_CFLAGS) -Fo$@ ../libmd5/md5.c

luahbbin/synctex.obj: synctex.c
synctex.c: ../synctexdir/synctex.c
	cp ../synctexdir/synctex.c $@

ocp/ocp.c: ocp/ocp.w
	../ctangle ocp/ocp.w - ocp/ocp.c
ocp/runocp.c: ocp/runocp.w
	../ctangle ocp/runocp.w - ocp/runocp.c
ocp/ocplist.c: ocp/ocplist.w
	../ctangle ocp/ocplist.w - ocp/ocplist.c
ocp/readocp.c: ocp/readocp.w
	../ctangle ocp/readocp.w - ocp/readocp.c


clean:
	rm -f *.obj libluahbtex.lib *.exe *~
	rm -f luahbbin/dvi/*.obj luahbbin/font/*.obj luahbbin/image/*.obj
	rm -f luahbbin/lang/*.obj luahbbin/lua/*.obj luahbbin/*.obj
	rm -f luahbbin/luaharfbuzz/*.obj
	rm -f luahbbin/pdf/*.obj luahbbin/tex/*.obj luahbbin/utils/*.obj
	rm -f dvi/*~ font/*~ image/*~
	rm -f lang/*~ lua/*~
	rm -f pdf/*~ tex/*~ utils/*~

distclean maintainer-clean extraclean: clean
	rm -f config.log config.status

depend: dependhb.mk

dependhb.mk: mkdephb.sh
	./mkdephb.sh

include dependhb.mk
