/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/github/ajalt/colormath/HSV;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "s", "v", "a", "", "(IIIF)V", "getA", "()F", "alpha", "getAlpha", "getH", "()I", "getS", "getV", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toHSL", "Lcom/github/ajalt/colormath/HSL;", "toHSV", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colormath"})
public final class HSV
implements Color,
HueColor {
    private final int h;
    private final int s;
    private final int v;
    private final float a;

    @Override
    public float getAlpha() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB toRGB() {
        void g;
        void r;
        Triple<Double, Double, Double> triple2;
        double h = (double)this.getH() / (double)60;
        double s = (double)this.s / (double)100;
        double v = (double)this.v / (double)100;
        boolean bl = false;
        double hi = Math.floor(h) % (double)6;
        boolean bl2 = false;
        double f = h - Math.floor(h);
        double p = (double)255 * v * (1.0 - s);
        double q = (double)255 * v * (1.0 - s * f);
        double t = (double)255 * v * (1.0 - s * (1.0 - f));
        v *= (double)255;
        switch (MathKt.roundToInt(hi)) {
            case 0: {
                triple2 = new Triple<Double, Double, Double>(v, t, p);
                break;
            }
            case 1: {
                triple2 = new Triple<Double, Double, Double>(q, v, p);
                break;
            }
            case 2: {
                triple2 = new Triple<Double, Double, Double>(p, v, t);
                break;
            }
            case 3: {
                triple2 = new Triple<Double, Double, Double>(p, q, v);
                break;
            }
            case 4: {
                triple2 = new Triple<Double, Double, Double>(t, p, v);
                break;
            }
            default: {
                triple2 = new Triple<Double, Double, Double>(v, p, q);
            }
        }
        Triple<Double, Double, Double> triple3 = triple2;
        double d = ((Number)triple3.component1()).doubleValue();
        double d2 = ((Number)triple3.component2()).doubleValue();
        double b = ((Number)triple3.component3()).doubleValue();
        return new RGB(MathKt.roundToInt((double)r), MathKt.roundToInt((double)g), MathKt.roundToInt(b), this.getAlpha());
    }

    @Override
    @NotNull
    public HSL toHSL() {
        double h = this.getH();
        double s = (double)this.s / (double)100;
        double v = (double)this.v / (double)100;
        double d = 0.01;
        boolean bl = false;
        double vmin = Math.max(v, d);
        double l = ((double)2 - s) * v / (double)2;
        double lmin = ((double)2 - s) * vmin;
        double sl = lmin == 2.0 ? 0.0 : s * vmin / (lmin <= 1.0 ? lmin : (double)2 - lmin);
        return new HSL(MathKt.roundToInt(h), MathKt.roundToInt(sl * (double)100), MathKt.roundToInt(l * (double)100), this.getAlpha());
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return this;
    }

    @Override
    public int getH() {
        return this.h;
    }

    public final int getS() {
        return this.s;
    }

    public final int getV() {
        return this.v;
    }

    public final float getA() {
        return this.a;
    }

    public HSV(int h, int s, int v, float a) {
        this.h = h;
        this.s = s;
        this.v = v;
        this.a = a;
        int n = this.getH();
        n = 0 <= n && 360 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "h must be in range [0, 360] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.s;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "s must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.v;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "v must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = this.a;
        boolean bl6 = f >= 0.0f && f <= 1.0f;
        bl = false;
        bl2 = false;
        if (!bl6) {
            boolean bl7 = false;
            String string = "a must be in range [0, 1] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ HSV(int n, int n2, int n3, float f, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, f);
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        return Color.DefaultImpls.toHex(this, withNumberSign, renderAlpha);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.getH();
    }

    public final int component2() {
        return this.s;
    }

    public final int component3() {
        return this.v;
    }

    public final float component4() {
        return this.a;
    }

    @NotNull
    public final HSV copy(int h, int s, int v, float a) {
        return new HSV(h, s, v, a);
    }

    public static /* synthetic */ HSV copy$default(HSV hSV, int n, int n2, int n3, float f, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = hSV.getH();
        }
        if ((n4 & 2) != 0) {
            n2 = hSV.s;
        }
        if ((n4 & 4) != 0) {
            n3 = hSV.v;
        }
        if ((n4 & 8) != 0) {
            f = hSV.a;
        }
        return hSV.copy(n, n2, n3, f);
    }

    @NotNull
    public String toString() {
        return "HSV(h=" + this.getH() + ", s=" + this.s + ", v=" + this.v + ", a=" + this.a + ")";
    }

    public int hashCode() {
        return ((Integer.hashCode(this.getH()) * 31 + Integer.hashCode(this.s)) * 31 + Integer.hashCode(this.v)) * 31 + Float.hashCode(this.a);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HSV)) break block3;
                HSV hSV = (HSV)object;
                if (this.getH() != hSV.getH() || this.s != hSV.s || this.v != hSV.v || Float.compare(this.a, hSV.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

