
##################################################################
##								##
##			This module is 				##
##           (C) 1999,2000 Perl4YOU software group. 		##
##								##
##	  You are free to redistribute the source code,		##
##	 use it in commercial projects and so on, leaving 	##
##		    this copyright untouched.			##
##								##
##                   Visit our website at 			##
##                 http://www.perl4you.com			##
##								##
##################################################################


package HandySQL;

use mysqlclient;

use vars qw($dbh %describen_tables $debug $requests);

# These register globals
use config qw(%cfg);
use Time::Local;
use HandyLog;
use strict;

BEGIN {
	use Exporter ();
	use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
	$VERSION = 1.00; @ISA = qw(Exporter); %EXPORT_TAGS = (); @EXPORT_OK = ();
	@EXPORT = qw(&describe_table &get_rows &get_row &update_rows &insert_rows &insert_rows_ifne
	             &do_query &delete_rows &str_sqlize &str_unsqlize &sql_date
	             &push_a_nmtable &make_nmtable &sql_lock &sql_unlock &sql_ts2sec &sql_date2ts
	             &sql_ts2date &sql_ts2time &sql_connect &sql_disconnect);
	
	my ($str,$user,$pass);
	$debug = $cfg{'dbdebug'};
	$requests = 0;
	$dbh = undef;
}

END {
	if ($dbh) { &sql_disconnect(); }
}

sub sql_connect
{
	return if ($dbh);
	$dbh = &mc_get();

	my $conntime = time;
	my $result = -1;

	while ((time - $conntime) < $cfg{'connection_timeout'}) {
		$result = &mc_connect($dbh, $cfg{'dbhost'}, $cfg{'dbuser'}, $cfg{'dbpass'});
		last if ($result >= 0);
		sleep (1); # wait one second, waiting for server to unload - FOR STRESSES
	}

	if ($result < 0) {
		&mc_close($dbh);
		$dbh = undef;
		&log_put('Unable to connect to database');
		exit;
	}

	if (&mc_select_db($dbh, $cfg{'dbname'}) < 0) {
		&log_put('Unable to select database');
		exit;
	}
}

sub sql_disconnect
{
	&log_printf("sql: did $requests requests");
	&mc_close($dbh);
	$dbh = undef;
}

sub log_transaction
{
	if ($cfg{'dblog'}) {
		open DBLOGF, '>>'.$cfg{'dblog'};
		print DBLOGF time." $$ ".$_[0]."\n";
		close DBLOGF;
	}
}

sub sql_lock ($$)
{
	my ($name, $timeout) = @_;

	if (!defined $timeout) { $timeout = $cfg{'lock_timeout'}; }
	if (!$dbh) { &sql_connect(); }
		
	$requests++;
	my $result = &mc_query($dbh, "SELECT GET_LOCK(\"$name\",$timeout)")->[0][0];
	if ($debug) {
		&log_put("SELECT GET_LOCK(\"$name\",$timeout)");
	}
	
	if ($result == 0) {
		return 0;
	}

	return 1;
}

sub sql_unlock ($)
{
	my ($name) = @_;
	if (!$dbh) { &sql_connect(); }

	$requests++;
	&mc_query($dbh, "SELECT RELEASE_LOCK(\"$name\")");
	if ($debug) {
		&log_put("SELECT RELEASE_LOCK(\"$name\")");
	}
}

sub sql_error { &log_put('sql_error:'.($#_>0?sprintf(@_):$_[0])); }

sub push_a_nmtable {
	my ($nmt,$dbt,$value) = @_;
	my (%nh,$i);
	for ($i = 0; $i <= $#$dbt; $i ++) { $nh{$dbt->[$i]} = $value->[$i]; }
	push (@{$nmt}, \%nh);
}

sub make_nmtable {
	my ($nmt,$dbt) = @_;
	my ($nh,$i,$value,$j);
	for ($j = 0; $j <= $#$nmt; $j ++) {
		$value = $nmt->[$j];
		$nh = {};
		for ($i = 0; $i <= $#$dbt; $i ++) { $nh->{$dbt->[$i]} = $value->[$i]; }
		$nmt->[$j] = $nh;
	}
}

# YYYY-MM-DD -> TIMESTAMP
sub sql_date2ts
{
	my ($yyyymmdd) = @_;
	my ($y,$m,$d) = split(/-/,$yyyymmdd);
	$y += 1900 if ($y < 1900);
	return sprintf("%04d%02d%02d000000",$y,$m,$d);
}

# TIMESTAMP -> HH:MM:DD
sub sql_ts2time
{
	my ($timestamp) = @_;
	return substr($timestamp,8,2).':'.substr($timestamp,10,2).':'.substr($timestamp,12,2);
}

# TIMESTAMP -> YYYY-MM-DD
sub sql_ts2date
{
	my ($timestamp) = @_;
	return substr($timestamp,0,4).'-'.substr($timestamp,4,2).'-'.substr($timestamp,6,2);
}

# TIMESTAMP -> SECONDS
sub sql_ts2sec
{
	my ($timestamp) = @_;

	return 0 if (length($timestamp) != 14);
	return 0 if ($timestamp eq '00000000000000');

	my @a = (substr($timestamp,12,2),substr($timestamp,10,2),substr($timestamp,8,2),
	         substr($timestamp,6,2), substr($timestamp,4,2) ,substr($timestamp,0,4));

	return 0 if ($a[0] > 59 || $a[0] < 0 || $a[1] > 59 || $a[1] < 0 || $a[2] > 23 || $a[2] < 0
	          || $a[3] > 31 || $a[3] < 1 || $a[4] > 12 || $a[4] < 1 || $a[5] <= 71
						|| ($a[5] >= 137 && $a[5] <= 1971) || $a[5] >= 2037); 
	
	$a[4] --;

	return timelocal(@a);
}

# SECONDS -> TIMESTAMP
sub sql_date
{
	my @a;

	if (defined $_[0]) {
		if ($_[0] == 0) {
			return '00000000000000';
		}
	 	@a = localtime($_[0]);
	} else {
		@a = localtime(time);
	}

	return sprintf("%04d%02d%02d%02d%02d%02d",$a[5]<1900?$a[5]+1900:$a[5],$a[4]+1,
	               $a[3], $a[2], $a[1], $a[0]);
}

sub str_unsqlize
{
	my $str = $_[0];

	if ($str =~ /^\'(.*)\'$/g) { # only if quoted
		$str = $1;
		$str =~ s/\\\'/\'/g;
		$str =~ s/\\\\/\\/g;
	}
	
	return $str;
}

sub str_sqlize
{
	my $str = $_[0];

	$str =~ s/\\/\\\\/g;
	$str =~ s/\'/\\\'/g;
	$str = "\'".$str."\'";
	
	return $str;
}

sub describe_table {
	my ($tablename) = @_;
	my (@row,$h,$i);
	
	if ($describen_tables{$tablename}) {
		return $describen_tables{$tablename};
	}

	if (!$dbh) { &sql_connect(); }
	$h = &mc_query($dbh, "show columns from $tablename");
	if (!$h) {
		&sql_error("show columns from $tablename");
		return [];
	}
	
	$requests++;

	foreach my $i (@$h) {	$i = lc($i->[0]); }
	$describen_tables{$tablename} = $h;
	
	if ($debug) {
		&log_printf('sql: describing '.$tablename.' '.join('|',@$h));
	}
	
	return $h;
}

sub get_rows {
	my ($tablename,$where,$orderby,$limit,$ofs) = @_;
	my ($select,$debug,$dbt,$nrw,@row);

	$debug = $sql::debug;
	if (substr($tablename,0,1) eq '*') { $debug = 1; $tablename =~ s/\*//g; }
		
	$dbt = &describe_table($tablename);
	
	if ($limit && $limit <= 0) {
		&sql_error('get_rows $limit == %d <= 0 Table: %s', $limit, $tablename);
		return $nrw;
	}
	
	if ($ofs && $ofs <= 0) {
		&sql_error('get_rows $ofs == %d <= 0 Table: %s', $ofs, $tablename);
		return $nrw;
	}
	
# check if $dbt is empty => do nothing.
	$select = 'SELECT * FROM '.$tablename;
	if ($where && $where ne '') { $select .= ' WHERE '.$where; }
	if ($orderby && $orderby ne '') { $select .= ' ORDER BY '.$orderby; }
	if ($ofs) { $select .= " LIMIT $ofs,$limit"; }
	elsif ($limit) { $select .= " LIMIT $limit"; }
	
	$requests++;
	if (!$dbh) { &sql_connect(); }
	$nrw = &mc_query($dbh, $select);
	if (!$nrw) {
		&log_printf("sql-error: $select\n");
		return $nrw;
	}

	&make_nmtable($nrw,$dbt);
	if ($debug) { log_printf("get_rows statement $select"); }
	
	return $nrw;
}

sub get_row {
	my ($tablename,$where,$orderby,$ofs) = @_;
	my ($select,$debug,$dbt,$nh,$rows,$i);

	$debug = $sql::debug;
	if (substr($tablename,0,1) eq '*') { $debug = 1; $tablename =~ s/\*//g; }

	if ($ofs && $ofs <= 0) {
		&sql_error('get_rows $ofs == %d <= 0 Table: %s', $ofs, $tablename);
		return undef;
	}
	
	$dbt = &describe_table($tablename);
	
# check if $dbt is empty => do nothing.
	$select = 'SELECT * FROM '.$tablename;
	if ($where && $where ne '') { $select .= ' WHERE '.$where; }
	if ($orderby && $orderby ne '') { $select .= ' ORDER BY '.$orderby; }
	if ($ofs) { $select .= " LIMIT $ofs,1"; }
	else { $select .= " LIMIT 1"; }

	$requests++;
	if (!$dbh) { &sql_connect(); }
	$rows = &mc_query($dbh, $select);
	if (!$rows) {
		&log_printf("sql-error: $select");
		return undef;
	}
	
	if ($debug) { &log_printf("get_rows statement $select"); }
	return undef if ($#$rows < 0);
	$rows = $rows->[0];
	$nh = {};
	for ($i = 0; $i <= $#$dbt; $i ++) {	$nh->{$dbt->[$i]} = $rows->[$i];	}
	
	return $nh;
}

sub update_rows {
	my ($tablename,$where,$fields) = @_;
	my ($stmt,$i,$isgood,$debug,$rv);
	
	$debug = $sql::debug;
	if (substr($tablename,0,1) eq '*') { $debug = 1; $tablename =~ s/\*//g; }
		
	if (!$where) {
		&log_printf("Warning: update_rows called without where clause.... NO WAY! Table: $tablename");
		return 0;
	}
	
	$stmt = "UPDATE $tablename SET";
	$isgood = 0;
	if ($fields) {
		foreach $i (keys %$fields) {
			if ($isgood) { $stmt .= ","; }
			$stmt .= " ".$i." = ".$fields->{$i};
			$isgood = 1;
		}
	}
	
	if (!$isgood) {
		log_printf("Warning: update_rows called without fields specified.... Table: $tablename");
		return 0;
	}
	
	$stmt .= " WHERE ".$where;
	
	if (!$dbh) { &sql_connect(); }
	$rv = &mc_query($dbh, $stmt);
	&log_transaction($stmt);
	$requests++;
	
	if (!$rv) {
		&sql_error($stmt);
		return 0;
	}

	if (!$dbh) { &sql_connect(); }
	$rv = &mc_affected_rows($dbh);
	if ($rv == 0) { $rv = '0E0'; }
	
	if ($debug) { log_printf("update_rows stmt $stmt");	}
	
	return $rv;
}

sub insert_rows_ifne {
	my ($tablename,$fields) = @_;
	my ($stmt,$i,$isgood,$debug,$rv,$vals);
	
	$debug = $sql::debug;
	if (substr($tablename,0,1) eq '*') { $debug = 1; $tablename =~ s/\*//g; }
		
	$stmt = "INSERT INTO $tablename (";
	$vals = "(";
	$isgood = 0;

	if ($fields) {
		foreach $i (keys %$fields) {
			if ($isgood) { $stmt .= ","; $vals .= ","; }
			$stmt .= $i;
			$vals .= "$fields->{$i}";
			$isgood = 1;
		}
	}

	$stmt .= ") VALUES ".$vals.")";
	
	if (!$isgood) {
		log_printf("Warning: insert_rows called without fields specified.... Table: $tablename");
		return 0;
	}
	
	if (!$dbh) { &sql_connect(); }
	&mc_query($dbh,$stmt);
	&log_transaction($stmt);
	$requests++;

	if (!$dbh) { &sql_connect(); }
	$rv = &mc_affected_rows($dbh);
	if (!$rv) {
		return 0;
	}
	
	if ($debug) { &log_printf("insert_rows stmt $stmt");	}
	
	return $rv;
}

sub insert_rows {
	my ($tablename,$fields) = @_;
	my ($stmt,$i,$isgood,$debug,$rv,$vals);
	
	$debug = $sql::debug;
	if (substr($tablename,0,1) eq '*') { $debug = 1; $tablename =~ s/\*//g; }
		
	$stmt = "INSERT INTO $tablename (";
	$vals = "(";
	$isgood = 0;

	if ($fields) {
		foreach $i (keys %$fields) {
			if ($isgood) { $stmt .= ","; $vals .= ","; }
			$stmt .= $i;
			$vals .= "$fields->{$i}";
			$isgood = 1;
		}
	}

	$stmt .= ") VALUES ".$vals.")";
	
	if (!$isgood) {
		log_printf("Warning: insert_rows called without fields specified.... Table: $tablename");
		return 0;
	}
	
	if (!$dbh) { &sql_connect(); }
	&mc_query($dbh,$stmt);
	&log_transaction($stmt);
	$requests++;

	if (!$dbh) { &sql_connect(); }
	$rv = &mc_affected_rows($dbh);
	if (!$rv) {
		&sql_error($stmt);
		return 0;
	}
	
	if ($debug) { &log_printf("insert_rows stmt $stmt");	}
	
	return $rv;
}

sub do_query {
	my ($select) = @_;
	my ($debug);

	$debug = $sql::debug;
	if (substr($select,0,1) eq '*') { $debug = 1; $select = substr($select,1); }
	$requests++;
	if ($debug) { &log_printf("do_query stmt $select"); }
	
	if ($select =~ /^\s*(?:insert|update|delete)/oi) {
		&log_transaction($select);
	}

	if (!$dbh) { &sql_connect(); }
	return &mc_query($dbh, $select);
}

sub delete_rows {
	my ($tablename,$where) = @_;
	my ($stmt,$i,$isgood,$debug,$rv);
	
	$debug = 0;
	if (substr($tablename,0,1) eq '*') { $debug = 1; $tablename =~ s/\*//g; }
		
	if (!$where) {
		&log_printf("Warning: delete_rows called without where clause.... NO WAY! Table: $tablename");
		return 0;
	}
	
	$stmt = "delete from $tablename where ".$where;

	&log_transaction($stmt);
	if (!$dbh) { &sql_connect(); }
	$rv = &mc_query($dbh,$stmt);
	$requests++;
	
	if (!$rv) {
		&sql_error($stmt);
		return 0;
	}
	
	$rv = &mc_affected_rows($dbh);
	if ($rv == 0) { $rv = '0E0'; }
	if ($debug) { &log_printf("delete_rows stmt $stmt");	}
	
	return $rv;
}

1;

