##################################################################
##								##
##			This module is 				##
##           (C) 1999,2000 Perl4YOU software group. 		##
##								##
##	  You are free to redistribute the source code,		##
##	 use it in commercial projects and so on, leaving 	##
##		    this copyright untouched.			##
##								##
##                   Visit our website at 			##
##                 http://www.perl4you.com			##
##								##
##################################################################

#
# This is basic configuration file for your new project
# You will probably want to eliminate this comment.
# We encourage you to write all you project-dependent configs
# here too.
#

package config;

use strict;

use vars qw(%cfg);

BEGIN {
	use Exporter ();
	use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
	$VERSION = 1.00; @ISA = qw(Exporter);   %EXPORT_TAGS = ();
	@EXPORT = qw(%cfg &load_config);
	@EXPORT_OK = qw(%cfg);

	#
	# Base directory of your web-project
	#
	my $basedir = '/home/www/bogus.com/';
	
	%cfg = (
		basedir => $basedir,
		extconfig => $basedir.'/config.txt',

		##### HandySQL.pm
		dblog => $basedir.'tmp/logs/dblog', # Log of database transactions
		dbname => 'webforum',     # Name of the database
		dbhost => 'localhost',    # Host to connect to
		dbuser => 'root',         # User, used to connect to
		dbpass => 'godzilla',     # Password
		dbdebug => 0,	            # Are we debugging ?
		lock_timeout => 60,       # Default lock timeout
		connection_timeout => 30, # Wait for connection for this time (if elapsed - we're dead)

		##### HandyLog.pm
		logfname => $basedir.'tmp/logs/log',      # File name of the log
		maxlogsize => 10000000,                   # Maximum log file before rotation
		maxrotatedepth => 7,                      # Maximum log rotation depth
	);
}

sub load_config
{
	if ($cfg{'extconfig'}) {
		local (*CONFIG);
		local $/ = "\n";
		if (open (CONFIG,'<'.$cfg{'extconfig'})) {
			while (<CONFIG>) {
				chomp;
				if (/^([^=]+)=(.*)$/oi) {
					$cfg{$1} = eval($2);
				}
			}
		}
	}
}

1;

