/* 
##################################################################
##								##
##			This module is 				##
##           (C) 1999,2000 Perl4YOU software group. 		##
##								##
##	  You are free to redistribute the source code,		##
##	 use it in commercial projects and so on, leaving 	##
##		    this copyright untouched.			##
##								##
##                   Visit our website at 			##
##                 http://www.perl4you.com			##
##								##
##################################################################
*/

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#include "mysql.h"

#define MAX_CONNECTIONS 32

static int active_connections = 0;
static MYSQL mysqls[MAX_CONNECTIONS];
static int busy[MAX_CONNECTIONS];

static int connect_s(int handle, char *host, char *username, char *password)
{
	if (handle < 0 || handle >= MAX_CONNECTIONS) return -1;
	if (busy[handle] != 1) return -1;
	if (mysql_connect(&mysqls[handle], host, username, password)) {
		busy[handle] = 2;
		return 0;
	}
	return -1;
}

static int init_s()
{
	int i;
	
	if (active_connections == MAX_CONNECTIONS) return -1;
	for (i = 0; i < MAX_CONNECTIONS && busy[i]; i++);
	if (!mysql_init(&mysqls[i])) return -1;
	busy[i] = 1;
	active_connections++;

	return i;
}

static int close_s(int handle)
{
	if (handle < 0 || handle >= MAX_CONNECTIONS) return -1;
	if (busy[handle] == 2) {
		mysql_close(&mysqls[handle]);
	}
	active_connections --;
	busy[handle] = 0;
}

static int select_db_s(int handle, char *db)
{
	if (handle < 0 || handle >= MAX_CONNECTIONS) return -1;
	if (busy[handle] != 2) return -1;
	return mysql_select_db(&mysqls[handle], db);
}

static SV *query_s(int handle, char *query)
{
	int result, i, j;
	MYSQL_RES *table;
	SV *refA, *refB, *field;
	AV *A, *B;
	MYSQL_ROWS *row;

	if (handle < 0 || handle >= MAX_CONNECTIONS) return sv_newmortal();
	if (busy[handle] != 2) return sv_newmortal();

	result = mysql_query(&mysqls[handle], query);
	if (result < 0) return sv_newmortal();
	table = mysql_store_result(&mysqls[handle]);
	if (!table || !table->data) return sv_2mortal(newRV_inc((SV*)newAV()));

	A = newAV();
	for (i = 0, row = table->data->data; row && i < table->data->rows; i++, row = row->next) {
		B = newAV();
		for (j = 0; j < table->data->fields; j++) {
			field = newSVpv(row->data[j]?row->data[j]:"",0);
			av_push(B,field);
		}
		refB = newRV_noinc((SV*)B);
		av_push(A, refB);
	}
	refA = sv_2mortal(newRV_noinc((SV*)A));

	mysql_free_result(table);
	
	return refA;
}

static unsigned int affected_rows_s(int handle)
{
	if (handle < 0 || handle >= MAX_CONNECTIONS) return 0;
	if (busy[handle] != 2) return 0;
	return mysqls[handle].affected_rows;
}

MODULE = mysqlclient		PACKAGE = mysqlclient

SV *
mc_query(handle,query)
	int handle;
	char *query;
	CODE:
	ST(0) = query_s(handle, query);

int
mc_max()
	CODE:
	RETVAL = MAX_CONNECTIONS;
	OUTPUT:
	RETVAL

int
mc_active()
	CODE:
	RETVAL = active_connections;
	OUTPUT:
	RETVAL

int
mc_get()
	CODE:
	RETVAL = init_s();
	OUTPUT:
	RETVAL

int
mc_close(handle)
	int handle;
	CODE:
	RETVAL = close_s(handle);
	OUTPUT:
	RETVAL

int
mc_connect(handle,host,username,password)
	int handle;
	char *host;
	char *username;
	char *password;
	CODE:
	RETVAL = connect_s(handle,host,username,password);
	OUTPUT:
	RETVAL

int
mc_select_db(handle,database)
	int handle;
	char *database;
	CODE:
	RETVAL = select_db_s(handle, database);
	OUTPUT:
	RETVAL

unsigned int
mc_affected_rows(handle)
	int handle;
	CODE:
	RETVAL = affected_rows_s(handle);
	OUTPUT:
	RETVAL
