#!/usr/bin/perl

use KAMXbase;
use DBI;
use strict;

$main::VERSION = "1.2";


################
#Process       #
################
&testargs(3, @ARGV);

&process($ARGV[0], $ARGV[1], $ARGV[2], $ARGV[3], $ARGV[4], $ARGV[5]);

exit;


################
#Help          #
################
sub help {
	print <<HELP;
Check Import $main::VERSION
	kmcgrail\@peregrinehw.com
	http://www.peregrinehw.com/downloads/perl

Possible Arguments for Check Import:

        Argument 1: DBF File to Check
        Argument 2: Database to Check
        Argument 3: Table to Check
        Argument 4: (Optional) User to connect to Database
        Argument 5: (Optional) Password to connect to Database
        Argument 6: (Optional) Host to connect to

HELP
	
}


sub testargs {
  my($min_params, @PARAMS) = @_;
  my ($i);
  for ($i =0; $i <= $#PARAMS; $i++) {
    print "Parameter ",($i+1),": $PARAMS[$i]\n";
  }
  if ($i < $min_params) {
    print "ERROR: Not Enough Arguments!\n\n";
    &help;
    exit;
  } else {
    print "\n";
  }
}

sub process {
  my ($file_to_process, $databaseto, $tableto, $user, $password, $hostto) = @_;

  my ($dbfdatabase, $end, $sth, $dbh, $rv, $driver, $options, $dsn, $numrecords, $query);

  $dbfdatabase = new KAMXbase;
  $dbfdatabase->open_dbf("$file_to_process") || die "Can't open $file_to_process!\n";
  $end=$dbfdatabase->lastrec;
  $dbfdatabase->close_dbf;

  # Use new DBI method to open the database
  # $dbh Database handle
  # $sth Statement handle
  # $rc Return code (often a status)
  # $rv Return value (often a row count)

  $driver = "mysql";
  $options = "";
  if ($hostto eq "") {
    $hostto = "localhost";
  }

  $dsn = "DBI:$driver:database=$databaseto;host=$hostto;$options";

  $dbh = DBI->connect($dsn, $user, $password);
  if (!$dbh) {
    print ("Could not connect to database $databaseto!\nERROR!: ". $dbh->errstr."\n");
    exit;
  }

  $query = "select count(*) from $tableto";

  $sth = $dbh->prepare($query);
  $rv = $sth->execute();

  $numrecords = $sth->fetchrow;

  $sth->finish;
  $dbh->disconnect;

  if (length($file_to_process) > 25) {
    $file_to_process = "...".substr($file_to_process, -25);
  }

  print "DATABASE:\t$file_to_process -- Records: $end \t\t$tableto -- Records: $numrecords";

  if ($end == $numrecords) {
    print "\t[OK]\n";
  } else {
    print "\t[ERROR]\n";
  }
}
