#!/usr/bin/perl 


# VERSION 0.50
# Fixed Xbase stat and open dbf routine.  Has proper field names and stats concur.  8/9/98 KAM
# Began Create routine. 8/9/98 KAM
# Finished Create routine. 8/11/98 KAM
# Wrote num_fields routine. 8/11/98 KAM

# VERSION 0.51
# Fixed a bug in Xbase.pm where it would return the num of fields as 15.67 fields  5/7/99

# VERSION 1.1
# Converted for DBI Usage -- 6/7/99 KAM
# Complete overhaul for strict, local variables and general upgrades in code
# Added timing function to main import loop for further testing with Database Options, Code Changes, Etc.
# Renamed Pratap's module to KAMXbase and have begun the modifications to replace this module
# Renumber Version to be consistent with KAMXbase.pm
#
# 7-8-99 KAM
# Continued on 1.1 Release.
# Due to some problems with memory leaks, we are trying some different DBI commands (prepare instead of do).
# The problem seems to be with the line doing the quote.
# Rewrote the DBI support to use the (?,?,?) so that quote would not be necessary.
#
# 7-16-99
# Continued on 1.1 Release
# No idea yet on the quote memory leak.
# Fixed addindex feature
# Added Host Connection feature
#
# 5-24-01
# Finalized Release as 1.2

use KAMXbase;
use DBI;
use strict;

my $VERSION = "1.1BETA3";

# SET TO 1 FOR MORE VERBOSE OUTPUT
$importdbf::debug = 0;

################
#Check Args    #
################
if ($#ARGV < 1) {
	print "ERROR: Not Enough Arguments!\n\n";
	&help($VERSION);
	exit;
}

################
#Help          #
################
sub help {
	my($VERSION) = @_;	

	print <<HELP;
Import DBF to SQL v$VERSION
	kmcgrail\@peregrinehw.com
	http://www.peregrinehw.com/downloads/perl

Possible Arguments for Import DBF:

	Argument 1: DBF File to Convert
	Argument 2: Database to Add To
	Argument 3: Table to Add To
	Argument 4: (Optional) 'create' creates database table -- WARNING! If the table already exists, then program exits!
	Argument 5: (Optional) 'addindex' adds index column of bigint unsigned autoincrement primary key
	Argument 6: (Optional) User to connect to Database
	Argument 7: (Optional) Password to connect to Database
	Argument 8: (Optional) Host to connect to

        NOTE: Just use anything other than 'create' or 'addindex' to ignore those arguments!

HELP
	
}
################
#Process       #
################
&test(@ARGV);

&process($ARGV[0], $ARGV[1], $ARGV[2], $ARGV[3], $ARGV[4], $ARGV[5], $ARGV[6], $ARGV[7]);  


sub test {
	my(@PARAMS) = @_;
	my $i = 0;
	while ($i <= $#PARAMS) {
		print "Parameter $i: $PARAMS[$i]\n";
		$i++;
	}
}

sub process {
	my($file_to_process, $databaseto, $tableto, $create, $addindex, $user, $password, $hostto) = @_;

	if ($importdbf::debug > 0) {
		print "Taking input from: $file_to_process\nAdding to Database: $databaseto\nAdding to Table: $tableto\n";
	}

	my $dbfdatabase = new KAMXbase;

	#Checking if input file exists and openable
	print "Input File: $file_to_process... ";
	if ($dbfdatabase->open_dbf("$file_to_process")) { 
		print "Opened!\n\n";
	} else {
		die "ERROR!\n";
	}

	# Use new DBI method to open the database
	# $dbh Database handle
	# $sth Statement handle
	# $rc Return code (often a status)
	# $rv Return value (often a row count)

	my $driver = "mysql";
	my $options = "";
	if ($hostto eq "") {
		$hostto = "localhost";
	}

	my $dsn = "DBI:$driver:database=$databaseto;host=$hostto;$options";

	my $dbh = DBI->connect($dsn, $user, $password);
	if (!$dbh) {
		print ("Could not connect to database $databaseto!\nERROR!: ". $dbh->errstr."\n");
		$dbfdatabase->close_dbf;
		exit;
	}

        print $dbfdatabase->dbf_type."\n";
	print $dbfdatabase->dbf_stat."\n";

	#Let's see if the user wants the table to be created.
	if (lc($create) eq "create") {
		print "Creating Table... ";
		my $query = $dbfdatabase->sql_create($tableto);
		if (lc($addindex) eq "addindex") {
			print "Adding Primary Key Index... ";
			$query =~ s/\(/\(ID bigint unsigned auto_increment primary key,\n/;
		}

               	my $rv = $dbh->do($query);
               	if(!$rv) {
                       	print "ERROR!\n\n";
                       	print "Create Query: $query\nDatabase Error: ".$dbh->errstr."\n";
			$dbfdatabase->close_dbf;
		        $dbh->disconnect;
                       	exit;
		} else {
			print "Created!\n";
		}
	}
	
	my $end=$dbfdatabase->lastrec;

	print "\n\nTotal Records to Import: $end\n\n";

	my $i = 0;

	my $starttime = (times)[0];

        print "# of good fields: ",$dbfdatabase->sql_num_fields('goodfields'),"\n\n";
	my $query = "insert into $tableto values (";
        for (my $num_fields = 0; $num_fields < $dbfdatabase->sql_num_fields("goodfields"); $num_fields++) {
          $query .= "? ,";
        }

	if (lc($addindex) eq "addindex") {
		$query .= "? ,";
	}

        $query .= ")";
        $query =~ s/,\)/\)/;

	my $sth = $dbh->prepare($query);

	while ($i < $end) {
		my $temp = "";
		my @fields = $dbfdatabase->get_record;

		# 7-8-99 Documented major MAJOR memory leak in the quote line
                for(my $k = 0; $k < $#fields; $k++) {
			#USE THIS AREA FOR KNOWN DATABASE ERRORS.  
                        #A FIELD THAT SAYS BoB and SHOULD BE BOB for example KAM 8-14-98
                        #ADD ARGUMENT HERE FOR THIS     
                        #if ($fields[$k] eq "Crane, Ichabod\\") {
                        #       $fields[$k] = "Crane, Ichabod";  
                        #} elsif ($fields[$k] eq "Skunkette unc\\") {
                        #       $fields[$k] .= "Skunkette unc";
                        #}

   			#$fields[$k] = $dbh->quote($fields[$k]);  #MEMORY LEAK!!
			
			if ($importdbf::debug > 0) {
                               print "Row $i - Field $k - Value:$fields[$k]\n";
                        }
                }

		if (lc($addindex) eq "addindex") {
			unshift @fields,"0";
		}

                my $rv = $sth->execute(@fields); 

		if (!$rv) {
  			print "ERROR!\n\n";
			print "Insert Query: $query\nDatabase Error: ".$dbh->errstr."\n";
			$dbfdatabase->close_dbf;
                        $dbh->disconnect;
			exit;
		}

		$dbfdatabase->go_next;
		$i++;

		print "Processing Record# $i -- ".($end - $i)." Records Left!\n" if $i =~ /00$/; 

	}

        my $endtime = (times)[0];

	print "\n\n$end Records imported in ";
	printf "%.2f CPU seconds\n\n",$endtime - $starttime;


	$dbfdatabase->close_dbf;
	my $rc = $sth->finish;
	$rc = $dbh->disconnect;

	print "\nNew and Old Databases Closed!\n";
}
