--
-- ADA 95 Definitions for libmySQL.DLL  Version 3.23.27
--
-- Tested with ObjectAda 7.2 on Windows 95
--
-- Written December 2000 by Francois FABIEN
-- For more info send Email to fr.fabien@infonie.fr
--
-- Notice : Software is supplied "as is" with no warranty
--
-- Important : OA linker must be changed to Microsoft Version 6.0
--             Using previous version of linker causes Access Violation
--             at Run Time
--             
-- Settings of OA : Create a Project              
--                  Use Project/Settings/Search to add
--                  ..\objectada\apilib
--                  ..\objectada\win32ada\binding\lib
--                  Use Project/Add Files to add libmysql.lib
--             
--
--Status : The package compiles correctly, binds and links OK with
--         test procedure. 
--         The package does not work with libmysqlclient.lib

with Interfaces.C, System;
with Interfaces.C.Strings;
use Interfaces.C;
use Interfaces.C.Strings;

package Mysql_Ada is


   use   type Interfaces.C.Char_Array; 
   use   type Interfaces.C.Strings.Chars_Ptr; 

   Mysql_Errmsg_Size    : constant            := 200;  
   Mysql_Port           : constant            := 3306;  
   Local_Host           : constant Char_Array := "localhost" & Nul;
      
   Name_Len             : constant            := 64;  
   Protocol_Version     : constant            := 10;  
   Mysql_Server_Version : constant Char_Array := "3.23.27" & Nul;
      
   Frm_Ver              : constant            := 6;  
   Mysql_Version_Id     : constant            := 32327;  
   -- Refresh Options
   Refresh_Grant : constant := 1;  
   -- Refresh grant tables  
   Refresh_Log : constant := 2;  
   -- Start on new log file  
   Refresh_Tables : constant := 4;  
   -- close all tables  
   Refresh_Hosts : constant := 8;  
   -- Flush host cache  
   Refresh_Status : constant := 16;  
   -- Flush status variables  
   Refresh_Fast : constant := 32768;  
   -- Field/table name length 
   Hostname_Length      : constant            := 60;  
   Username_Length      : constant            := 16;  
   Local_Host_Namedpipe : constant Char_Array := "." & Nul;  
   -- Alloced by ISI for MySQL  
   Mysql_Namedpipe   : constant Char_Array := "MySQL" & Nul;  
   Mysql_Servicename : constant Char_Array := "MySql" & Nul;  


   type Enum_Server_Command is 
         (Com_Sleep,         
          Com_Quit,          
          Com_Init_Db,       
          Com_Query,         
          Com_Field_List,    
          Com_Create_Db,     
          Com_Drop_Db,       
          Com_Refresh,       
          Com_Shutdown,      
          Com_Statistics,    
          Com_Process_Info,  
          Com_Connect,       
          Com_Process_Kill,  
          Com_Debug,         
          Com_Ping,          
          Com_Time,          
          Com_Delayed_Insert); 

   Not_Null_Flag : constant := 1;  
   -- Field can't be NULL  
   Pri_Key_Flag : constant := 2;  
   -- Field is part of a primary key  
   Unique_Key_Flag : constant := 4;  
   -- Field is part of a unique key  
   Multiple_Key_Flag : constant := 8;  
   -- Field is part of a key  
   Blob_Flag : constant := 16;  
   -- Field is a blob  
   Unsigned_Flag : constant := 32;  
   -- Field is unsigned  
   Zerofill_Flag : constant := 64;  
   -- Field is zerofill  
   Binary_Flag : constant := 128;  
   -- The following are only sent to new clients  
   Enum_Flag : constant := 256;  
   -- field is an enum  
   Auto_Increment_Flag : constant := 512;  
   -- field is a autoincrement field  
   Timestamp_Flag : constant := 1024;  
   -- Field is a timestamp  
   Set_Flag : constant := 2048;  
   -- field is a set  
   Part_Key_Flag : constant := 16384;  
   -- Intern; Part of some key  
   Group_Flag : constant := 32768;  
   -- Intern: Group field  
   Unique_Flag : constant := 65536;  
   -- Intern: Used by sql_yacc  
   -- Intern flag  
   Client_Long_Password : constant := 1;  
   -- new more secure passwords  
   Client_Found_Rows : constant := 2;  
   -- Found instead of affected rows  
   Client_Long_Flag : constant := 4;  
   -- Get all column flags  
   Client_Connect_With_Db : constant := 8;  
   -- One can specify db on connect  
   Client_No_Schema : constant := 16;  
   -- Don't allow database.table.column  
   Client_Compress : constant := 32;  
   -- Can use compression protcol  
   Client_Odbc : constant := 64;  
   -- Odbc client  
   Client_Local_Files : constant := 128;  
   -- Can use LOAD DATA LOCAL  
   Client_Ignore_Space : constant := 256;  
   -- Ignore spaces before '('  
   Client_Interactive : constant := 1024;  
   -- This is an interactive client  
   Net_Read_Timeout : constant := 30;  
   -- Timeout on read     
   Net_Write_Timeout : constant := 60;  
   -- Timeout on write  
   Net_Wait_Timeout : constant := 8 * 60 * 60;  
   -- Wait for new query 
   type Enum_Field_Types is 
         (Field_Type_Decimal,     
          Field_Type_Tiny,        
          Field_Type_Short,       
          Field_Type_Long,        
          Field_Type_Float,       
          Field_Type_Double,      
          Field_Type_Null,        
          Field_Type_Timestamp,   
          Field_Type_Longlong,    
          Field_Type_Int24,       
          Field_Type_Date,        
          Field_Type_Time,        
          Field_Type_Datetime,    
          Field_Type_Year,        
          Field_Type_Newdate,     
          Field_Type_Enum,        
          Field_Type_Set,         
          Field_Type_Tiny_Blob,   
          Field_Type_Medium_Blob, 
          Field_Type_Long_Blob,   
          Field_Type_Blob,        
          Field_Type_Var_String,  
          Field_Type_String); 

   for Enum_Field_Types'Size use 4*8;
   for Enum_Field_Types use
      (
     Field_Type_Decimal     => 0,   
     Field_Type_Tiny        => 1,   
     Field_Type_Short       => 2,   
     Field_Type_Long        => 3,   
     Field_Type_Float       => 4,   
     Field_Type_Double      => 5,   
     Field_Type_Null        => 6,   
     Field_Type_Timestamp   => 7,   
     Field_Type_Longlong    => 8,   
     Field_Type_Int24       => 9,   
     Field_Type_Date        => 10,  
     Field_Type_Time        => 11,  
     Field_Type_Datetime    => 12,  
     Field_Type_Year        => 13,  
     Field_Type_Newdate     => 14,  
     Field_Type_Enum        => 247, 
     Field_Type_Set         => 248, 
     Field_Type_Tiny_Blob   => 249, 
     Field_Type_Medium_Blob => 250, 
     Field_Type_Long_Blob   => 251, 
     Field_Type_Blob        => 252, 
     Field_Type_Var_String  => 253, 
     Field_Type_String      => 254);

   -- For compability 
   Field_Type_Char     : constant Enum_Field_Types := Field_Type_Tiny;
      
   Field_Type_Interval : constant Enum_Field_Types := Field_Type_Enum;
      


   type My_Bool is new Char; 
   type Unsigned_Chars_Ptr is access all Unsigned_Char; 

   type My_Socket is new Int; 

   type Mysql_Status is 
         (Mysql_Status_Ready,      
          Mysql_Status_Get_Result, 
          Mysql_Status_Use_Result); 

   for Mysql_Status'Size use 4*8;

   for Mysql_Status use
      (
     Mysql_Status_Ready      => 0, 
     Mysql_Status_Get_Result => 1, 
     Mysql_Status_Use_Result => 2);


   type Mysql_Option is 
         (Mysql_Opt_Connect_Timeout, 
          Mysql_Opt_Compress,        
          Mysql_Opt_Named_Pipe,      
          Mysql_Init_Command,        
          Mysql_Read_Default_File,   
          Mysql_Read_Default_Group,  
          Mysql_Set_Charset_Dir,     
          Mysql_Set_Charset_Name); 

   for Mysql_Option'Size use 4*8;

   type Used_Mem; 
   type Pused_Mem is access all Used_Mem; 
   --   for Pused_Mem'size use System.Address'Size;

   type Used_Mem is 
      record 
         Next : Pused_Mem;  
         Left : Unsigned;  
         Size : Unsigned;  
      end record; 
   pragma Convention(C, Used_Mem);                        -- mysql.h:39


   type Mem_Root is 
      record 
         Free          : Pused_Mem;  
         Used          : Pused_Mem;  
         Pre_Malloc    : Pused_Mem;  
         Min_Malloc    : Unsigned;  
         Block_Size    : Unsigned;  
         Error_Handler : System.Address;  
      end record; 
   pragma Convention(C, Mem_Root);                        -- mysql.h:39

   type Pmem_Root is access all Mem_Root; 


   type Enum_Net_Type is 
         (Net_Type_Tcpip,    
          Net_Type_Socket,   
          Net_Type_Namedpipe); 
   for Enum_Net_Type'Size use 4*8;
   -- 
   type Last_Error_Type is array (1 .. Mysql_Errmsg_Size) of Char; 

   type Net is 
      record 
         Nettype : Enum_Net_Type;  
         --#Ifdef Win32
         Hpipe : Unsigned_Chars_Ptr;  
         --Handle;                                  
         --#Endif
         Fd            : My_Socket;  
         Fcntl         : Int;  
         Buff          : Unsigned_Chars_Ptr;  
         Buff_End      : Unsigned_Chars_Ptr;  
         Write_Pos     : Unsigned_Chars_Ptr;  
         Read_Pos      : Unsigned_Chars_Ptr;  
         Last_Error    : Last_Error_Type;  
         Last_Errno    : Unsigned;  
         Max_Packet    : Unsigned;  
         Timeout       : Unsigned;  
         Pkt_Nr        : Unsigned;  
         Error         : My_Bool;  
         Return_Errno  : My_Bool;  
         Compress      : My_Bool;  
         Remain_In_Buf : Unsigned_Long;  
         Length        : Unsigned_Long;  
         Buf_Length    : Unsigned_Long;  
         Where_B       : Unsigned_Long;  
         More          : My_Bool;  
         Save_Char     : Char;  
      end record; -- Net
   for Net'Size use 272*8;

   -- Constants when using compression 
   Net_Header_Size : constant := 4;  
   -- standard header size 
   Comp_Header_Size : constant := 3;  
   -- compression header extra size

   type Mysql_Field is 
      record 
         Name          : Chars_Ptr;  
         Table         : Chars_Ptr;  
         Def           : Chars_Ptr;  
         My_Field_Type : Enum_Field_Types;  
         Length        : Unsigned;  
         Max_Length    : Unsigned;  
         Flags         : Unsigned;  
         Decimals      : Unsigned;  
      end record; 
   pragma Convention(C, Mysql_Field);                        -- mysql.h:39

   type Ptr_Mysql_Field is access all Mysql_Field; 

   -- typedef char **MYSQL_ROW;
   -- MYSQL_ROW is a Pointer to pointer to char
   -- translation to Ada could be improved
   -- Here we decide to translate to a static array

   type Row_Array; 
   type Mysql_Row is access all Row_Array; 
   type Row_Array is array (1 .. 2000) of Chars_Ptr; 

   type Mysql_Field_Offset is new Unsigned; 


   --   type My_Ulonglong is  => ObjectAda does not support 64 bit integer
   --   for My_Ulonglong'Size use 8*8;

   type Mysql_Rows; 
   type Mysql_Row_Offset is access all Mysql_Rows; 

   type Mysql_Rows is 
      record 
         Next : Mysql_Row_Offset;  
         Data : Mysql_Row;  
      end record; 
   pragma Convention(C, Mysql_Rows);

   type Mysql_Data is 
      record 
         Rows   : Unsigned;  
         Dummy  : Unsigned;  
         Fields : Unsigned;  
         Data   : Mysql_Row_Offset;  
         --MYSQL_ROWS *data;          
         Alloc : Mem_Root;  
      end record; 
   pragma Convention(C, Mysql_Data);

   type Ptr_Mysql_Data is access all Mysql_Data; 


   type Mysql_Option_S is 
      record 
         Connect_Timeout : Unsigned;  
         Client_Flag     : Unsigned;  
         Compress        : My_Bool;  
         Named_Pipe      : My_Bool;  
         Port            : Unsigned;  
         Host            : Chars_Ptr;  
         Init_Command    : Chars_Ptr;  
         User            : Chars_Ptr;  
         Password        : Chars_Ptr;  
         Unix_Socket     : Chars_Ptr;  
         Db              : Chars_Ptr;  
         My_Cnf_File     : Chars_Ptr;  
         My_Cnf_Group    : Chars_Ptr;  
         Charset_Dir     : Chars_Ptr;  
         Charset_Name    : Chars_Ptr;  
         Use_Ssl         : My_Bool;  
         Ssl_Key         : Chars_Ptr;  
         Ssl_Cert        : Chars_Ptr;  
         Ssl_Ca          : Chars_Ptr;  
         Ssl_Capath      : Chars_Ptr;  
      end record; 
   pragma Convention(C, Mysql_Option_S);

   type Mysql is 
      record 
         My_Net : Net;  
         -- Communication parameters */ 
         Connector_Fd        : Chars_Ptr;  
         Host                : Chars_Ptr;  
         User                : Chars_Ptr;  
         Passwd              : Chars_Ptr;  
         Unix_Socket         : Chars_Ptr;  
         Server_Version      : Chars_Ptr;  
         Host_Info           : Chars_Ptr;  
         Info                : Chars_Ptr;  
         Db                  : Chars_Ptr;  
         Port                : Unsigned;  
         Client_Flag         : Unsigned;  
         Server_Capabilities : Unsigned;  
         Protocol_Version    : Unsigned;  
         Field_Count         : Unsigned;  
         Server_Status       : Unsigned;  
         Thread_Id           : Unsigned_Long;  
         -- Id for connection in server */ 
         Affected_Rows : Unsigned;  
         Dummy_1       : Unsigned;  
         Insert_Id     : Unsigned;  
         Dummy_2       : Unsigned;  
         -- id if insert on table with NEXTNR */ 
         Extra_Info : Unsigned;  
         Dummy_3    : Unsigned;  
         -- Used by mysqlshow */ 
         Packet_Length : Unsigned_Long;  
         Status        : Mysql_Status;  
         Fields        : Ptr_Mysql_Field;  
         -- Mysql_Field * Fields;   
         Field_Alloc : Mem_Root;  
         Free_Me     : My_Bool;  
         --	If free in mysql_close */ 
         Reconnect : My_Bool;  
         --	 set to 1 if automatic reconnect */ 
         Options         : Mysql_Option_S;  
         Scramble_Buff   : String (1 .. 9);  
         Charset         : System.Address;  
         Server_Language : Unsigned;  
      end record; 

   pragma Convention(C, Mysql);

   type Ptr_Mysql is access all Mysql; 

   type Ptr_Lengths is access all Unsigned_Long; 

   type Mysql_Res is 
      record 
         Row_Count     : Unsigned;  
         Dummy         : Unsigned;  
         Field_Count   : Unsigned;  
         Current_Field : Unsigned;  
         Fields        : Ptr_Mysql_Field;  
         --MYSQL_FIELD	*fields;
         Data : Ptr_Mysql_Data;  
         --MYSQL_DATA	*data;
         Data_Cursor : Mysql_Row_Offset;  
         --MYSQL_ROWS	*data_cursor; 
         Field_Alloc : Mem_Root;  
         Row         : Mysql_Row;  
         -- If unbuffered read 
         Current_Row : Mysql_Row;  
         -- buffer to current row 
         Lengths : Ptr_Lengths;  
         --unsigned long	*lengths;
         -- column lengths of current row
         Handle : Ptr_Mysql;  
         -- for unbuffered reads    
         Eof : My_Bool;  
         -- Used my mysql_fetch_row
      end record; 
   pragma Convention(C, Mysql_Res);

   type Ptr_Mysql_Res is access all Mysql_Res; 

   --void STDCALL mysql_close(MYSQL *sock);
   procedure Mysql_Close (
         Sock : Ptr_Mysql ); 

   --MYSQL* STDCALL mysql_connect(MYSQL *mysql, const char *host,
   --				      const char *user, const char *passwd);
   function Mysql_Connect (
         Access_Mysql : Ptr_Mysql; 
         Host         : Chars_Ptr; 
         User         : Chars_Ptr; 
         Passwd       : Chars_Ptr  ) 
     return Ptr_Mysql; 

   --int	 STDCALL mysql_create_db(MYSQL *mysql, const char *DB);
   function Mysql_Create_Db (
         Access_Mysql : Ptr_Mysql; 
         Db           : Chars_Ptr  ) 
     return Int; 

   --void STDCALL mysql_data_seek(MYSQL_RES *result,unsigned int offset);
   procedure Mysql_Data_Seek (
         Result : Ptr_Mysql_Res; 
         Offset : Unsigned       ); 

   --void STDCALL mysql_debug(const char *debug);
   procedure Mysql_Debug (
         Debug : Chars_Ptr ); 

   --int  STDCALL mysql_drop_db(MYSQL *mysql, const char *DB);
   function Mysql_Drop_Db (
         Access_Mysql : Ptr_Mysql; 
         Db           : Chars_Ptr  ) 
     return Int; 

   --int  STDCALL mysql_dump_debug_info(MYSQL *mysql);
   function Mysql_Dump_Debug_Info (
         Access_Mysql : Ptr_Mysql ) 
     return Int; 

   --unsigned int STDCALL mysql_escape_string(char *to,const char *from,
   --                        		    unsigned int from_length);
   function Mysql_Escape_String (
         To          : Chars_Ptr; 
         From        : Chars_Ptr; 
         From_Length : Unsigned   ) 
     return Unsigned; 

   --MYSQL_FIELD* STDCALL mysql_fetch_field(MYSQL_RES *result);
   function Mysql_Fetch_Field (
         Result : Ptr_Mysql_Res ) 
     return Ptr_Mysql_Field; 

   --MYSQL_FIELD *STDCALL mysql_fetch_field_direct(MYSQL_RES *res,
   --					      unsigned int fieldnr);
   function Mysql_Fetch_Field_Direct (
         Result    : Ptr_Mysql_Res; 
         Field_Nbr : Unsigned       ) 
     return Ptr_Mysql_Field; 


   --unsigned long*	STDCALL mysql_fetch_lengths(MYSQL_RES *result);
   function Mysql_Fetch_Lengths (
         Result : Ptr_Mysql_Res ) 
     return Ptr_Lengths; 

   --MYSQL_ROW	      STDCALL mysql_fetch_row(MYSQL_RES *result);
   function Mysql_Fetch_Row (
         Result : Ptr_Mysql_Res ) 
     return Mysql_Row; 

   --unsigned int STDCALL mysql_field_count(MYSQL *mysql);
   function Mysql_Field_Count (
         Access_Mysql : Ptr_Mysql ) 
     return Unsigned; 

   --MYSQL_FIELD_OFFSET STDCALL mysql_field_seek(MYSQL_RES *result,
   --					   MYSQL_FIELD_OFFSET offset);
   function Mysql_Field_Seek (
         Result : Ptr_Mysql_Res;     
         Offset : Mysql_Field_Offset ) 
     return Mysql_Field_Offset; 

   --void  STDCALL mysql_free_result(MYSQL_RES *result);
   procedure Mysql_Free_Result (
         Result : Ptr_Mysql_Res ); 

   --char* STDCALL mysql_get_client_info(void);
   function Mysql_Get_Client_Info return Chars_Ptr; 

   --char* STDCALL mysql_get_host_info(MYSQL *mysql);
   function Mysql_Get_Host_Info (
         Access_Mysql : Ptr_Mysql ) 
     return Chars_Ptr; 

   --unsigned int	STDCALL mysql_get_proto_info(MYSQL *mysql);
   function Mysql_Get_Proto_Info (
         Access_Mysql : Ptr_Mysql ) 
     return Unsigned; 

   --char* STDCALL mysql_get_server_info(MYSQL *mysql);
   function Mysql_Get_Server_Info (
         Access_Mysql : Ptr_Mysql ) 
     return Chars_Ptr; 

   --MYSQL* STDCALL mysql_init(MYSQL *mysql);
   function Mysql_Init (
         Access_Mysql : Ptr_Mysql ) 
     return Ptr_Mysql; 


   --int   STDCALL mysql_kill(MYSQL *mysql,unsigned long pid);
   function Mysql_Kill (
         Access_Mysql : Ptr_Mysql;    
         Pid          : Unsigned_Long ) 
     return Int; 

   --MYSQL_RES* STDCALL mysql_list_dbs(MYSQL *mysql,const char *wild);
   function Mysql_List_Dbs (
         Access_Mysql : Ptr_Mysql; 
         Wild         : Chars_Ptr  ) 
     return Ptr_Mysql_Res; 

   --MYSQL_RES* STDCALL mysql_list_fields(MYSQL *mysql, const char *table,
   --					 const char *wild);
   function Mysql_List_Fields (
         Access_Mysql : Ptr_Mysql; 
         Table        : Chars_Ptr; 
         Wild         : Chars_Ptr  ) 
     return Ptr_Mysql_Res; 

   --MYSQL_RES* STDCALL mysql_list_processes(MYSQL *mysql);
   function Mysql_List_Processes (
         Access_Mysql : Ptr_Mysql ) 
     return Ptr_Mysql_Res; 

   --MYSQL_RES* STDCALL mysql_list_tables(MYSQL *mysql,const char *wild);
   function Mysql_List_Tables (
         Access_Mysql : Ptr_Mysql; 
         Wild         : Chars_Ptr  ) 
     return Ptr_Mysql_Res; 

   --unsigned int STDCALL mysql_num_fields(MYSQL_RES *res);

   function Mysql_num_fields (
         Result : Ptr_Mysql_Res ) 
     return Unsigned; 

   --int STDCALL mysql_options(MYSQL *mysql,enum mysql_option option,
   --				      const char *arg);
   function Mysql_Options (
         Access_Mysql : Ptr_Mysql;    
         Option       : Mysql_Option; 
         Arg          : Chars_Ptr     ) 
     return Int; 

   --int STDCALL mysql_ping(MYSQL *mysql);
   function Mysql_Ping (
         Access_Mysql : Ptr_Mysql ) 
     return Int; 

   --int STDCALL mysql_query(MYSQL *mysql, const char *q);
   function Mysql_Query (
         Access_Mysql : Ptr_Mysql; 
         Q            : Chars_Ptr  ) 
     return Int; 

   --MYSQL* STDCALL mysql_real_connect(MYSQL *mysql, const char *host,
   --	                  	   const char *user,
   --					   const char *passwd,
   --					   const char *db,
   --					   unsigned int port,
   --					   const char *unix_socket,
   --					   unsigned int clientflag);
   function Mysql_Real_Connect (
         Access_Mysql : Ptr_Mysql; 
         Host         : Chars_Ptr; 
         User         : Chars_Ptr; 
         Passwd       : Chars_Ptr; 
         Db           : Chars_Ptr; 
         Port         : Unsigned;  
         Unix_Socket  : Chars_Ptr; 
         Clientflag   : Unsigned   ) 
     return Ptr_Mysql; 

   --int		STDCALL mysql_real_query(MYSQL *mysql, const char *q,
   --					unsigned int length);
   function Mysql_Real_Query (
         Access_Mysql : Ptr_Mysql; 
         Q            : Chars_Ptr; 
         Length       : Unsigned   ) 
     return Int; 

   --int		STDCALL mysql_refresh(MYSQL *mysql,
   --				     unsigned int refresh_options);
   function Mysql_Refresh (
         Access_Mysql    : Ptr_Mysql; 
         Refresh_Options : Unsigned   ) 
     return Int; 

   --MYSQL_ROW_OFFSET STDCALL mysql_row_seek(MYSQL_RES *result, MYSQL_ROW_OFFSET);
   --   function Mysql_Row_Seek (
   --         Result : Ptr_Mysql_Res;   
   --         Offset : Mysql_Row_Offset ) 
   --     return Mysql_Row_Offset; 


   --int		STDCALL mysql_select_db(MYSQL *mysql, const char *db);
   function Mysql_Select_Db (
         Access_Mysql : Ptr_Mysql; 
         Db           : Chars_Ptr  ) 
     return Int; 

   --int		STDCALL mysql_shutdown(MYSQL *mysql);
   function Mysql_Shutdown (
         Access_Mysql : Ptr_Mysql ) 
     return Int; 

   --char*		STDCALL mysql_stat(MYSQL *mysql);
   function Mysql_Stat (
         Access_Mysql : Ptr_Mysql ) 
     return Chars_Ptr; 

   --MYSQL_RES*	STDCALL mysql_store_result(MYSQL *mysql);
   function Mysql_Store_Result (
         Access_Mysql : Ptr_Mysql ) 
     return Ptr_Mysql_Res; 


   --MYSQL_RES*	STDCALL mysql_use_result(MYSQL *mysql);
   function Mysql_Use_Result (
         Access_Mysql : Ptr_Mysql ) 
     return Ptr_Mysql_Res; 

private

   pragma Import(Stdcall, Mysql_Close, "mysql_close");
   pragma Import(Stdcall, Mysql_Connect, "mysql_connect");
   pragma Import(Stdcall, Mysql_Create_Db, "mysql_create_db");
   pragma Import(Stdcall, Mysql_Data_Seek, "mysql_data_seek");
   pragma Import(Stdcall, Mysql_Debug, "mysql_debug");
   pragma Import(Stdcall, Mysql_Drop_Db, "mysql_drop_db");
   pragma Import(Stdcall, Mysql_Dump_Debug_Info, "mysql_dump_debug_info");
   pragma Import(Stdcall, Mysql_Escape_String, "mysql_escape_string");
   pragma Import(Stdcall, Mysql_Fetch_Field, "mysql_fetch_field");
   pragma Import(Stdcall, Mysql_Fetch_Field_Direct, "mysql_fetch_field_direct");
   pragma Import(Stdcall, Mysql_Fetch_Lengths, "mysql_fetch_lengths");
   pragma Import(Stdcall, Mysql_Fetch_Row, "mysql_fetch_row");
   pragma Import(Stdcall, Mysql_Field_Count, "mysql_field_count");
   pragma Import(Stdcall, Mysql_Field_Seek, "mysql_field_seek");
   pragma Import(Stdcall, Mysql_Free_Result, "mysql_free_result");
   pragma Import(Stdcall, Mysql_Get_Client_Info, "mysql_get_client_info");
   pragma Import(Stdcall, Mysql_Get_Host_Info, "mysql_get_host_info");
   pragma Import(Stdcall, Mysql_Get_Proto_Info, "mysql_get_proto_info");
   pragma Import(Stdcall, Mysql_Get_Server_Info, "mysql_get_server_info");
   pragma Import(Stdcall, Mysql_Init, "mysql_init");
   pragma Import(Stdcall, Mysql_Kill, "mysql_kill");
   pragma Import(Stdcall, Mysql_List_Dbs, "mysql_list_dbs");
   pragma Import(Stdcall, Mysql_List_Fields , "mysql_list_fields");
   pragma Import(Stdcall, Mysql_List_Processes , "mysql_list_processes");
   pragma Import(Stdcall, Mysql_List_Tables, "mysql_list_tables");
   pragma Import(Stdcall, Mysql_num_fields, "mysql_num_fields");
   pragma Import(Stdcall, Mysql_Options, "mysql_options");
   pragma Import(Stdcall, Mysql_Ping, "mysql_ping");
   pragma Import(Stdcall, Mysql_Query, "mysql_query");
   pragma Import(Stdcall, Mysql_Real_Connect ,"mysql_real_connect");
   pragma Import(Stdcall, Mysql_Real_Query, "mysql_real_query");
   pragma Import(Stdcall, Mysql_Refresh, "mysql_refresh");
   pragma Import(Stdcall, Mysql_Select_Db , "mysql_select_db");
   pragma Import(Stdcall, Mysql_Shutdown , "mysql_shutdown");
   pragma Import(Stdcall, Mysql_Stat, "mysql_stat");
   pragma Import(Stdcall, Mysql_Store_Result, "mysql_store_result");
   pragma Import(Stdcall, Mysql_Use_Result , "mysql_use_result");
end;