/*long num_records=0;*/
/*int num_fields=11;*/
#include "dbf.h"
#include "sqlmy.h"
#include <mysql.h>

extern char errores[100];

int Version;
long nRows=0;
int nFields, HeaderLen;
long RecordLen;
int year, month, day;


int write_in_dbf(FILE *tfp, MYSQL_RES *result)
{
  struct db_Struct_File *MyRecords;
  char column_name[10];
  char formato[10];
  int j,i;
  MYSQL_ROW tuple;

  nFields=mysql_num_fields(result);
  MyRecords = (struct db_Struct_File *) malloc( nFields * sizeof(struct db_Struct_File));
  /* Fetch the name of fields  */
  RecordLen=0;
  for(j=0;j<nFields;j++) 
  {
    /* Sorry, but the length of column name in a dbf file it doesn't
       exceed 10 characters, so if it is longer than 10, I will 
       truncate the column name */

    if(strlen(result->fields[j].name)>10) 
      strncpy(MyRecords[j].FieldName,result->fields[j].name,10);
    else
      strcpy(MyRecords[j].FieldName,result->fields[j].name);
    MyRecords[j].FieldName[10]='\0';

   /* get the type of field */
    switch(result->fields[j].type)
    {
      case FIELD_TYPE_TINY:
      case FIELD_TYPE_SHORT:
      case FIELD_TYPE_LONG:
      case FIELD_TYPE_LONGLONG:
      case FIELD_TYPE_INT24:
      case FIELD_TYPE_ENUM:
      case FIELD_TYPE_SET:
      				MyRecords[j].Type=DB_NUMERIC_FLD;
				break;
      case FIELD_TYPE_TIMESTAMP:
      case FIELD_TYPE_TIME:
      case FIELD_TYPE_DATETIME:
      case FIELD_TYPE_TINY_BLOB:
      case FIELD_TYPE_STRING:
      case FIELD_TYPE_YEAR:
      case FIELD_TYPE_VAR_STRING:
      				MyRecords[j].Type=DB_CHAR_FLD;
				break;
      case FIELD_TYPE_DATE:
      				MyRecords[j].Type=DB_DATE_FLD;
				break;
      case FIELD_TYPE_FLOAT:
      case FIELD_TYPE_DECIMAL:
      case FIELD_TYPE_DOUBLE:
      				MyRecords[j].Type=DB_NUMERIC_FLD;
				break;

  /* The next type of field are not supported yet, if you really
     want to use it, please let me know, because I am thinking in
     supporting it */
      case FIELD_TYPE_NULL:
      case FIELD_TYPE_NEWDATE:
      case FIELD_TYPE_MEDIUM_BLOB:
      case FIELD_TYPE_LONG_BLOB:
      case FIELD_TYPE_BLOB:
		pr_error("This type of data is not supported yet");
                return -1;
		break;
    }
    MyRecords[j].FieldLen=result->fields[j].length;
    if(MyRecords[j].Type==DB_NUMERIC_FLD && result->fields[j].length > 16)
      MyRecords[j].FieldLen=16;
    if(MyRecords[j].Type==DB_DATE_FLD)
      MyRecords[j].FieldLen=8;
    MyRecords[j].NoOfDecs=result->fields[j].decimals;
    RecordLen=RecordLen+MyRecords[j].FieldLen;
    
  }
  RecordLen++; /* the place to put the deleted record */

  /* get the tuples from de BD */

  if(CreateStruct( tfp, MyRecords, DB_OVERLAY,nFields,nRows )== DB_ERROR) 
    return DB_ERROR;
  nRows=0;
  while ((tuple=mysql_fetch_row(result)))
  {
    for(j=0;j<nFields;j++) 
    {
      char width[15];
      char formato[25]; formato[0]='\0';
      sprintf(width,"%d",MyRecords[j].FieldLen);
      if(MyRecords[j].Type==DB_CHAR_FLD)
        strcat(formato,"%-"); 
      else
        strcat(formato,"%"); 
      strcat(formato,width); strcat(formato,"s");
      if(MyRecords[j].Type==DB_DATE_FLD){
        int l=0;
        for(i=0;i<strlen(tuple[j]);i++)
          if(isdigit(tuple[j][i]))tuple[j][l++]=tuple[j][i];
        tuple[j][l]='\0';
      }
      fprintf(tfp, formato, tuple[j]);
    }
    fprintf(tfp,"%s"," "); /* the space to mark deleted record */
    nRows++;
  }
  free(MyRecords);
  /* Rewrite the header only to put the correct number of rows
     just obtained */
  if(WriteHeader( tfp, 2 ) != DB_NO_ERROR )
  {
      pr_error("I cannot write the number of rows");
      return DB_ERROR;
  }
  return nRows;
}     
/* -------------- end of write_to_dbf module ----------- */

/*  CreateStruct: This function create the structure of the
    xbase type, the data are: Type, date of creation, etc. etc. */

int CreateStruct( FILE *dbf_file, struct db_Struct_File * sf, 
    const int Overlay, const int nFields, const int nRows )
{

   int    j, k, k2, NameLen, rc;
   int MemoPresent;
   int i = j = HeaderLen = 0;
   long CurRec;
   char *RecBuf, *RecBuf2;
   struct db_Struct_Rec *Struct_Rec_Ptr;
   char EofChar[10];

   strncpy(EofChar,"\x0D\0x1A",10);


   /* i get the length of the record */
   MemoPresent=0;
   /* MEMO is not implemented yet, maybe in the near future */
   for (i=0;i<nFields;i++) 
   {
     if(sf[i].Type== DB_MEMO_FLD) MemoPresent=1;
   }
     

   if(( RecBuf = (char *) malloc( RecordLen )) == NULL ) {
      pr_error(DB_MEMORY_ERROR);
      return DB_ERROR;
   }

   if(( RecBuf2 = (char *) malloc( RecordLen )) == NULL )
   { 
      free( RecBuf );
      pr_error(DB_MEMORY_ERROR);
      return DB_ERROR;
   }

   /* BlankRecord(); */
   memset( RecBuf, 0x20, RecordLen );
   memset( RecBuf2, 0x20, RecordLen );

   /* set class variables */

   if( MemoPresent ) 
      Version = 0x83;
   else
      Version = 0x03;

   CurRec  = 0L;

   HeaderLen = 33 + nFields * 32;

   year = 0x00;
   month = 0x02;
   day = 0x01;



   /* write the header information */
   if(( rc = WriteHeader( dbf_file, 0 )) != DB_NO_ERROR )
   {  
      free( RecBuf );
      free( RecBuf2 );
      pr_error(DB_ERROR_WRITING_HEADER);
      return DB_ERROR;
   }

   for( i = 0; i < 20; i++ )
   {
      if(( fwrite( "\x00", 1, 1, dbf_file )) != 1 )
      {
         free( RecBuf );
         free( RecBuf2 );
         pr_error(DB_ERROR_WRITING_HEADER);
         return DB_ERROR;
      }
   }
   if((Struct_Rec_Ptr = (struct db_Struct_Rec *) malloc( nFields * sizeof(struct db_Struct_Rec))) == NULL ) 
   {
      free( RecBuf ); 
      free( RecBuf2 );
      pr_error(DB_MEMORY_ERROR);
      return DB_ERROR;
   }
   memset( Struct_Rec_Ptr, 0, ( nFields * sizeof(struct db_Struct_Rec)));

   /* write the field information into the header */
   for( i = 0, k = 1; i < nFields; i++ )
   {
      strcpy( Struct_Rec_Ptr[i].FieldName, sf[i].FieldName );
      Struct_Rec_Ptr[i].Type = sf[i].Type;

      if( sf[i].Type == 'M' || sf[i].Type == 'B' || sf[i].Type == 'O' )
      {  /* memo fields are always 10 bytes */
        Struct_Rec_Ptr[i].FieldLen = 10;
        Struct_Rec_Ptr[i].NoOfDecs = 0;
      }
      else
      {
        Struct_Rec_Ptr[i].FieldLen = sf[i].FieldLen;
        Struct_Rec_Ptr[i].NoOfDecs = sf[i].NoOfDecs;
      }

      if( Struct_Rec_Ptr[i].NoOfDecs > Struct_Rec_Ptr[i].FieldLen )
      {
         free( Struct_Rec_Ptr );
         free( RecBuf );
         free( RecBuf2 );
         pr_error("Invalid schema");
         return DB_ERROR;
      }

      k2 = k;
      k += Struct_Rec_Ptr[i].FieldLen;

      if(( fwrite( &Struct_Rec_Ptr[i], 1, 18, dbf_file )) != 18 )
      {
         free( Struct_Rec_Ptr );
         free( RecBuf );
         free( RecBuf2 );
         pr_error(DB_ERROR_WRITING_HEADER);
         return DB_ERROR;
      }

      for( j = 0; j < 14; j++ )
      {
         if(( fwrite( "\x00", 1, 1, dbf_file )) != 1 )
         {
            free( Struct_Rec_Ptr );
            free( RecBuf );
            free( RecBuf2 );
            pr_error(DB_ERROR_WRITING_HEADER);
            return DB_ERROR;
         }
      }
      Struct_Rec_Ptr[i].Address  = RecBuf  + k2;
      Struct_Rec_Ptr[i].Address2 = RecBuf2 + k2;
   }

   /* write the end of header marker */
   if(( fwrite( EofChar, 2, 1, dbf_file )) != 1 )
   {
      free( Struct_Rec_Ptr );
      free( RecBuf );
      free( RecBuf2 );
      pr_error(DB_ERROR_WRITING_HEADER);
      return DB_ERROR;
   }
   if( MemoPresent )
   {
   /*   CreateMemoFile();*/
   }
}



int WriteHeader( FILE *dbf_file,const int PositionOption )
{
   char buf[4];
   if (PositionOption)
     rewind( dbf_file );

   /* write the version number */
   if(fwrite(&Version, 1, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }
   
   if(fwrite(&year, 1, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }

   if(fwrite(&month, 1, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }

   if(fwrite(&day, 1, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }

   memset( buf, 0x00, 4 );
   PutLong( buf, nRows );
   if (fwrite(&buf, 4, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }

   if (PositionOption == 2)
      return DB_NO_ERROR;

   memset( buf, 0x00, 4 );
   PutUShort( buf, HeaderLen );
   if (fwrite(&buf, 2, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }

   memset( buf, 0x00, 4 );
   PutUShort( buf, RecordLen );
   if (fwrite(&buf, 2, 1, dbf_file) != 1)
   {
     pr_error(DB_ERROR_WRITING_HEADER);
     return DB_ERROR;
   }

   return DB_NO_ERROR;
}

void impre(char *string)
{
    FILE *fp;
    fp = fopen(err_log, "a");
    fprintf(fp, ": %s\n", string);
    fclose( fp );
}
void pr_error(char *string)
{
    time( &now );
    fp = fopen(err_log, "a");
    fprintf(fp, "%s ", getenv("USER") );
    fprintf(fp, "%s ", ctime(&now));
    fprintf(fp, "Error: %s\n", string);
    fclose( fp );
}

/* This routine puts a long value to a 4 byte character stream */
void PutLong( char * c, const long l )
{
   char *sp, *tp;
   int i;

   tp = c;
   sp = (char *) &l;
   if( EndianType == 'L' )
      for( i = 0; i < 4; i++ ) *tp++ = *sp++;
   else
   {
      sp+=3;
      for( i = 0; i < 4; i++ ) *tp++ = *sp--;
   }
   return;
}

/* This routine puts a short value to a 2 byte character stream */
void PutUShort( char * c, const short int s )
{
   char *sp, *tp;
   int i;

   tp = c;
   sp = (char *) &s;
   if( EndianType == 'L' )
      for( i = 0; i < 2; i++ ) *tp++ = *sp++;
   else
   {
      sp++;
      for( i = 0; i < 2; i++ ) *tp++ = *sp--;
   }
   return;
}

/* This routine puts a long value to a 4 byte character stream */
void PutULong( char * c, const long l )
{
   char *sp, *tp;
   long i;

   tp = c;
   sp = (char *) &l;
   if( EndianType == 'L' )
      for( i = 0; i < 4; i++ ) *tp++ = *sp++;
   else
   {
      sp+=3;
      for( i = 0; i < 4; i++ ) *tp++ = *sp--;
   }
   return;
}

/* This routine puts a double value to an 8 byte character stream */
void PutDouble( char * c, const double d )
{
   char *sp, *tp;
   int i;

   tp = c;
   sp = (char *) &d;
   if( EndianType == 'L' )
      for( i = 0; i < 8; i++ ) *tp++ = *sp++;
   else
   {
      sp+=7;
      for( i = 0; i < 8; i++ ) *tp++ = *sp--;
   }
   return;
}
