/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Vport.h,v $
    Module Description:	 Machine Porting Definitions File


Description:


Edit History:

	$Log: Vport.h,v $
 * Revision 2.4  1996/04/17  15:20:35  damian
 * add section for bsdi
 *
	Revision 2.3  1996/03/08 00:37:41  damian
	added Vfreebsd for FreeBSD 2.1.0

	Revision 2.2  1996/01/11 13:18:07  damian
	move typedefs into per system ifdefs

 * Revision 2.1  1996/01/04  11:18:02  V
 * Version 2
 * added typedef ulong
 *
 * Revision 1.2  1995/07/26  19:22:50  V
 * UV to V
 *
 * Revision 1.1  1995/01/19  10:29:18  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program)
static char moduleRCSid[] = "@(#) $Id: Vport.h,v 2.4 1996/04/17 15:20:35 damian Exp $";
*/


#ifndef V__Vport
#define V__Vport


/* currently defined porting symbols (please keep this up to date):
   System symbols:
   Vsolaris21			Sun sparc architecture (Solaris 2.1)
   Vsunos40			Sun sparc architecture (SunOS 4.x)
   Valtos				Altos 1000/386 (5.3.1)
   Vbos20				Bull B.O.S. 2.0
   VdguxV4            DG Aviion (DG/UX 5.4R2.01)
   Vhpux              Hewlett-Packard (HP-UX A.09.00 E)
   Vatt40				AT&T UNIX 4.0
   Vsco386			SCO UNIX/386
   Vdrsnx				ICL DRS6000/DRS3000 (DRS/NX) SVR4
   VUmaxV			McDonnell Douglas Series-X (Umax V 3.0.5.8)
   Vrealix88k		    Modcomp (REAL/IX V.3-RELD.0 M88K)
   VsysV88		    Motorola (sysV88 R32V3)
   VmipsV			    Mips RISC (RISC/os UMIPS-V 4_52.2A)
   Vfreebsd 	    	    FreeBSD 2.1.0
   Vlinux   	    	    Linux all versions
   Vbsdi                    Bsdi 2.1

   Capability/quirk symbols:
   Vtermios			System supports termios port control
   Vnomemcpy			System does not have memcpy library call
   Vnomemset			System does not have memset library call
   Vnobzero			..and also does not have bzero library call
   Vnostrchr		System does not have strchr/strrchr library calls
   Vnoindex		..and also does not have index/rindex library calls
   Vnounistd			System does not support unistd.h (POSIX)
   Vsigvoidp			Signal() uses void pointers, not int pointers
   Vnotli              System does not support TLI
   Vnogethostid        System does not have gethostid()
   Vnosysinfo          System does not have sysinfo()
   Vnoselect           System does not have select() (uses poll() instead)
   Vlocklockf	    System locks files with lockf()
   Vlockflock	    System locks files with flock()
   Vlockfcntl	    System locks files with fcntl()
   Vnolocks	    System has no locking facilities
*/


typedef int BOOLEAN;

typedef int BitMask;

typedef char *String;

typedef char **StringList;

typedef int (*PFI) ();


#ifdef Vsolaris21

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
#define Vtermios
#define Vnogethostid
#define Vnoindex
#define Vnorindex
#define Vlocklockf		/* use lockf() for file locking */
#define V_INTERNET		/* we are Internet mail */
#define V_SENDMAIL "/usr/lib/sendmail"	/* default mailer */
#define V_MAILX "mailx"		/* dumb mailer */
#define V_SMFLAGS "-oi -oeq"	/* default mailer flags */
/*

   sendmail options:

      -oeq throw away error messages (only exit status is returned)
           If the send failes, a copy of the message is  appended  to
           the file dead.letter in the sender's home directory.

    -oi    Do not take dots on a line by themselves as  a  message
           terminator.
*/

#define V_RMCOMMAND "/bin/rm -f"
typedef unsigned char Vu_char;
#endif

/* FreeBsd 2.1.0 */
#ifdef Vfreebsd

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#endif

/* Bsdi 2.1 */
#ifdef Vbsdi

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#endif




#ifdef Vsunos40

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vnotli
#define Vsigvoidp
#define Vnosysinfo
#define Vtermios
#define Vlockflock		/* use bsd style flock() file locking */
#define V_INTERNET		/* we are Internet mail */
#define V_SENDMAIL "/usr/lib/sendmail"	/* default mailer */
#define V_MAILX "mailx"		/* dumb mailer */
#define V_SMFLAGS "-oi -oeq"	/* default mailer flags */
/*

   sendmail options:

      -oeq throw away error messages (only exit status is returned)
           If the send failes, a copy of the message is  appended  to
           the file dead.letter in the sender's home directory.

    -oi    Do not take dots on a line by themselves as  a  message
           terminator.
*/

#define V_RMCOMMAND "/bin/rm -f"
typedef unsigned char Vu_char;
#endif

#ifdef Valtos

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
#define Vnounistd
#define Vnoselect
typedef unsigned char Vu_char;
#endif

#ifdef Vatt40

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vtermios
typedef unsigned char Vu_char;
#endif

#ifdef Vlinux

#include <linux/version.h>
#include <linux/types.h>

typedef int int32;

typedef short int16;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vtermios
#define Vnosysinfo
#define Vnotli
typedef unsigned char Vu_char;
#define Vlockfcntl		/* use fcntl() for file locking */
#define V_INTERNET		/* we are Internet mail */
#define V_SENDMAIL "/usr/lib/sendmail"	/* default mailer */
#define V_MAILX "mailx"		/* dumb mailer */
#define V_SMFLAGS "-oi -oeq"	/* default mailer flags */
#endif

#ifdef Vbos20

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
#define Vnounistd
typedef unsigned char Vu_char;
#endif

#ifdef Vhpux

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
#define Vnotli
typedef unsigned char Vu_char;
#endif

#ifdef VdguxV4

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vnotli
#define Vsigvoidp
#define Vtermios
typedef unsigned char Vu_char;
#endif

#ifdef VUmaxV

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
typedef unsigned char Vu_char;
#endif

#ifdef VsysV88

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
typedef unsigned char Vu_char;
#endif

#ifdef Vrealix88k

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vsigvoidp
typedef unsigned char Vu_char;
#endif

#ifdef Vsco386

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vnogethostid
typedef unsigned char Vu_char;
#endif

#ifdef Vdrsnx

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vlocklockf
#define Vsigvoidp
#define Vtermios
typedef unsigned char Vu_char;
#endif

#ifdef VmipsV

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

typedef unsigned char uchar;

#define Vnosysinfo
#define Vnostdlib
#define Vsigvoidp
typedef unsigned char Vu_char;
#endif

#endif /* V__Vport */
