/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: DfltsMem.c,v $
    Module Description:	Brief description of source module

Command Line Args: (for main program modules only)
    Arg      Param      Description

Description: 

Linked with: <file.c> .. <file.c>

Created on    3 Jul 1997    By damian

Edit History:

	$Log: DfltsMem.c,v $
 * Revision 1.4  1998/02/27  16:03:46  damian
 * fix file descriptor leak
 *
 * Revision 1.3  1997/09/10  10:12:27  damian
 * don't syslog an error message if you can't open a defaults set as it may not
 * exist and this is not an error
 *
 * Revision 1.2  1997/08/19  15:38:50  damian
 * include Vlib.h
 *
 * Revision 1.1  1997/08/19  15:27:32  damian
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: DfltsMem.c,v 1.4 1998/02/27 16:03:46 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */


/*
 *   system header files
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <memory.h>
#include <unistd.h>
#include <syslog.h>

#ifdef Vsunos40
#include "Vansi.h"
#endif

/*
 * third party headers ie, X, informix, ctree
 */

/*
 * project header files
 */

#include "Vlib.h"

#include "dflts.h"

/*
 *  local application/library header files
 */

#include "dfltsP.h"

/*
 * local defines 
*/

/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/


/*
 * static functions 
*/

/*
 * non static functions 
*/


#define SET_TYPE    1
#define GROUP_TYPE  2

/* in this type either set or group is non NULL, but not both */
typedef struct _SetGroup
{
    int     sgtype;
    char    *name;		/* name of this set or group */
  LLITEMPTR list;		/* list of SetGroup or TagDefs */
}

SetGroup;


SetGroup *
CreateSetGroup (char *name, int sgtype)
{
  SetGroup *sg;

  sg = (SetGroup *) Malloc (sizeof (SetGroup));

  Memset (sg, 0, sizeof (SetGroup));

  sg->sgtype = sgtype;
  sg->name = CopyString (name);

  sg->list = LLCreate ();

  return sg;
}


#ifdef __STDC__
int
DfltAddGroupDefs (LLITEMPTR list, char *group)
#else
int
DfltAddGroupDefs (list, group)
     LLITEMPTR list;
     char *group;
#endif
{
  TagDef *tdef;
  char *ftag, *fval;
  char buf[4096];
  char *str, *t;
  FILE *fp;

  ftag = fval = NULL;

  if ((t = strrchr (group, '/')) != NULL)
    if ((strcmp (t +1, ".") == 0) || (strcmp (t +1, "..") == 0))
      return -1;

  if ((fp = fopen (group, "r")) == NULL)
    {
      syslog (LOG_ERR,"couldn't open dflts group %s\n", group);
      return -1;
    }

  while ((str = fgets (buf, 4096, fp)) != NULL)
    {

      if (SeperateTagAndValue (str, &ftag, &fval) < 0)
	continue;

      StripLTBlanks (ftag);
      StripLTBlanks (fval);
      StripLTBlanks (ftag);
      StripLTBlanks (fval);

      tdef = CreateTagDef (ftag, fval);
      LLAddEnd (list, (void *) tdef);
    }

  fclose(fp);

  return 0;
}


/* load the user local & global sets */

#ifdef __STDC__
int
DfltAddSetDefs (LLITEMPTR list, char *set)
#else
int
DfltAddSetDefs (list, set)
     LLITEMPTR list;
     char *set;
#endif
{
  DIR *dir;
  struct dirent *dent;
  char buf[MAXPATHLEN];
  SetGroup *sg = NULL;

  /* open up this set */
  if ((dir = opendir (set)) == NULL)
    {
/*      syslog(LOG_ERR,"couldn't open dflts data set %s", set); */
      return -1;
    }
  else
    {
      struct stat stbuf;

      while ((dent = readdir (dir)) != NULL)
	{
	  if (strcmp (dent->d_name, ".") == 0)
	    continue;
	  if (strcmp (dent->d_name, "..") == 0)
	    continue;

	  sprintf (buf, "%s/%s", set, dent->d_name);

	  if (stat (buf, &stbuf) < 0)
	    continue;

	  if ((stbuf.st_mode & S_IFMT) == S_IFDIR)
	    {
	      /* this is a set so process it */
	      sg = CreateSetGroup (dent->d_name, SET_TYPE);

	      if (DfltAddSetDefs (sg->list, buf) < 0)
		return -1;

	    }
	  else if ((stbuf.st_mode & S_IFMT) == S_IFREG)
	    {

	      sg = CreateSetGroup (dent->d_name, GROUP_TYPE);

	      if (DfltAddGroupDefs (sg->list, buf) < 0)
		return -1;
	    }
	  else
	    syslog(LOG_ERR, "invalid directory entry %s/%s",
		     set, dent->d_name);

	  /* now add it to this sets list */
	  LLAddEnd (list, (void *) sg);

	}
      closedir (dir);
    }
  return 0;
}



/* 

  find 
     global/add_to_times 
     sql/servers/default

*/

char *
DfltFindGrpDef(LLITEMPTR list, char *tag)
{
    TagDef   *td = NULL;
    LLITEMPTR   cpos;

    cpos = list;

    while ((td = (TagDef *)LLScan(&cpos)) != NULL) {

	if (strcmp(td->tag, tag) == 0)
	    return td->val;

    }

    return NULL;
}


/* a set contains a list of group files */
char *
DfltFindSetDef(LLITEMPTR list, char *tag)
{
    SetGroup *sg = NULL;
    char     *p, tbuf[256];
    int      groupname;
    LLITEMPTR   cpos;

    cpos = list;

    strcpy(tbuf, tag);

    /* find the matching group or set and recurse */
    if ((p = strchr(tbuf, '/')) != NULL) {
	*p++ = '\0';
    } else
	p = tbuf;

    if ( strchr(p,'/') != NULL) 
	/* it's a set */
	groupname = FALSE;
    else
	/* it's a group */
	groupname = TRUE;

    while ((sg = (SetGroup *)LLScan(&cpos)) != NULL) {

	if (sg->sgtype == GROUP_TYPE && groupname && strcmp(sg->name,tbuf) == 0)
	    return DfltFindGrpDef(sg->list, p);

	if (sg->sgtype == SET_TYPE && !groupname && strcmp(sg->name,tbuf) == 0)
	    return DfltFindSetDef(sg->list, p);

    }

    return NULL;
}


TagDef *
DfltFindTagGrpDef(LLITEMPTR list, char *tag)
{
    TagDef   *td = NULL;
    LLITEMPTR   cpos;

    cpos = list;

    while ((td = (TagDef *)LLScan(&cpos)) != NULL) {

	if (strcmp(td->tag, tag) == 0)
	    return td;

    }

    return NULL;
}


/* a set contains a list of group files */
TagDef *
DfltFindTagDef(LLITEMPTR list, char *tag)
{
    SetGroup *sg = NULL;
    char     *p, tbuf[256];
    int      groupname;
    LLITEMPTR   cpos;

    cpos = list;

    strcpy(tbuf, tag);

    /* find the matching group or set and recurse */
    if ((p = strchr(tbuf, '/')) != NULL) {
	*p++ = '\0';
    } else
	p = tbuf;

    if ( strchr(p,'/') != NULL) 
	/* it's a set */
	groupname = FALSE;
    else
	/* it's a group */
	groupname = TRUE;

    while ((sg = (SetGroup *)LLScan(&cpos)) != NULL) {

	if (sg->sgtype == GROUP_TYPE && groupname && strcmp(sg->name,tbuf) == 0)
	    return DfltFindTagGrpDef(sg->list, p);

	if (sg->sgtype == SET_TYPE && !groupname && strcmp(sg->name,tbuf) == 0)
	    return DfltFindTagDef(sg->list, p);

    }

    return NULL;
}


