/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: test.c,v $
    Module Description:	Brief description of source module

Command Line Args: (for main program modules only)
    Arg      Param      Description

Description: 

Linked with: <file.c> .. <file.c>

Created on    3 Jul 1997    By damian

Edit History:

	$Log: test.c,v $
 * Revision 1.1  1997/08/19  15:42:15  damian
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: test.c,v 1.1 1997/08/19 15:42:15 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 * system header files 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

/*
 * third party headers ie, X, informix, ctree 
*/

/*
 * project header files 
*/
#include "Vlib.h"

#include "dflts.h"

/*
 * local header files 
*/

/*
 * local defines 
*/

/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

/* uncomment this in main module only and obviously set it to something
   sensible.  It should actually be reset during program initialisation
   to the value of argv[0] 
char *Vprogram = "<whatever>" ; 
*/

/*
 * static functions 
*/

/*
 * non static functions 
*/

/* in this type either set or group is non NULL, but not both */
typedef struct _SetGroup
{
    int     sgtype;
    char    *name;
    LLITEMPTR list;		/* list of SetGroup or TagDefs */
}

SetGroup;


void
printgrplist(LLITEMPTR list, char *name, int indent)
{
    TagDef  *td;
    char    inbuf[64];
    LLITEMPTR   cpos;
    int      i;

    inbuf[0] = '\0';

    for(i = 0; i < indent; i++)
	strcat(inbuf,"\t");

    printf("%s group (%s)\n", inbuf, name);

    cpos = list;

    while ((td = (TagDef *)LLScan(&cpos)) != NULL) {

	printf("\t%s%s = %s\n", inbuf, td->tag, td->val);
    }

}

void
printsetlist(LLITEMPTR list, char *name, int indent)
{
    char    inbuf[64];
    SetGroup *sg = NULL;
    LLITEMPTR   cpos;
    int      i;

    inbuf[0] = '\0';

    for(i = 0; i < indent; i++)
	strcat(inbuf,"\t");

    printf("%s set (%s)\n", inbuf, name);

    cpos = list;

    while ((sg = (SetGroup *)LLScan(&cpos)) != NULL) {

	if (sg->sgtype == 2)
	    printgrplist(sg->list, sg->name, indent + 1);
	else
	    printsetlist(sg->list, sg->name, indent +1);

    }

}

char Vusrmsg[2048];

int
dotest(void)
{

    DfltsInfo   di;
    char    *val;
    int     n;

    memset(&di, 0, sizeof(di));

    /* user tests */

    printf("testing USER defaults values in ${HOME}/defaults\n");

    di.group = "test";

    di.base = USER_DFLT_SET;
    di.tag = "user_test_msg";
    if ((val = DfltGetString(&di)) != NULL )
	printf("user_test_msg = %s\n", val);

    di.base = USER_DFLT_SET;
    di.tag = "user_test_word";
    if ((val = DfltGetString(&di)) != NULL )
	printf("user_test_word = %s\n", val);

    di.base = USER_DFLT_SET;
    di.tag = "user_test_bool";
    if ((val = DfltGetString(&di)) != NULL )
	if ( strncmp(val, "TRUE", 4 ) == 0)
	    printf("user_test_bool = %s (true)\n", val);
	else
	    printf("user_test_bool = %s (false)\n", val);

    di.base = USER_DFLT_SET;
    if (DfltGetBool(&di))
	printf("user_test_bool = (TRUE)\n");
    else
	printf("user_test_bool = (FALSE)\n");

    di.base = USER_DFLT_SET;
    di.tag = "user_test_int";
    di.num = -1;
    n = DfltGetInt(&di);
    printf("user_test_int = %d\n", n);


    /* local tests */

    printf("testing LOCAL defaults values in /usr/local/defaults\n");

    di.group = "test";

    di.base = LOCAL_DFLT_SET;
    di.tag = "local_test_msg";
    if ((val = DfltGetString(&di)) != NULL )
	printf("local_test_msg = %s\n", val);

    di.base = LOCAL_DFLT_SET;
    di.tag = "local_test_word";
    if ((val = DfltGetString(&di)) != NULL )
	printf("local_test_word = %s\n", val);

    di.base = LOCAL_DFLT_SET;
    di.tag = "local_test_bool";
    if ((val = DfltGetString(&di)) != NULL )
	if ( strncmp(val, "TRUE", 4 ) == 0)
	    printf("local_test_bool = %s (true)\n", val);
	else
	    printf("local_test_bool = %s (false)\n", val);

    di.base = LOCAL_DFLT_SET;
    if (DfltGetBool(&di))
	printf("local_test_bool = (TRUE)\n");
    else
	printf("local_test_bool = (FALSE)\n");

    di.base = LOCAL_DFLT_SET;
    di.tag = "local_test_int";
    di.num = -1;
    n = DfltGetInt(&di);
    printf("local_test_int = %d\n", n);


    /* global tests */

    printf("testing GLOBAL defaults values in /etc/defaults\n");
    di.group = "test";

    di.base = GLOBAL_DFLT_SET;
    di.tag = "global_test_msg";
    if ((val = DfltGetString(&di)) != NULL )
	printf("global_test_msg = %s\n", val);

    di.base = GLOBAL_DFLT_SET;
    di.tag = "global_test_word";
    if ((val = DfltGetString(&di)) != NULL )
	printf("global_test_word = %s\n", val);

    di.base = GLOBAL_DFLT_SET;
    di.tag = "global_test_bool";
    if ((val = DfltGetString(&di)) != NULL )
	if ( strncmp(val, "TRUE", 4 ) == 0)
	    printf("global_test_bool = %s (true)\n", val);
	else
	    printf("global_test_bool = %s (false)\n", val);

    di.base = GLOBAL_DFLT_SET;
    if (DfltGetBool(&di))
	printf("global_test_bool = (TRUE)\n");
    else
	printf("global_test_bool = (FALSE)\n");

    di.base = GLOBAL_DFLT_SET;
    di.tag = "global_test_int";
    di.num = -1;
    n = DfltGetInt(&di);
    printf("global_test_int = %d\n", n);

    /* now test in any set and print the base it was found in */

    printf("testing defaults values in any base set\n");
    printf("the base set numbers are;\n\tUSER == 3\n\tLOCAL == 2\n\tGLOBAL == 1\n\tANY == 0\n");

    di.group = "test";

    di.base = ANY_DFLT_SET;
    di.tag = "test_msg";
    if ((val = DfltGetString(&di)) != NULL ) {
	printf("test_msg = %s\t", val);
	printf("found in base %d\n", di.base );
    }

    di.base = ANY_DFLT_SET;
    di.tag = "test_word";
    if ((val = DfltGetString(&di)) != NULL ) {
	printf("test_word = %s\t", val);
	printf("found in base %d\n", di.base );
    }

    di.base = ANY_DFLT_SET;
    di.tag = "test_bool";
    if ((val = DfltGetString(&di)) != NULL ) {
	if ( strncmp(val, "TRUE", 4 ) == 0)
	    printf("test_bool = %s (true)\t", val);
	else
	    printf("test_bool = %s (false)\t", val);

	printf("found in base %d\n", di.base );
    }

    di.base = ANY_DFLT_SET;
    if (DfltGetBool(&di))
	printf("test_bool = (TRUE)\t");
    else
	printf("test_bool = (FALSE)\t");

    printf("current base %d\n", di.base );

    di.base = ANY_DFLT_SET;
    di.tag = "test_int";
    di.num = -1;
    n = DfltGetInt(&di);
    printf("test_int = %d\t", n);

    printf("current base %d\n", di.base );

    return 0;
}


int
main(int argc, char **argv)
{
    int     i;

    DfltsInit(NULL,NULL,NULL);

    for(i = 1; i < 4; i++) {
	printf("doing test iteration %d\n\n", i);
	dotest();
    }

    return 0;
}

