/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: mysqlVport.h,v $
    Module Description:	 Machine Porting Definitions File

An earlier version of mysql also defined the uchar typedef so the
original version of this file ../../include/Vport.h caused an error

This file doesn't contain the typedef so things will compile OK

Description:


Edit History:

	$Log: mysqlVport.h,v $
 * Revision 1.1  1997/08/21  18:08:59  damian
 * Initial revision
 *
 * Revision 2.4  1996/04/17  15:20:35  damian
 * add section for bsdi
 *
	Revision 2.3  1996/03/08 00:37:41  damian
	added Vfreebsd for FreeBSD 2.1.0

	Revision 2.2  1996/01/11 13:18:07  damian
	move typedefs into per system ifdefs

 * Revision 2.1  1996/01/04  11:18:02  V
 * Version 2
 * added typedef ulong
 *
 * Revision 1.2  1995/07/26  19:22:50  V
 * UV to V
 *
 * Revision 1.1  1995/01/19  10:29:18  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program)
static char moduleRCSid[] = "@(#) $Id: mysqlVport.h,v 1.1 1997/08/21 18:08:59 damian Exp $";
*/


#ifndef V__Vport
#define V__Vport


/* currently defined porting symbols
   System symbols:
   Vsolaris21			Sun sparc architecture (Solaris 2.1)
   Vsunos40			Sun sparc architecture (SunOS 4.x)
   Vfreebsd 	    	    FreeBSD 2.1.0
   Vlinux   	    	    Linux all versions
   Vbsdi                    Bsdi 2.1

   Capability/quirk symbols:
   Vtermios			System supports termios port control
   Vnomemcpy			System does not have memcpy library call
   Vnomemset			System does not have memset library call
   Vnobzero			..and also does not have bzero library call
   Vnostrchr		System does not have strchr/strrchr library calls
   Vnoindex		..and also does not have index/rindex library calls
   Vnounistd			System does not support unistd.h (POSIX)
   Vsigvoidp			Signal() uses void pointers, not int pointers
   Vnotli              System does not support TLI
   Vnogethostid        System does not have gethostid()
   Vnosysinfo          System does not have sysinfo()
   Vnoselect           System does not have select() (uses poll() instead)
   Vlocklockf	    System locks files with lockf()
   Vlockflock	    System locks files with flock()
   Vlockfcntl	    System locks files with fcntl()
   Vnolocks	    System has no locking facilities
*/


typedef int BOOLEAN;

typedef int BitMask;

typedef char *String;

typedef char **StringList;

typedef int (*PFI) ();


#ifdef Vsolaris21

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

#define Vsigvoidp
#define Vtermios
#define Vnogethostid
#define Vnoindex
#define Vnorindex
#define Vlocklockf		/* use lockf() for file locking */
#endif

/* FreeBsd 2.1.0 */
#ifdef Vfreebsd

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

#endif

/* Bsdi 2.1 */
#ifdef Vbsdi

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

#endif




#ifdef Vsunos40

typedef int int32;

typedef short int16;

typedef unsigned long ulong;

typedef unsigned int uint32;

typedef unsigned short uint16;

#define Vnotli
#define Vsigvoidp
#define Vnosysinfo
#define Vtermios
#define Vlockflock		/* use bsd style flock() file locking */
#endif


#ifdef Vlinux

#include <linux/version.h>
#include <linux/types.h>

typedef int int32;

typedef short int16;

typedef unsigned int uint32;

typedef unsigned short uint16;

#define Vtermios
#define Vnosysinfo
#define Vnotli

#define Vlockfcntl		/* use fcntl() for file locking */

#endif


#endif /* V__Vport */
