/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: mysqlacc.c,v $
    Module Description:	Virtual interface to mysql database engine

Description: 

Created on   21/1/97   By damian

Edit History:

	$Log: mysqlacc.c,v $
 * Revision 1.4  1998/03/20  10:56:21  damian
 * define data storage for db handles instead of getting memory from heap
 *
 * Revision 1.3  1998/03/06  12:35:48  damian
 * use the standard Vport.h as mysql no longer defines uchar
 *
	Revision 1.2  1997/09/02 12:06:45  damian
	use Vdbmsg error message pointer

	Revision 1.1  1997/08/21 18:08:59  damian
	Initial revision


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: mysqlacc.c,v 1.4 1998/03/20 10:56:21 damian Exp damian $";

/* must come first header files  */
#include "V.h"	
#include "Vport.h"


/*
 * system header files 
*/
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#include <memory.h>

/*
 * third party headers ie, X, informix, ctree 
*/

#include "mysql.h"


/*
 * project header files 
*/

#include "Vlib.h"
#include "Vdb.h"

#include "dflts.h"

/*
 * local header files 
*/

/*
 * local defines 
*/

#ifdef Vsunos40
#include "Vansi.h"
#endif


/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

/*
 * static functions 
*/

/*
 * non static functions 
*/

typedef struct {
    MYSQL   	dbh;
    MYSQL_RES  *res;
    int         rpos;
    MYSQL_ROW   row;
    int         nrows;
    int         nfields;
    int     	inuse;
} DBhandle;

static DBhandle dbs[NOFILE];
static DBhandle bkdbs[NOFILE];

static int numhandles = 0;

static char *user = NULL;
static char *passwd = NULL;

static char errbuf[1024];

#ifdef __STDC__
int
MysqlaccNumrows(int handle)
#else
int
MysqlaccNumrows(handle)
int handle;
#endif
{
    return dbs[handle].nrows;
}

#ifdef __STDC__
int
MysqlaccNumfields(int handle)
#else
int
MysqlaccNumfields(handle)
int handle;
#endif
{
    return dbs[handle].nfields;
}


static char *backup_server = NULL;
static int  backup_queries = FALSE;

int
MysqlInit(char *init_user, char *init_passwd)
{
    if (init_user)
	user = strdup(init_user);

    if ( init_passwd)
	passwd = strdup(init_passwd);

    memset(dbs,0,sizeof(dbs));

    numhandles = NOFILE;

    return 0;
}

/* 
 * connect to database engine on specified host
*/
int
MysqlaccConnect(char *host)
{
    MYSQL     *mysql, *bkmysql;
    DfltsInfo   di;
    char    *val;
    register int    i;

    Vdbmsg = errbuf;
    errbuf[0] = '\0';

    if ( numhandles == 0)
	MysqlInit(NULL, NULL);

    if ( backup_server == NULL) {

	memset(&di, 0, sizeof(di));
	di.group = "mysql";
	di.tag = "backup_server";
	di.base = ANY_DFLT_SET;

	if ((val = DfltGetString(&di)) == NULL)
	    backup_server = "";
	else
	    backup_server = strdup(val);

	di.tag = "backup_queries";
	di.base = ANY_DFLT_SET;
	backup_queries = DfltGetBool(&di);

    }

    /* find a free handle */
    for(i = 0 ; i < numhandles; i++) {
	if (dbs[i].inuse == 0)
	    break;
    }

    if ( i == NOFILE) {
	Vdbmsg = "Couldn't connect to engine! no more handles\n";
	return -1;
    }

    mysql = &dbs[i].dbh;
    bkmysql = &bkdbs[i].dbh;
    dbs[i].inuse = 1;

    if (mysql_connect(mysql,host,user,passwd) == NULL )
	sprintf(errbuf, "Couldn't connect to engine! - %s\n", 
		mysql_error(mysql));

    if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	if (mysql_connect(bkmysql,backup_server,user,passwd) == NULL )
	    sprintf(errbuf, "Couldn't connect to backup server! - %s\n", 
		    mysql_error(bkmysql));
    }
   
    return i;
}

/*
 * select a database
*/
#ifdef __STDC__
int
MysqlaccSelect(int handle, char *db)
#else
int
MysqlaccSelect(handle, db)
int     handle;
char    *db;
#endif
{
    int     err;
    MYSQL   *mysql, *bkmysql;

    Vdbmsg = errbuf;
    errbuf[0] = '\0';

    mysql = &dbs[handle].dbh;
    bkmysql = &bkdbs[handle].dbh;

    if ((err = mysql_select_db(mysql,db)) < 0 ) {
	sprintf(errbuf, "Couldn't select database [%s]! - %s\n", 
		db, mysql_error(mysql));
    }

    if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	if ((err = mysql_select_db(bkmysql,db)) < 0 ) {
	    sprintf(errbuf, 
		    "Couldn't select database on backup server [%s]! - %s\n", 
		    db, mysql_error(bkmysql));
	}
    }
    return err;

}

static char     *mysql_logfile = NULL;
static int      log_queries = FALSE;
static int      do_insert = FALSE;
static int      do_update = FALSE;
static int      do_delete = FALSE;
static int      do_select = FALSE;

static StringList     incsl = NULL;
static StringList     excsl = NULL;
static int      include_num;
static int      exclude_num;


/*
 * perform a database query
*/
#ifdef __STDC__
int
MysqlaccQuery(int handle, char *dbname, char *query)
#else
int
MysqlaccQuery(handle, dbname, query)
int     handle;
char	*dbname;		/* used for logging purposes */
char    *query;
#endif
{
    
    int     err, do_logging = FALSE, num;
    DfltsInfo   di;
    char    *val;
    FILE    *lfp;
    MYSQL   *mysql, *bkmysql;
    DBhandle	*db;

    Vdbmsg = errbuf;
    errbuf[0] = '\0';

    mysql = &dbs[handle].dbh;
    bkmysql = &bkdbs[handle].dbh;
    db = &dbs[handle];

    /* log the query if logging is enabled */

    if ( mysql_logfile == NULL ) {

	memset(&di, 0, sizeof(di));
	di.group = "mysql";
	di.tag = "log_file";
	di.base = ANY_DFLT_SET;

	/* if the logfile isn't specified then set logfile to "" so we don't
	   keep trying to get the tag's value */

	if ((val = DfltGetString(&di)) == NULL)
	    mysql_logfile = "";
	else
	    mysql_logfile = strdup(val);

	di.tag = "log_queries";
	di.base = ANY_DFLT_SET;
	log_queries = DfltGetBool(&di);

	di.tag = "log_insert";
	di.base = ANY_DFLT_SET;
	do_insert = DfltGetBool(&di);

	di.tag = "log_delete";
	di.base = ANY_DFLT_SET;
	do_delete = DfltGetBool(&di);

	di.tag = "log_update";
	di.base = ANY_DFLT_SET;
	do_update = DfltGetBool(&di);

	di.tag = "log_select";
	di.base = ANY_DFLT_SET;
	do_select = DfltGetBool(&di);

#ifdef 0
	di.tag = "log_include";
	di.base = ANY_DFLT_SET;
	if ((val = DfltGetString(&di)) != NULL) {
	    incsl = StringListFromString(val, ';');
	    include_num = CountStringList(incsl);
	}

	di.tag = "log_exclude";
	di.base = ANY_DFLT_SET;
	if ((val = DfltGetString(&di)) != NULL) {
	    excsl = StringListFromString(val, ';');
	    exclude_num = CountStringList(excsl);
	}
#endif

    }

    if ( mysql_logfile && mysql_logfile[0] && log_queries == TRUE) {

	switch( query[0] ) {
	case 'i':
	case 'I':
	    do_logging = do_insert;
	    break;
	case 'u':
	case 'U':
	    do_logging = do_update;
	    break;
	case 'd':
	case 'D':
	    do_logging = do_delete;
	    break;
	case 's':
	case 'S':
	    do_logging = do_select;
	    break;
	}

	/* work out if the query matches an include or exclude
	   pattern */

	/* if the pattern is explicitly excluded then turn logging off
	   for this query, we don't need to check if logging is
	   already FALSE */
	if ( excsl != NULL && do_logging == TRUE )
	    for(num = 0; num < exclude_num ; num++) {
		if ( strstr(query, excsl[num]) != NULL) {
		    do_logging = FALSE;
		    break;
		}
	    }

	/* if pattern is explicitly included then turn logging on
	   for this query,  we don't need to check if logging is
	   already TRUE */
	if ( incsl != NULL && do_logging == FALSE)
	    for(num = 0; num < include_num ; num++) {
		if ( strstr(query, incsl[num]) != NULL) {
		    do_logging = TRUE;
		    break;
		}
	    }

	if ( do_logging == TRUE ) {
	    if ((lfp = fopen(mysql_logfile, "a")) == NULL)
		sprintf(errbuf, "couldn't open mysql logfile %s - %m", 
		       mysql_logfile);
	    else {
		fprintf(lfp, "%s: %s\n", dbname, query);
		fflush(lfp);
		fclose(lfp);
	    }
	}
    }

    /*-- do the query */
    if ( (err = mysql_query(mysql,query)) < 0 ) {
	/* if this is a select and 
	   there is a backup server then query on that */
	if (backup_server && 
	    backup_server[0] && 
	    backup_queries == TRUE &&
	    strncasecmp(query,"select",6) == 0) 
	{
	    if ( (err = mysql_query(bkmysql,query)) < 0 ) {
		sprintf(errbuf, 
		       "Query failed on primary (%s) AND backup (%s)\n", 
		       mysql_error(mysql), mysql_error(bkmysql));
		return err;
	    }
	} else {
	    sprintf(errbuf, "Query failed! - %s\n", 
		   mysql_error(mysql));
	    return err;
	}
    }

    if ( strncasecmp(query,"select", 6) == 0) {
	if ( db->res != NULL )
	    mysql_free_result(db->res);

	/*-- store the result so it isn't overwritten */
	db->res = mysql_store_result(mysql);

	db->nrows = mysql_num_rows(db->res);

	db->nfields = mysql_num_fields(db->res);
    } else if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	if ( (err = mysql_query(bkmysql,query)) < 0 ) {
	    sprintf(errbuf, "Query failed on backup server! - %s\n", 
		    mysql_error(bkmysql));
	    return err;
	}
    }

    return 0;

}

/*
 * close the connection to the database engine
*/
#ifdef __STDC__
int
MysqlaccClose(int handle)
#else
int
MysqlaccClose(handle)
int    handle;
#endif
{
    MYSQL   *mysql, *bkmysql;

    mysql = &dbs[handle].dbh;
    bkmysql = &bkdbs[handle].dbh;

    mysql_close(mysql);

    dbs[handle].inuse = 0;

    if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	mysql_close(bkmysql);
    }

    return 0;
}

/*
 * 
*/
int
MysqlaccFetchRow(int handle, char *fldv[], int *num)
{
    int      i;
    MYSQL   *mysql, *bkmysql;
    DBhandle	*db;

    db = &dbs[handle];
    mysql = &dbs[handle].dbh;
    bkmysql = &bkdbs[handle].dbh;

    if ( *num > db->nfields )
	*num = db->nfields;

    if ((db->row=mysql_fetch_row(db->res)) == NULL) 
	return -1;

    /*-- print each field into the buffer */
    for (i = 0; i < *num; i++) 
    {
	fldv[i] = db->row[i];
    }

    return 0;
}

/*
 * get pointers to the first record's data values
*/
int
MysqlaccFirstRec(int handle, char *fldv[], int *num)
{
    DBhandle	*db;

    db = &dbs[handle];

    mysql_data_seek(db->res,(db->rpos = 0));

    return MysqlaccFetchRow(handle, fldv, num);

}

/*
 * move the result record pointer to the next result
 * and get the values therein
*/
int
MysqlaccNextRec(int handle, char *fldv[], int *num)
{
    DBhandle	*db;

    db = &dbs[handle];

    mysql_data_seek(db->res,++db->rpos);

    return MysqlaccFetchRow(handle, fldv, num);
}

/*
 * move the result record pointer to the previous result
 * and get the values therein
*/
int
MysqlaccPrevRec(int handle, char *fldv[], int *num)
{
    DBhandle	*db;

    db = &dbs[handle];

    if ( db->rpos > 0) {
	mysql_data_seek(db->res,--db->rpos);

	return MysqlaccFetchRow(handle, fldv, num);
    } else
	return -1;

}

/*
 * format the result of a query into a list of strings
 * each field is delimited by the character given in sep
*/
#ifdef __STDC__
StringList  
MysqlaccResultSL(int handle, int sep)
#else
StringList  
MysqlaccResultSL(handle, sep)
int handle;
int     sep;
#endif
{
    StringList   sl = NULL;
    char         rbuf[4096], *p;
    int          i, num = 1;
    DBhandle	*db;

    db = &dbs[handle];

    /*-- while there are more rows in the result */

    while ((db->row=mysql_fetch_row(db->res)) != NULL) 
    {
	if ( sl == NULL) {
	    sl = CreateStringList(1);
	}

	p = rbuf;

	/*-- print each field into the buffer */
	for (i = 0; i < db->nfields; i++) 
	{
	    sprintf( p, "%s%c", db->row[i], sep & 0xff );

	    p = EndOfString(p) +1;
	}

	/*-- extend the StringList to accomodate the new row
	  (has no effect for the first row) */
	sl = ExtendStringList(sl, &num);

	/*-- and copy the buffer into the StringList */
	sl[num - 1] = strdup(rbuf);

	num++;

    }

    return sl;
}


/*
 * format the result of a query into a list of strings
 * each field is delimited by specified seperator character
*/
#ifdef __STDC__
LLlist  *
MysqlaccResultLL(int handle, int sep)
#else
LLlist  *
MysqlaccResultLL(handle, sep)
int handle;
int     sep;
#endif
{
    LLlist       *rl;
    char         rbuf[4096], *p;
    int          i;
    DBhandle	*db;

    db = &dbs[handle];

    rl = LLcreate(NULL,NULL,NULL,0);

    /*-- while there are more rows in the result */

    while ((db->row=mysql_fetch_row(db->res)) != NULL) 
    {
	p = rbuf;

	/*-- print each field into the buffer */
	for (i = 0; i < db->nfields; i++) 
	{
	    sprintf( p, "%s%c", db->row[i], sep & 0xff );

	    p = EndOfString(p);
	}

	/*-- and copy the buffer into the StringList */
	LLappend(rl,(void *) strdup(rbuf));

    }

    return rl;
}

