/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Memory.c,v $
    Module Description:	Generic Memory Set Routine


Description: 


Edit History:

	$Log: Memory.c,v $
 * Revision 1.4  1995/08/29  10:13:27  damian
 * changes for sunos
 *
 * Revision 1.3  1995/02/27  17:40:04  V
 * cleaned up unused warnings
 *
 * Revision 1.2  1995/01/09  18:32:14  V
 * include stdio.h and stdlib.h
 *
 * Revision 1.1  1995/01/09  18:21:23  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: Memory.c,v 1.4 1995/08/29 10:13:27 damian Exp $";



#include "V.h"
#include "Vport.h"

#include <stdio.h>
#include <stdlib.h>

#ifndef Vnomemset
#include <memory.h>
#endif

#ifdef VANSI_1
void Memset(register char *address, register int ch, register int size)
#else
void Memset(address, ch, size)
register char *address;
register int ch;
register int size;
#endif
{
#ifndef Vnomemset
	memset(address, ch, (unsigned)size);
#else
#ifndef Vnobzero
	if (ch == 0)
	  {
		bzero(address, size);
		return;
	  }
#endif
	  {
		register int i;
		for (i = 0; i < size; i++)
			*address++ = ch;
	  }
#endif
} 	


/*
 * Wrapper for malloc which will abort program if fails to get memory
 * also if size is 0 return NULL since malloc returns a non null pointer 
 * in this case, which may not be dereferenced (which is nonsense)
 */


#ifdef VANSI_1
void *Malloc(size_t n)
#else
void *Malloc( n)
size_t n;
#endif
{
    void *p;

    if ( n == 0 ) {
	fprintf( stderr, "Malloc: attempt to allocate 0 bytes\n" );
	return NULL;
    }

    if ((p = malloc(n)) == NULL) {
	printf("fatal: Malloc: no memory to allocate %ld bytes\n", n);
	exit(1);
    }
#ifdef DEBUG_MEMORY
    addToMemtab( p, n );
#endif			
    return p;
}

/*
 * Wrapper for free which will ignore null ptrs passed to it. If have a true
 * ANSI free then could use that instead.
 */
#ifdef VANSI_1
void Free(void *p)
#else
void Free(p)
void *p;
#endif
{
    if (p) {
	free(p);
#ifdef DEBUG_MEMORY
	delFromMemtab(p);
#endif
    }
}


	
/*
 * Copy a string into malloced memory and return ptr to it. If i/p
 * string is NULL then return NULL.
 */
#ifdef VANSI_1
char *CopyString( char *s)
#else
char *CopyString(s)
char *s;
#endif
{
    char        *s2;

    if (!s)
	return NULL;

    s2 = Malloc(strlen(s) + 1);
    strcpy(s2,s);
    return s2;
}




#ifdef VANSI_1
void *Calloc(size_t nobj,size_t size)
#else
void *Calloc( nobj, size)
size_t nobj;
size_t size;
#endif
{
    void        *p;

    if ((p = calloc(nobj,size)) == NULL) {
	printf("fatal: Calloc: no memory to allocate %ld bytes (%ld x %ld)\n",
	       nobj * size,nobj,size);
	exit(1);
    }
#ifdef DEBUG_MEMORY
    addToMemtab( p, nobj * size );
#endif
    return p;
}

#ifdef VANSI_1
void *Realloc(void *oldp,size_t size)
#else
void *Realloc(oldp, size)
void *oldp;
size_t size;
#endif
{
    void *p;

    if ((p = realloc(oldp,size)) == NULL) {
	printf("fatal: Realloc: no memory when allocating %ld bytes\n",size);
	exit(1);
    }
#ifdef DEBUG_MEMORY
    delFromMemtab(oldp);

    addToMemtab( p, size );
#endif
    return p;

}	
