#!/usr/bin/perl
###########################################################################
#    Mysql Web based Administration
#    Written by Ying Gao, gaoying@hotmail.com, http://billow.cjb.net
#    It's a free script. You can modify it freely!
###########################################################################
package gymysql;

require Exporter;
@ISA = qw (Exporter);
@EXPORT = qw(@EXPORT_OK);

@EXPORT_OK = qw($dbh $VERSION);

use strict;
use gymysqlvars qw(%Config);
use vars qw($dbh $VERSION); 

$gymysql::VERSION = "1.0.0";

# Some versions of perl are barking about the DBI and statement handlers
# For now, we are just turning these off.
$SIG{'__WARN__'} = sub { };
###########################################################################
# Start of the main subroutines
###########################################################################


###########################################################################
# Get_input - Parses form input and returns it in a hash.
# Useage: my %Input = &Get_Form_Data(1);
# Input : 1 => filter special chars
#         0 => Do not filter chars          
# Notice: It read both the $ENV{'QUERY_STRING'} and the STDIN
###########################################################################
sub Get_Form_Data
{
        my $filterchar = shift;
        my(@pairs) = ();
        if ($ENV{'QUERY_STRING'})
        {
	      @pairs=split(/&/,$ENV{'QUERY_STRING'});
        }
        if($ENV{'REQUEST_METHOD'} eq "POST")
        {
 	      my $buffer = "";
  	      read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  	      my @postpairs=split(/&/,$buffer);
  	      push(@pairs,@postpairs);
  	}
        
        my ($pair,$name,$value,@data) = ();
	
	foreach $pair (@pairs)
	{
		($name,$value) = split(/=/,$pair);
		$value=~tr/+/ /;

                $name  =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;
                $value =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;

		$value =~ s/\r//g;
		if($filterchar)
		{
		    $value = &RemoveBadChar($value);
		    $value =~ s/:/$Config{'COLON'}/g;
		}

		push (@data,$name);
		push (@data, $value);
	}
	my %formdata=@data;
	return %formdata;
}

###########################################################################
# Filter specail chars, such as ASCII value < 32, "<" and ">"
# Useage: my $output = &RemoveBadChar($input);
###########################################################################
sub RemoveBadChar
{
        my $srctxt = shift;
	$srctxt =~ s/<([^>]|\n)*>//g;
	$srctxt =~ s/<//g;
	
        my $strlen = length($srctxt);
        my $result = "";
        my ($binchar,$char,$binchar2) = '';
        for (my($i) = 0; $i < $strlen; $i++) 
        {
	     $binchar = vec($srctxt, $i, 8); 
	     next if ($binchar < 32);
	     $char = substr($srctxt, $i, 1);
	     $result .= $char;
        }
        return $result;
}

sub FilterHtml
{
	my $result = shift;
        $result =~ s/<([^>]|\n)*>//g;
        $result =~ s/<//g;
        return $result;
}

###########################################################################
# url_encode: Encodes a string for printing in a URL.
# Usage: my $encoded = &url_encode ($string);
###########################################################################
sub url_encode {

  my $input = shift;
  $input =~s/([^a-zA-Z0-9_.-])/uc sprintf("%%%02x",ord($1))/eg;
  return $input

}

 
###########################################################################
# Url_decode: Decodes a string that's been encoded in a URL.
# Usage: my $string = &url_decode ($encoded);
###########################################################################
sub url_decode {

  my $input = shift;
  $input =~ tr/+/ /;
  $input =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
  return $input;

}


###########################################################################
# check_refer: Checks for a valid referer
###########################################################################
sub check_refer {
  if($Config{'checkurl'})
  {
      my $valid = 0;
      ($ENV{'HTTP_REFERER'} =~ /$Config{'referer'}/i) and $valid++;
      $valid or not_right ("The host you are trying to send the input from is not a valid host.");
  }
}


###########################################################################
# Connects to the database.
###########################################################################
sub db_connect{

  if (!$ENV{'MOD_PERL'}) {
    require DBI;
  }

  my $source = "";
  if($Config{'dbname'})
  {
  	$source = "$Config{'dbname'}";
  	if($Config{'dbserver'})
  	{
  		$source .= ";host=$Config{'dbserver'}";
  	}
  	if($Config{'dbport'})
  	{
  		$source .= ";port=$Config{'dbport'}";
  	}
  }
  
  $dbh = DBI -> connect("DBI:$Config{'dbdriver'}:$source", "$Config{'dbuser'}", "$Config{'dbpass'}") or  gymysql::cgi_error("Can't connect to sql server. <br>Reason: <em>$DBI::errstr</em>");

  if (!$ENV{'MOD_PERL'}) {
    $dbh->{'Warn'} = 0;
  }
}


###########################################################################
# Disconnects from the database
###########################################################################
sub db_disconnect{

   defined $dbh and
    ($dbh->disconnect or die "Can't disconnect from database. Reason: <em>$DBI::errstr</em>" and undef $dbh);

}

###########################################################################
# GetCookies - Gets all the cookies and returns them in a hash
# Usage: my %cookie = &GetCookies;
###########################################################################
sub GetCookies
{
  my ($cookie, $value, $char, %cookie);
  my @Cdec = ('\+', '\%3A\%3A', '\%3D', '\%2C', '\%25', '\%2B', '\%26','\%3B');
  my %Cdec = ('\+',' ','\%3A\%3A','::','\%3D','=','\%2C',',','\%25','%','\%2B','+','\%26','&','\%3B',';');
  if ($ENV{'HTTP_COOKIE'}) 
  {
    foreach (split(/; /,$ENV{'HTTP_COOKIE'})) 
    {
       ($cookie,$value) = split(/=/);
       foreach $char (@Cdec) 
       {
           $cookie =~ s/$char/$Cdec{$char}/g;
           $value =~ s/$char/$Cdec{$char}/g;
       }
       $cookie{$cookie} = $value;
    }
  }
  return %cookie;
}

###########################################################################
# set_cookie - Sets a cookie.
# Usage : SetCookies(X,Y,'Name',"Value") X => Expire time; Y => Path
# Example:SetCookies(0,'/','gymysqlUSER','Billow'); => Temprary Cookies, return to all pages in gymysql.com
###########################################################################
sub SetCookies 
{
    my $exptime   = shift;
    my $path      = shift;
    my(@days)     = ("Sun","Mon","Tue","Wed","Thu","Fri","Sat");
    my(@months)   = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

    if($exptime ne 0)
    {
    	$exptime += time;
    	my($seconds,$min,$hour,$mday,$mon,$year,$wday) = gmtime($exptime);
    	$seconds = "0".$seconds if $seconds < 10;
        $min = "0".$min if $min < 10;
        $hour= "0".$hour if $hour < 10; 
        $exptime = "$days[$wday], $mday-$months[$mon]-$year $hour:$min:$seconds GMT";
    }
    
    my @cookies = @_;
    my($cookie,$value,$char);
    my @Cenc = ('\;','\&','\+','\%','\,','\=','\:\:','\s');
    my %Cenc = ('\;','%3B','\&','%26','\+','%2B','\%','%25','\,','%2C','\=','%3D','\:\:','%3A%3A','\s','+');

    my $secure = ($Config{'secookie'}) ? "secure" : "";
    while( ($cookie,$value) = @cookies )
    {
        foreach $char (@Cenc) 
        {
            $cookie =~ s/$char/$Cenc{$char}/g;
            $value =~ s/$char/$Cenc{$char}/g;
        }
        print 'Set-Cookie: ' . $cookie . '=' . $value . ';';
        print ' expires='.$exptime.';' if ($exptime);
        print ' path='.$path.';' if ($path);
        print " $secure\n";
        shift(@cookies); shift(@cookies);
    }
}

###########################################################################
# set_cookie - Sets a cookie.
# Usage : SetCompressedCookies(X,Y,'CookiesName','Name',"Value") X => Expire time; Y => Path
# Example:SetCompressedCookies(0,'/','gymysqlMulCookie','gymysqlUSER','Billow'); => Temprary Cookies, return to all pages in gymysql.com
###########################################################################
sub SetCompressedCookies 
{
    my($exptime,$path,$cookie_name,@cookies) = @_;
    my($cookie,$value,$cookie_value,$char);
    my @Cenc = ('\;','\&','\+','\%','\,','\=','\:\:','\s');
    my %Cenc = ('\;','%3B','\&','%26','\+','%2B','\%','%25','\,','%2C','\=','%3D','\:\:','%3A%3A','\s','+');

    while ( ($cookie,$value) = @cookies ) 
    {
        foreach $char (@Cenc) 
        {
            $cookie =~ s/$char/$Cenc{$char}/g;
            $value  =~ s/$char/$Cenc{$char}/g;        
        }
        if ($cookie_value) 
        {
            $cookie_value .= '&' . $cookie . '::' . $value;        
        }
        else 
        {            
            $cookie_value = $cookie . '::' . $value;
        }
        shift(@cookies);
        shift(@cookies);    
    }
    &SetCookies($exptime,$path,"$cookie_name","$cookie_value");
}

############################
#GetCompressedCookies($cookiesname,\%Cookies)
#Return NULL
############################
sub GetCompressedCookies
{
    my($cookie_name,$cookies) = @_;
    my($cookie,$value,$char);
    my @Cdec = ('\+', '\%3A\%3A', '\%3D', '\%2C', '\%25', '\%2B', '\%26','\%3B');
    my %Cdec = ('\+',' ','\%3A\%3A','::','\%3D','=','\%2C',',','\%25','%','\%2B','+','\%26','&','\%3B',';');

    if ($$cookies{$cookie_name})
    {
            foreach (split(/&/,$$cookies{$cookie_name})) 
            {
                ($cookie,$value) = split(/::/);
                foreach $char (@Cdec) 
                {
                    $cookie =~ s/$char/$Cdec{$char}/g;
                    $value =~ s/$char/$Cdec{$char}/g;
                    $$cookies{$cookie} = $value;
                }
            }
            delete($$cookies{$cookie_name});
    }
}

###########################################################################
# Figure out how we should exit
###########################################################################
sub exit{
  if(exists $ENV{MOD_PERL}) {
    Apache::exit(0); 
  }
  else {
    CORE::exit(0);
  }
}

########################################################################
sub authenticate {
# ---------------------------------------------------------
# Checks the username/password to make sure it is valid, and
# returns a hash of the user info. If no parameters are provided,
# it gets the username/password from cookies. Returns undef if unable
# to validate or no username/password found.
	my ($Username, $Password);
	if (@_ == 2) {
		($Username, $Password) = @_;
	}
	else {
		my %cookies = &GetCookies();
		$Username   = $cookies{'Username'};
		$Password   = $cookies{'Password'};
	}
	return undef unless $Username and $Password;

	my $Username_q  = $dbh->quote($Username);
        my $Password_q  = $dbh->quote($Password);
    
	my $query = qq!
		SELECT *
		FROM   Users
		WHERE  Username = $Username_q AND Password = $Password_q
	!;
	my $sth = $dbh->prepare ($query) or die "Can't prepare: $query. Reason: $!";
	$sth->execute                    or die "Can't execute: $query. Reason: $!";

	if ($sth->rows) {
          my $user = $sth->fetchrow_hashref;
          $sth->finish;
          return %{$user};
	}
	$sth->finish;
	return undef;
}

###########################################################################
# not_right- User did something wrong.
###########################################################################
sub not_right{

  my $error = shift;
  &send_header ("There was a problem!");
  &table_header ("We encountered a problem!");
  print qq~
    The server encountered an error and cannot complete your request.  The error reported was:
    </p><p>
    <i>
    $error
    </i>
    </p><p>
    This error could be something as simple as your browser not being set to accept cookies.  If you feel you this error is a problem with the server then please contact <a href="mailto:$Config{'emailaddy'}">$Config{'emailaddy'}</a> and let us know what exactly went wrong so it can be fixed as soon as possible.  Otherwise, please use your back button to return to the previous page and try again.
    </p>
  ~;
  &send_footer;   # Send a footer back to the browser
  gymysql::exit();
}

###########################################################################
# cgi_error - System did something wrong
###########################################################################
sub cgi_error {
  my $error = shift;
  #print "Content-type: text/html\nPragma: no-cache\n\n" if($Config{'HTML_Header'});
  print "Content-type: text/html\n\n" if($Config{'HTML_Header'});
  print qq~
<br>
<font size=+1>System Error: <br><pre>$error</pre></font><br>
<center><a href="javascript:history.go(-1)">Back</a></center>
<br>
~;
  &send_footer;
  #die;
  exit;
}

sub send_header{

  #print "Content-type: text/html\nPragma: no-cache\n\n" if($Config{'HTML_Header'});
  print "Content-type: text/html\n\n" if($Config{'HTML_Header'});
  $Config{'HTML_Header'} = 0;
  #Read a header.txt here!
  if(open(HEADER,"$Config{'include'}/header.html"))
  {
		flock(HEADER,1) if($Config{'flock'});
		for(<HEADER>)
		{
			print $_;
		}
		close HEADER;
  }
}

###########################################################################
# table_header . Prints the table header bar that most pages use.
# Usage: &table_header("Header 1");
###########################################################################
sub table_header 
{
  my $header = shift;
  print qq~
  <table border=0 width=100%>
    <tr bgcolor="$Config{'pageheader'}"><td><b>$header</b></td></tr>
  </table>
  ~;
}

sub send_footer
{
  if(open(FOOTER,"$Config{'include'}/footer.html"))
	{
		flock(FOOTER,1) if($Config{'flock'});
		for(<FOOTER>)
		{
			print $_;
		}
		close FOOTER;
  }
  print qq~
  <address><center>
  <a href="http://billow.cjb.net">Mysql Database Manager V1.0</a>, Write by <a href="mailto:gaoying\@hotmail.com">Ying Gao</a><br>
  <small>The script lent some ideas and codes from <a href="http://www.mysql.com/Contrib/mysqladm.tar.gz">mysqladm-2.tgz</a> written by <a href='mailto:tps\@users.buoy.com'>Tim Sailer</a> and <a href='mailto:hightide\@iname.com'>Sean Bastille</a></small>
  </center></address>
  </body></html>
  ~;
}

sub convert_time {

  my $time = shift; 
  $time = localtime($time);
    my @tarray = split(/ +/,$time);
    my %months = (
      "Jan" => 1,
      "Feb" => 2,
      "Mar" => 3,
      "Apr" => 4,
      "May" => 5,
      "Jun" => 6,
      "Jul" => 7,
      "Aug" => 8,
      "Sep" => 9,
      "Oct" => 10,
      "Nov" => 11,
      "Dec" => 12
    );         
    my $year = substr($tarray[4],2,2);
    $time = "$year-$months{$tarray[1]}-$tarray[2]";

  return $time;

}


sub PrintHtmlHeader
{
    print "Content-type: text/html\nPragma: no-cache\n";
    $Config{'HTML_Header'}  = 0;
}

sub SetConfigData
{
   my($driver,$server,$port,$name,$user,$pass) = @_;
   $Config{'dbdriver'}  = $driver if($driver);
   $Config{'dbserver'}  = $server if($server);
   $Config{'dbport'}    = $port   if($port);
   $Config{'dbname'}    = $name   if($name);
   $Config{'dbuser'}    = $user   if($user);
   $Config{'dbpass'}    = $pass   if($pass);
}

sub GetSetDatabaseInfo
{
	my $dbname = shift;
	my %Cookies = &GetCookies;
	&GetCompressedCookies('DBINFO',\%Cookies);
        &SetConfigData($Cookies{'dbdriver'},$Cookies{'dbserver'},$Cookies{'dbport'},$dbname,$Cookies{'dbuser'},$Cookies{'dbpass'});	
}

sub Runsqlcommand
{
	my $statement = shift;
	$dbh -> do ($statement) or cgi_error "Can't execute query:<br><b>$statement</b> \nReason:<br><em>$DBI::errstr</em>";
}

sub ShowIndex
{
	my ($status,$message,$tablename) = @_;
	my $result;
	my $EncodeTableName  = gymysql::url_encode($tablename);
	my $EncodeDBName     = gymysql::url_encode($Config{'dbname'});
	
	$result = qq~
<SCRIPT>
<!-- 
function leapto(select,type)
{
   var linkvalue   = select.options[select.selectedIndex].value;
   linkvalue       = escape(linkvalue);
   var dbname      = escape("$Config{'dbname'}");
   if(type == "TB")
   {
         window.location = "table.pl?dbname=" + dbname + "&table=" + linkvalue;
   }
   else
   {
        window.location = "database.pl?dbname=" + linkvalue;
   }
}
// end -->
</script>	
~;
	$result .= qq{<form name=form>$Config{'sitename'} : <a href="$Config{'docurl'}">$Config{'dbserver'} : $Config{'dbport'} : $Config{'dbuser'}</a>};
	
	if($status > 1)
	{
              $result .= qq{ : <a href="$Config{'cgiurl'}/start.pl?dbname=$EncodeDBName">DB</a>} ;
              my(@databases,$cursor) = ();
              $cursor = $dbh->prepare("show databases") || gymysql::cgi_error("show databases failed: <em>$DBI::errstr</em>");
              $cursor->execute;
              $result .= qq{:<select name=dblist onChange="leapto(this.form.dblist,'DB')">\n};
              while (@databases = $cursor->fetchrow) 
              {
                   $result .= "<option value=\"$databases[0]\"";
                   $result .= " selected" if($databases[0] eq $Config{'dbname'});
                   $result .= ">$databases[0]</option>\n";
              }
              $cursor->finish;
              $result .= "</select>\n";
        }
	if($status > 2)
	{
              $result .= qq{ : <a href="$Config{'cgiurl'}/database.pl?dbname=$EncodeDBName">TB</a>};
              my(@tables,$cursor) = ();
              $cursor = $dbh->prepare("show tables") || gymysql::cgi_error("show table failed: <em>$DBI::errstr</em>");
              $cursor->execute;
              $result .= qq{:<select name=tblist onChange="leapto(this.form.tblist,'TB')">\n};
              while (@tables = $cursor->fetchrow) 
              {
                   $result .= "<option value=\"$tables[0]\"";
                   $result .= " selected" if($tables[0] eq $tablename);
                   $result .= ">$tables[0]</option>\n";
              }
              $cursor->finish;
              $result .= "</select>\n";
        }
	$result .= qq{ : <a href="$Config{'cgiurl'}/table.pl?dbname=$EncodeDBName&table=$EncodeTableName">Record Index</a>}      if($status > 3);
	$result .= qq{ : $message} if($message ne "");
	$result .= "</form>";
	return $result;
}

sub RunShortcut_Key
{
	my $Key_no = shift;
	$Key_no =~ s/\D//g;
	return "Sorry, the Key NO. is wrong!" if($Key_no < 1);

        my $query = qq~
           SELECT  Command
           FROM    _ScriptFile
           WHERE   ID = $Key_no
~;
        my $cursor=$dbh->prepare("$query") || gymysql::cgi_error("Prepare failed: $query, Reson: <em>$DBI::errstr</em>");
        $cursor->execute;
        if($cursor->rows < 1)
        {
        	$cursor->finish;
        	return "Sorry, can not find that shortkey!";
        }
        my($command) = $cursor->fetchrow;
        $cursor->finish;
        &Runsqlcommand($command);
        return $command;
}

1;
