#include <ctype.h>
#include "cgi++-lib.h"

#include <time.h>

ostream *active_os = NULL;

ostream& operator << (ostream& os, const CgippDateInput& date)
 {
  os << date.year << "-" << date.month << "-" << date.day;
 }

CgippDateInput::CgippDateInput()
 {
    name = "";
    start_year = 1970;
    end_year = 2030;
    struct tm* now_tm;
    time_t now;
    time(&now);
    now_tm = localtime(&now);

    year = 1900 + now_tm->tm_year;
    month = 1 + now_tm->tm_mon;
    day = now_tm->tm_mday;
 }

void CgippDateInput::write_html_input(ostream& os)
 {
  int i;

  os << "<select name=" << name << "_day>" << endl;

  for(i = 1; i <= 31; i++)
   {
    os << "<option value=" << i << 
      (i == day ? " selected" : "" )  <<  ">" << i << endl;
   }
  os << "</select>" << endl;

  const char* months[] = { "Jan", "Feb", "Mar", "Apr", "May",
   "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

  os << "<select name=" << name << "_month>" << endl;
  
  for(i = 1; i <= 12; i++)
   {
    os << "<option value=" << i <<
     (i == month ? " selected" : "" ) << ">" << months[i-1] << endl;
   }

  os << "</select>" << endl;
   
  os << "<select name=" << name << "_year>" << endl;

  for(i = start_year; i <= end_year; i++)
   {
    os << "<option value=" << i << (i == year ? " selected" : "" ) 
     << ">" << i << endl;
   }
  os << "</select>" << endl;

 }

void cgi_do_hash_parse(map<string, string, less<string> >& cgi_parse_hash,
 const char* content_buf, int content_len)
  {
   int i;
   int on_hex = 0;
   int on_name = 1;
   string var_name = "";
   string var_val = "";
   char char_code = 0;

   for(i = 0; i < content_len; i++)
    {
     char c = content_buf[i];
     switch(c)
        {
         case '%': 
	  on_hex = 2; 
	  char_code = 0;
	  break;
         case '+': 
	  if(on_name) 
	   var_name += ' '; 
	  else
	   var_val += ' ';
	  break;

         case '=':
	  on_name = 0;
	  break;

	 case '&':
	  on_name = 1;
	  cgi_parse_hash[var_name] = var_val;
	  var_name = "";
	  var_val = "";
	  break; 

	 default:  
          if(on_hex) 
           {
            int lower_c = tolower(c);
            char_code = (char_code << 4)  +    ((lower_c <= '9') ? lower_c - '0' : lower_c - 'a' + 10);
            if(!(--on_hex)) 
	     if(on_name)
	      var_name += char_code; 
	     else
	      var_val += char_code; 
	      
	     break;
           }
           else 
	     if(on_name)
	      var_name += c; 
	     else
	      var_val += c; 
             
	   break;
        }

    }
  
    if(var_name.length())
     cgi_parse_hash[var_name] = var_val;
     
  }


void write_cgi_encoded(ostream& os, string& s)
 {
  int i;
  int old_flags, old_fill, old_width;
  old_flags = os.flags();
  os << hex;
  old_fill = os.fill('0');
  old_width = os.width(2);

  for(i = 0; i < s.length(); i++)
   {
    unsigned char c = s[i];
    if(isalnum(c))
      os << c;
    else if(c == ' ')
     os << '+';
    else
     {
      os << '%' <<  (int)c;
     }
   }
 
   os.fill(old_fill);
   os.width(old_width);
   os.flags(old_flags);
 }

char* sql_quote(const string& s)
 {
  if(s.length() == 0)
   return "";

  return sql_quote(s.c_str());
 }

char* sql_quote(const char* s)
 {
  int i;
  char c;

  for(i = 0; c = s[i]; ++i)
   {
    if(c == '\'')
     *active_os << '\'';
    *active_os << c;
   }

  return "";
 }

