#ifndef CGIPP_LIB_H
#define CGIPP_LIB_H

#include <iostream.h>
#include <string>
#include <map>

extern ostream* active_os;

void write_cgi_encoded(ostream& os, string& s);
char* sql_quote(const char* s);
char* sql_quote(const string& s);
void cgi_do_hash_parse(map<string, string, less<string> >& cgi_parse_hash,
 const char* content_buf, int content_len);

struct CgippDateInput
 {
  string name;
  int start_year;
  int end_year;
  int year;
  int month;
  int day;
 
  CgippDateInput();
 
  CgippDateInput(int init_year, int init_month, int init_day)
   {
    year = init_year;
    day = init_day;
    month = init_month;
    start_year = 1970;
    end_year = 2035;
   }

  void write_html_input(ostream& os);

  friend ostream& operator << (ostream& os, 
    const CgippDateInput& date);
 };

ostream& operator << (ostream& os, const CgippDateInput& date);

#endif
