/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.ErrMsgAdapter;
import com.ice.sqlclient.MySQLAdapter;
import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.AWTUtilities;
import com.ice.util.UserProperties;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;

public class TableDefsPanel
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener {
    private JComboBox tableList;
    private JButton refreshButton;
    private JPanel tablePanel;
    private JSplitPane splitPane;
    private JTable resultTable;
    private MySQLAdapter sqlAdapter;
    private JScrollPane scroller;
    private boolean isListFresh = false;
    private boolean isTableFresh;
    private int autoResizeMode;

    public TableDefsPanel() {
        this.setDoubleBuffered(true);
        this.establishContents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("REFRESH")) {
            this.refresh();
            return;
        }
        ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: unknown command: " + string);
        this.setTableModel((TableModel)errMsgAdapter);
    }

    public void refresh() {
        SQLClientHandler sQLClientHandler = this.getMyHandler();
        if (sQLClientHandler != null) {
            sQLClientHandler.flushTableCaches();
            this.isListFresh = false;
            this.refreshTableList();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)this.tableList.getSelectedItem();
            this.refreshTableDef(string);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (jTabbedPane.getSelectedComponent() == this && !this.isListFresh) {
            this.refreshTableList();
        }
    }

    public void refreshTableDef(String string) {
        SQLClientHandler sQLClientHandler = this.getMyHandler();
        if (sQLClientHandler == null) {
            return;
        }
        try {
            this.sqlAdapter = (MySQLAdapter)sQLClientHandler.getTableColumnInfo(string);
            this.setTableModel((TableModel)this.sqlAdapter);
            return;
        }
        catch (SQLException sQLException) {
            String string2 = "SQLException: retrieving table definition:\n" + sQLException.getMessage();
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter(string2);
            this.setTableModel((TableModel)errMsgAdapter);
            return;
        }
    }

    public void refreshTableList() {
        SQLClientHandler sQLClientHandler = this.getMyHandler();
        if (sQLClientHandler == null) {
            return;
        }
        try {
            String[] stringArray = sQLClientHandler.getDatabaseTableList();
            this.tableList.removeAllItems();
            int n = 0;
            while (n < stringArray.length) {
                this.tableList.addItem((Object)stringArray[n]);
                ++n;
            }
            this.isListFresh = true;
            return;
        }
        catch (SQLException sQLException) {
            String string = "SQLException: retrieving table information:\n" + sQLException.getMessage();
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter(string);
            this.setTableModel((TableModel)errMsgAdapter);
            return;
        }
    }

    private void setTableModel(TableModel tableModel) {
        if (tableModel instanceof ErrMsgAdapter) {
            this.resultTable.setAutoResizeMode(2);
        } else {
            this.resultTable.setAutoResizeMode(this.autoResizeMode);
        }
        this.resultTable.setModel(tableModel);
        this.resultTable.tableChanged(new TableModelEvent(tableModel, -1));
    }

    private SQLClientHandler getMyHandler() {
        SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
        if (sQLClientHandler == null) {
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: current handler is null.");
            this.setTableModel((TableModel)errMsgAdapter);
        } else if (!sQLClientHandler.isOpen()) {
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: connection is not open.");
            this.setTableModel((TableModel)errMsgAdapter);
            sQLClientHandler = null;
        }
        return sQLClientHandler;
    }

    private void establishContents() {
        int n = 0;
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener((ActionListener)this);
        this.refreshButton.setActionCommand("REFRESH");
        AWTUtilities.constrain((Container)((Object)this), (Component)this.refreshButton, 0, 10, 0, n, 1, 1, 0.0, 0.0);
        this.tableList = new JComboBox();
        this.tableList.setEditable(false);
        this.tableList.addItemListener((ItemListener)this);
        AWTUtilities.constrain((Container)((Object)this), (Component)this.tableList, 2, 10, 1, n++, 1, 1, 1.0, 0.0);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        int n2 = 0;
        JLabel jLabel = new JLabel("Table Definition:");
        AWTUtilities.constrain((Container)this.tablePanel, (Component)jLabel, 0, 17, 0, n2++, 1, 1, 0.0, 0.0);
        this.sqlAdapter = new MySQLAdapter(null);
        this.resultTable = new JTable((TableModel)this.sqlAdapter);
        this.autoResizeMode = UserProperties.getClassConstant("tableDefsAutoResizeMode", 2);
        this.resultTable.setAutoResizeMode(this.autoResizeMode);
        this.scroller = JTable.createScrollPaneForTable((JTable)this.resultTable);
        Dimension dimension = new Dimension(300, 50);
        this.scroller.setMinimumSize(dimension);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setHorizontalScrollBarPolicy(32);
        AWTUtilities.constrain((Container)this.tablePanel, (Component)this.scroller, 1, 10, 0, n2++, 1, 1, 1.0, 1.0);
        AWTUtilities.constrain((Container)((Object)this), (Component)this.tablePanel, 1, 11, 0, n++, 2, 1, 1.0, 1.0);
    }
}

