/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class FileUtilities {
    public static final String RCS_ID = "$Id: FileUtilities.java,v 1.2 1998/04/23 23:48:02 time Exp $";
    public static final String RCS_REV = "$Revision: 1.2 $";
    public static final String RCS_NAME = "$Name:  $";

    public static void copyFile(File file, File file2) throws IOException {
        long l;
        int n;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new IOException("FileUtilities.copyFile: opening input stream '" + file.getPath() + "', " + iOException.getMessage());
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (Exception exception) {
            try {
                ((FilterInputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
            throw new IOException("FileUtilities.copyFile: opening output stream '" + file2.getPath() + "', " + exception.getMessage());
        }
        byte[] byArray = new byte[8192];
        for (long i = l = file.length(); i > 0L; i -= (long)n) {
            n = (int)(i > 8192L ? 8192L : i);
            try {
                n = bufferedInputStream.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                try {
                    ((FilterInputStream)bufferedInputStream).close();
                    bufferedOutputStream.close();
                }
                catch (IOException iOException2) {}
                throw new IOException("FileUtilities.copyFile: reading input stream, " + iOException.getMessage());
            }
            if (n < 0) break;
            try {
                bufferedOutputStream.write(byArray, 0, n);
                continue;
            }
            catch (IOException iOException) {
                try {
                    ((FilterInputStream)bufferedInputStream).close();
                    bufferedOutputStream.close();
                }
                catch (IOException iOException3) {}
                throw new IOException("FileUtilities.copyFile: writing output stream, " + iOException.getMessage());
            }
        }
        try {
            ((FilterInputStream)bufferedInputStream).close();
            bufferedOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new IOException("FileUtilities.copyFile: closing file streams, " + iOException.getMessage());
        }
    }

    public static boolean fileEqualsExtension(String string, String string2) {
        int n;
        boolean bl = false;
        int n2 = string.length();
        if (n2 > (n = string2.length())) {
            String string3 = string.substring(n2 - n);
            bl = FileUtilities.caseSensitivePathNames() ? string3.equals(string2) : string3.equalsIgnoreCase(string2);
        }
        return bl;
    }

    public static boolean caseSensitivePathNames() {
        boolean bl = true;
        String string = System.getProperty("os.name");
        if (string != null) {
            if (string.startsWith("macos")) {
                bl = false;
            } else if (string.startsWith("Windows")) {
                bl = false;
            }
        }
        return bl;
    }
}

