/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

import com.ice.util.AWTUtilities;


public class
QueryPanel extends JPanel
		implements ActionListener
	{
	private JTextArea		queryText;
	private JTextArea		resultText;
	private JButton			queryButton;

	private JPanel			queryPanel;
	private JPanel			resultPanel;
	private JSplitPane		splitPane;


	public
	QueryPanel()
		{
		this.setDoubleBuffered( true );
		this.establishContents();
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "QUERY" ) )
			{
			String qText = this.queryText.getText();
			
			SQLClientHandler handler =
				SQLClientHandler.getCurrentHandler();

			if ( handler == null )
				{
				this.resultText.setText
					( "INTERNAL ERROR: current handler is null." );
				return;
				}

			if ( ! handler.isOpen() )
				{
				this.resultText.setText
					( "INTERNAL ERROR: connection is not open." );
				return;
				}

			try {
				String qResult =
					handler.performSQLQuery
						( qText + "\n" );
				
				this.resultText.setText( qResult );
				}
			catch ( SQLException ex )
				{
				this.resultText.setText
					( "SQLException:\n" + ex.getMessage() );
				}
			}
		else
			{
			this.resultText.setText
				( "INTERNAL ERROR: unknown command: " + command );
			}
		}

	private void
	establishContents()
		{
		JLabel		lbl;
		JScrollPane	scroller;
		int			row = 0;

		this.setLayout( new BorderLayout() );

		this.queryPanel = new JPanel();
		this.queryPanel.setLayout( new GridBagLayout() );
		this.queryPanel.setPreferredSize( new Dimension(450, 125) );

		lbl = new JLabel( "Query:" );
		AWTUtilities.constrain(
			this.queryPanel, lbl,
			GridBagConstraints.NONE,
			GridBagConstraints.WEST,
			0, row, 2, 1, 0.0, 0.0 );

		++row;

		this.queryText = new JTextArea();
		scroller = new JScrollPane();
		scroller.getViewport().add( this.queryText );
		AWTUtilities.constrain(
			this.queryPanel, scroller,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, row, 2, 1, 1.0, 1.0 );

		++row;
		
		this.queryButton =
			new JButton( "Perform Query" );
		this.queryButton.setActionCommand( "QUERY" );
		this.queryButton.addActionListener( this );
		AWTUtilities.constrain(
			this.queryPanel, this.queryButton,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row, 2, 1, 1.0, 0.0 );
		
		this.resultPanel = new JPanel();
		this.resultPanel.setLayout( new GridBagLayout() );

		row = 0;

		lbl = new JLabel( "Result:" );
		AWTUtilities.constrain(
			this.resultPanel, lbl,
			GridBagConstraints.NONE,
			GridBagConstraints.WEST,
			0, row, 1, 1, 0.0, 0.0 );

		++row;

		this.resultText = new JTextArea();

		scroller = new JScrollPane();
		scroller.getViewport().add( this.resultText );
		AWTUtilities.constrain(
			this.resultPanel, scroller,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, row, 1, 1, 1.0, 1.0 );

		++row;

		
		this.splitPane =
			new JSplitPane
				( JSplitPane.VERTICAL_SPLIT,
					this.queryPanel, this.resultPanel );

		this.splitPane.setContinuousLayout( true );

		this.add( this.splitPane, BorderLayout.CENTER );
		}

	}


