// $Id: test_create.java,v 1.3 1997/11/19 18:19:23 xzhu Exp $
// test_create.java
//
// port from perl script 'test-create'
//
// This test is for testing how long it takes to create tables,
// make a count(*) from them and finally drop the tables. These
// commands will be done in different ways in this test.
// Using option --force will drop all the tables in the end
// of this test with one command instead of making own
// 'drop' command for each and every table.
// By changing the variable '$table_amount' value you can make
// this test a lot harder/easier for your computer to drive.
// Note that when using value bigger than 64 for this variable
// will do 'drop table'-command  in totally different way because of that
// how MySQL handles these commands.
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/14
//
// Copyright (C) 1997, X.K.ZHU
//   The `test_create.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.
package bench;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class test_create implements DBugConstant
{
  // Change this to make test harder/easier
  // This is the default value for the amount of tables used in this test.
  private  int loopCount = 100;

  private long second_orig;
  private InputStream myIn;

  private boolean skipCreate;
  private boolean skipIn;
  private boolean skipDelete;
  private boolean verbose;
  private boolean lockTables;
  private boolean debug;
  private boolean force;
  private boolean fast;

  private test_create()
  {
    second_orig = -1;
    myIn = System.in;

    skipCreate = false;
    skipIn = false;
    skipDelete = false;
    verbose = false;
    lockTables = false;
    debug = false;
    force = false;
    fast = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "force", "help", "host", "loop_value", 
      "password", "port", "user", "debug", "fast" };
    int[] loHasArg = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG, GetOpt.NO_ARG };
    int[] loValue = { 'f', '?', 'h', 'l', 'p', 'P', 'u', '#', 'F' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?Ffh:l:p::P:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = new String("test");
    String debugStr = null;
    int c;
    boolean tty_password = false;
    boolean error = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
            debugStr = g.getOptarg();
            break;
	  case 'f':
	    force = true;
	    break;
	  case 'F':
	    fast = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'l':
	    String s1 = g.getOptarg();
	    if (s1 != null)
	      loopCount = new Integer(s1).intValue();
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (error)
    {
      System.out.println("Usage: java test_connect [OPTIONS]");
      System.out.println("\n" +
  "-#, --debug=opt      debug string, default is NO, see DBug.java for details\n" +
  "-?, --help		display this help and exit\n" + 
  "-h, --host=#		connect to host\n" +
  "-f, --force		force drop table.\n" +
  "-F, --fast		fast drop table.\n" +
  "-l, --loop_value=xxx	loop value.\n" +
  "-p, --password[=xxx]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-u, --user=#		user for login if not current user\n");
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();

    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    Connection conn;
    int i;
    int rows;
    // Here we'll make a loop $opt_table_amount times, 
    // which includes 1 create table,
    // 1 count * from table and 1 drop table. Then we'll check how much
    // time did it take.
    long zsec = System.currentTimeMillis();
    conn = executeConnect(host, port, user, password, database);
    try
    {
      if (force)
      {
        System.out.println("Okay, Let's make sure that our tables don't exist yet.");
        Statement stmt = conn.createStatement();
	try
	{
          if (fast)
          {
            StringBuffer sb = new StringBuffer();
	    sb.append("drop table test_0");
	    for (i=1; i<loopCount; ++i)
	      sb.append(",table test_" + i);
	    rows = stmt.executeUpdate(sb.toString());
          }
          else
          {
            for (i=0; i<loopCount; ++i)
	      rows = stmt.executeUpdate("drop table test_" + i);
          }
	} catch (Exception e9) {}
      }
      System.out.println("Testing create (" + loopCount + ") tables now...");
      second_orig = System.currentTimeMillis();
      Statement stmt = conn.createStatement();
      for (i=0; i<loopCount; ++i)
        rows = stmt.executeUpdate("create table test_" +i+ 
	" (i int,d double,f float,s char(10),v varchar(100), primary key (i))");
      System.out.println("Time to create: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

      // Here comes loopCount couples of count(*) to the tables.
      // We'll check how long it will take...
      System.out.println("Testing make " + loopCount + " of count(*)s now...");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
        stmt.executeQuery("select count(*) from test_" + i);
      System.out.println("Time to select count(*): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // Now we are going to drop loopCount tables;
      //
      System.out.println("Testing drop");
      second_orig = System.currentTimeMillis();
      if (fast)
      {
        StringBuffer sb = new StringBuffer();
	sb.append("drop table test_0");
	for (i=1; i<loopCount; ++i)
	  sb.append(",table test_" + i);
	rows = stmt.executeUpdate(sb.toString());
      }
      else
      {
        for (i=0; i<loopCount; ++i)
	  rows = stmt.executeUpdate("drop table test_" + i);
      }
      System.out.println("Time to drop (" + loopCount + ") tables: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

      // We'll do first one 'create table' and then we'll drop it
      // away immediately. This loop shall be executed loopCount
      // times.
      System.out.println("Testing create+drop " +loopCount+ " times...");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
      {
	rows = stmt.executeUpdate("create table test_" +i+ 
	"(i int,d double,f float,s char(10),v varchar(100), primary key (i))");
	rows = stmt.executeUpdate("drop table test_" + i);
      }
      System.out.println("Time to create+drop (" + loopCount + ") tables: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    executeClose(conn);

    // End of the test 
    // Finally print time used to execute the whole test
    System.out.println("Toal time: " + (System.currentTimeMillis() - zsec)/1000.0 + " sec.");
  }

  private Connection executeConnect(String host, String port, String user, 
    String password, String database)
  {
    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
//System.out.println(url);

      return DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    return null;
  }

  private void executeClose(Connection conn)
  {
    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
    /* System.out.println("wait for 10 sec for closing...");
    try
    {
          Thread.sleep(10000);
    } catch (InterruptedException e) {}
    */
  }

  private int displayResult(ResultSet rs)
    throws SQLException
  {               
    int i;          
    int rows = 0;
    ResultSetMetaData rsmd = rs.getMetaData ();
    int numCols = rsmd.getColumnCount ();
        
    try 
    {
    boolean hasMore = rs.next();
    if (hasMore)
    {
      // Display column headings
      System.out.print("|");
      for (i=1; i<=numCols; i++) 
      {
        System.out.print(rsmd.getColumnName(i));
        System.out.print("\t|");
      }
      System.out.println("");
      // Display data, fetching until end of the result set
      while (hasMore) 
      {          
        rows++;    
        System.out.print("|");
        for (i=1; i<=numCols; i++) 
        {
          System.out.print(rs.getString(i));
  	System.out.print("\t|");
        }
        System.out.println("");
	hasMore = rs.next();
      }
    }       
    } 
    catch (SQLException e)
    { throw e; }

    return rows;
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != 10 && in != 13 && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  public static void main (String[] args) 
  {
    test_create admin = new test_create();
    admin.doit(args);
  }
}
