// $Id: jmysql.java,v 1.2 1997/11/25 21:28:17 xzhu Exp $
// jmysql.java
//
// MySQL client with java
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/11
//
// Copyright (C) 1997, X.K.ZHU
//   The `jmysql.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.

//
// The original mysql.c:
//
// Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
//   This file is public domain and comes with NO WARRANTY of any kind 
//
package jms;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class jmysql implements DBugConstant
{
  private static final int QUIT = 0;
  private static final int HELP = 1;
  private static final int GO = 2;
  private static final int COMMENT = 3;
  private static final int CONTINUE = 4;

  private long second_orig;

  private Connection conn;
  private InputStream myIn = System.in;
  private StringBuffer commandBuffer;
  private boolean isContinue;
  private boolean isSelectQuery;
  private boolean ignore_errors;
  static private String debugStr = null;

  private jmysql()
  {
    conn = null;
    commandBuffer = null;
    isContinue = false;
    isSelectQuery = true;
    second_orig = -1;
    ignore_errors = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "exec", "force", "help", "host", "password",
      "port", "silent", "user", "debug" };
    int[] loHasArg = { GetOpt.OPT_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG,
      GetOpt.REQ_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG,
      GetOpt.NO_ARG, GetOpt.REQ_ARG, GetOpt.REQ_ARG };
    int[] loValue = { 'e', 'f', '?', 'h', 'p', 'P', 's', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?e::fh:p::P:su:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = null;
    int c;
    boolean tty_password = false;
    boolean error = false;
    boolean silent = false;
    boolean batch = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
	  case '#':
	    debugStr = g.getOptarg();
	    break;
          case 'e':
	    batch = true;
	    if (g.getOptarg() != null)
	      myIn = initBatch(g.getOptarg());
	    //if (myIn == null)
	    //  error = true;
	    break;
          case 's':
	    silent = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'f':
	    ignore_errors = true;
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    int optind = g.getOptind();
    if (optind < args.length)
      database = args[optind++];
    else
    {
      System.err.println("Need to provide the database.");
      error = true;
    }

    if (error)
    {
      System.out.println("MySQL client monitor with Java");
      System.out.println("Copyright (C) Xiaokun Kelvin ZHU, 1997");
      System.out.println("Usage: java jmysql database [OPTIONS]");
      System.out.println("\n" +
  "-e, --exec=...	execute command and quit. (batch mode)\n" + 
  "-f, --force		continue even if we get an sql error\n" + 
  "-?, --help		display this help and exit\n" + 
  "-h, --host=#		connect to host\n" +
  "-p, --password[=...]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-s, --silent		be more silent.\n" +
  "-u, --user=#		user for login if not current user\n");
      if (zxk_debug)
        DBug.dbug.dbPop();
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();

    if (!batch)
    {
      System.out.println("Welcome to the mysql monitor with JDBC.  Commands end with ; or \\g");
      System.out.println("Type 'help' for help.");
    }
    executeConnect(host, port, user, password, database);
    boolean quit = false;
    while (!quit)
    {
      String line;
      if (!batch && !isContinue)
        System.out.print("jMySql> ");
      if ((line = readLine()) == null)
        break;
      int code = parseLine(line);
      switch(code)
      {
        case QUIT:  // quit
	  quit = true;
	  break;
	case HELP:  // help
	  System.out.println("\nMySQL commands\n" +
	    "help\t(\\h)\tDisplay this text\n" + 
	    "?\t(\\h)\tSynonym for `help'\n" +
            "quit\t(\\q)\tQuit jmysql\n" +
	    "go\t(\\g)Send command to mysql server");
	  break;
	case GO:  // go
	  executeCommand();
	  break;
	case COMMENT:  // comment
	  break;
	default:  // CONTINUE
          if (!batch)
            System.out.print("      > ");
      }
    }
    executeClose();

    if (zxk_debug)
      DBug.dbug.dbPop();
  }

  private int parseLine(String str)
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("parseLine()", "jmysql", 219);

    String s1 = str.trim();
    if (s1.length() == 0)
    {
      if (zxk_debug)
        DBug.dbug.dbReturn(224);    
      return COMMENT;
    }

    int code = CONTINUE;
    if (zxk_debug)
      DBug.dbug.dbPrint(12, "p_1", "mode: "+code);
    if (!isContinue)
    {
      int i = s1.indexOf(' ');
      String command;
      if (i == -1)
        command = s1;
      else
        command = s1.substring(0,i);
// System.out.print(" command: " + command);
      if (command.equals("quit") || command.equals("\\q"))
        code = QUIT;
      else if (command.equals("help") || command.equals("\\h") ||
               command.charAt(0) == '?')
        code = HELP;
      else if (command.equals("go") || command.equals("\\g"))
        code = GO;
      else if (command.startsWith("--") || command.charAt(0) == '#')
	code = COMMENT;
      else  // standard sql command
      {
        if (command.equalsIgnoreCase("alter"))
	  isSelectQuery = false;
	else if (command.equalsIgnoreCase("create"))
	  isSelectQuery = false;
        else if (command.equalsIgnoreCase("delete"))
	  isSelectQuery = false;
        else if (command.equalsIgnoreCase("describe"))
	  isSelectQuery = false;
        else if (command.equalsIgnoreCase("drop"))
	  isSelectQuery = false;
        else if (command.equalsIgnoreCase("grant"))
	  isSelectQuery = false;
        else if (command.equalsIgnoreCase("select"))
	  isSelectQuery = true;
	else if (command.equalsIgnoreCase("insert"))
	  isSelectQuery = false;
	else if (command.equalsIgnoreCase("load"))
	  isSelectQuery = false;
	else if (command.equalsIgnoreCase("set"))
	  isSelectQuery = false;
	else if (command.equalsIgnoreCase("update"))
	  isSelectQuery = false;
	else if (command.equalsIgnoreCase("show"))
	  isSelectQuery = true;
	else if (command.equalsIgnoreCase("delete"))
	  isSelectQuery = false;
	else if (command.equalsIgnoreCase("update"))
	  isSelectQuery = false;

	code = CONTINUE;
        commandBuffer = new StringBuffer();
      }
    }
    if (code != CONTINUE)
    {
      if (zxk_debug)
        DBug.dbug.dbReturn(287);    
      return code;
    }

    int i = s1.indexOf(';');
    if (i == -1)
    {
      if (code == CONTINUE)
      {
	commandBuffer.append(s1);
        isContinue = true;
      }
    }
    else
    {
      code = GO;
      if (s1.length() > 1)
      {
        String s2 = s1.substring(0,i);
        commandBuffer.append(s2);
      }
      isContinue = false;
    }

    if (zxk_debug)
      DBug.dbug.dbReturn(312);    

    return code;
  }

  private void executeConnect(String host, String port, String user, 
    String password, String database)
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("executeConnect()", "jmysql", 321);

    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
      if (zxk_debug)
        DBug.dbug.dbPrint(347, "ec_1", url);

      conn = DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      e.printStackTrace();
      if (zxk_debug)
        DBug.dbug.dbPop();
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }

    if (zxk_debug)
      DBug.dbug.dbReturn(312);    
  }

  private boolean executeCommand()
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("executeConnect()", "jmysql", 370);

    if (commandBuffer == null || commandBuffer.length() == 0)
    {
      if (zxk_debug)
        DBug.dbug.dbReturn(375);    
      return true;
    }
  
    second();
    try
    {
      Statement stmt = conn.createStatement();

      if (zxk_debug)
        DBug.dbug.dbPrint(385, "ec_2", commandBuffer.toString());

      if (isSelectQuery)
      {
        ResultSet rs = stmt.executeQuery(commandBuffer.toString());
	int rows = displayResult(rs);
	if (rows == 0)
	  System.out.println("Empty set (" + second() + " sec).");
	else if (rows == 1)
	  System.out.println("1 row in set (" + second() + " sec).");
	else
	  System.out.println(rows + " rows affected (" + second() + " sec).");
      }
      else
      {
        int rows = stmt.executeUpdate(commandBuffer.toString());
	if (rows <= 1)
	  System.out.println("Query OK, " + rows + " row affected (" + second() + " sec).");
	else
	  System.out.println("Query OK, " + rows + " rows affected (" + second() + " sec).");
      }
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.err.println(commandBuffer.toString());
      reInitialCommand();
      if (!ignore_errors)
      {
        if (zxk_debug)
          DBug.dbug.dbReturn(416);    
        return false;
      }
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.err.println(commandBuffer.toString());
      reInitialCommand();
      if (!ignore_errors)
      {
        if (zxk_debug)
          DBug.dbug.dbReturn(429);    
        return false;
      }
    }
    reInitialCommand();

    if (zxk_debug)
      DBug.dbug.dbReturn(436);    
    return true;
  }

  private void executeClose()
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("executeClose()", "jmysql", 443);

    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
    /* System.out.println("wait for 10 sec for closing...");
    try
    {
          Thread.sleep(10000);
    } catch (InterruptedException e) {}
    */
    if (zxk_debug)
      DBug.dbug.dbReturn(461);    
  }

  private void reInitialCommand()
  {
    commandBuffer = new StringBuffer();
//    isContinue = false;
  }

  private int displayResult(ResultSet rs)
    throws SQLException
  {               
    if (zxk_debug)
      DBug.dbug.dbEnter("displayResult()", "jmysql", 474);

    int i;          
    int rows = 0;
    ResultSetMetaData rsmd = rs.getMetaData ();
    int numCols = rsmd.getColumnCount ();
        
    try 
    {
    boolean hasMore = rs.next();
    if (hasMore)
    {
      // Display column headings
      System.out.print("|");
      for (i=1; i<=numCols; i++) 
      {
        System.out.print(rsmd.getColumnName(i));
        System.out.print("\t|");
      }
      System.out.println("");
      // Display data, fetching until end of the result set
      while (hasMore) 
      {          
        rows++;    
        System.out.print("|");
        for (i=1; i<=numCols; i++) 
        {
          System.out.print(rs.getString(i));
  	System.out.print("\t|");
        }
        System.out.println("");
	hasMore = rs.next();
      }
    }       
    } 
    catch (SQLException e)
    {
      if (zxk_debug)
        DBug.dbug.dbReturn(461);    
      throw e; 
    }

    if (zxk_debug)
      DBug.dbug.dbReturn(461);    
    return rows;
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != '\n' && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  private InputStream initBatch(String str)
  {
    String fileName = str.trim();  
    DataInputStream in = null;
    try
    {
      in = new DataInputStream(new FileInputStream(fileName));
    } 
    catch (FileNotFoundException e)
    { 
      System.err.println("File " + fileName + " not found");
      return null; 
    }
    return in;
  }

  private double second()
  {
    if (second_orig==-1) {
      second_orig = System.currentTimeMillis();
    }
    return (System.currentTimeMillis() - second_orig)/1000.0;
  }

  public static void main (String[] args) 
  {
    jmysql admin = new jmysql();
    admin.doit(args);
  }
}
