// $Id: testDBug.java,v 1.4 1997/10/16 10:34:30 xzhu Exp $

/**
  testDBug  --  test DBug

  java -DDBug.debug="-#d:t:L:n:C:m:N:P" testDBug
    use System.err to output all debugger and trace message.


  java -DDBug.debug="-#d:t:L:n:C:m:N:P:o,-" testDBug
    use System.out to output all debugger and trace message.
    

  java -DDBug.debug="-#d:t:L:n:C:m:N:P:o,1.out" testDBug
    use file 1.out to output all debugger and trace message.

  java -DDBug.debug="-#d:t,2:L:n:C:m:N:P" testDBug
    maxdepth = 2, all keywords

  java -DDBug.debug="-#d,add2K2*,mul2K1:t,2:L:n:C:m:N:P" testDBug
    maxdepth = 2, keywords: add2k2*, mul2K1
 */
package zxk.util;

public class testDBug implements DBugConstant
{
  public testDBug()
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("testDBug()", "testDBug", 34);
    // other stuff ...
    System.out.println("Default constructor of class testDBug");
    if (zxk_debug)
      DBug.dbug.dbReturn(38);
  }

  private int
  add2(int a, int b)
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("add2()", "testDBug", 45);

    int res = 0;
    for (int i=0; i<a+b; ++i)
    {
      res += 1;
      if (zxk_debug)
        DBug.dbug.dbPrint(52, "add2K" + i, "" + res);
    }

    if (zxk_debug)
      DBug.dbug.dbReturn(56);

    return res;
  }

  private int
  mul2(int a, int b)
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("mul2()", "testDBug", 65);

    int res = a;
    for (int i=1; i<b; ++i)
    {
      res = add2(res, a);
      if (zxk_debug)
        DBug.dbug.dbPrint(72, "mul2K" + i, "" + res);
    }

    if (zxk_debug)
      DBug.dbug.dbReturn(76);

    return res;
  }

  private void
  doit()
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("doit()", "testDBug", 85);

    // other stuff ...
    int a = 10;
    int b = 20;
    int c = add2(a, b);
    if (zxk_debug)
      DBug.dbug.dbPrint(92, "addRes", "the result of add2 ( " + a + " + " + b + " ) = " + c);
    int d = mul2(a, b);
    if (zxk_debug)
      DBug.dbug.dbPrint(95, "mulRes", "the result of mul2 ( " + a + " * " + b + " ) = " + d);

    if (zxk_debug)
      DBug.dbug.dbReturn(98);
  }

  public static void main (String[] args)
  {
    testDBug tdbug = new testDBug();

    tdbug.doit();

    if (zxk_debug)
      DBug.dbug.dbPop();
    System.err.println("hello world again");
  }
}
