#include "DialogFormEditor.h"

#define Inherited DialogFormEditorData

DialogFormEditor::DialogFormEditor(QWidget *parent, Form &form)
  : Inherited(parent), form(form), saved(true)
  {
  setCaption("Form editor");
  setIcon(KApplication::getKApplication()->getIcon());
  // La barre de menu
  //   Menu fichier
  QPopupMenu *m_form = new QPopupMenu();
  CHECK_PTR(m_form);
  m_form->insertItem("&Preview", this, SLOT(menuPreview()));
  m_form->insertItem("&Cancel", this, SLOT(menuCancel()));
  m_form->insertItem("&Save", this, SLOT(menuSave()));
  //    Ajout des menus
  menubar->insertItem("&Form", m_form);
  //
  fillFromForm();
  }


DialogFormEditor::~DialogFormEditor()
  {
  }

void DialogFormEditor::newField(void)
  {
  DialogNewField dlg(this);
  if(dlg.exec())
    {
    FormItem *res = dlg.getItem();
    if(res == NULL)
      return; // this shouldn't happen
    if(!form.itemExists(res->getName()))
      {
      fieldList->insertItem(res->getName());
      form.addItem(res);
      saved = false;
      }
    else
      {
      QMessageBox::warning(this, "New item", "Field name is already used");
      delete res;
      }
    }
  }

void DialogFormEditor::editField(void)
  {
  int current = fieldList->currentItem();
  if(current != -1)
  	{
  	int currentItem = form.findItemFromName(fieldList->text(current));
  	if(currentItem == -1)
  		{
  		warning("Form::findItemFromName failed.");
  		return;
  		}
  	FormItem *item = form.items.at(currentItem);
  	DialogNewField dlg;
  	dlg.fill(item);
  	if(dlg.exec())
    	{
    	FormItem *res = dlg.getItem();
    	if(res == NULL)
      	return; // Should manage error, but it shouldn't happen
    	if(!form.itemExists(res->getName(), item))
     		{
      	fieldList->changeItem(res->getName(), current);
      	form.items.remove(currentItem);
      	form.items.insert(currentItem, res);
      	saved = false;
      	}
    	else
      	{
      	QMessageBox::warning(this, "Edit item", "Field name is already used");
      	delete res;
      	}
    	}
  	}
  }

void DialogFormEditor::deleteField(void)
  {
  int current = fieldList->currentItem();
  if(current != -1)
    {
    warning("Removing item: %s", fieldList->text(current));
    form.removeItem(fieldList->text(current));
    fieldList->removeItem(current);
    saved = false;
    }
  }

	
void DialogFormEditor::saveForm(void)
	{
	form.setName(editName->text());
  form.setQuery(editQuery->text());
	}


void DialogFormEditor::menuSave(void)
  {
  accept();
  }

void DialogFormEditor::menuCancel(void)
  {
  reject();
  }

void DialogFormEditor::menuPreview(void)
  {
  FormDialog formDialog(this, form, true);
  formDialog.exec();
  }


void DialogFormEditor::fillFromForm(void)
  {
  editName->setText(form.getName());
  editQuery->setText(form.getQuery());
  fieldList->clear();
  for(FormItem *item = form.items.first(); item; item = form.items.next())
    fieldList->insertItem(item->getName());
  }





