#include "DialogPref.h"

DialogPref::DialogPref(QWidget *parent)
  : DialogPrefData(parent, 0)
  {
  setCaption("KMySql settings");
  QIntValidator *v = new QIntValidator(edit_nbsaved);
  edit_nbsaved->setValidator(v);
  }

void DialogPref::setFields(Pref pref)
  {
  saveq->setChecked(pref.savequit);
  QString s;
  s.setNum(pref.nbsaved);
  edit_nbsaved->setText(s);
  }

void DialogPref::ok(void)
  {
  done(1);
  }

void DialogPref::cancel(void)
  {
  done(0);
  }

Pref DialogPref::getResult(void)
  {
  Pref res;
  res.savequit = saveq->isChecked();
  QString s = edit_nbsaved->text();
  res.nbsaved = s.toInt();
  return res;
  }
