#include "FormDialog.h"

FormDialog::FormDialog(QWidget* parent, Form &form, bool preview)
  : QDialog(parent, 0, true), form(form), preview(preview)
  {
  createFromForm();
  }

FormDialog::~FormDialog(void)
  {
  if(fields)
    delete[] fields;
  if(names)
    delete[] names;
  }

void FormDialog::ok(void)
  {
  done(1);
  }

void FormDialog::cancel(void)
  {
  done(0);
  }


int FormDialog::createFromForm(void)
  {
  // On cre le tableau de widgets
  fields = new (QWidget *)[form.items.count()];
  names = new QString[form.items.count()];
  // Set catpion
  QString caption = "KMySql Form - " + form.getName();
  if(preview)
    caption += " (Preview)";
  setCaption(caption);
  // Get query
  query = form.getQuery();
  // Le layout principal
  QBoxLayout *mainLayout = new QVBoxLayout(this);
  mainLayout->addSpacing(10);
  // On cre le layout destin  recevoir les widgets
  // Il fait 2 de large, et a autant de lignes que la forme contient
  // de widgets
  int count = form.items.count();
  QGridLayout *layout = new QGridLayout(count*2+1, 5);
  mainLayout->addLayout(layout, 100);
  layout->addColSpacing(0, 10);
  layout->addColSpacing(2, 10);
  layout->addColSpacing(4, 10);
  //layout->setColStretch(1, 100);
  layout->setColStretch(3, 100);
  // On cre chaque couple de widget
  int maxLabelWidth = -1;
  int maxFieldWidth = -1;
  for(int line = 0; line<count; line++)
    {
    // Le label
    FormItem *item = form.items.at(line);
    layout->addRowSpacing(line*2+1, 10);
    //layout->setRowStretch(line*2, 30);
    QLabel *label = new QLabel(item->getName()+": ", this);
    //label->setFixedSize(label->sizeHint());
    if(label->sizeHint().width()>maxLabelWidth)
    	maxLabelWidth = label->sizeHint().width();
    layout->addWidget(label, line*2, 1);
    QWidget *field = NULL;
    // Le widget
    if(item->getType() == FormItem::TypeText) // Type text
      {
      field = new QLineEdit(this);
      layout->addWidget(field, line*2, 3);
      }
    else if(item->getType() == FormItem::TypeCombo) // Type combo
      {
      field = new QComboBox(this);
      FormItemCombo *combo = (FormItemCombo *)item;
      for(unsigned int i=0; i<combo->choices.count(); i++)
				((QComboBox *)field)->insertItem(combo->choices.at(i));
      layout->addWidget(field, line*2, 3);
      }
    field->setFixedHeight(field->sizeHint().height());
    //field->setFixedSize(field->sizeHint());
    if(field->sizeHint().width()>maxFieldWidth)
    	maxFieldWidth = field->sizeHint().width();
    fields[line] = field;
    names[line] = item->getName();
    }
  layout->addColSpacing(1, maxLabelWidth);
	layout->addColSpacing(3, maxFieldWidth);
  // Boutons du bas
  QBoxLayout *btnLayout = new QHBoxLayout;
  mainLayout->addLayout(btnLayout, 1);
  btnLayout->addStretch();
  QPushButton *btnCancel = new QPushButton("Cancel", this);
  btnCancel->setFixedSize(btnCancel->sizeHint());
  btnLayout->addWidget(btnCancel);
  btnLayout->addSpacing(10);
  QPushButton *btnSubmit = new QPushButton("Submit", this);
  btnSubmit->setEnabled(!preview);
  btnSubmit->setFixedSize(btnSubmit->sizeHint());
  btnSubmit->setDefault(true);
  btnLayout->addWidget(btnSubmit);
  btnLayout->addSpacing(10);
  connect(btnSubmit, SIGNAL(clicked()), SLOT(ok()));
  connect(btnCancel, SIGNAL(clicked()), SLOT(cancel()));
  // Activation du layout
  mainLayout->addSpacing(10);
  mainLayout->activate();
  // Taille
  //setFixedHeight((count+1)*40);
  mainLayout->freeze();
  return 0;
  }


QString FormDialog::makeQuery(void)
  {
  if(query.isEmpty())
    return "";
  QString res = "";
  unsigned int len = query.length();
  for(unsigned int i=0; i<len; i++)
    {
    if(query[i] != '%')
      {
      res += query[i];
      }
    else
      {
      QString fieldName = "";
      i++;
      while(i<len && query[i] != '%')
			fieldName += query[i++];
      res += Utils::insertQuotes(getValue(fieldName));
      }
    }
  return res;
  }

QString FormDialog::getValue(QString fieldName)
  {
  for(unsigned int i=0; i<form.items.count(); i++)
    if(form.items.at(i)->getName() == fieldName)
      {
      FormItem *item = form.items.at(i);
      if(item->getType() == FormItem::TypeText)
				return ((QLineEdit *)(fields[i]))->text();
      else if(item->getType() == FormItem::TypeCombo)
				return ((QComboBox *)(fields[i]))->currentText();
      }
  return "";
  }



