#include "MainFrame.h"

MainFrame::MainFrame(QWidget *parent)
  : QWidget(parent)
  {
  // Le panner principal
  KPanner *mainPanner = new KPanner(this, "mpanner", KPanner::O_HORIZONTAL, 70);
  QBoxLayout *topLayout = new QBoxLayout(mainPanner->child0(), QBoxLayout::TopToBottom);
  QBoxLayout *botLayout = new QBoxLayout(mainPanner->child1(), QBoxLayout::TopToBottom);
  // L'arbre et la vue
  KPanner *panner = new KPanner(mainPanner->child0(), "panner", KPanner::O_VERTICAL, 30);
  QBoxLayout *leftLayout = new QBoxLayout(panner->child0(), QBoxLayout::LeftToRight);
  QBoxLayout *rightLayout = new QBoxLayout(panner->child1(), QBoxLayout::LeftToRight);
  treeView = new ServerTree(panner->child0());
  leftLayout->addWidget(treeView);
  tab = new TabView(panner->child1());
  CHECK_PTR(tab);
  tab->setSeparator('\t');
  tab->setAutoUpdate(true);
  rightLayout->addWidget(tab);
  topLayout->addWidget(panner);
  // Query edit combo
  edit = new QueryEdit(mainPanner->child1());
  botLayout->addWidget(edit);
  // Le layout vertical
  QBoxLayout *vbox = new QBoxLayout(this, QBoxLayout::TopToBottom);
  vbox->addWidget(mainPanner, 100);
  vbox->addSpacing(5);
  // Le layout (pour les boutons)
  QBoxLayout *hbox = new QHBoxLayout; //QBoxLayout::LeftToRight);
  vbox->addLayout(hbox, 0);
	// HistoryButton
  history = new QListBox(this);
  history->setFixedHeight(50);
  hbox->addWidget(history);
  hbox->addSpacing(5);
  // Go button
  btn_go = new QPushButton("Submit", this);
  btn_go->setFixedSize(50, 50);
  hbox->addWidget(btn_go);
  };



MainFrame::~MainFrame(void)
	{
	}





