#include "MainWindow.h"

#define MAIN_MIN_W 250
#define MAIN_MIN_H 250

#define MAIN_W 650
#define MAIN_H 550


QList<MainWindow> MainWindow::windows;
QList<Connection> MainWindow::connections;
Pref MainWindow::pref;
bool MainWindow::initialized = false;
//DialogFormEditor *MainWindow::formEditor;
PluginManager *MainWindow::pluginManager;

MainWindow::MainWindow(const char *name)
  : KTMainWindow(name)
  {
  // Gestion de la liste des fenetres
  windows.setAutoDelete(false);
  windows.append(this);
  // Gnral
  setMinimumSize(MAIN_MIN_W, MAIN_MIN_H);
  setGeometry(x(), y(), MAIN_W, MAIN_H);
  setCaption("KMySql");
  // Menu fichier
  fichier = new QPopupMenu();
  CHECK_PTR(fichier);
  fichier->insertItem("&New window", this, SLOT(menuNewWindow()));
  fichier->insertSeparator();
  fichier->insertItem("&Add server", this, SLOT(menuAddServer()));
  fichier->insertSeparator();
  fichier->insertItem("&Print...", this, SLOT(menuPrint()));
  fichier->insertSeparator();
  pref_id = fichier->insertItem("S&ettings...", this, SLOT(menuPref()));
  fichier->insertItem("&Modules...", this, SLOT(menuModules()));
  fichier->insertItem("&Save settings", this, SLOT(menuSavePref()));
  fichier->insertSeparator();
  fichier->insertItem("&Quit", this, SLOT(menuQuit()));
  // Menu Edition
  edition = new QPopupMenu();
  CHECK_PTR(edition);
  edition->insertItem("&Clear all", this, SLOT(menuClear()));
  edition->insertSeparator();
  edition->insertItem("&Fit all", this, SLOT(menuFitAll()));
  /*// Menu Forms
  delforms = new QPopupMenu();
  forms = new QPopupMenu();
  CHECK_PTR(forms);
  forms->insertItem("&Form editor", this, SLOT(menuFormEditor()));
  forms->insertItem("&Run form...", this, SLOT(menuRunForm()));
  forms->insertItem("&Add form...", this, SLOT(menuAddForm()));
  forms->insertItem("R&emove form", delforms);
  forms->insertSeparator();
  connect(forms, SIGNAL(activated(int)), this, SLOT(menuFormsActivated(int)));
  connect(delforms, SIGNAL(activated(int)), this, SLOT(menuDelformsActivated(int)));
  */
  // Menu help
  QPopupMenu *help = KApplication::getKApplication()->getHelpMenu(true, "This is KMySql "VERSION"\n"
								  "A MySql client for KDE.\n"
								  "\n"
								  "By Frdrik Bilhaut\n"
								  "bilhaut_f@mail.cpod.fr\n"
								  "http://www.etu.info.unicaen.fr/~fbilhaut/kmysql");
  // Menubar
  menu = menuBar();
  menu->insertItem("&File", fichier);
  editionId = menu->insertItem("&Edit", edition);
  //menu->insertItem("F&orms", forms);
  menu->insertSeparator();
  menu->insertItem("&Help", help);
  // MainFrame
  MainFrame *mainFrame = new MainFrame(this);
  edit = mainFrame->edit;
  tab = mainFrame->tab;
  btn_go = mainFrame->btn_go;
  treeView = mainFrame->treeView;
  history = mainFrame->history;
//  history->setInsertionPolicy(KCombo::AtTop);
//  history->setSizeLimit(pref.nbsaved);
  setView(mainFrame);
  // Status Bar
  status = statusBar();
  status->insertItem("KMySql " VERSION, 0);
  // Tool bar
  KToolBar *tb = toolBar();
  KIconLoader *iconLoader = KApplication::getKApplication()->getIconLoader();
  //iconLoader->insertDirectory(0, QString("./toolbar"));
  QPixmap pix1 = iconLoader->loadIcon(QString("exit.xpm"));
  tb->insertButton(pix1, 1, SIGNAL(clicked()), this, SLOT(menuQuit()), true, "Quit");
  // Connects
  connect(btn_go, SIGNAL(clicked()), SLOT(go()));
  connect(edit, SIGNAL(submit()), SLOT(go()));
  connect(history, SIGNAL(selected(int)), SLOT(historyActivated(int)));
  connect(treeView, SIGNAL(tableSelect()), SLOT(menuTableSelect()));
  connect(treeView, SIGNAL(tableSelectAll()), SLOT(menuTableSelectAll()));
  connect(treeView, SIGNAL(tableShowFields()), SLOT(menuShowFields()));
  connect(treeView, SIGNAL(tableDrop()), SLOT(menuDropTable()));
  connect(treeView, SIGNAL(formExecute()), SLOT(menuFormExecute()));
  connect(treeView, SIGNAL(formEdit()), SLOT(menuFormEdit()));
  connect(treeView, SIGNAL(formDelete()), SLOT(menuFormDelete()));
  connect(treeView, SIGNAL(baseCreateTable()), SLOT(menuCreateTable()));
  connect(treeView, SIGNAL(baseDelete()), SLOT(menuDeleteBase()));
  connect(treeView, SIGNAL(baseSelect()), SLOT(menuSelect()));
  connect(treeView, SIGNAL(baseNewForm()), SLOT(menuBaseNewForm()));
  connect(treeView, SIGNAL(serverConnect()), SLOT(menuConnect()));
  connect(treeView, SIGNAL(serverDisconnect()), SLOT(menuClose()));
  connect(treeView, SIGNAL(serverCreateBase()), SLOT(menuCreateBase()));
  connect(treeView, SIGNAL(serverRemove()), SLOT(menuRemoveServer()));
  connect(treeView, SIGNAL(serverShutdown()), SLOT(menuShutdownServer()));
  connect(treeView, SIGNAL(serverReload()), SLOT(menuReloadServer()));
  connect(treeView, SIGNAL(serverInfo()), SLOT(menuServerInfo()));
  connect(treeView, SIGNAL(queryWizard()), SLOT(menuQueryWizard()));
  // Things to be done at startup
  connections.setAutoDelete(true);
  commonInit();
  // Divers
  formMenuItems.setAutoDelete(true);
  }


void MainWindow::commonInit(void)
  {
  if(!initialized)
    {
    initialized = true;
    pluginManager = new PluginManager;
    readPref();
    updateWithPrefs();
    }
  }

MainWindow::~MainWindow(void)
  {
  warning("MainWindow::~MainWindow()");
  windows.removeRef(this);
  }

void MainWindow::closeEvent(QCloseEvent *e)
  {
  if(windows.count() > 1)
    {
    warning("Close a window");
    e->accept();
    delete this;
    } 
  else
    {
    warning("Close last window, let's quit");
    menuQuit();
    }
  }

void MainWindow::menuNewWindow(void)
  {
  (new MainWindow(0))->show();
  }

void MainWindow::menuConnect(void)
  {
  Connection *conn = currentConnection();
  if(!conn)
  	{
  	QMessageBox::warning(this, "Connect", "Please select a server");
  	return;
  	}
  QueryResult res = conn->connect();
  if(res.type == QueryResult::Error)
  	{
  	QMessageBox::warning(this, "Connect error", res.message);
  	return;
  	}
  updateTree();
  }


void MainWindow::menuClose(void)
  {
  ISqlServer *sql = currentServer();
  if(!sql)
  	{
  	QMessageBox::warning(this, "Disconnect", "Please select a server");
  	return;
  	}
  sql->close();
  updateTree();
  }


void MainWindow::menuPref(void)
  {
  DialogPref *dlg = new DialogPref(this);
  dlg->setFields(pref);
  if(dlg->exec())
    {
    Pref p;
    p = dlg->getResult();
    pref.savequit = p.savequit;
    pref.nbsaved = p.nbsaved;
    updateWithPrefs();
    }
  delete dlg;
  }

void MainWindow::menuModules(void)
	{
	DialogModules *dlg = new DialogModules(pluginManager, this);
	if(dlg->exec())
		{
		}
	delete dlg;	
	}

void MainWindow::menuSavePref(void)
  {
  savePref();
  }


void MainWindow::menuSelectBase(void)
  {
  }


void MainWindow::menuPrint(void)
  {
  QPrinter printer;
  if(printer.setup(this))
  		{
  		QMessageBox::critical(this, "Sorry", "Not yet implemented");
  		}
  }
  

void MainWindow::menuQuit(void)
  {
  if(pref.savequit)
    savePref();
  delete pluginManager;
  qApp->quit();
  }

void MainWindow::menuRemoveRow(void)
  {
  }
  

void MainWindow::menuClear(void)
  {
  tab->clear();
  }


void MainWindow::menuFitAll(void)
  {
  tab->fitAll();
  }


void MainWindow::menuShowTables(void)
  {
  }


void MainWindow::menuCreateTable(void)
  {
  QString base = currentBase();
  if(base.isEmpty())
    {
    QMessageBox::warning(this, "Create table", "Please select a base");
    return;
    }
  DialogCreateTable dlg(this);
  if(dlg.exec())
    {
    QString query = dlg.getQuery();
    warning(query);
    newQuery(query);
    }
  updateTree();
  }


void MainWindow::menuAlterTable(void)
  {
  updateTree();
  }


void MainWindow::menuDropTable(void)
  {
  QString table = currentTable();
  if(table.isEmpty())
    {
    QMessageBox::warning(this, "Drop table", "Please select a table");
    return;
    }
  QString tmp = "Are you sure you want to drop this table: ";
  tmp += table;
  tmp += " ?";
  if(KMsgBox::yesNo(this, "Drop Table", (const char *)tmp) == 1)
    {
    QString query = "DROP TABLE "+table;
    newQuery(query);
    }
  updateTree();
  }


void MainWindow::menuFormEditor(void)
  {
  //formEditor->show();
  }


void MainWindow::menuRunForm(void)
  {
  }


void MainWindow::menuAddForm(void)
  {
  KFileDialog filedlg(0, 0, this, 0, true, false);
  if(filedlg.exec())
    {
    QString afilename = filedlg.selectedFile();
    FormMenuItem *formMenuItem = new FormMenuItem;
    formMenuItem->id = forms->insertItem(afilename);
    formMenuItem->delid = delforms->insertItem(afilename);
    formMenuItem->filename = afilename;
    formMenuItems.append(formMenuItem);
    }
  }


void MainWindow::menuDelformsActivated(int id)
  {
  warning("Delete form %d", id);
  FormMenuItem *item = formMenuItems.first();
  for(; item; item=formMenuItems.next())
    if(item->delid == id)
      {
      forms->removeItem(item->id);
      delforms->removeItem(item->delid);
      formMenuItems.remove(item);
      break;
      }
  }


void MainWindow::menuFormsActivated(int id)
  {
  }


void MainWindow::menuQueryWizard(void)
	{
	QueryWizard *dlg = new QueryWizard(this);
	if(dlg->exec())
		{
		}
	delete dlg;
	}

int MainWindow::newQuery(const char *query)
  {
  if(currentBase().isEmpty())
    {
    QMessageBox::warning(this, "Query", "Please select a base");
    return 0;
    }
  QueryResult res;
  if(!currentServer()->isConnected())
    {
    QMessageBox::critical(this, "Error", "Not connected");
    return 0;
    }
  res = currentServer()->selectBase(currentBase());  
  if(res.type == QueryResult::Error)
    {
    QMessageBox::critical(this, "Error", res.message);
    return 0;
    }
  res = currentServer()->query(query);
  if(res.type == QueryResult::Error)
    {
    QMessageBox::critical(this, "Error", res.message);
    return 0;
    }
  else if(res.type == QueryResult::Ok)
    {
    status->changeItem(res.message, 0);
    updateTree();
    return 1;
    }
  else if(res.type == QueryResult::Set)
    {
    tab->clear();
    tab->setAutoUpdate(false);
    int nbcols = res.numColumns;
    tab->setNumCols(nbcols);
    tab->setColumns(res.fields);
    QStrList rows = res.result;
    for(unsigned int i=0; i<rows.count(); i++)
      tab->appendItem(rows.at(i));
    status->changeItem(res.message, 0);
    tab->fitAll();
    tab->update();
    tab->setAutoUpdate(true);
    tab->repaint();
    updateTree();
    return 1;
    }
  return 0;
  }


int MainWindow::readPref(void)
  {
  KConfig *config = KApplication::getKApplication()->getConfig();
  // Install modules
  pluginManager->readPref(config);
  // Read all connections.
 	int count;
  config->setGroup("Connections");
  count = config->readNumEntry("Count", 0);
  for(int i=0; i < count; i++)
	  {
    QString host, user, passwd, pluginName;
	  QString nr;
	  QStrList list;
    nr.sprintf("%d", i);
    config->readListEntry(nr, list);
    host = list.first();
    user = list.next();
    passwd = list.next();
    pluginName = list.next();
		int id = pluginManager->getPluginByName(pluginName);
		if(id == -1)
			QMessageBox::critical(this, "Config", "A connection can't be restored because the plugin can't be found.");
		else
			{
			ISqlServer *sql = pluginManager->createInstance(id);
			const char *ppath = pluginManager->getPluginPath(id);
			Connection *conn = new Connection(sql, ppath, pluginName, host, user, passwd);
  	 	addConnection(conn);
  	 	}
 		}
 	// Other configs...
  config->setGroup("Options");
  pref.savequit = config->readBoolEntry("SaveQuit", false);
  pref.nbsaved = config->readNumEntry("MaxSaved", 10);
  return 1;
  }

int MainWindow::savePref(void)
  {
  KConfig *config = KApplication::getKApplication()->getConfig();
  // Save all modules
  pluginManager->savePref(config);
  // Save all connections
  int i = 0;
  config->setGroup("Connections");
  config->writeEntry("Count", connections.count());
  for(Connection *aConnect = connections.first(); aConnect != NULL; aConnect = connections.next() )
  	{
  	QStrList list;
	  QString nr;
 	 	nr.sprintf("%d", i);
    list.append(aConnect->getHost());
    list.append(aConnect->getLogin());
    list.append(aConnect->getPassword());
    list.append(aConnect->getPluginName());
    config->writeEntry(nr, list);
    i++;
	  }
	// Other little things
  config->setGroup("Options");
  config->writeEntry("SaveQuit", pref.savequit);
  config->writeEntry("MaxSaved", pref.nbsaved);
  return 1;
  }

void MainWindow::go(void)
  {
	if(newQuery(edit->text()))
  	{
  	edit->setFocus();
  	edit->selectAll();
  	addHistory(edit->text());
  	}
  }

void MainWindow::historyActivated(int i)
	{
	edit->setText(history->text(i));
	go();
	}


void MainWindow::updateWithPrefs(void)
  {
  }

int MainWindow::addConnection(Connection *conn)
  {
  if(connectionByName(conn->getName()) != NULL)
  	return 1;
  connections.append(conn);
  updateTree();
  return 0;
  }

int MainWindow::removeConnection(Connection *conn)
	{
	if(!conn)
		return 1;
	if(conn->sql()->isConnected())
		conn->sql()->close();
	connections.removeRef(conn);
	updateTree();
	return 0;
	}

int MainWindow::updateTree(Connection *conn)
	{
	if(!conn)
		return 1;
	// Si pas connect
	if(!conn->sql()->isConnected())
		{
		KTreeListItem *item = treeView->createServerItem(conn->getName());
		treeView->insertItem(item);
		return 0;
		}
	KTreeListItem *item = treeView->createConnectedServerItem(conn->getName());
  // On rcupre les diffrentes bases
  QueryResult res = conn->sql()->getBases();
  if(res.type == QueryResult::Error)
  	return 2;
  QStrList bases = res.result;
  for(unsigned int i=0; i<bases.count(); i++)
    {
    char *baseName = bases.at(i);
    // On rcupre les diffrentes tables
    QueryResult res = conn->sql()->getTables(baseName);
    if(res.type == QueryResult::Error)
    	continue;
   	KTreeListItem *base = treeView->createBaseItem(baseName);
    QStrList tables = res.result;
    for(unsigned int j=0; j<tables.count(); j++)
 	    {
  	  QString tableName = tables.at(j);
   	  // Une table normale
   	  if(tableName != "__KmysqlForms" && tableName != "__KmysqlFields")
  		  {
   	  	KTreeListItem *table = treeView->createTableItem(tableName);
    		base->appendChild(table);
    		}
     	// Les forms
     	else if(tableName == "__KmysqlForms")
     		{
     		QueryResult res = conn->sql()->query("SELECT Name from __KmysqlForms");
     		if(res.type == QueryResult::Error)
     			{
   				//return 4;
   				continue;
   				}
   			QStrList forms = res.result;
   			for(unsigned int k=0; k<forms.count(); k++)
   				{
   				QString formName = forms.at(k);
   				KTreeListItem *form = treeView->createFormItem(formName);
   				base->insertChild(0, form);
   				}
   			}
      }
    item->appendChild(base);
    }
  treeView->insertItem(item);
  return 0;
	}

int MainWindow::updateTree(void)
	{
	treeView->saveTree();
	treeView->setAutoUpdate(false);
	treeView->clear();
	for(unsigned int c=0; c<connections.count(); c++)
		updateTree(connections.at(c));
	treeView->repaint();
	treeView->setAutoUpdate(true);
	treeView->restoreTree();
	return 0;
	}


ISqlServer *MainWindow::currentServer(void)
  {
  Connection *conn = currentConnection();
  if(!conn)
  	return NULL;
  return conn->sql();
  }

Connection *MainWindow::currentConnection(void)
	{
	QString connName = treeView->currentConnectionName();
  if(connName.isEmpty())
    return NULL;
  Connection *conn = connectionByName(connName);
  return conn;
	}

QString MainWindow::currentBase(void)
  {
  return treeView->currentBaseName();
  }

QString MainWindow::currentTable(void)
  {
  return treeView->currentTableName();
  }

QString MainWindow::currentForm(void)
  {
  return treeView->currentFormName();
  }

Connection *MainWindow::connectionByName(QString name)
  {
  for(unsigned int i=0; i<connections.count(); i++)
    {
    Connection *conn = connections.at(i);
    if(conn->getName() == name)
      return conn;
    }
  return NULL;
  }

void MainWindow::menuTableSelectAll(void)
	{
	QString query = "SELECT * from "+currentTable();
	newQuery(query);
	}

void MainWindow::menuTableSelect()
	{
	DialogSelect dlg(this, currentTable());
	if(dlg.exec())
		newQuery(dlg.getQuery());
	}

void MainWindow::menuSelect(void)
	{
	DialogSelect dlg(this);
	if(dlg.exec())
		newQuery(dlg.getQuery());
	}
	
	
void MainWindow::menuShowFields()
	{
	QString table = currentTable();
	if(table.isEmpty())
		{
		QMessageBox::warning(this, "Show fields", "Please select a table");
		return;
		}
	newQuery("SHOW FIELDS FROM "+table);
	}
	
void MainWindow::menuDeleteBase()
	{
	QString baseName = currentBase();
	if(baseName.isEmpty())
		return;
	QString tmp = "Are you sure tyou want to drop this base: ";
  tmp += baseName;
  tmp += " ?";
  if(KMsgBox::yesNo(this, "Drop Base", (const char *)tmp, KMsgBox::DB_SECOND) == 1)
    {
    ISqlServer *sql = currentServer();
		if(!sql || !sql->isConnected())
			{
			QMessageBox::critical(this, "Create base", "This shouldn't happen!");
			return;
			}
    QueryResult res = sql->dropBase(baseName);
		if(res.type == QueryResult::Error)
			{
			QMessageBox::critical(this, "Drop base", res.message);
			return;
			}
		status->changeItem("Base dropped successfully", 0);
		updateTree();
    }
	}
	
void MainWindow::menuCreateBase()
	{
	DialogInput dlg(this);
	dlg.setMessage("Base name:");
	dlg.setCaption("Create base");
	if(dlg.exec())
		{
		QString baseName = dlg.getText();
		ISqlServer *sql = currentServer();
		if(!sql || !sql->isConnected())
			{
			QMessageBox::critical(this, "Create base", "This shouldn't happen!");
			return;
			}
		QueryResult res = sql->createBase(baseName);
		if(res.type == QueryResult::Error)
			{
			QMessageBox::critical(this, "Create base", res.message);
			return;
			}
		status->changeItem("New base created successfully", 0);
		updateTree();
		}
	}

void MainWindow::menuAddServer()
	{
	if(pluginManager->count() == 0)
		{
		QMessageBox::critical(this, "Add server", "You must install at least one plugin");
		return;
		}	
	DialogAddServer dlg(pluginManager, this);
	if(dlg.exec())
		{
		// Alloue une nouvelle connection.
		// Elle sera dsaloue par la QList connections
		Connection *conn = dlg.result();
		int r = addConnection(conn);
		if(r == 1)
			{
			delete conn;
			QMessageBox::critical(this, "Add server", "Such a connection already exists");
			}
		}
	}
	
void MainWindow::menuRemoveServer()
	{
	removeConnection(currentConnection());
	}
	
void MainWindow::menuShutdownServer()
	{
	Connection *conn = currentConnection();
	if(!conn)
		return;
	ISqlServer *sql = conn->sql();
	if(!sql)
		return;
	if(!sql->isConnected())
		return;
	QueryResult res = sql->shutdown();
	if(res.type == QueryResult::Error)
		{
		QMessageBox::critical(this, "Shutdown", res.message);
		return;
		}
	removeConnection(conn);
	status->changeItem("Server stoped successfully", 0);
	}

void MainWindow::menuReloadServer()
	{
	Connection *conn = currentConnection();
	if(!conn)
		return;
	ISqlServer *sql = conn->sql();
	if(!sql)
		return;
	if(!sql->isConnected())
		return;
	QueryResult res = sql->reload();
	if(res.type == QueryResult::Error)
		{
		QMessageBox::critical(this, "Reload", res.message);
		return;
		}
	updateTree();	
	status->changeItem("Server reloaded successfully", 0);
	}

void MainWindow::menuServerInfo(void)
	{
	ISqlServer *sql = currentServer();
	if(sql && sql->isConnected())
		QMessageBox::information(this, "Server information", sql->serverInfo());
	}


void MainWindow::addHistory(QString query)
	{
	query = query.stripWhiteSpace();
	for(unsigned int i=0; i<history->count(); i++)
		{
		QString s = history->text(i);
		if(s == query)
			return;
		}
	history->insertItem(query, 0);
	if(history->count() > pref.nbsaved)
		history->removeItem(history->count()-1);
	}


bool MainWindow::prepareBaseForForms(QString base)
	{
	QueryResult res;
	ISqlServer *sql = currentServer();
	if(!sql)
		return false;
	res = sql->selectBase(base);
	if(res.type == QueryResult::Error)
	   return false;
	res = sql->query("CREATE TABLE __KmysqlForms (Ref INT NOT NULL AUTO_INCREMENT, Name VARCHAR(255) NOT NULL, Query TEXT NOT NULL, PRIMARY KEY(Ref))");
	if(res.type == QueryResult::Error)
	   return false;
	res = sql->query("CREATE TABLE __KmysqlFields (Ref INT NOT NULL AUTO_INCREMENT, FormRef INT NOT NULL, Name VARCHAR(255) NOT NULL, Type VARCHAR(63) NOT NULL, Extra TEXT NOT NULL, PRIMARY KEY(Ref))");
	if(res.type == QueryResult::Error)
	   return false;
	return true;	
	}


bool MainWindow::isBasePreparedForForms(QString base)
	{
	QueryResult res;
	ISqlServer *sql = currentServer();
	if(!sql)
		return false;
	res = sql->selectBase(base);
	if(res.type == QueryResult::Error)
	   return false;
	res = sql->query("show tables like \"__KmysqlForms\"");
	if(res.type == QueryResult::Error)
	   return false;
	if(res.result.count() == 0)
		return false;
	return true;
	}

void MainWindow::menuBaseNewForm(void)
	{
	QueryResult res;
	ISqlServer *sql = currentServer();
	if(!sql)
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuBaseNewForm()");
		return;
		}
	QString baseName = currentBase();
	if(!isBasePreparedForForms(baseName))
		if(!prepareBaseForForms(baseName))
			{
			QMessageBox::critical(this, "New form", "Unable to create forms in this base (check permissions)");
			return;
			}
	Form form;
	DialogFormEditor *formEditor = new DialogFormEditor(this, form);
	if(formEditor->exec())
		{
		formEditor->saveForm();
		if(!form.writeDatabase(sql))
			{
			QMessageBox::critical(this, "New form", "Error while writing form in database");
			delete formEditor;
			return;
			}
		updateTree();
		}
	delete formEditor;
	}


void MainWindow::menuFormExecute(void)
	{
	ISqlServer *sql = currentServer();
	if(!sql)
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormExecute():1");
		return;
		}
	QString formName = currentForm();
	if(formName.isEmpty())
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormExecute():2");
		return;
		}		
	Form form;
	if(!form.readDatabase(sql, formName))
	  {
		QMessageBox::critical(this, "Critical", "Internal error in menuFormExecute():3");
		return;
		}
	FormDialog formDialog(this, form);
	if(formDialog.exec())
		newQuery(formDialog.makeQuery());
	}
	
void MainWindow::menuFormEdit(void)
	{
	ISqlServer *sql = currentServer();
	if(!sql)
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormEdit():1");
		return;
		}
	QString formName = currentForm();
	if(formName.isEmpty())
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormEdit():2");
		return;
		}		
	Form form;
	if(!form.readDatabase(sql, formName))
	  {
		QMessageBox::critical(this, "Critical", "Internal error in menuFormEdit():3");
		return;
		}
	QString oldFormName = form.getName();
	DialogFormEditor formEditor(this, form);
	if(formEditor.exec())
		{
		formEditor.saveForm();
		if(!Form::removeFromDatabase(sql, oldFormName))
			{
			QMessageBox::critical(this, "Critical", "Internal error in menuFormEdit():4");
			return;
			}
		if(!form.writeDatabase(sql))
			{
			QMessageBox::critical(this, "Critical", "Internal error in menuFormEdit():5");
			return;
			}
		updateTree();
		}
	}
	
void MainWindow::menuFormDelete(void)
	{
	ISqlServer *sql = currentServer();
	if(!sql)
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormDelete():1");
		return;
		}
	QString formName = currentForm();
	if(formName.isEmpty())
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormDelete():2");
		return;
		}			
	if(!Form::removeFromDatabase(sql, formName))
		{
		QMessageBox::critical(this, "Critical", "Internal error in menuFormDelete():3");
		return;
		}
	updateTree();
	}
























