#include "TabView.h"

TabView::TabView(QWidget *parent, const char *name)
	: KTabListBox(parent, name)
	{
	}

void TabView::fitAll(void)
	{
	QFontMetrics metrics(tableFont());
	for(int i=0; i<numCols(); i++)
		{
		int max = metrics.width(getHeadText(i));
		for(int j=0; j<numRows(); j++)
			{
			QString s = text(j, i);
			int tmp = metrics.width(s, s.length());
			if(tmp>max)
				max = tmp;
			}
		setColumnWidth(i, max+10);
		}
	}


void TabView::setColumns(QString columns)
	{
	if(columns.isEmpty())
		return;
	heads.clear();
	int index = 0;
	bool fin = false;
	int i = 0;
	while(!fin)
		{
		int index2 = columns.find('\t', index);
		if(index2 == -1)
			{
			index2 = columns.length();
			fin = true;
			}
		QString col = columns.mid(index, index2-index);
		setColumn(i, col);
		heads.append(col);
		index = index2+1;
		i++;
		}
	}
	
QString TabView::getHeadText(unsigned int index)
	{
	if(index<0 || index>=heads.count())
		return 0;
	return heads.at(index);	
	}
	